Ext.data.JsonP.MobileCCS_WebchatMedia({"tagname":"class","name":"MobileCCS.WebchatMedia","autodetected":{},"files":[{"filename":"ccs-webchatmedia.js","href":null}],"extends":"MobileCCS.BaseMedia","members":[{"name":"AgentLabel","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-AgentLabel","meta":{"readonly":true}},{"name":"ArrivalTime","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ArrivalTime","meta":{"readonly":true}},{"name":"CanSendChatMessage","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-CanSendChatMessage","meta":{"readonly":true}},{"name":"CanSendIsTyping","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-CanSendIsTyping","meta":{"readonly":true}},{"name":"CanSendPagePushUrl","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-CanSendPagePushUrl","meta":{"readonly":true}},{"name":"ContactID","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ContactID","meta":{"readonly":true}},{"name":"ContactType","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ContactType","meta":{"readonly":true}},{"name":"CustomerLabel","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-CustomerLabel","meta":{"readonly":true}},{"name":"DisplayName","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-DisplayName","meta":{"readonly":true}},{"name":"From","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-From","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"Message","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-Message","meta":{"readonly":true}},{"name":"MessageType","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-MessageType","meta":{"readonly":true}},{"name":"Method","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-Method","meta":{"readonly":true}},{"name":"SenderID","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-SenderID","meta":{"readonly":true}},{"name":"SenderType","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-SenderType","meta":{"readonly":true}},{"name":"Status","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-Status","meta":{"readonly":true}},{"name":"Subject","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-Subject","meta":{"readonly":true}},{"name":"Timestamp","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-Timestamp","meta":{"readonly":true}},{"name":"Transcript","tagname":"property","owner":"MobileCCS.WebchatMedia","id":"property-Transcript","meta":{"readonly":true}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"SendChatMessage","tagname":"method","owner":"MobileCCS.WebchatMedia","id":"method-SendChatMessage","meta":{}},{"name":"SendIsTyping","tagname":"method","owner":"MobileCCS.WebchatMedia","id":"method-SendIsTyping","meta":{}},{"name":"SendPagePushUrl","tagname":"method","owner":"MobileCCS.WebchatMedia","id":"method-SendPagePushUrl","meta":{}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.WebchatMedia","short_doc":"The WebchatMedia object provides the media associated with Web_Communications interactions. ...","component":false,"superclasses":["CCSObject","MobileCCS.BaseMedia"],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='docClass'>MobileCCS.BaseMedia</a><div class='subclass '><strong>MobileCCS.WebchatMedia</strong></div></div></div></pre><div class='doc-contents'><p>The <em>WebchatMedia</em> object provides the media associated with Web_Communications interactions.</p>\n\n<p><em>Media</em> objects are retrieved from the server by calling the <a href=\"#!/api/MobileCCS.Interaction-method-OpenMedia\" rel=\"MobileCCS.Interaction-method-OpenMedia\" class=\"docClass\">OpenMedia</a>\nmethod on the <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object.</p>\n\n<p>The methods available on the <em>WebchatMedia</em> object allow the client application to control this media (e.g. send a chat message\non an active contact).</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-AgentLabel' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-AgentLabel' class='name expandable'>AgentLabel</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the Agent Label as configured by an administrator.</p>\n</div><div class='long'><p>Provides the Agent Label as configured by an administrator.</p>\n</div></div></div><div id='property-ArrivalTime' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ArrivalTime' class='name expandable'>ArrivalTime</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The time at which the interaction associated with this media arrived at the Conatac Center.</p>\n</div><div class='long'><p>The time at which the interaction associated with this media arrived at the Conatac Center.</p>\n</div></div></div><div id='property-CanSendChatMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-CanSendChatMessage' class='name expandable'>CanSendChatMessage</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if a chat message ban be sent by calling the <a href=\"#!/api/MobileCCS.WebchatMedia-method-SendChatMessage\" rel=\"MobileCCS.WebchatMedia-method-SendChatMessage\" class=\"docClass\">SendChatMessage</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if a chat message ban be sent by calling the <a href=\"#!/api/MobileCCS.WebchatMedia-method-SendChatMessage\" rel=\"MobileCCS.WebchatMedia-method-SendChatMessage\" class=\"docClass\">SendChatMessage</a> method.</p>\n</div></div></div><div id='property-CanSendIsTyping' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-CanSendIsTyping' class='name expandable'>CanSendIsTyping</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if a typing notification can be sent by calling the <a href=\"#!/api/MobileCCS.WebchatMedia-method-SendIsTyping\" rel=\"MobileCCS.WebchatMedia-method-SendIsTyping\" class=\"docClass\">SendIsTyping</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if a typing notification can be sent by calling the <a href=\"#!/api/MobileCCS.WebchatMedia-method-SendIsTyping\" rel=\"MobileCCS.WebchatMedia-method-SendIsTyping\" class=\"docClass\">SendIsTyping</a> method.</p>\n</div></div></div><div id='property-CanSendPagePushUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-CanSendPagePushUrl' class='name expandable'>CanSendPagePushUrl</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if a page push url can be sent by calling the <a href=\"#!/api/MobileCCS.WebchatMedia-method-SendPagePushUrl\" rel=\"MobileCCS.WebchatMedia-method-SendPagePushUrl\" class=\"docClass\">SendPagePushUrl</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if a page push url can be sent by calling the <a href=\"#!/api/MobileCCS.WebchatMedia-method-SendPagePushUrl\" rel=\"MobileCCS.WebchatMedia-method-SendPagePushUrl\" class=\"docClass\">SendPagePushUrl</a> method.</p>\n</div></div></div><div id='property-ContactID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ContactID' class='name expandable'>ContactID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The ID of the contact associated with this Media object. ...</div><div class='long'><p>The ID of the contact associated with this Media object.  The value of the <em>ContactID</em> property is a string\nthat identifies the contact within the context of the underlying service provider.</p>\n\n<p>The contents of the contact ID string depend on the underlying service provider, therefore\nthe application should not rely on the <em>ContactID</em> string being of a particular format.</p>\n</div></div></div><div id='property-ContactType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ContactType' class='name expandable'>ContactType</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The contact type for this interaction. ...</div><div class='long'><p>The contact type for this interaction.</p>\n\n<p>This property allows the client to determine what contact type is being handled by this interaction.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">ContactTypes</a> class.</p>\n</div></div></div><div id='property-CustomerLabel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-CustomerLabel' class='name expandable'>CustomerLabel</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the Customer Label as configured by an administrator.</p>\n</div><div class='long'><p>Provides the Customer Label as configured by an administrator.</p>\n</div></div></div><div id='property-DisplayName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-DisplayName' class='name expandable'>DisplayName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the Display Name of the participant who has sent a chat message.</p>\n</div><div class='long'><p>Provides the Display Name of the participant who has sent a chat message.</p>\n</div></div></div><div id='property-From' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-From' class='name expandable'>From</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the address of the customer that initiated the contact.</p>\n</div><div class='long'><p>Provides the address of the customer that initiated the contact.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-Message' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-Message' class='name expandable'>Message</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>A chat message sent by a participant in the chat room.</p>\n</div><div class='long'><p>A chat message sent by a participant in the chat room.</p>\n</div></div></div><div id='property-MessageType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-MessageType' class='name expandable'>MessageType</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The type of message received from a participant in the chat room. ...</div><div class='long'><p>The type of message received from a participant in the chat room.\nPossible values are <strong>normal</strong>, <strong>comfortMessage</strong>, <strong>welcomeMessage</strong> and <strong>whisper</strong>.</p>\n</div></div></div><div id='property-Method' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-Method' class='name expandable'>Method</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Indicates the type of update received from the client. ...</div><div class='long'><p>Indicates the type of update received from the client.\nPossible values are <strong>agentJoinRoom</strong>, <strong>newMessage</strong>, <strong>pagePush</strong>, <strong>customerDisconnect</strong>, <strong><strong> and </strong>exitRoom</strong>.</p>\n</div></div></div><div id='property-SenderID' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-SenderID' class='name expandable'>SenderID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the ID of the sender of a message.</p>\n</div><div class='long'><p>Provides the ID of the sender of a message.</p>\n</div></div></div><div id='property-SenderType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-SenderType' class='name expandable'>SenderType</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Provides participant type of the sender of a message. ...</div><div class='long'><p>Provides participant type of the sender of a message.\nPossible values are <strong>agent</strong> and <strong>customer</strong>.</p>\n</div></div></div><div id='property-Status' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-Status' class='name expandable'>Status</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The status of the interaction. ...</div><div class='long'><p>The status of the interaction.</p>\n\n<p>This property allows the client to determine the current status this interaction.</p>\n\n<p>Possible values are <strong>New</strong>, <strong>Closed</strong>, <strong>Open</strong> and <strong>Waiting</strong>.</p>\n</div></div></div><div id='property-Subject' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-Subject' class='name expandable'>Subject</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The subject of the contact.</p>\n</div><div class='long'><p>The subject of the contact.</p>\n</div></div></div><div id='property-Timestamp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-Timestamp' class='name expandable'>Timestamp</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides a Timestamp associated with a message.</p>\n</div><div class='long'><p>Provides a Timestamp associated with a message.</p>\n</div></div></div><div id='property-Transcript' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-property-Transcript' class='name expandable'>Transcript</a> : Object[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The format of the Transcript is an array of transcript message objects. ...</div><div class='long'><p>The format of the Transcript is an array of transcript message objects.</p>\n\n<p>The format of the message object is as follows:</p>\n\n<ul>\n<li><strong>type</strong></li>\n<li><strong>sender</strong></li>\n<li><strong>displayName</strong></li>\n<li><strong>timestamp</strong></li>\n</ul>\n\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-IsFunctionAvailable' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-SendChatMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-method-SendChatMessage' class='name expandable'>SendChatMessage</a>( <span class='pre'>message, isWhisper</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Send a new chat message to participants in a chat. ...</div><div class='long'><p>Send a new chat message to participants in a chat.</p>\n\n<p>Most errors can be prevented by using the <a href=\"#!/api/MobileCCS.WebchatMedia-property-CanSendChatMessage\" rel=\"MobileCCS.WebchatMedia-property-CanSendChatMessage\" class=\"docClass\">CanSendChatMessage</a> property to determine when it is possible to call this method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>message</span> : String<div class='sub-desc'><p>contains the message sent by the agent.</p>\n</div></li><li><span class='pre'>isWhisper</span> : Boolean<div class='sub-desc'><p>specifies if the message should be sent to other agents only, or all chat participants.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-SendIsTyping' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-method-SendIsTyping' class='name expandable'>SendIsTyping</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Send an isTyping to let other chat participants know this agent is typing. ...</div><div class='long'><p>Send an isTyping to let other chat participants know this agent is typing.</p>\n\n<p>Most errors can be prevented by using the <a href=\"#!/api/MobileCCS.WebchatMedia-property-CanSendIsTyping\" rel=\"MobileCCS.WebchatMedia-property-CanSendIsTyping\" class=\"docClass\">CanSendIsTyping</a> property to determine when it is possible to call this method.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-SendPagePushUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.WebchatMedia'>MobileCCS.WebchatMedia</span><br/></div><a href='#!/api/MobileCCS.WebchatMedia-method-SendPagePushUrl' class='name expandable'>SendPagePushUrl</a>( <span class='pre'>url</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Send a page push url to participants in a chat. ...</div><div class='long'><p>Send a page push url to participants in a chat.</p>\n\n<p>Most errors can be prevented by using the <a href=\"#!/api/MobileCCS.WebchatMedia-property-CanSendPagePushUrl\" rel=\"MobileCCS.WebchatMedia-property-CanSendPagePushUrl\" class=\"docClass\">CanSendPagePushUrl</a> property to determine when it is possible to call this method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>contains the url sent by the agent.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});