/**
 * interactionService contains the callback functions required to interact with the AACC/ACCS server
 * interactionData persists an array of current interactions and all known information provided by the server 
 *
 */
angular.module('refClientJS.interactions', ['ui.router', 'refClientJS.alerts', 'refClientJS.signedin'])

.factory("interactionService", ["$rootScope", "interactionData", "$state", "alertsService", function ($rootScope, interactionData, $state, alertsService) {
        window.interactionServiceScope = interactionService;

        var interactionService = {};    
           
        interactionService.handleInteractions = function (returnedNotifyType, returnedNotifyData) {
            alertsService.log('interactionsService: handleInteractions', returnedNotifyType);

            if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

                if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {

                    return;
                }
                alertsService.addAlert(returnedNotifyData.Message, 'danger');

                console.log(returnedNotifyData);
                $state.go('signedin');

            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.DELETE) {
                interactionData.interactions = interactionData.removeInteraction(returnedNotifyData);                

                alertsService.log('interactionsService: handleInteractions', 'interactions array in the interactionService factory after delete');
                console.log(interactionData.interactions);
                $rootScope.$broadcast('interaction-deleted', returnedNotifyData.ID);
                $state.go('signedin');

            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.NEW) {

                interactionData.interactions = interactionData.addInteraction(returnedNotifyData);

                console.log(interactionData.interactions);
                if (returnedNotifyData.State == 'Preview') {

                    $rootScope.$broadcast('preview-countdown', returnedNotifyData.PreviewTimer);

                }
                $state.go('signedin');
            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.UPDATE) {
                interactionData.interactions = interactionData.updateInteraction(returnedNotifyData);

                console.log(returnedNotifyData);
                if (returnedNotifyData.State == 'Wrapup') {

                    $rootScope.$broadcast('wrapup-countdown', returnedNotifyData.WrapupTimer);

                }


                $rootScope.$broadcast('updateInteractions', interactionData.interactions);
                $state.go('signedin');

            }
            
            alertsService.log('interactionsService: handleInteractions', returnedNotifyData.State + ' ' + returnedNotifyData.ContactType);
            
        };
    
        interactionService.previewDial = function previewDial() {

            //Called when the preview dial timer expires this function calls the preview dial method on the interaction 
            //currently in preview state using the customer number of the interaction marked as the default.

            alertsService.log('interactionsService: previewDial', ' dial timer expired ');

            //search through the interactions searching for preview status and dial
            for (i = 0; i < interactionData.interactions.length; i++) {

                if (interactionData.interactions[i].State === 'Preview' && interactionData.interactions[i].CanPreviewDial) {
                    console.log('interactionService - Preview found');

                    //loop through the interaction contact numbers and find the default
                    for (j = 0; j < interactionData.interactions[i].ContactNumbers.length; j++) {

                        if (interactionData.interactions[i].ContactNumbers[j].IsDefault) {
                            alertsService.log('interactionsService: previewDial', ' dialing');

                            interactionData.interactions[i].PreviewDial(interactionData.interactions[i].ContactNumbers[j]);
                        }
                    }
                    return;
                }
            }


        };
        interactionService.wrapUpInteraction = function wrapUpInteraction() {
            alertsService.log('interactionsService: wrapUpInteraction ', interactionData.interactions.length);
            //search through the contacts, find the contact wtiha wrap up status and complete
            for (i = 0; i < interactionData.interactions.length; i++) {

                if (interactionData.interactions[i].State === 'Wrapup' && interactionData.interactions[i].CanWrapup) {

                    alertsService.log('interactionsService: wrapUpInteraction: ', 'wrapping up');

                    interactionData.interactions[i].Wrapup();

                    return;
                }
            }

        };

        interactionService.getDispositionCodes = function (interaction) {
            alertsService.log('interactionsService: getDispositionCodes ', ' server request');
            interaction.GetDispositionCodes(this.handleDispositionCodes);
        };

        interactionService.getConsultDestinations = function (destType, interaction) {
            alertsService.log('interactionsService: getConsultDestinations ', ' server request');
            interaction.GetConsultDestinations(destType, this.handleConsultDests);

        };

        interactionService.getActivityCodes = function (interaction) {
            alertsService.log('interactionsService: getActivityCodes ', ' server request');
            interaction.GetActivityCodes(this.handleActivityCodes);
        };
    
        interactionService.getCallbackDestinations = function (interaction) {
            alertsService.log('interactionsService: getCallbackDestinations ', ' CallbackDestTypes');
            console.log(interaction.CallbackDestTypes);
            for (j = 0; j < interaction.CallbackDestTypes.length; j++) {

                interaction.GetCallbackDestinations(interaction.CallbackDestTypes[j], this.handleCallbackDestinations);
            }
        };
    
        interactionService.getCustomerHistory = function (interaction, callbackHandler) {            
            if (interaction.CanGetCustomerHistory) {
                alertsService.log('interactionsService: getCustomerHistory ', ' server request');
                interaction.GetCustomerHistory(callbackHandler);
            }
        };
    
        interactionService.getCustomerInteractionMedia = function (interactionID, interaction, callbackHandler) {
            if (interaction.CanGetCustomerInteractionMedia) {
                alertsService.log('interactionsService: getCustomerInteractionMedia ', ' server request');
                interaction.GetCustomerInteractionMedia(interactionID, callbackHandler);
            }
        };
    
        interactionService.handleCallbackDestinations = function (returnedNotifyType, returnedNotifyData) {
            alertsService.log('interactionsService: handleCallbackDestinations ', returnedNotifyType);

            if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

                if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {
                    return;
                }
                alertsService.addAlert(returnedNotifyData.Message, 'danger');
                interactionData.consultDests = [];

                console.log(returnedNotifyData);
            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.RESPONSE) {

                console.log(returnedNotifyData);

                for (var j = returnedNotifyData.DestinationListValues.length - 1; j >= 0; j--) {
                    console.log(returnedNotifyData.DestinationListValues[j]);
                    interactionData.callbackDestinations[interactionData.callbackDestinations.length] = returnedNotifyData.DestinationListValues[j];
                }

                $rootScope.$broadcast('callbackdestinations', interactionData.callbackDestinations);

                $state.go('signedin');
            }
        };

        interactionService.handleActivityCodes = function (returnedNotifyType, returnedNotifyData) {
            alertsService.log('interactionsService: handleActivityCodes ', returnedNotifyType);


            if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

                if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {

                    return;
                }
                alertsService.addAlert(returnedNotifyData.Message, 'danger');
                console.log(returnedNotifyData);
            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.RESPONSE) {
                console.log(returnedNotifyData);
                var parsedCodes = [];
                var element = {};

                for (var key in returnedNotifyData.Codes) {
                    if (returnedNotifyData.Codes.hasOwnProperty(key)) {
                        element.Code = key;
                        element.Name = returnedNotifyData.Codes[key];
                    }
                    parsedCodes.push(element);
                    element = {};
                }
                interactionData.activityCodes = parsedCodes;
                $state.go('signedin');
            }
        };
        interactionService.handleDispositionCodes = function (returnedNotifyType, returnedNotifyData) {
            alertsService.log('interactionsService: handleDispositionCodes ', returnedNotifyType);
            window.returned = returnedNotifyData;

            if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

                if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {

                    return;
                }
                alertsService.addAlert(returnedNotifyData.Message, 'danger');
                console.log(returnedNotifyData);
            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.RESPONSE) {
                console.log(returnedNotifyData);
                var parsedCodes = [];
                var element = {};

                for (var key in returnedNotifyData.Codes) {
                    if (returnedNotifyData.Codes.hasOwnProperty(key)) {
                        element.Code = key;
                        element.Name = returnedNotifyData.Codes[key];
                    }
                    parsedCodes.push(element);
                    element = {};
                }
                interactionData.dispositionCodes = parsedCodes;
                $state.go('signedin');
            }
        };

        interactionService.handleAgentNotes = function (returnedNotifyType, returnedNotifyData) {
            alertsService.log('interactionsService: handleAgentNotes ', returnedNotifyType);
            if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

                if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {

                    return;
                }
                alertsService.addAlert(returnedNotifyData.Message, 'danger');

                console.log(returnedNotifyData);
            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.RESPONSE) {
                console.log(returnedNotifyData);
                interactionData.agentNotes = returnedNotifyData;
                $state.go('signedin');
            }


        };
        interactionService.handleConsultDests = function (returnedNotifyType, returnedNotifyData) {
            alertsService.log('interactionsService: handleConsultDests ', returnedNotifyType);
            if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

                if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {

                    return;
                }
                alertsService.addAlert(returnedNotifyData.Message, 'danger');
                interactionData.consultDests = [];

                console.log(returnedNotifyData);

            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.RESPONSE) {
                console.log(returnedNotifyData);
                interactionData.consultDests = returnedNotifyData.DestinationListValues;
                $state.go('signedin');
            }


        };

        return interactionService;
    }])
    .factory('interactionData', ["alertsService", function (alertsService) {
    
        // interaction store
        var interactions = [];      
        var dispositionCodes = false;        
        var consultDests = false;
        var agentNotes = null;
        var activityCodes = false;    
        var callbackDestinations = [];
        var callbackDestinationTypes = false;
        var tabsInfo = {
            id: "",
            isLoaded: false,
            active: true,
            disabled: false,
            selected: true
        };

        function removeAll() {
            interactions.length = [];            
        }

        function addInteraction(newinteraction) {
            for (var i = interactions.length - 1; i >= 0; i--) {
                if (interactions[i].ID === newinteraction.ID) {
                    return;
                }
            }

            interactions.push(newinteraction);
            console.log(interactions);
            return interactions;
        }

        function removeInteraction(interaction) {

            for (var i = interactions.length - 1; i >= 0; i--) {

                if (interactions[i].ID === interaction.ID) {
                    interactions.splice(i, 1);
                }
            }
            return interactions;
        }

        function updateInteraction(interaction) {
            //loop through and replace based on ID
            //leave in the same place in the array s the view will remain static displaying the contacts

            for (var i = interactions.length - 1; i >= 0; i--) {

                if (interactions[i].ID === interaction.ID) {
                    interactions[i] = interaction;
                }
            }
            return interactions;
        }      
    
        return {
            'interactions': interactions,          
            'addInteraction': addInteraction,
            'removeInteraction': removeInteraction,
            'updateInteraction': updateInteraction,           
            'dispositionCodes': dispositionCodes,           
            'agentNotes': agentNotes,
            'removeAll': removeAll,
            'activityCodes': activityCodes,
            'consultDests': consultDests,
            'callbackDestinations': callbackDestinations,
            'tabsInfo': tabsInfo
        };
    }]);