 /* jshint -W097 */
 "use strict";
/*
  * userService factory handles the user callbacks from the server and includes methods to manipulate the User ObjectNotFound 
  * methods within this factory are called from the other controllers and services it is injected into
*/ 
 var userModule = angular.module('refClientJS.user', ['ui.router', 'refClientJS.alerts']);

 userModule.factory('userService', ["userData", "$state", "alertsService", function (userData, $state, alertsService) {
     var userService = this;

     userService.handleUser = function (returnedNotifyType, returnedNotifyData) {
         alertsService.log("userService handleUser", returnedNotifyType);
         console.log(returnedNotifyData);
         if (returnedNotifyType === MobileCCS.NotifyTypes.ERROR) {
             alertsService.addAlert(returnedNotifyData.Message, 'danger');
             console.log("User notification Error: " + returnedNotifyType + ", Message=" + returnedNotifyData.Message);
             $state.go("signedin");
             return;
         }

         if (returnedNotifyType === MobileCCS.NotifyTypes.DELETE) {
            
             userData.user = {};
             $state.go("login");
             return;
         }
         if (returnedNotifyType === MobileCCS.NotifyTypes.NEW) {
             
             userData.user = returnedNotifyData;
             $state.go("signedin");
             return;


         }
         if (returnedNotifyType === MobileCCS.NotifyTypes.UPDATE) {
            
             userData.user = returnedNotifyData;
             console.log(userData.user);
             $state.go("signedin");
             return;
         }


     };

     userService.getNotReadyReasonCodes = function () {
         alertsService.log("userService getNotReadyReasonCodes","retrieving not ready reason codes from the server");
         userData.user.GetNotReadyReasonCodes(userService.handleNRRCodes);
     };

     userService.handleNRRCodes = function (returnedNotifyType, returnedNotifyData) {
        
        alertsService.log("userService handleNRRCodes", returnedNotifyType);

         if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

             if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {

                 return;
             }

             alertsService.addAlert(returnedNotifyData.Message, 'danger');

             alertsService.logerror("userService handleNRRCodes", returnedNotifyData.Message);

         }

         if (returnedNotifyType === MobileCCS.NotifyTypes.RESPONSE) {
             console.log(returnedNotifyData);
             var parsedCodes = [];
             var element = {};

             for (var key in returnedNotifyData.Codes) {
                 if (returnedNotifyData.Codes.hasOwnProperty(key)) {
                     element.Code = key;
                     element.Name = returnedNotifyData.Codes[key];
                 }
                 parsedCodes.push(element);
                 element = {};
             }
             userData.NRRCodes = parsedCodes;
             $state.go('signedin');
         }

     };

     userService.monitorUsers = function () {
         userData.user.MonitorUsers(userService.handleMonitorUsers);
     };

     userService.handleMonitorUsers = function (returnedNotifyType, returnedNotifyData) {

         alertsService.log("userService handleMonitorUsers", returnedNotifyType);

         console.log(returnedNotifyData);

         if (returnedNotifyType === MobileCCS.NotifyTypes.ERROR) {
             alertsService.addAlert(returnedNotifyData.Message, 'danger');
             alertsService.logerror("userService handleMonitorUsers",returnedNotifyData.Message);
             $state.go("signedin");
             return;
         }

         if (returnedNotifyType === MobileCCS.NotifyTypes.DELETE) {
            
             userData.removeUser(returnedNotifyData);
             $state.go("login");
             return;
         }
         if (returnedNotifyType === MobileCCS.NotifyTypes.NEW) {
            
             userData.addUser(returnedNotifyData);
             console.log(userData.monitoredUsers);
             $state.go("signedin");
             return;


         }
         if (returnedNotifyType === MobileCCS.NotifyTypes.UPDATE) {
             
             userData.updateUser(returnedNotifyData);
             console.log(userData.monitoredUsers);
             $state.go("signedin");
             return;
         }
     };   

     return userService;

 }]);
/*
  * userData factory returns a user Object which persists the current User data for the application
  * used by other services and controllers that require this information.
*/ 

 userModule.factory("userData", function () {
     var user = {};
     var NRRCodes = {};
     var monitoredUsers = [];

     //window variable used for debugging in the console.
     window.userDataScope = user;

     function removeAllMonitoredUsers() {
         monitoredUsers.length = 0;
     }

     //The following methods are used for maintaining the user object
     function addUser(newUser) {
         console.log('addUser');
         console.log(newUser);
         for (var i = monitoredUsers.length - 1; i >= 0; i--) {
             if (monitoredUsers[i].ID === newUser.ID) {
                 return;
             }
         }
         console.log('adding User');
         console.log(monitoredUsers);
         monitoredUsers.push(newUser);

         console.log('after adding User');
         console.log(monitoredUsers);

     }

     function removeUser(User) {

         for (var i = monitoredUsers.length - 1; i >= 0; i--) {

             if (monitoredUsers[i].ID === User.ID) {
                 monitoredUsers.splice(i, 1);
             }
         }
         return monitoredUsers;
     }

     function updateUser(User) {
         for (var i = monitoredUsers.length - 1; i >= 0; i--) {

             if (monitoredUsers[i].ID === User.ID) {
                 monitoredUsers[i] = User;
             }
         }
     }

     return {
         'user': user,
         'NRRCodes': NRRCodes,     
         'monitoredUsers': monitoredUsers,
         'removeAllMonitoredUsers': removeAllMonitoredUsers,
         'addUser': addUser,
         'removeUser': removeUser,
         'updateUser': updateUser
     };

 });