angular.module("templates-app", ["customer/customerDetails/customer-details.tpl.html", "customer/customerHistory/customer-history.tpl.html", "customer/customerName/customer-name.tpl.html", "home/home.tpl.html", "interaction/customer-content.tpl.html", "interaction/interaction-caps.tpl.html", "interaction/interaction-props.tpl.html", "interaction/screenpops-content.tpl.html", "media/email-media.tpl.html", "media/webchat-media.tpl.html", "resources/resource-caps.tpl.html", "resources/resource-props.tpl.html", "signedin/ActivityCodesModal.tpl.html", "signedin/ACWCodesModal.tpl.html", "signedin/CallBackModal.tpl.html", "signedin/ConsultModal.tpl.html", "signedin/DataModal.tpl.html", "signedin/DispCodesModal.tpl.html", "signedin/IntrinsicsModal.tpl.html", "signedin/LoginModal.tpl.html", "signedin/NRRCodesModal.tpl.html", "signedin/signedin.tpl.html", "signedin/UUIModal.tpl.html", "signin/signin.tpl.html", "supervisor/monitoredUsers.tpl.html", "supervisor/NRRForcedCodesModal.tpl.html", "user/user-caps.tpl.html", "user/user-props.tpl.html"]);

angular.module("customer/customerDetails/customer-details.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("customer/customerDetails/customer-details.tpl.html",
    "<h5><b>Phones:</b></h5>\n" +
    "\n" +
    "<!-- display the customer phones currently administered on the server -->\n" +
    "<div ng-repeat='phone in selectedCustomer.PhoneList.PhoneListValues'>\n" +
    "    <input id='inpPhoneCountryCode{{$index}}' placeholder='Enter Country Code' ng-model='phone.CountryCode'>\n" +
    "    <input id='inpPhoneAreaCode{{$index}}' placeholder='Enter Area Code' ng-model='phone.AreaCode'>\n" +
    "    <input id='inpPhoneNumber{{$index}}' placeholder='Enter Phone Number' ng-model='phone.PhoneNumber'>\n" +
    "    <input id='inpPhoneTimeZone{{$index}}' placeholder='Enter Timezone' ng-model='phone.Timezone'>\n" +
    "    <label for='inpPhoneDefault'>Default</label>\n" +
    "    <input id='inpPhoneDefault' type=\"checkbox\" ng-model='phone.IsDefault'>\n" +
    "    <label for='inpPhoneDoNotCall' ng-hide='selectedInteraction !== undefined && selectedInteraction.ContactType === \"POM_Outbound\"'>DoNotCall</label>\n" +
    "    <input id='inpPhoneDoNotCall' type=\"checkbox\" ng-model='phone.DoNotCall' ng-hide='selectedInteraction !== undefined && selectedInteraction.ContactType === \"POM_Outbound\"'>\n" +
    "\n" +
    "    <button id='btnSaveCustPhone{{$index}}' class=\"btn btn-default\" ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanUpdateCustomerPhone : true)' ng-click='updateCustomerPhone(phone)'>Save</button>\n" +
    "\n" +
    "    <button id='btnRemoveCustPhone{{$index}}' class=\"btn btn-default\" ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanRemoveCustomerPhone : true)' ng-click='removeCustomerPhone(phone.ID)'>Delete</button>\n" +
    "\n" +
    "    <!-- DNC is only for POM contacts -->\n" +
    "    <button id='btnDNC' class=\"btn btn-default\" ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanAddToDNC : true)' ng-show='selectedInteraction !== undefined && selectedInteraction.ContactType === \"POM_Outbound\"' ng-click='addToDNC(phone.ID)'>DNC</button>\n" +
    "</div>\n" +
    "\n" +
    "<button id='btnAddCustPhone' class='btn btn-default' ng-click='showNewCustomerPhone(true)' ng-hide='showNewPhone' ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanAddCustomerPhone : true)'>Add New Phone</button>\n" +
    "\n" +
    "<!-- template for adding new phone, display if add phone was clicked -->\n" +
    "<div ng-show=\"showNewPhone\">\n" +
    "    <input id='inpNewPhoneCountryCode' placeholder='Enter Country Code' ng-model='newPhone.CountryCode'>\n" +
    "    <input id='inpNewPhonePhoneAreaCode' placeholder='Enter Area Code' ng-model='newPhone.AreaCode'>\n" +
    "    <input id='inpNewPhonePhoneNumber' placeholder='Enter Phone Number' ng-model='newPhone.PhoneNumber'>\n" +
    "    <input id='inpNewPhoneTimeZone' placeholder='Enter Timezone' ng-model='newPhone.Timezone'>    \n" +
    "    <label for='inpNewPhoneDefault'>Default</label>\n" +
    "    <input id='inpNewPhoneDefault' type=\"checkbox\" ng-model='newPhone.IsDefault'>\n" +
    "    <label for='inpNewPhoneDoNotCall'>DoNotCall</label>\n" +
    "    <input id='inpNewPhoneDoNotCall' type=\"checkbox\" ng-model='newPhone.DoNotCall'>\n" +
    "\n" +
    "    <!-- cancel and save are displayed once add phone is clicked -->\n" +
    "    <button id='btnCancelNewCustPhone' class='btn btn-default' ng-click='showNewCustomerPhone(false)'>Cancel</button>\n" +
    "    <button id='btnSaveNewCustPhone' class='btn btn-default' ng-click='addCustomerPhone()'>Save</button>\n" +
    "</div>\n" +
    "\n" +
    "<hr>\n" +
    "\n" +
    "<h5><b>Addresses:</b></h5>\n" +
    "\n" +
    "<!-- display the customer addresses currently administered on the server -->\n" +
    " <div ng-repeat='postalAddress in selectedCustomer.AddressList.PostalAddressValues'>\n" +
    "    <input id='inpAddrLine1{{$index}}' placeholder='Enter Address Line 1' ng-model='postalAddress.Line1'>\n" +
    "    <input id='inpAddrLine2{{$index}}' placeholder='Enter Address Line 2' ng-model='postalAddress.Line2'>\n" +
    "    <input id='inpAddrLine3{{$index}}' placeholder='Enter Address Line 3' ng-model='postalAddress.Line3'>\n" +
    "    <input id='inpAddrLine4{{$index}}' placeholder='Enter Address Line 4' ng-model='postalAddress.Line4'>\n" +
    "    <input id='inpAddrLine5{{$index}}' placeholder='Enter Address Line 5' ng-model='postalAddress.Line5'>\n" +
    "    <input id='inpAddrCountry{{$index}}' placeholder='Enter Country' ng-model='postalAddress.Country'>\n" +
    "    <input id='inpAddrZip{{$index}}' placeholder='Enter Zipcode' ng-model='postalAddress.ZipCode'>\n" +
    "    <label for='inpAddrDefault{{$index}}'>Default</label>\n" +
    "    <input id='inpAddrDefault{{$index}}' type=\"checkbox\" ng-model='postalAddress.IsDefault'>\n" +
    "\n" +
    "    <button id='btnSaveCustAddress{{$index}}' class=\"btn btn-default\" ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanUpdateCustomerAddress : true)' ng-click='updateCustomerAddress(postalAddress)'>Save</button>\n" +
    "    <button id='btnRemoveCustAddress{{$index}}' class=\"btn btn-default\" ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanRemoveCustomerAddress : true)' ng-click='removeCustomerAddress(postalAddress.ID)'>Delete</button>\n" +
    "</div>\n" +
    "\n" +
    "<button id='btnAddCustAddress' class='btn btn-default' ng-click='showNewCustomerAddress(true)' ng-hide='showNewAddress' ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanAddCustomerAddress : true)'>Add New Address</button>\n" +
    "\n" +
    "<!-- template for adding new address, display if add address was clicked -->\n" +
    "<div ng-show=\"showNewAddress\">\n" +
    "    <input id='inpNewAddrLine1' placeholder='Enter Address Line 1' ng-model='newPostalAddress.Line1'>\n" +
    "    <input id='inpNewAddrLine2' placeholder='Enter Address Line 2' ng-model='newPostalAddress.Line2'>\n" +
    "    <input id='inpNewAddrLine3' placeholder='Enter Address Line 3' ng-model='newPostalAddress.Line3'>\n" +
    "    <input id='inpNewAddrLine4' placeholder='Enter Address Line 4' ng-model='newPostalAddress.Line4'>\n" +
    "    <input id='inpNewAddrLine5' placeholder='Enter Address Line 5' ng-model='newPostalAddress.Line5'>\n" +
    "    <input id='inpNewAddrCountry' placeholder='Enter Country' ng-model='newPostalAddress.Country'>\n" +
    "    <input id='inpNewAddrZip' placeholder='Enter Zipcode' ng-model='newPostalAddress.ZipCode'>\n" +
    "    <label for='inpNewAddrDefault'>Default</label>\n" +
    "    <input id='inpNewAddrDefault' type=\"checkbox\" ng-model='newPostalAddress.IsDefault'>\n" +
    "\n" +
    "    <!-- cancel and save are displayed once add address is clicked -->\n" +
    "    <button id='btnCancelNewCustAddress' class='btn btn-default' ng-click='showNewCustomerAddress(false)'>Cancel</button>\n" +
    "    <button id='btnSaveNewCustAddress' class=\"btn btn-default\" ng-click='addCustomerAddress()'>Save</button>\n" +
    "</div>            \n" +
    "\n" +
    "<hr>\n" +
    "\n" +
    "<h5><b>Emails:</b></h5>\n" +
    "<!-- display the customer email addresses currently administered on the server -->\n" +
    "<div ng-repeat='emailAddress in selectedCustomer.EmailAddresses.EmailValues'>\n" +
    "    <input id='inpEmail{{$index}}' type='text' placeholder='Enter Email Address' ng-model='emailAddress.Email' />\n" +
    "    <label for='inpEmailDefault{{$index}}'>Default</label>\n" +
    "    <input id='inpEmailDefault{{$index}}' type=\"checkbox\" ng-model='emailAddress.IsDefault'>\n" +
    "\n" +
    "    <button id='btnSaveCustEmail{{$index}}' class=\"btn btn-default\" ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanUpdateCustomerEmail : true)' ng-click='updateCustomerEmail(emailAddress)'>Save</button>\n" +
    "    <button id='btnRemoveCustEmail{{$index}}' class=\"btn btn-default\" ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanRemoveCustomerEmail : true)' ng-click='removeCustomerEmail(emailAddress.ID)'>Delete</button>\n" +
    "</div>\n" +
    "\n" +
    "<button id='btnAddCustEmail' class='btn btn-default' ng-click='showNewCustomerEmail(true)' ng-hide='showNewEmail' ng-disabled='!(selectedInteraction !== undefined ? selectedInteraction.CanAddCustomerEmail : true)'>Add New Email</button>\n" +
    "\n" +
    "<!-- template for adding a new email address, display if add new email was clicked -->\n" +
    "<div ng-show=\"showNewEmail\">\n" +
    "    <input id='inpNewEmail' type='text' placeholder='Enter Email Address' ng-model='newEmailAddress.Email' />   \n" +
    "    <label for='inpNewEmailDefault'>Default</label>\n" +
    "    <input id='inpNewEmailDefault' type=\"checkbox\" ng-model='newEmailAddress.IsDefault'>\n" +
    "\n" +
    "    <!-- cancel and save are displayed once add new email is clicked -->\n" +
    "    <button id='btnCancelNewCustEmail' class='btn btn-default' ng-click='showNewCustomerEmail(false)'>Cancel</button>\n" +
    "    <button id='btnSaveNewCustEmail' class='btn btn-default' ng-click='addCustomerEmail()'>Save</button>\n" +
    "</div>");
}]);

angular.module("customer/customerHistory/customer-history.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("customer/customerHistory/customer-history.tpl.html",
    "<h5><b>Customer Interactions</b></h5>  \n" +
    "<!-- proof of concept angular-ui-grid -->\n" +
    "<div id=\"customerHistoryGrid\" ui-grid=\"customerHistoryGridOptions\" ui-grid-auto-resize ui-grid-selection ui-grid-pagination class=\"grid\">\n" +
    "</div>\n" +
    "\n" +
    "<div ng-show=\"customerInteractionMediaList === undefined\">  \n" +
    "    <hr>    \n" +
    "    <h5><b>No Customer Interaction Selected</b></h5>  \n" +
    "</div>\n" +
    "\n" +
    "<!-- display of selected customer interaction media objects -->   \n" +
    "<div ng-show=\"customerInteractionMediaList !== undefined\">     \n" +
    "    <hr>\n" +
    "    <h5><b>Media for Selected Interaction: {{customerInteractionMediaList.ContactID}}</b></h5>    \n" +
    "    <div ng-repeat=\"media in customerInteractionMediaList.Medias\">   \n" +
    "        <span><b>Source:</b> {{media.Source}}</span>\n" +
    "        <br>\n" +
    "        <span><b>Creation Time:</b> {{media.CreationTime}}</span>\n" +
    "        <br>\n" +
    "        <div ng-hide=\"{{media.UserRole === undefined}}\">\n" +
    "            <span><b>Created by Agent:</b> {{media.UserFirstName}} {{media.UserLastName}}</span>  \n" +
    "            <br>\n" +
    "        </div>\n" +
    "\n" +
    "        <!-- media content (messages sent and received etc) -->\n" +
    "        <div>\n" +
    "            <div ng-hide=\"{{media.From === undefined}}\">\n" +
    "                <span><b>From:</b> {{media.From}}</span>\n" +
    "                <br>\n" +
    "            </div>\n" +
    "            <div ng-hide=\"{{media.To === undefined}}\">\n" +
    "                <span><b>To:</b> {{media.To}}</span>\n" +
    "                <br>\n" +
    "            </div>\n" +
    "            <div ng-hide=\"{{media.CC === undefined}}\">\n" +
    "                <span><b>CC:</b> {{media.CC}}</span>\n" +
    "                <br>\n" +
    "            </div>\n" +
    "            <div ng-hide=\"{{media.BCC === undefined}}\">\n" +
    "                <span><b>BCC:</b> {{media.BCC}}</span>\n" +
    "                <br>\n" +
    "            </div>\n" +
    "            <div ng-hide=\"{{media.Subject === undefined}}\">\n" +
    "                <span><b>Subject:</b> {{media.Subject}}</span>\n" +
    "                <br>\n" +
    "            </div>\n" +
    "            <!-- bootstrap well class -->\n" +
    "            <div ng-hide=\"{{media.Body === undefined}}\" class=\"well\">{{media.Body}}<br></div>\n" +
    "            <div ng-hide=\"{{media.BodyHtml === undefined}}\" ng-bind-html=\"media.BodyHtml\" class=\"well\"><br></div>\n" +
    "        </div>        \n" +
    "        <div ng-hide=\"{{media.Attachments === undefined}}\">\n" +
    "            <span><b>Attachments:</b></span>   \n" +
    "            <div ng-repeat=\"attachment in media.Attachments\"> \n" +
    "                <p><a ng-href=\"{{attachment.Address}}\" target=\"_blank\">{{attachment.Name}}</a></p>\n" +
    "            </div>\n" +
    "            <br>\n" +
    "        </div>\n" +
    "        <div ng-hide=\"{{media.ClosedReason === undefined}}\">\n" +
    "            <span><b>Close Reason:</b> {{media.ClosedReason}}</span>     \n" +
    "            <br>\n" +
    "        </div>\n" +
    "        <div ng-hide=\"{{media.Note === undefined}}\">\n" +
    "            <span><b>Agent Note:</b> {{media.Note}}</span>     \n" +
    "            <br>\n" +
    "        </div>        \n" +
    "    </div>    \n" +
    "    <hr>\n" +
    "</div>");
}]);

angular.module("customer/customerName/customer-name.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("customer/customerName/customer-name.tpl.html",
    "<div>                    \n" +
    "    <input id='inpTitle' placeholder='Enter Title' ng-model='title'>\n" +
    "    <input id='inpFName' placeholder='Enter First Name' ng-model='firstName'>\n" +
    "    <input id='inpLName' placeholder='Enter Last Name' ng-model='lastName'>\n" +
    "    <button id='btnSaveCustName' class=\"btn btn-default\" ng-click='updateCustomerName()'>Save</button>\n" +
    "</div>");
}]);

angular.module("home/home.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("home/home.tpl.html",
    "<div class=\"jumbotron\">\n" +
    "    <h1>Avaya Aura Contact Center</h1>\n" +
    "\n" +
    "    <p class=\"lead\">\n" +
    "        Sign into the contact center\n" +
    "    </p>\n" +
    "    <!--Welcome page to app -highest level where user can navigate to form to sign into contact center->\n" +
    "    <div class=\"btn-group\">\n" +
    "        <!--changes state to signin-->\n" +
    "    <a id=\"btnSignin\" ui-sref=\"signin\" class=\"btn btn-large btn-default\">\n" +
    "        <i class=\"fa fa-book\"></i> Sign in\n" +
    "    </a>\n" +
    "</div>\n" +
    "\n" +
    "</div>");
}]);

angular.module("interaction/customer-content.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("interaction/customer-content.tpl.html",
    "<!--Customer Details at this stage it is only relevant for POM, EMail and Webchat interactions -->\n" +
    "<div class=\"left-nav\" ng-show='interactionSelected.ContactType == \"POM_Outbound\" || interactionSelected.ContactType == \"EMail\" || interactionSelected.ContactType == \"Web_Communications\"'>\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\">\n" +
    "            <accordion-heading>\n" +
    "                Customer\n" +
    "                <span class=\"caret\"></span>\n" +
    "            </accordion-heading>\n" +
    "            \n" +
    "            <customer-name interaction=\"interactionSelected\" customer=\"interactionSelected.Customer\"></customer-name>\n" +
    "\n" +
    "            <hr>\n" +
    "\n" +
    "            <tabset panel-tabs=\"true\" panel-class=\"{{demoTabbedPanelClass}}\" heading=\"{{demoTabbedPanelHeading}}\">\n" +
    "\n" +
    "                <!-- tab for customer details content -->\n" +
    "                <tab index=\"0\" heading=\"Details\">\n" +
    "                    <customer-details interaction=\"interactionSelected\" customer=\"interactionSelected.Customer\"></customer-details>             \n" +
    "                </tab>\n" +
    "                \n" +
    "                <!-- ng-click is a workaround for the problem, when the inner grid does not render until scrolled or resized -->>\n" +
    "                <tab index=\"1\" heading=\"History\"  ng-click=\"\">                     \n" +
    "                    <customer-history interaction=\"interactionSelected\"></customer-history>\n" +
    "                </tab>\n" +
    "                \n" +
    "            </tabset>            \n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>\n" +
    "\n" +
    "<div class=\"content\">\n" +
    "</div>");
}]);

angular.module("interaction/interaction-caps.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("interaction/interaction-caps.tpl.html",
    "<div class=\"left-nav\">\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\" ng-show='demo'>\n" +
    "            <accordion-heading>\n" +
    "                Interaction Capabilities\n" +
    "                <span class=\"caret\" />\n" +
    "            </accordion-heading>\n" +
    "\n" +
    "            <table class=\"table table-bordered table-striped\">\n" +
    "                <tbody>\n" +
    "                    <tr>\n" +
    "                        <td>CanAddAgentNote</td>\n" +
    "                        <td>{{interactionSelected.CanAddAgentNote}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanAddCustomerAddress</td>\n" +
    "                        <td>{{interactionSelected.CanAddCustomerAddress}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanAddCustomerEmail</td>\n" +
    "                        <td>{{interactionSelected.CanAddCustomerEmail}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanAddCustomerPhone</td>\n" +
    "                        <td>{{interactionSelected.CanAddCustomerPhone}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanAddToDNC</td>\n" +
    "                        <td>{{interactionSelected.CanAddToDNC}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanAnswer</td>\n" +
    "                        <td>{{interactionSelected.CanAnswer}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanChangeConferenceOwner </td>\n" +
    "                        <td>{{interactionSelected.CanChangeConferenceOwner }} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanCompleteConference </td>\n" +
    "                        <td>{{interactionSelected.CanCompleteConference}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanCompleteTransfer</td>\n" +
    "                        <td>{{interactionSelected.CanCompleteTransfer}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanCreateCallback</td>\n" +
    "                        <td>{{interactionSelected.CanCreateCallback}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanEmergency</td>\n" +
    "                        <td>{{interactionSelected.CanEmergency}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanEnd </td>\n" +
    "                        <td>{{interactionSelected.CanEnd}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanEndConference</td>\n" +
    "                        <td>{{interactionSelected.CanEndConference}} </td>\n" +
    "                    </tr>                    \n" +
    "                    <tr>\n" +
    "                        <td>CanExtendWrapup </td>\n" +
    "                        <td>{{interactionSelected.CanExtendWrapup}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetActivityCodes </td>\n" +
    "                        <td>{{interactionSelected.CanGetActivityCodes}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetAutoPhrases </td>\n" +
    "                        <td>{{interactionSelected.CanGetAutoPhrases}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetCallbackDestinations </td>\n" +
    "                        <td>{{interactionSelected.CanGetCallbackDestinations}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetConsultDestinations </td>\n" +
    "                        <td>{{interactionSelected.CanGetConsultDestinations}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetCustomerDetails </td>\n" +
    "                        <td>{{interactionSelected.CanGetCustomerDetails}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetCustomerHistory </td>\n" +
    "                        <td>{{interactionSelected.CanGetCustomerHistory}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetCustomerInteractionMedia </td>\n" +
    "                        <td>{{interactionSelected.CanGetCustomerInteractionMedia}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetDispositionCodes </td>\n" +
    "                        <td>{{interactionSelected.CanGetDispositionCodes}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetPagePushUrls </td>\n" +
    "                        <td>{{interactionSelected.CanGetPagePushUrls}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanGetSkillsets </td>\n" +
    "                        <td>{{interactionSelected.CanGetSkillsets}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanHold</td>\n" +
    "                        <td>{{interactionSelected.CanHold}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanInitiateConference </td>\n" +
    "                        <td>{{interactionSelected.CanInitiateConference}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanInitiateConferenceToDestination </td>\n" +
    "                        <td>{{interactionSelected.CanInitiateConferenceToDestination}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanInitiateTransfer </td>\n" +
    "                        <td>{{interactionSelected.CanInitiateTransfer}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanInitiateTransferToDestination </td>\n" +
    "                        <td>{{interactionSelected.CanInitiateTransferToDestination }} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanJoinConference</td>\n" +
    "                        <td>{{interactionSelected.CanJoinConference}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanOpenMedia</td>\n" +
    "                        <td>{{interactionSelected.CanOpenMedia}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanPlayDTMF</td>\n" +
    "                        <td>{{interactionSelected.CanPlayDTMF}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanPreviewCancel </td>\n" +
    "                        <td>{{interactionSelected.CanPreviewCancel}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanPreviewDial </td>\n" +
    "                        <td>{{interactionSelected.CanPreviewDial}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanPreviewDialFreeForm </td>\n" +
    "                        <td>{{interactionSelected.CanPreviewDialFreeForm}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRedial</td>\n" +
    "                        <td>{{interactionSelected.CanRedial}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRefreshAgentNotes </td>\n" +
    "                        <td>{{interactionSelected.CanRefreshAgentNotes}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRemoveCustomerAddress </td>\n" +
    "                        <td>{{interactionSelected.CanRemoveCustomerAddress}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRemoveCustomerEmail </td>\n" +
    "                        <td>{{interactionSelected.CanRemoveCustomerEmail}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRemoveCustomerPhone </td>\n" +
    "                        <td>{{interactionSelected.CanRemoveCustomerPhone}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRemoveData </td>\n" +
    "                        <td>{{interactionSelected.CanRemoveData}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRemoveIntrinsic </td>\n" +
    "                        <td>{{interactionSelected.CanRemoveIntrinsic}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanSetActivityCode</td>\n" +
    "                        <td>{{interactionSelected.CanSetActivityCode}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanSetClosedReasonCode</td>\n" +
    "                        <td>{{interactionSelected.CanSetClosedReasonCode}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanSetIntrinsic</td>\n" +
    "                        <td>{{interactionSelected.CanSetIntrinsic}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanSetUUI </td>\n" +
    "                        <td>{{interactionSelected.CanSetUUI}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanTransferToDestination </td>\n" +
    "                        <td>{{interactionSelected.CanTransferToDestination}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanUnhold </td>\n" +
    "                        <td>{{interactionSelected.CanUnhold}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanUpdateCustomerAddress</td>\n" +
    "                        <td>{{interactionSelected.CanUpdateCustomerAddress}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanUpdateCustomerEmail </td>\n" +
    "                        <td>{{interactionSelected.CanUpdateCustomerEmail}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanUpdateCustomerName </td>\n" +
    "                        <td>{{interactionSelected.CanUpdateCustomerName}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanUpdateCustomerPhone</td>\n" +
    "                        <td>{{interactionSelected.CanUpdateCustomerPhone}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>PreviewTimer</td>\n" +
    "                        <td>{{interactionSelected.PreviewTimer}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>WrapupTimer</td>\n" +
    "                        <td>{{interactionSelected.WrapupTimer}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanWrapup </td>\n" +
    "                        <td>{{interactionSelected.CanWrapup}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanWrapupWithCode </td>\n" +
    "                        <td>{{interactionSelected.CanWrapupWithCode}} </td>\n" +
    "                    </tr>\n" +
    "                </tbody>\n" +
    "            </table>\n" +
    "\n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>");
}]);

angular.module("interaction/interaction-props.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("interaction/interaction-props.tpl.html",
    "<div class=\"left-nav\">\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\" ng-show='demo'>\n" +
    "            <accordion-heading>\n" +
    "                Interaction Properties\n" +
    "                <span class=\"caret\" />\n" +
    "            </accordion-heading>\n" +
    "\n" +
    "            <table class=\"table table-bordered table-striped\">\n" +
    "                <tbody>\n" +
    "                    <tr>\n" +
    "                        <td>ActivityCode</td>\n" +
    "                        <td>{{interactionSelected.ActivityCode}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>Address</td>\n" +
    "                        <td>{{interactionSelected.Address}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CallingAddress </td>\n" +
    "                        <td>{{interactionSelected.CallingAddress}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CalledAddress </td>\n" +
    "                        <td>{{interactionSelected.CalledAddress}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>ContactID</td>\n" +
    "                        <td>{{interactionSelected.ContactID}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>ContactType</td>\n" +
    "                        <td>{{interactionSelected.ContactType}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>Skillset </td>\n" +
    "                        <td>{{interactionSelected.Skillset}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>State </td>\n" +
    "                        <td>{{interactionSelected.State}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>StateReason</td>\n" +
    "                        <td>{{interactionSelected.StateReason}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>OriginalDestination </td>\n" +
    "                        <td>{{interactionSelected.OriginalDestination}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>Participation Reason </td>\n" +
    "                        <td>{{interactionSelected.ParticipationReason}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CampaignName </td>\n" +
    "                        <td>{{interactionSelected.CampaignName}} </td>\n" +
    "                    </tr>\n" +
    "                </tbody>\n" +
    "\n" +
    "            </table>\n" +
    "        </accordion-group>\n" +
    "\n" +
    "    </accordion>\n" +
    "</div>");
}]);

angular.module("interaction/screenpops-content.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("interaction/screenpops-content.tpl.html",
    "<div class=\"left-nav\" ng-show='interactionSelected.ScreenPops.length > 0'>\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\">\n" +
    "            <accordion-heading>\n" +
    "                Screenpops\n" +
    "                <span class=\"caret\"></span>\n" +
    "            </accordion-heading>\n" +
    "            \n" +
    "            <tabset panel-tabs=\"true\" panel-class=\"{{demoTabbedPanelClass}}\" heading=\"{{demoTabbedPanelHeading}}\">\n" +
    "                <tab ng-repeat=\"screenpop in interactionSelected.ScreenPops\" index=\"$index + 1\" heading=\"{{screenpop.Name}}\">\n" +
    "                    <iframe ng-src={{trustUrl(screenpop.Path)}} height=\"400\" width=\"100%\" style=\"border:none;\">\n" +
    "                    </iframe>\n" +
    "                </tab> \n" +
    "            </tabset>            \n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>\n" +
    "\n" +
    "<div class=\"content\">\n" +
    "</div>");
}]);

angular.module("media/email-media.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("media/email-media.tpl.html",
    "<div class=\"left-nav\">     \n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\">  \n" +
    "            <accordion-heading>\n" +
    "                Email Content\n" +
    "                <span class=\"caret\" />\n" +
    "            </accordion-heading>\n" +
    "\n" +
    "            <!-- email received view -->\n" +
    "            <div ng-hide=\"replyClicked || transferClicked || finishClicked || isCompleted || isInitiated\">\n" +
    "                <!-- email details -->\n" +
    "                <div>\n" +
    "                    <span>Subject: {{media.Subject}}</span>\n" +
    "                    <br/>\n" +
    "                    <span>From: {{media.From}}</span>\n" +
    "                    <br/>\n" +
    "                    <span>To: {{media.To}}</span>\n" +
    "                    <br/>\n" +
    "                    <a ng-click=\"toggleShowMediaDetails()\">\n" +
    "                        <span ng-show=\"!mediaDetailsDisplayed\">Show Details</span>\n" +
    "                        <span ng-show=\"mediaDetailsDisplayed\">Hide Details</span>\n" +
    "                        <span class=\"caret cursor-pointer\"></span>  \n" +
    "                    </a>\n" +
    "                    <div ng-show=\"mediaDetailsDisplayed\">\n" +
    "                        <span>CC: {{media.CC}}</span>                    \n" +
    "                        <br/>\n" +
    "                        <span>BCC: {{media.BCC}}</span>                    \n" +
    "                        <br/>\n" +
    "                        <span>Sent: {{media.ArrivalTime}}</span>                    \n" +
    "                        <br/>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <!-- email content -->\n" +
    "                <div>\n" +
    "                    <div contenteditable=\"false\" class=\"content-area form-control\" ng-model=\"media.Body\">                        \n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                \n" +
    "                <!-- display received email attachments -->\n" +
    "                <div ng-show=\"media.Attachments.length > 0\">\n" +
    "                    <span>Attachments:</span>\n" +
    "                    \n" +
    "                    <span ng-repeat=\"attachment in media.Attachments\">\n" +
    "                        <a ng-href=\"{{attachment.Address}}\" target=\"_blank\">{{attachment.Name}}</a>                    \n" +
    "                    </span>                    \n" +
    "                </div>\n" +
    "            </div>\n" +
    "\n" +
    "            <!-- email reply and initiate view -->\n" +
    "            <div ng-show=\"replyClicked || isInitiated\" ng-hide=\"isCompleted\">\n" +
    "\n" +
    "                <!-- email suggested responses -->\n" +
    "                <div ng-show=\"suggestedResponses.length > 0\">\n" +
    "                    <label for=\"suggestedResponsesList\">Suggested Responses:</label>\n" +
    "                    <select id=\"suggestedResponsesList\" ng-options=\"suggestedResponse.Name for suggestedResponse in suggestedResponses track by suggestedResponse.ID\" ng-model=\"data.selectedSuggestedResponse\">\n" +
    "                    </select>\n" +
    "                    <button id=\"insertSuggestedResponseBtn\" class=\"btn btn-default\" ng-click=\"insertSuggestedResponse()\" ng-disabled=\"data.selectedSuggestedResponse === undefined\">Insert</button>\n" +
    "                    <button id=\"removeSuggestedResponseBtn\" class=\"btn btn-default\" ng-click=\"removeSuggestedResponse()\" ng-disabled=\"!suggestedResponseInserted\">Remove</button>\n" +
    "                </div>\n" +
    "\n" +
    "                <hr>\n" +
    "\n" +
    "                <!-- skillsets list for initiate email -->\n" +
    "                <div class=\"form-group\" ng-show=\"isInitiated\">\n" +
    "                    <label for=\"initiateEmailSkillsetList\">Skillsets:</label>\n" +
    "                    <select id=\"initiateEmailSkillsetList\" class=\"form-control\" ng-options=\"skillset.Name for skillset in destinationSkillsets track by skillset.Number\" ng-model=\"data.selectedSkillset\">\n" +
    "                    </select>\n" +
    "                </div>\n" +
    "\n" +
    "\n" +
    "                <div ng-show=\"(isInitiated && data.selectedSkillset !== undefined) || replyClicked\">\n" +
    "                    <!-- email reply or initiate details -->\n" +
    "                    <div class=\"form-group\">\n" +
    "                        <label for=\"emailReplyToTextFields\">To:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailReplyToTextField\" ng-model=\"emailContent.to\">\n" +
    "                        <label for=\"emailReplyCcTextField\">CC:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailReplyCcTextField\" ng-model=\"emailContent.cc\">\n" +
    "                        <label for=\"emailReplyBccTextField\">BCC:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailReplyBccTextField\" ng-model=\"emailContent.bcc\">\n" +
    "                        <label for=\"emailReplySubjectTextField\">Subject:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailReplySubjectTextField\" ng-model=\"emailContent.subject\">\n" +
    "                    </div>\n" +
    "                    <!-- email reply content, original message in editable text area -->\n" +
    "                    <div>\n" +
    "                        <!-- use a content editable div instead of text area to display emails received from the server in html format -->\n" +
    "                        <div contenteditable=\"true\" ng-model=\"emailContent.body\" class=\"content-area form-control\"></div>\n" +
    "                    </div>\n" +
    "\n" +
    "                    <!-- adding email attachments -->\n" +
    "                    <div>\n" +
    "                        <span><b>Attachments:</b></span>\n" +
    "                        <br>\n" +
    "                        <label for=\"attachmentsFileInput\" class=\"label-as-btn\">Select Files</label>\n" +
    "                        <!-- custom onFileChange directive -->\n" +
    "                        <input type=\"file\" multiple on-file-change=\"addAttachmentFiles(files)\" id=\"attachmentsFileInput\" class=\"hidden\" />\n" +
    "                        <!-- display added attachments -->\n" +
    "                        <span ng-repeat=\"attachmentFile in outgoingAttachments\">{{attachmentFile.name}}\n" +
    "                            <button class=\"btn btn-default\" ng-click=\"removeAttachmentFile(attachmentFile)\">Remove</button>\n" +
    "                        </span>\n" +
    "                    </div>\n" +
    "\n" +
    "                    <!-- agent note -->\n" +
    "                    <div>\n" +
    "                        <label for=\"agentNoteReplyTextArea\">Agent Note:</label>\n" +
    "                        <textarea class=\"form-control\" rows=\"2\" ng-model=\"data.agentNote\" id=\"agentNoteReplyTextArea\">\n" +
    "                    </textarea>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "\n" +
    "            <!-- email transfer view -->\n" +
    "            <div ng-show=\"transferClicked\">\n" +
    "                <label for=\"transferToOptionForm\">Transfer To:</label>\n" +
    "                <form id=\"transferToOptionForm\">\n" +
    "                    <label class=\"radio-inline\">\n" +
    "                        <input type=\"radio\" ng-model=\"data.transferTo\" value=\"skillset\">\n" +
    "                        Skillset\n" +
    "                    </label>\n" +
    "                    <label class=\"radio-inline\">\n" +
    "                        <input type=\"radio\" ng-model=\"data.transferTo\" value=\"user\">\n" +
    "                        User\n" +
    "                    </label>\n" +
    "                    <label class=\"radio-inline\">\n" +
    "                        <input type=\"radio\" ng-model=\"data.transferTo\" value=\"external\">\n" +
    "                        External\n" +
    "                    </label>\n" +
    "                </form>\n" +
    "\n" +
    "                <!-- skillsets list -->\n" +
    "                <div class=\"form-group\" ng-show=\"data.transferTo === 'skillset'\">\n" +
    "                    <label for=\"selectListSkillset\">Skillsets:</label>\n" +
    "                    <select id=\"selectListSkillset\" class=\"form-control\" ng-options=\"skillset.Name for skillset in destinationSkillsets track by skillset.Number\" ng-model=\"data.selectedSkillset\">   \n" +
    "                        <option value=\"\">--- Clear ---</option>                        \n" +
    "                    </select>                    \n" +
    "                </div>  \n" +
    "                \n" +
    "                <!-- users list -->\n" +
    "                <div class=\"form-group\" ng-show=\"data.transferTo === 'user'\">\n" +
    "                    <label for=\"selectListUser\">Users:</label>\n" +
    "                    <select id=\"selectListUser\" class=\"form-control\" ng-options=\"user.Name for user in consultUsers track by user.Number\" ng-model=\"data.selectedUser\">   \n" +
    "                        <option value=\"\">--- Clear ---</option>                        \n" +
    "                    </select>                    \n" +
    "                </div>\n" +
    "                \n" +
    "                <!-- external forward of email -->\n" +
    "                <div class=\"form-group\" ng-show=\"data.transferTo === 'external'\">\n" +
    "                    <div class=\"form-group\">\n" +
    "                        <label for=\"emailForwardToTextField\">To:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailForwardToTextField\" ng-model=\"emailContent.to\">\n" +
    "                        <label for=\"emailForwardCcTextField\">CC:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailForwardCcTextField\" ng-model=\"emailContent.cc\">\n" +
    "                        <label for=\"emailForwardBccTextField\">BCC:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailForwardBccTextField\" ng-model=\"emailContent.bcc\">\n" +
    "                        <label for=\"emailForwardSubjectTextField\">Subject:</label>\n" +
    "                        <input type=\"text\" class=\"form-control\" id=\"emailForwardSubjectTextField\" ng-model=\"emailContent.subject\">\n" +
    "                    </div>\n" +
    "                    <!-- email forward content, original message in editable text area -->\n" +
    "                    <div contenteditable=\"true\" ng-model=\"emailContent.body\" class=\"content-area form-control\">\n" +
    "                    </div>                   \n" +
    "                </div>\n" +
    "                <!-- transfer agent note -->\n" +
    "                <div>\n" +
    "                    <label for=\"agentNoteTransferTextArea\">Agent Note:</label>\n" +
    "                    <textarea class=\"form-control\" rows=\"2\" ng-model=\"data.agentNote\" id=\"agentNoteTransferTextArea\">                        \n" +
    "                    </textarea>\n" +
    "                </div>                \n" +
    "            </div>\n" +
    "\n" +
    "            <!-- disposition view -->\n" +
    "            <div ng-show=\"finishClicked || isCompleted\">\n" +
    "                <!-- agent closing note -->\n" +
    "                <div>\n" +
    "                    <label for=\"agentNoteCloseTextArea\">Agent Closing Note:</label>\n" +
    "                    <textarea class=\"form-control\" rows=\"4\" ng-model=\"data.closingAgentNote\" id=\"agentNoteCloseTextArea\">                        \n" +
    "                    </textarea>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "\n" +
    "            <hr>\n" +
    "\n" +
    "            <!-- email controls -->\n" +
    "            <div>      \n" +
    "                <button id='btnEmailFinish' ng-click='finish()' ng-hide=\"replyClicked || transferClicked || finishClicked || isCompleted || isInitiated\" type=\"button\" class=\"btn btn-default\">Finish</button>\n" +
    "                <button id='btnEmailCancel' ng-click='cancel()' ng-show='replyClicked || transferClicked || finishClicked || (isInitiated && !isCompleted)' type=\"button\" class=\"btn btn-default\">Cancel</button>\n" +
    "\n" +
    "                <button id='btnEmailClose' ng-click='close()' ng-show=\"finishClicked || isCompleted\" ng-disabled='!(selectedInteraction.CanEnd)' type=\"button\" class=\"btn btn-default\">Close</button>                \n" +
    "                <button id='btnEmailReply' ng-click='reply()' ng-hide='replyClicked || transferClicked || finishClicked || isCompleted || isInitiated' type=\"button\" class=\"btn btn-default\">Reply</button>                \n" +
    "                <button id='btnEmailReplyAll' ng-click='replyAll()' ng-hide='replyClicked || transferClicked || finishClicked || isCompleted || isInitiated' type=\"button\" class=\"btn btn-default\">Reply All</button>                \n" +
    "                <button id='btnEmailTransfer' ng-click='transfer()' ng-hide='replyClicked || finishClicked || isCompleted || isInitiated' ng-disabled='shouldDisableTransferButton()' type='button' class='btn btn-default'>Transfer</button>                \n" +
    "                <button id='btnEmailSendReply' ng-click='sendEmailReply()' ng-show='replyClicked' type=\"button\" class=\"btn btn-default\">Send</button>\n" +
    "                <button id='btnSendEmail' ng-click='sendEmail()' ng-show='isInitiated && !isCompleted' type=\"button\" class=\"btn btn-default\">Send</button>\n" +
    "            </div>\n" +
    "\n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>");
}]);

angular.module("media/webchat-media.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("media/webchat-media.tpl.html",
    "<div class=\"left-nav\">     \n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\">  \n" +
    "            <accordion-heading>\n" +
    "                Webchat Content\n" +
    "                <span class=\"caret\" />\n" +
    "            </accordion-heading>\n" +
    "\n" +
    "            <!-- webchat content view -->\n" +
    "            <div>\n" +
    "                <!-- webchat details -->\n" +
    "                <div>\n" +
    "                    <span>Skillset: {{selectedInteraction.Skillset}}</span>\n" +
    "                    <br/>\n" +
    "                    <span>Contact ID: {{selectedInteraction.ContactID}}</span>\n" +
    "                    <br/>\n" +
    "                </div>\n" +
    "                <div ng-hide=\"finishClicked || isCompleted || consultTransferClicked || (selectedInteraction.IsConsult && !consultInitiated)\">\n" +
    "                    <label for=\"textChatArea\">Customer Text Chat:</label>\n" +
    "                    <div contenteditable=\"false\" class=\"content-area form-control\" ng-model=\"data.chatBody\" id=\"textChatArea\">                        \n" +
    "                    </div>\n" +
    "                    <div>\n" +
    "                        <span id=\"typingLabel\" ng-show='isCustomerTyping'>The Customer is currently writing a message.</span>\n" +
    "                        <br ng-hide='isCustomerTyping'>\n" +
    "                    </div>\n" +
    "                    <!-- agent typing area -->\n" +
    "                    <div>\n" +
    "                        <textarea class=\"form-control\" rows=\"2\" ng-model=\"data.agentTypedText\" ng-change='isTyping()' ng-disabled=\"shouldDisableChatControls\" id=\"agentTypeTextArea\"></textarea>\n" +
    "                    </div>\n" +
    "                    <br/>\n" +
    "                    <button id='btnWcSend' ng-click='sendMessage(data.agentTypedText)' type=\"button\" class=\"btn btn-default\" ng-disabled=\"shouldDisableChatControls\">Send</button>\n" +
    "                    <button id='btnWcFinish' ng-click='finish()' type=\"button\" class=\"btn btn-default\">Finish</button>\n" +
    "                    <button id='btnWcConsultTransfer' ng-click='displayTransfer()' type='button' class='btn btn-default' ng-disabled=\"shouldDisableChatControls\">Consult/Transfer</button>\n" +
    "                    <select id=\"selectListPhrase\" class=\"pull-right\" ng-options=\"autoPhrase.Phrase for autoPhrase in autoPhrases\" ng-model=\"data.selectedPhrase\">   \n" +
    "                        <option value=\"\"> Phrases </option>                        \n" +
    "                    </select>\n" +
    "                    <select id=\"selectListUrls\" class=\"pull-right\" ng-options=\"urlList.Url for urlList in pagePushUrls\" ng-model=\"data.selectedUrl\">   \n" +
    "                        <option value=\"\"> URLs </option>                        \n" +
    "                    </select>\n" +
    "                    <div>\n" +
    "                        <label class=\"pull-right\"> Email Transcript to Customer: \n" +
    "                            <input id=\"chkBoxSendChat\" type=\"checkbox\" ng-model=\"data.sendChatTranscript\" ng-disabled=\"shouldDisableChatControls\">\n" +
    "                        </label>\n" +
    "                    </div>\n" +
    "\n" +
    "                </div>              \n" +
    "            </div>\n" +
    "            \n" +
    "            <!-- webchat consult/transfer view -->\n" +
    "            <div ng-show=\"consultTransferClicked\">\n" +
    "                <label for=\"transferToOptionForm\">Transfer To:</label>\n" +
    "                <form id=\"transferToOptionForm\">\n" +
    "                    <label class=\"radio-inline\">\n" +
    "                        <input type=\"radio\" ng-model=\"data.transferTo\" value=\"skillset\">\n" +
    "                        Skillset\n" +
    "                    </label>\n" +
    "                </form>\n" +
    "\n" +
    "                <!-- skillsets list -->\n" +
    "                <div class=\"form-group\" ng-show=\"data.transferTo === 'skillset'\">\n" +
    "                    <label for=\"selectListSkillset\">Skillsets:</label>\n" +
    "                    <select id=\"selectListSkillset\" class=\"form-control\" ng-options=\"skillset.Name for skillset in transferSkillsets track by skillset.Number\" ng-model=\"data.selectedSkillset\">   \n" +
    "                        <option value=\"\">--- Clear ---</option>                        \n" +
    "                    </select>                    \n" +
    "                </div>  \n" +
    "                \n" +
    "                <!-- transfer reason note -->\n" +
    "                <div>\n" +
    "                    <label for=\"agentTransferReasonTextArea\">Transfer Reason:</label>\n" +
    "                    <textarea class=\"form-control\" rows=\"2\" ng-model=\"data.agentTransferReason\" id=\"agentTransferReasonTextArea\">                        \n" +
    "                    </textarea>\n" +
    "                    <br>\n" +
    "                </div>\n" +
    "                \n" +
    "                <button id='btnWcTransfer' ng-click='transferToSkillset()' ng-disabled='shouldDisableTransferButton()' type='button' class='btn btn-default'>Transfer</button>\n" +
    "            </div>\n" +
    "            \n" +
    "            <!-- disposition view -->\n" +
    "            <div ng-show=\"finishClicked || isCompleted\">\n" +
    "                <!-- agent closing note -->\n" +
    "                <div>\n" +
    "                    <label for=\"agentNoteCloseTextArea\">Agent Closing Note:</label>\n" +
    "                    <textarea class=\"form-control\" rows=\"4\" ng-model=\"data.closingAgentNote\" id=\"agentNoteCloseTextArea\">                        \n" +
    "                    </textarea>\n" +
    "                    <br/>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            \n" +
    "            <div>\n" +
    "                <button id='btnWcCancel' ng-click='cancel()' ng-show='finishClicked || consultTransferClicked' type=\"button\" class=\"btn btn-default\">Cancel</button>\n" +
    "                <button id='btnWcClose' ng-click='close()' ng-show=\"finishClicked || isCompleted\" ng-disabled='!(selectedInteraction.CanEnd)' type=\"button\" class=\"btn btn-default\">Close</button>\n" +
    "            </div>  \n" +
    "\n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>");
}]);

angular.module("resources/resource-caps.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("resources/resource-caps.tpl.html",
    "<div class=\"left-nav\">\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\" >\n" +
    "            <accordion-heading class='panel-title-info'>\n" +
    "                Resource Capabilities\n" +
    "                <span id='caretResourceCaps' class=\"caret\" </span>\n" +
    "            </accordion-heading>\n" +
    "\n" +
    "            <table class=\"table table-bordered table-striped\">\n" +
    "                <tbody>\n" +
    "                    <tr>\n" +
    "                        <td>CanCallSupervisor</td>\n" +
    "                        <td>{{resource.CanCallSupervisor}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanOriginate </td>\n" +
    "                        <td>{{resource.CanOriginate}} </td>\n" +
    "                    </tr>\n" +
    "                </tbody>\n" +
    "\n" +
    "            </table>\n" +
    "\n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>");
}]);

angular.module("resources/resource-props.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("resources/resource-props.tpl.html",
    "<div class=\"left-nav\">\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\" ng-show='demo'>\n" +
    "            <accordion-heading>\n" +
    "                Resource Properties\n" +
    "                <span id='caretResourceProps' class=\"caret\" </span>\n" +
    "            </accordion-heading>\n" +
    "\n" +
    "            <table class=\"table table-bordered table-striped\">\n" +
    "                <tbody>\n" +
    "                    <tr>\n" +
    "                        <td>ID</td>\n" +
    "                        <td>{{resource.ID}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>ContactTypes</td>\n" +
    "                        <td>{{resource.ContactTypes}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>Default Contact Type</td>\n" +
    "                        <td>{{resource.DefaultContactType}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>Address </td>\n" +
    "                        <td>{{resource.Address}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>State </td>\n" +
    "                        <td>{{resource.State}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>State Reason</td>\n" +
    "                        <td>{{resource.StateReason}} </td>\n" +
    "                    </tr>\n" +
    "                </tbody>\n" +
    "\n" +
    "            </table>\n" +
    "\n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>");
}]);

angular.module("signedin/ActivityCodesModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/ActivityCodesModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"ActivityCodesModal.tpl.html\">-->\n" +
    "<div id=\"modalhdrDispo\" class=\"modal-header\">\n" +
    "    <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Form to allow selection of activity code\" class=\"modal-title center\">Select an Activity Code</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyDispo\" class=\"modal-body\">\n" +
    "    <form id='frmDispoCodes' name='dispositionModalForm'>\n" +
    "        <div ng-show='codes'>\n" +
    "            <table id='tblCodes'>\n" +
    "                <tr ng-repeat=\"x in codes\">\n" +
    "\n" +
    "                    <td>\n" +
    "                        <input name='inpRadio' id='{{x.Code}}' type=\"radio\" ng-model='$parent.selected' ng-value='x'> {{ x.Code }} {{ x.Name }}</td>\n" +
    "                </tr>\n" +
    "            </table>\n" +
    "            <p ng-hide='codes'>Loading codes....</p>\n" +
    "        </div>\n" +
    "</div>\n" +
    "<div id=\"modalfooterDispo\" class=\"modal-footer\">\n" +
    "    <p ng-hide='!(selected)'> Selected: {{selected}}</p>\n" +
    "    <button type='submit' id='btnSubmit' ng-click='submit(selected)'>Set Activity</button>\n" +
    "    </form>\n" +
    "</div>\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("signedin/ACWCodesModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/ACWCodesModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"ACWCodesModal.html\">-->\n" +
    "<div id=\"modalhdrACW\" class=\"modal-header\">\n" +
    "    <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Form to allow selection of activity code\" class=\"modal-title center\">Select an After Call Work Code</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyACW\" class=\"modal-body\">\n" +
    "    <form id='frmACWCodes' name='ACWModalForm'>\n" +
    "        <div ng-show='codes'>\n" +
    "            <table id='tblCodes'>\n" +
    "                <tr ng-repeat=\"x in codes\">\n" +
    "\n" +
    "                    <td>\n" +
    "                        <input name='inpRadio' id='{{x.Code}}' type=\"radio\" ng-model='$parent.selected' ng-value='x'> {{ x.Code }} {{ x.Name }}</td>\n" +
    "                </tr>\n" +
    "            </table>\n" +
    "            <p ng-hide='codes'>Loading codes....</p>\n" +
    "        </div>\n" +
    "</div>\n" +
    "<div id=\"modalfooterDispo\" class=\"modal-footer\">\n" +
    "    <p ng-hide='!(selected)'> Selected: {{selected}}</p>\n" +
    "    <button type='submit' id='btnSubmit' ng-click='submit(selected)'>Set After Call Work Code</button>\n" +
    "    </form>\n" +
    "</div>\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("signedin/CallBackModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/CallBackModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"CallBackModal.tpl.html\">-->\n" +
    "<div class='min-app-width'>\n" +
    "<div id=\"modalhdrCallBack\" class=\"modal-header\">\n" +
    "    <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"CallBack form\" class=\"modal-title center\">Schedule Callback</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyCallBack\" class=\"modal-body align-center\">\n" +
    "    <div class=\"container\">\n" +
    "        <div class=\"row clearfix\">\n" +
    "            <div class=\"col-md-12 column\">\n" +
    "                <form id='frmCB' role=\"form\" name='callbackModalForm' >\n" +
    "                    <div class=\"form-group\" ng-class=\"{ 'has-error': callbackModalForm.$invalid && callbackModalForm.$dirty }\" >\n" +
    "                    <div class=\"row\">\n" +
    "                        <div class=\"col-sm-10 col-md-10\">\n" +
    "                            <div class=\"panel panel-default\">\n" +
    "                                <div class=\"panel-heading \">Callback Date Time </div>\n" +
    "                                <div class=\"panel-body\">\n" +
    "                                    <div class=\"row\">\n" +
    "                                        <!--Callback Date Time-->\n" +
    "                                        <div class=\"col-sm-10 col-md-10\">\n" +
    "                                            <div class=\"panel panel-default\">\n" +
    "                                                <div class=\"panel-body\">\n" +
    "                                                    <div class=\"col-sm-6 \">\n" +
    "                                                        <label for=\"inpStartDate\" class=\"form-control-label\">Date</label>\n" +
    "                                                        <input type=\"datetime-local\" id='inpStartDate' name=\"inputDate\" class=\"form-control\" ng-model='callbackDate.callbackDateTime'required>\n" +
    "                                                        <span class=\"validation-prompt\" ng-show=\"callbackModalForm.inputDate.$error.required\">Required</span>\n" +
    "                                                        </p>\n" +
    "                                                    </div>\n" +
    "\n" +
    "                                                    <div class=\"col-sm-6 \">\n" +
    "                                                        <label for=\"inpExpiryMinutes\" class=\"form-control-label\">Expires in (minutes)</label>\n" +
    "                                                        <input id='inpExpiryMinutes' class=\"form-control\" name=\"inputExpiryMinutes\" type=\"number\" \n" +
    "                                                         ng-model=\"callbackDate.expiryMinutes\" required>\n" +
    "                                                        <span class=\"validation-prompt\" ng-show=\"callbackModalForm.inputExpiryDate.$error.required\">Required</span>\n" +
    "                                                    </div>\n" +
    "                                                </div>\n" +
    "                                            </div>\n" +
    "                                        </div>\n" +
    "                                    </div>\n" +
    "                                </div>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                    </div>\n" +
    "\n" +
    "                    <!--Call back Destinations Start-->\n" +
    "                 \n" +
    "\n" +
    "                    <div class=\"row\">\n" +
    "                        <div class=\"col-sm-10\">\n" +
    "                            <div class=\"panel panel-default\">\n" +
    "                                <div class=\"panel-heading \">Callback Type </div>\n" +
    "                                <div class=\"panel-body\">\n" +
    "                                    <div class=\"row\">\n" +
    "                                        <div class=\"col-sm-12\">\n" +
    "                                            <table align=\"center\" id='tblDestinations'>\n" +
    "                                                <tr ng-repeat=\"x in destinations track by $index\">\n" +
    "\n" +
    "                                                    <td>\n" +
    "                                                    <input name='destinationRadio' id='{{x.Name}}' type=\"radio\" ng-model='$parent.callback.callbackDest' ng-value='x' required> {{ x.DestinationType }} {{ x.Name }} {{ x.State }} {{ x.Number }} Zone: {{ x.PomZone }} </td>\n" +
    "                                                     <span class=\"validation-prompt\" ng-show=\"callbackModalForm.destinationRadio.$error.required\">Required</span>\n" +
    "                                                </tr>\n" +
    "                                            </table>\n" +
    "                                        </div>\n" +
    "                                    </div>\n" +
    "\n" +
    "                                </div>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                    </div>\n" +
    "    <!--Call back Destinations End-->\n" +
    "\n" +
    "                    <div class=\"row\">\n" +
    "                        <!--Memo-->\n" +
    "                        <div class=\"col-sm-10\">\n" +
    "                            <div class=\"panel panel-default\">\n" +
    "                                <div class=\"panel-heading \">Agent Notes </div>\n" +
    "                                <div class=\"panel-body\">\n" +
    "                                    <!--ng-maxlength=\"32767\"-->\n" +
    "                                    <textarea class=\"col-xs-12 orm-control\" rows=\"3\" id='txtMemo' name='textMemo' ng-model=\"callback.agentNotes\" ng-maxlength=\"32767\"></textarea>\n" +
    "                                    <p ng-show=\"callbackModalForm.textMemo.$error.maxlength\" class=\"help-block\">Agent note is too long.</p>\n" +
    "                                </div>\n" +
    "\n" +
    "                            </div>\n" +
    "\n" +
    "                        </div>\n" +
    "                        </p>\n" +
    "                    </div>\n" +
    "\n" +
    "                    <!--Customer Contact Details-->\n" +
    "                    <div class=\"row\">\n" +
    "                        <div class=\" col-sm-10 form-inline\">\n" +
    "                            <div class=\"panel panel-default\">\n" +
    "\n" +
    "                                <div class=\"panel-heading \">Contact Details </div>\n" +
    "                                <div class=\"panel-body\">\n" +
    "                                    </p>\n" +
    "\n" +
    "                                    <label class=\"span1 col-sm-3\" id='lblPhoneCallback' for=\"inpPhoneCallback\">Phone</label>\n" +
    "\n" +
    "                                    <select allow-clear=\"true\" name=\"SelectCallbackNumber\" id=\"SelectCBNumber\" ng-model=\"interaction.ContactNumbers.repeatSelect\" class='form-control' ng-required='!contactNumberExternal' >\n" +
    "                                        <option id=\"optSelectOption\" value=''>--- Select a Customer Number ---</option>\n" +
    "                                        <option id=\"optCBContactNumber{{$index}}\" ng-selected= '{{n == interaction.ContactNumbers.repeatSelect}}' ng-repeat='n in interaction.ContactNumbers' value='{{n}} '  > {{n.Name}}: {{n.Number}} , Is default:{{n.IsDefault}}, Timezone:{{n.Timezone}}</option>\n" +
    "                                    </select>\n" +
    "                                    <button class='btn btn-default btn-custom' id='btnSubmit' ng-disabled='callbackModalForm.$invalid || !interaction.ContactNumbers.repeatSelect' ng-click='createCallback() '>Create Callback</button>\n" +
    "\n" +
    "                                    </br>\n" +
    "                                    </p>\n" +
    "                                    <label class=\"span1 col-sm-3\" id='lblNumberCallback' for='inpNumberCallback'>Number</label>\n" +
    "                                    <input class=\"span3 col-sm-3 form-control\" id='inpNumberCallback' name = 'NumberCallback' ng-required='!interaction.ContactNumbers.repeatSelect' ng-model='contactNumberExternal' type=\"text\" >\n" +
    "                                    <button class='btn btn-default btn-custom' id='btnSubmitExternal' ng-disabled='callbackModalForm.$invalid || !contactNumberExternal' ng-click='createCallbackExternal() '>Callback External Number</button>\n" +
    "                                    </br>\n" +
    "                                    </p>\n" +
    "                                    <span class=\"validation-prompt\" ng-show=\"callbackModalForm.SelectCallbackNumber.$error.required || callbackModalForm.NumberCallback.$error.required\"> Select a customer contact number</span>\n" +
    "                                    </p>\n" +
    "                                </div>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                    </div>\n" +
    "\n" +
    "\n" +
    "\n" +
    "\n" +
    "                </form>\n" +
    "\n" +
    "\n" +
    "\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>\n" +
    "<div class=\"row\">\n" +
    "    <div id=\"modalfooterCallBack\" class=\"modal-footer\">\n" +
    "        <button id='btnCancelScheduleCallback' ng-click=\"cancel()\">Cancel</button>\n" +
    "    </div>\n" +
    "</div>");
}]);

angular.module("signedin/ConsultModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/ConsultModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"ConsultModal.tpl.html\">-->\n" +
    "<div id=\"modalhdrDispo\" class=\"modal-header\">\n" +
    "    <button id='btnCancel' aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Form to select consult destination\" class=\"modal-title center\">Select a destination</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyDispo\" class=\"modal-body\">\n" +
    "    <form id='frmConsult' name='consultModalForm'>\n" +
    "\n" +
    "\n" +
    "<tabset>\n" +
    " <tab ng-repeat=\"tab in interaction.ConsultDestTypes\" heading=\"{{tab}}\" ng-click=\"onTabSelect(tab)\">\n" +
    "     <table id='tblAgentDests1'>\n" +
    "          <tr ng-show='consultDests.length' ng-repeat=\"x in consultDests\">\n" +
    "                <td name='Dest{{index}}' id='{{x.Number}}' ng-value='x'> {{ x.Number }} {{ x.Name }}\n" +
    "                     <button type='submit' id='btnConsult' ng-click='initConf(x)'>Consult</button>\n" +
    "                     <button type='submit' id='btnTransfer' ng-click='initTrans(x)'>Transfer</button>\n" +
    "                </td>\n" +
    "            </tr>\n" +
    "        </table>\n" +
    "    </tab>\n" +
    "</tabset>\n" +
    "\n" +
    "</br>\n" +
    "</br>\n" +
    "\n" +
    "        <p ng-hide='consultDests.length'>No Consult Destinations....</p>\n" +
    "\n" +
    "</div>\n" +
    "\n" +
    "<div id=\"modalfooterDispo\" class=\"modal-footer\">\n" +
    "    <button id='btnRefresh' ng-click='refresh()'>Refresh</button>\n" +
    "\n" +
    "\n" +
    "</div>\n" +
    "</form>\n" +
    "\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("signedin/DataModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/DataModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"DataModal.tpl.html\">-->\n" +
    "<div id=\"modalhdrData\" class=\"modal-header\">\n" +
    "    <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Data of the interaction\" class=\"modal-title center\">Data</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyData\" class=\"modal-body\">\n" +
    "    <form id='frmData' name='dataModalForm'>\n" +
    "\n" +
    "        <tabset active=\"activeJustified\" justified=\"true\">\n" +
    "            <tab index=\"0\" heading='Key / Value Pairs'>\n" +
    "                <table id='tblKVP' class=\"table table-bordered table-striped\">\n" +
    "                    <tbody>\n" +
    "                        <thead>\n" +
    "                            <tr>\n" +
    "                                <td>\n" +
    "                                    Name\n" +
    "                                </td>\n" +
    "                                <td>\n" +
    "                                    Value\n" +
    "                                    \n" +
    "                                </td>\n" +
    "                              \n" +
    "                            </tr>\n" +
    "                        </thead>\n" +
    "                        <tr ng-repeat=\"(key, value) in dataKVP.KVP\">\n" +
    "                            <td>\n" +
    "                                {{ key }}\n" +
    "                               \n" +
    "                            </td>\n" +
    "                            <td>\n" +
    "                                {{ value }}\n" +
    "                             \n" +
    "                            </td>\n" +
    "                           \n" +
    "                        </tr>\n" +
    "                        <tr>\n" +
    "                            <td>\n" +
    "                                <input type=\"text\" id='inpNewKVPKey' name=\"inpNewKVPName\" ng-value= 'key' ng-model='dataNewKVPkey'>\n" +
    "                            </td>\n" +
    "                            <td>\n" +
    "                                <input type=\"text\" id='inpNewKVPValue' name=\"inpNewKVPValue\" ng-value= 'value' ng-model='dataNewKVPvalue'>\n" +
    "                            </td>\n" +
    "                            <td>\n" +
    "                                <button id='btnAddData' ng-disabled='!interaction.CanSetData' ng-click='addKVPData(dataNewKVPkey,dataNewKVPvalue)' type=\"button\" class=\"btn btn-default\">Add</button>\n" +
    "                            </td>\n" +
    "                        </tr>\n" +
    "                    </tbody>\n" +
    "\n" +
    "                </table>\n" +
    "               \n" +
    "                <button id='btnUpdateData' ng-disabled='!(interaction.CanSetData)' ng-click='interaction.SetData(dataKVP.KVP)' type=\"button\" class=\"btn btn-default\">Update</button>\n" +
    "            </tab>\n" +
    "\n" +
    "            <tab index=\"1\" heading=\"String Data\" >\n" +
    "                {{dataSTR.STR}} \n" +
    "                <input type=\"text\" id='inpDataValue' name=\"inpDataValue\" ng-value= 'dataSTR.STR' ng-model='dataSTR.STR'>\n" +
    "                <button id='btnUpdateData' ng-disabled='(!interaction.CanSetData)' ng-click='interaction.SetData(dataSTR.STR)' type=\"button\" class=\"btn btn-default\">Update</button>\n" +
    "                \n" +
    "            </tab>\n" +
    "\n" +
    "            <tab index=\"2\" heading=\"Binary Data\">\n" +
    "                <div ng-repeat=\"n in dataBIN.BIN track by $index\"> {{n}} </div>\n" +
    "                \n" +
    "            </tab>\n" +
    "\n" +
    "        </tabset>\n" +
    "        \n" +
    "        <button id='btnRemoveData' ng-disabled='!(interaction.CanRemoveData)' ng-click='interaction.RemoveData()' type=\"button\" class=\"btn btn-default\">Remove all data</button>\n" +
    "\n" +
    "\n" +
    "    </form>\n" +
    "</div>\n" +
    "<div id=\"modalfooterData\" class=\"modal-footer\">\n" +
    "\n" +
    "\n" +
    "</div>\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("signedin/DispCodesModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/DispCodesModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"DispCodesModal.tpl.html\">-->\n" +
    "<div id=\"modalhdrDispo\" class=\"modal-header\">\n" +
    "    <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Form to allow selection of disposition code\" class=\"modal-title center\">Select a Disposition Code</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyDispo\" class=\"modal-body\">\n" +
    "    <form id='frmDispoCodes' name='dispositionModalForm'>\n" +
    "        <div ng-show='dispositionCodes'>\n" +
    "            <table id='tblDispositionCodes'>\n" +
    "                <tr ng-repeat=\"x in dispositionCodes\">\n" +
    "\n" +
    "                    <td>\n" +
    "                        <input name='dispositionRadio' id='{{x.Code}}' type=\"radio\" ng-model='$parent.dispoSelected' ng-value='x'> {{ x.Code }} {{ x.Name }}</td>\n" +
    "                </tr>\n" +
    "            </table>\n" +
    "            <p ng-hide='dispositionCodes'>Loading codes....</p>\n" +
    "        </div>\n" +
    "</div>\n" +
    "<div class='panel-body'>\n" +
    "    <button ng-click='clearAlerts()' ng-show='alerts.length > 0'>Clear All Alerts</button>\n" +
    "\n" +
    "    <!--Loop through the messages and display in panel-->\n" +
    "    <alert ng-repeat=\"alert in alerts\" type=\"{{alert.type}}\" close=\"closeAlert($index)\">{{alert.msg}}</alert>\n" +
    "</div>\n" +
    "<div id=\"modalfooterDispo\" class=\"modal-footer\">\n" +
    "    <p ng-hide='!(dispoSelected)'> Selected: {{dispoSelected}}</p>\n" +
    "    <button type='submit' id='submitDispo' ng-click='submit(dispoSelected)'>Disposition</button>\n" +
    "    </form>\n" +
    "</div>\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("signedin/IntrinsicsModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/IntrinsicsModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"IntrinsicsModal.tpl.html\">-->\n" +
    "<div id=\"modalhdrIntrinsics\" class=\"modal-header\">\n" +
    "    <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Data of the interaction\" class=\"modal-title center\">Intrinsics</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyIntrinsics\" class=\"modal-body\">\n" +
    "    <form id='frmIntrinsics' name='intrinsicsModalForm' ng-class=\"{ 'has-error' : newIntrinsicForm.newInpIntKey.$invalid && !newIntrinsicForm.newInpIntKey.$pristine && newIntrinsicForm.newInpIntValue.$invalid && !newIntrinsicForm.newInpIntValue.$pristine }\">\n" +
    "\n" +
    "        <tabset active=\"activeJustified\" justified=\"true\">\n" +
    "            <tab index=\"0\" heading='Interaction Intrinsics'>\n" +
    "                <table id='tblKVP' class=\"table table-bordered table-striped\">\n" +
    "                    <tbody>\n" +
    "                        <thead>\n" +
    "                            <tr>\n" +
    "                                <td>\n" +
    "                                    Intrinsic Name\n" +
    "                                </td>\n" +
    "                                <td>\n" +
    "                                    Intrinsic Value\n" +
    "                                </td>\n" +
    "                                <td>\n" +
    "                                    Update\n" +
    "                                </td>\n" +
    "                                <td>\n" +
    "                                    Remove\n" +
    "                                </td>\n" +
    "                            </tr>\n" +
    "                        </thead>\n" +
    "                        <tr ng-repeat=\"(key,value) in intrinsics\">\n" +
    "                            <td>\n" +
    "                                {{ key }}\n" +
    "                            </td>\n" +
    "                            <td>\n" +
    "                                {{ value }}\n" +
    "                            </td>\n" +
    "                            <td >\n" +
    "                                <input type=\"text\" id='inpIntrinsicValue' name=\"inpIntValue\" ng-value= 'value' ng-model='value' ng-show='!(interaction.IsIntrinsicReadOnly(key))' >\n" +
    "                                <button id='btnUpdateIntrinsic' ng-disabled='(interaction.IsIntrinsicReadOnly(key) && !interaction.CanSetIntrinsic)' ng-click='interaction.SetIntrinsic(key, value)' type=\"button\" class=\"btn btn-default\">Update</button>\n" +
    "                            </td>\n" +
    "                            <td>\n" +
    "                                <button id='btnRemoveIntrinsic' ng-disabled='!(interaction.CanRemoveIntrinsic)' \n" +
    "                                ng-click='interaction.RemoveIntrinsic(key)' type=\"button\" class=\"btn btn-default\">Remove</button>\n" +
    "                            </td>\n" +
    "                        </tr>\n" +
    "                        <tr>\n" +
    "                            <td>\n" +
    "                                 <input type=\"text\" id='inpNewIntrinsicKey' name=\"newInpIntKey\" class=\"form-control\" ng-model='newIntrinsicKey' required>\n" +
    "                                 <p ng-show=\"intrinsicsModalForm.newInpIntKey.$invalid && !intrinsicsModalForm.newInpIntKey.$pristine\" class=\"help-block\">Key is required.</p>\n" +
    "                             </td>\n" +
    "                             <td>\n" +
    "                                 <input type=\"text\" id='inpNewIntrinsicValue' name=\"newInpIntValue\" class=\"form-control\" ng-model='newIntrinsicValue' required>\n" +
    "                                 <p ng-show=\"intrinsicsModalForm.newInpIntValue.$invalid && !intrinsicsModalForm.newInpIntValue.$pristine\" class=\"help-block\">Value is required.</p>\n" +
    "                             </td>\n" +
    "                             <td>\n" +
    "                                 <button id='btnAddIntrinsic' ng-disabled='!newIntrinsicKey && !newIntrinsicValue' ng-click='interaction.SetIntrinsic(newIntrinsicKey, newIntrinsicValue)' type=\"button\" class=\"btn btn-default\">Add</button>                               \n" +
    "                             </td>\n" +
    "                        </tr>\n" +
    "\n" +
    "                    </tbody>\n" +
    "\n" +
    "                </table>\n" +
    "            </tab>\n" +
    "\n" +
    "        </tabset>\n" +
    "\n" +
    "\n" +
    "\n" +
    "    </form>\n" +
    "</div>\n" +
    "<div id=\"modalfooterIntrinsics\" class=\"modal-footer\">\n" +
    "\n" +
    "\n" +
    "</div>\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("signedin/LoginModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/LoginModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"LoginModal.tpl.html\">-->\n" +
    "<div id=\"modalbodyIntrinsics\" class=\"modal-body login-modal-content\">\n" +
    "    \n" +
    "    <form name=\"loginForm\"  role=\"form\">\n" +
    "        <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "\n" +
    "        <div class=\"form-group\" ng-class=\"{ 'has-error': loginForm.loginID.$dirty && loginForm.loginID.$error.required }\">\n" +
    "            <label for=\"loginID\">Login ID</label>\n" +
    "            <input type=\"text\" name=\"loginID\" id=\"loginID\" class=\"form-control\" ng-model=\"loginID\" required />\n" +
    "            <span ng-show=\"loginForm.loginID.$dirty && loginForm.loginID.$error.required\" class=\"help-block\">loginID is required</span>\n" +
    "        </div>\n" +
    "        <div class=\"form-group\">\n" +
    "            <label for=\"loginPassword\">Password</label>\n" +
    "            <input type=\"password\" name=\"loginPassword\" id=\"loginPassword\" class=\"form-control\" ng-model=\"loginPassword\" />\n" +
    "\n" +
    "        </div>\n" +
    "        <p>Zone</p>\n" +
    "        <div ng-show=\"hasPOMContactType\">\n" +
    "            <select name=\"SelectPomZone\" id=\"SelectPZ\" ng-model=\"pzones.repeatSelect\" placeholder='Select a Zone' required>\n" +
    "                <option id=\"optPZ{{$index}}\" ng-repeat='p in pzones' value='{{p}} '> {{p}}</option>\n" +
    "            </select>\n" +
    "        </div>\n" +
    "        <p></p>\n" +
    "\n" +
    "        <div class=\"form-actions\">\n" +
    "           \n" +
    " <button id=\"btnSubmit\" type=\"submit\" ng-disabled=\"form.$invalid || ctrl.dataLoading\" ng-click='logInToContactCenter()' class=\"btn-custom btn-primary center\">Login</button>\n" +
    "        </div>\n" +
    "    </form>\n" +
    "</div>");
}]);

angular.module("signedin/NRRCodesModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/NRRCodesModal.tpl.html",
    "<div id=\"modalhdrNRRC\" class=\"modal-header\">\n" +
    "    <button id='btnCancel' aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Form to allow selection of not ready reason code\" class=\"modal-title center\">Select a Not Ready Reason Code</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyNRRC\" class=\"modal-body\">\n" +
    "    <form id='frmNRRCodes' name='NRRCModalForm'>\n" +
    "        <div ng-show='NRRCodes'>\n" +
    "            <table id='tblNRRCodes'>\n" +
    "                <tr ng-repeat=\"x in NRRCodes\">\n" +
    "\n" +
    "                    <td>\n" +
    "                        <input name='NRRCRadio' id='{{x.Code}}' type=\"radio\" ng-model='$parent.codeSelected ' ng-value='x'> {{ x.Code }} {{ x.Name }}\n" +
    "                    </td>\n" +
    "                </tr>\n" +
    "            </table>\n" +
    "            <p ng-hide='NRRCodes'>Loading codes....</p>\n" +
    "        </div>\n" +
    "    </form>\n" +
    "</div>\n" +
    "<div class='panel-body'>\n" +
    "    <button id='btnClearAlerts' ng-click='alerts = []' ng-show='alerts.length > 0'>Clear All Alerts</button>\n" +
    "</div>\n" +
    "<div id=\"modalfooterNRRC\" class=\"modal-footer\">\n" +
    "    <p id='pcodeSelected' ng-hide='!(codeSelected)'> Selected: {{codeSelected}}</p>\n" +
    "    <button type='submit' id='submitNRRC' ng-click='submit(codeSelected)'>Not Ready</button>    \n" +
    "</div>");
}]);

angular.module("signedin/signedin.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/signedin.tpl.html",
    "<div class=\"container-fluid\">\n" +
    "    <div class='min-app-width'>\n" +
    "        <div class='row'>\n" +
    "\n" +
    "            <div class=' col-sm-12 col-md-12'>\n" +
    "                <img class='pull-left' id='avaya-logo' height='50px' alt='Avaya logo' src='assets\\Avaya_Logo_Web.jpg'>\n" +
    "                <div class=\"pull-right navbar-brand\">\n" +
    "                    JSRefClient\n" +
    "                    <small> \n" +
    "                        7.1.0.2              \n" +
    "                    </small>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "\n" +
    "        </div>\n" +
    "\n" +
    "        <div class='row-fluid'>\n" +
    "            <!-- <div class=\"span12\">-->\n" +
    "            <div class=' col-sm-12 col-md-12'>\n" +
    "\n" +
    "                <div class='row'>\n" +
    "                    <div class=\"panel panel-default panel-collapse\">\n" +
    "                        <div class=\"top-panel-heading-custom  panel-collapse\">\n" +
    "\n" +
    "                            <li id=\"state-dropdown\" type=\"button\" class=\"dropdown pull-left no-list agent-dropdown-custom cursor-pointer\" dropdown>\n" +
    "                                <a class=\"dropdown-toggle agent-dropdown-custom\" dropdown-toggle type=\"button\" aria-expanded=\"false\">\n" +
    "                                    <span id=\"agent-state-dropdown\">{{user.FullName}} {{user.State}}</span>\n" +
    "\n" +
    "                                    <img ng-src=\"{{userImg}}\" class='cursor-pointer' />\n" +
    "                                    <span class=\"caret cursor-pointer\"></span>\n" +
    "\n" +
    "                                    <span id=\"pPOMState\" ng-show='user.IsPomNailedUp' class=\"agent-dropdown-custom\">Nailed up with POM</span>\n" +
    "                                </a>\n" +
    "                                <ul class=\"dropdown-menu\" role=\"menu\">\n" +
    "                                    <li role=\"option\" aria-label=\"change state to ready\"><a id=\"optReady\" ng-class=\"{dropdowndisabled:!user.CanReady}\" ng-click=\"ready()\">Ready</a></li>\n" +
    "                                    <li role=\"option\" aria-label=\"change to no ready\"><a id=\"optNotReady\" ng-class=\"{dropdowndisabled:!user.CanNotReady}\" ng-click=\"notReady()\">Not Ready</a></li>\n" +
    "                                    <li role=\"option\" aria-label=\"change state to ready\"><a id=\"optNotReadyWithCode\" ng-class=\"{dropdowndisabled:!user.CanNotReady}\" ng-click=\"notReadyWithCodes()\">Not Ready With Reason</a></li>\n" +
    "                                    <li role=\"option\" aria-label=\"change after call work code\"><a id=\"optACW\" ng-class=\"{dropdowndisabled:!user.CanAfterCallWork}\" ng-click=\"ACWCode()\">After Call Work</a></li>\n" +
    "                                    <li role=\"option\" aria-label=\"log in\"><a id=\"optLogin\" ng-class=\"{dropdowndisabled:!user.CanLogin}\" ng-click=\"logIn()\">Log in</a></li>\n" +
    "                                    <li role=\"option\" aria-label=\"log out\"><a id=\"optLogout\" ng-class=\"{dropdowndisabled:!user.CanLogout}\" ng-click=\"logOut()\">Log out</a></li>\n" +
    "                                    <li role=\"option\" aria-label=\"supervisor controls widget\"><a id=\"opySprCtrls\" ng-class=\"{dropdowndisabled:!user.CanMonitorUsers}\" ng-disabled='!(user.CanMonitorUsers)' ng-click=\"monitorUsersForm()\">Supervisor Controls</a></li>\n" +
    "                                    <li aria-hidden=\"true\" class=\"divider\"></li>\n" +
    "                                    <li role=\"option\" aria-label=\"Sign out of the contact center\"><a id=\"optSignOut\" ng-click=\"disconnect()\">Sign Out</a></li>\n" +
    "                                    <li role=\"option\" aria-label=\"Demo mode of application\"><a id=\"optDemoMode\" ng-class=\"optClass\" ng-click=\"toggleDemo()\">Demo</a></li>\n" +
    "                                    <!-- Customer Search not supported in 7.1.0.2 release -->\n" +
    "                                    <!--<li role=\"option\" aria-label=\"Customer Search\"><a id=\"optCustSearch\" ng-class=\"optCustSearchClass\" ng-click=\"toggleDisplayCustomerSearch()\">Customer Search</a></li>-->\n" +
    "\n" +
    "                                </ul>\n" +
    "                            </li>                        \n" +
    "\n" +
    "                            <div class='panel-heading-callcontrol pull-right'>\n" +
    "                                {{resources[0].State}}\n" +
    "                                <input class='header-signedin-input' ng-model='newCall.calledNumber' id=\"inpDialNumberHeader\" type='text ' placeholder='<Enter Number>' ng-keydown='keypress($event, \"originate\")' />\n" +
    "                                <span ng-show=\"resources[0].CanOriginate\" class='cursor-pointer' ng-click='originate()'>\n" +
    "                                    <img  ng-src=\"{{callImg}}\"  id='callHeader' />\n" +
    "                                    \n" +
    "                                </span>\n" +
    "                                <span ng-show=\"resources[0].CanCallSupervisor\" class='cursor-pointer' ng-click='resources[0].CallSupervisor()'>\n" +
    "                                    <img  ng-src=\"{{callSprImg}}\"  id='callSprHeader' /> Call Supervisor\n" +
    "                                </span>\n" +
    "                                <span ng-show=\"user.CanOriginateEmail\" class='cursor-pointer' ng-click='originateEmail()'>\n" +
    "                                    <img  ng-src=\"{{emailImg}}\"  id='emailHeader' />\n" +
    "                                    Create Email\n" +
    "                                </span>\n" +
    "                                <span ng-show=\"user.CanRetrieve\" class='cursor-pointer' ng-click='pullContact()'>\n" +
    "                                    Pull\n" +
    "                                </span>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <!-- end of header call control row -->\n" +
    "                \n" +
    "                <!-- Customer Search not supported in 7.1.0.2 release -->\n" +
    "                <!-- Customer Search View Start -->\n" +
    "<!--\n" +
    "                <div class='row'>                    \n" +
    "                    <div class='col-sm-12 col-md-12'>\n" +
    "                        <div class=\"mycontainer\" ng-show=\"showCustomerSearch\">\n" +
    "                            <customer-search></customer-search>\n" +
    "                        </div>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "-->\n" +
    "                <!-- Customer Search View End -->\n" +
    "                \n" +
    "                <div class='row'>\n" +
    "                    <div class=\"panel panel-body\">\n" +
    "                        <!--Main body of signed in form containing user, resource and interaction information Start-->\n" +
    "                        <div class='col-sm-6 col-md-6'>\n" +
    "                            <!--User and Resource Views-->\n" +
    "                            <div class=\"row\">\n" +
    "                                <!--User View Start-->\n" +
    "                                <div class=\"span3\">                                   \n" +
    "                                    <!--User Capabilities-->\n" +
    "                                    <div class=\"mycontainer\" ng-show='demo' ng-include=\"'user/user-caps.tpl.html'\">\n" +
    "                                    </div>\n" +
    "                                    <!--User Properties-->\n" +
    "                                    <div class=\"mycontainer\" ng-show='demo' ng-include=\"'user/user-props.tpl.html'\">\n" +
    "                                    </div>                                              \n" +
    "                                </div>                \n" +
    "                                <!--User View End-->\n" +
    "\n" +
    "                                <!--Resource View Start-->\n" +
    "                                <div class=\"panel-body\" ng-repeat='resource in resources' ng-show='demo'>\n" +
    "                                    <div class=\"panel panel-default\">\n" +
    "                                        <input class='signedin-input' ng-model='newCall.calledNumber' id=\"inpDialNumber\" ng-keydown='keypress($event, \"originate\")' name='inpCalledNumber' type='text ' placeholder='Number to call ' />\n" +
    "\n" +
    "                                        <button class='btn btn-default btn-custom' id='btnOriginate' ng-click='originate()' ng-disabled='!resource.CanOriginate ' >Call</button>\n" +
    "                                        <button class='btn btn-default btn-custom' id='btnCallSuper' ng-click='resource.CallSupervisor() ' ng-disabled='!resource.CanCallSupervisor '>Call Supervisor</button>\n" +
    "\n" +
    "                                        <!--Resource Capabilities-->                                                                       \n" +
    "                                        <div class=\"mycontainer\" ng-include=\"'resources/resource-caps.tpl.html'\">\n" +
    "                                            <div class=\"content\">\n" +
    "                                            </div>\n" +
    "                                        </div>\n" +
    "                                        <!--Resource Properties-->\n" +
    "                                        <div class=\"mycontainer\" ng-include=\"'resources/resource-props.tpl.html'\">\n" +
    "                                            <div class=\"content\">\n" +
    "                                            </div>\n" +
    "                                        </div>\n" +
    "                                    </div>\n" +
    "                                </div>\n" +
    "                                <!--Resource View End-->\n" +
    "\n" +
    "                                <p ng-show='user.Code.Name'>Reason: {{user.Code.Name}}</p>\n" +
    "                                <p id=\"pNotification\" ng-if='user.Notification' class=\"bg-info\">{{user.Notification.Text }} <i class=\"fa fa-times-circle pull-right cursor-ptr\" ng_click='user.ClearNotification()'></i> </p>\n" +
    "                                <p id=\"pNotification\" ng-if='user.UserSyncMessage' class=\"bg-info\">{{user.UserSyncMessage }} <i class=\"fa fa-times-circle pull-right cursor-ptr\" ng_click='user.ClearNotification()'></i> </p>\n" +
    "                            </div>\n" +
    "\n" +
    "                        </div>\n" +
    "\n" +
    "\n" +
    "                        <!--Supervisor View Start -->\n" +
    "                        <div class='col-sm-9 col-md-10'>\n" +
    "                            <div class=\"panel panel-default\" ng-show='monitorUsersShowForm'>\n" +
    "                                <div class=\"panel-heading panel-heading-custom\">\n" +
    "                                    Supervisor Controls - {{user.FullName}} <i class=\"fa fa-times-circle pull-right cursor-ptr\" aria-hidden=\"true\" ng_click='closeSprWidget()'></i>\n" +
    "                                </div>\n" +
    "\n" +
    "                                <div class=\"panel-body\">\n" +
    "                                    <table class=\"table table-bordered table-striped\">\n" +
    "                                        <thead>\n" +
    "                                            <tr>\n" +
    "                                                <td>\n" +
    "\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    Agent Name\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    Number\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    Status\n" +
    "                                                </td>\n" +
    "\n" +
    "                                            </tr>\n" +
    "                                        </thead>\n" +
    "\n" +
    "                                        <tbody>\n" +
    "                                            <tr ng-repeat=\"user in monitoredUsers\">\n" +
    "                                                <td>\n" +
    "                                                    <input id=\"inpMonitor{{$index}}\" type=\"checkbox\" ng-model=\"monitor\" ng-change=\"monitorUserTick(user, monitor)\" />\n" +
    "                                                </td>\n" +
    "                                                <td>{{user.FullName}}</td>\n" +
    "                                                <td>{{user.LoginID}}</td>\n" +
    "                                                <td>{{user.State}}\n" +
    "                                                    <li id=\"user-dropdown\" class=\"dropdown pull-right no-list\" dropdown>\n" +
    "                                                        <sess class=\"dropdown-toggle\" dropdown-toggle type=\"button\" aria-expanded=\"false\">\n" +
    "                                                            <span id=\"user-state-dropdown\" class='fa fa-exchange'>\n" +
    "                                                            </span>\n" +
    "\n" +
    "                                                        </sess>\n" +
    "                                                        <ul class=\"dropdown-menu\" role=\"menu\">\n" +
    "                                                            <li role=\"option\" aria-label=\"force ready\"><a id=\"optReady\" ng-class=\"{dropdowndisabled:!user.CanForceReady}\" ng-click=\"user.ForceReady()\">Ready</a></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"force not ready\"><a id=\"optNotReady\" ng-class=\"{dropdowndisabled:!user.CanForceNotReady}\" ng-click=\"user.ForceNotReady()\">Not Ready</a></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"force not ready with reason\"><a id=\"optNotReadyWithReason\" ng-class=\"{dropdowndisabled:!user.CanForceNotReady}\" ng-click=\"ForceNotReadyWithReason(user)\">Not Ready With Reason</a></li>\n" +
    "                                                            <li aria-hidden=\"true\" class=\"divider\"></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"force agent log out \"><a id=\"optLogout\" ng-class=\"{dropdowndisabled:!user.CanForceLogout}\" ng-click=\"user.ForceLogout()\">Log out</a></li>\n" +
    "                                                        </ul>\n" +
    "                                                    </li>\n" +
    "                                                </td>\n" +
    "                                            </tr>\n" +
    "                                        </tbody>\n" +
    "\n" +
    "                                    </table>\n" +
    "                                    Calls of monitored users\n" +
    "                                    <table class=\"table table-bordered table-striped\">\n" +
    "                                        <thead>\n" +
    "                                            <tr>\n" +
    "                                                <td>\n" +
    "                                                    Agent Name\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    Address\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    Type\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    Skillset\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    Contact ID\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    State\n" +
    "                                                </td>\n" +
    "                                                <td>\n" +
    "                                                    More\n" +
    "                                                </td>\n" +
    "                                            </tr>\n" +
    "                                        </thead>\n" +
    "\n" +
    "                                        <tbody>\n" +
    "                                            <tr ng-repeat=\"i in monitoredInteractions\">\n" +
    "                                                <td>{{i.AgentID }}</td>\n" +
    "                                                <td>{{i.CallingAddress }}</td>\n" +
    "                                                <td>{{i.ContactType }}</td>\n" +
    "                                                <td>{{i.Skillset }}</td>\n" +
    "                                                <td>{{i.ContactID }}</td>\n" +
    "                                                <td>{{i.State }}</td>\n" +
    "                                                <td>\n" +
    "                                                    <li id=\"monitor-call-dropdown\" class=\"dropdown pull-right no-list\" dropdown>\n" +
    "                                                        <sess class=\"dropdown-toggle\" dropdown-toggle type=\"button\" aria-expanded=\"false\">\n" +
    "                                                            <span id=\"agent-state-dropdown\" class='fa fa-bars'>\n" +
    "                                                            </span>\n" +
    "\n" +
    "                                                        </sess>\n" +
    "                                                        <ul class=\"dropdown-menu\" role=\"menu\">\n" +
    "                                                            <li role=\"option\" aria-label=\"observe the call\"><a id=\"optObserve\" ng-class=\"{dropdowndisabled:!i.CanObserve}\" ng-click=\"i.Observe()\">Observe</a></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"whisper on the call\"><a id=\"optWhisper\" ng-class=\"{dropdowndisabled:!i.CanWhisper}\" ng-click=\"i.Whisper()\">Whisper</a></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"barge in on the call\"><a id=\"optBargeIn\" ng-class=\"{dropdowndisabled:!i.CanBargeIn}\" ng-click=\"i.BargeIn()\">Barge-in</a></li>\n" +
    "                                                            <li aria-hidden=\"true\" class=\"divider\"></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"view data form \"><a id=\"optData\" ng-click=\"launchDataForm(i)\">Data</a></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"view uui of call\"><a id=\"optUUI\" ng-click=\"launchUUIForm(i)\">UUI</a></li>\n" +
    "                                                            <li role=\"option\" aria-label=\"view intrinsics of call\"><a id=\"optIntrinsics\" ng-click=\"launchIntrinsicsForm(i)\">Intrinsics</a></li>\n" +
    "                                                        </ul>\n" +
    "                                                </td>\n" +
    "                                            </tr>\n" +
    "                                        </tbody>\n" +
    "\n" +
    "                                    </table >\n" +
    "                                </div>\n" +
    "                            </div>\n" +
    "                        </div>\n" +
    "                        <!--Supervisor View End-->\n" +
    "\n" +
    "                        <!--Interaction View Start-->\n" +
    "                        <!--<div class=\"span9\">-->\n" +
    "                        <div class='col-sm-12 col-md-12'>\n" +
    "\n" +
    "                            <!--Interaction tabs Start-->\n" +
    "                            <!-- Tab panes \"{'panel-border-active':interactionSelected.State == 'Active'}\" -->\n" +
    "                            <!--div class=\"panel-body\"-->\n" +
    "                            <!--div class=\"panel panel-default\"-->\n" +
    "                            <tabset panel-tabs=\"true\" panel-class=\"{{demoTabbedPanelClass}}\" heading=\"{{demoTabbedPanelHeading}}\">\n" +
    "                                <tab ng-repeat=\"ii in interactions\" index=\"$index + 1\" heading=\"{{ii.ContactType}} {{ii.State}}\" select=\"getTabContent(ii.ID, $index)\">\n" +
    "\n" +
    "                                    <div>\n" +
    "                                        <p>ID:{{interactionSelected.ContactID}} State:{{interactionSelected.State}}</p>\n" +
    "                                        <p> Calling:{{interactionSelected.CallingAddress}} Called:{{interactionSelected.CalledAddress}}</p>\n" +
    "                                        <p>\n" +
    "                                            <label id='txtActivityCode' ng-show='interactionSelected.ActivityCode!=null'>Activity Code: {{interactionSelected.ActivityCode.Number}} {{interactionSelected.ActivityCode.Name}}</label>\n" +
    "                                        </p>\n" +
    "                                        <p>\n" +
    "                                            <label id='txtClosedReasonCode' ng-show='interactionSelected.CloseReasonCode!=null'>Closed Reason Code: {{interactionSelected.CloseReasonCode.Number}} {{interactionSelected.CloseReasonCode.Name}}</label>\n" +
    "                                        </p>\n" +
    "                                        <br />   \n" +
    "\n" +
    "                                        <p id='txtPreviewCounter' ng-show='interactionSelected.State==\"Preview\"' ng-model=\"counter\">{{previewCounter}} seconds until dialing</p>\n" +
    "                                        <p id='txtWrapUpCounter' ng-show='interactionSelected.State==\"Wrapup\"' ng-model=\"counter\">{{counter}} seconds wrap up time remaining</p>\n" +
    "                                        <button class='btn btn-default' ng-show=\"interactionSelected.CanExtendWrapup || demo\" ng-disabled='!interactionSelected.CanExtendWrapup' ng-click=\"extendWrapup(interactionSelected)\">Extend wrapup time by {{interactionSelected.WrapupTimer}} seconds</button>\n" +
    "\n" +
    "                                        <!--Interaction Capabilities-->\n" +
    "                                        <div class=\"mycontainer\" ng-show='demo' ng-include=\"'interaction/interaction-caps.tpl.html'\">\n" +
    "                                            <div class=\"content\">\n" +
    "                                            </div>\n" +
    "                                        </div>\n" +
    "                                        <!--Interaction Properties-->\n" +
    "                                        <div class=\"mycontainer\" ng-show='demo' ng-include=\"'interaction/interaction-props.tpl.html'\">\n" +
    "                                            <div class=\"content\">\n" +
    "                                            </div>\n" +
    "                                        </div>\n" +
    "\n" +
    "\n" +
    "                                        <div class='panel panel-default '>\n" +
    "                                            <form id='frmDial' name='dialForm' ng-show=\"(interactionSelected.CanPreviewDial || interactionSelected.CanRedial || demo) && interactionSelected.ContactNumbers\">\n" +
    "                                                <div ng-show=\"(interactionSelected.CanPreviewDial || interactionSelected.CanRedial || demo) && interactionSelected.ContactNumbers\">\n" +
    "                                                    <select name=\"SelectContactNumber\" id=\"selectContactNumber\" ng-model=\"defaultPreviewContactNumber\" placeholder='Select a number to dial' required>\n" +
    "                                                        <option id=\"optSelectOption\" value=''>--- Select a Customer Number ---</option>\n" +
    "                                                        <option id=\"optContactNumber{{$index}}\" ng-selected='{{n == defaultPreviewContactNumber}}' ng-repeat='n in interactionSelected.ContactNumbers' value='{{n}} '> {{n.Name}}: {{n.Number}} , Is default:{{n.IsDefault}}, Timezone:{{n.Timezone}}</option>\n" +
    "                                                    </select>\n" +
    "                                                </div>\n" +
    "\n" +
    "\n" +
    "                                                <p></p>\n" +
    "                                                <button id='btnPreviewDial' ng-show=\"interactionSelected.CanPreviewDial || demo\" class=\"btn btn-default\" ng-click='interactionSelected.PreviewDial(defaultPreviewContactNumber)' ng-disabled='dialForm.SelectContactNumber.$invalid'>Dial </button>\n" +
    "                                                <p></p>\n" +
    "\n" +
    "\n" +
    "                                                <button id='btnRedial' ng-show=\"interactionSelected.CanRedial || demo\" class=\"btn btn-default\" ng-click='redial(interactionSelected.ContactNumbers.repeatSelect, i) ' ng-disabled='!(interactionSelected.CanRedial) && !(interactionSelected.ContactNumbers.repeatSelect) '>Redial</button>\n" +
    "\n" +
    "\n" +
    "                                            </form>\n" +
    "\n" +
    "                                            <form name=\"freeFormNumberForm\" class=\"css-form\" novalidate>\n" +
    "                                                <div ng-show='interactionSelected.CanPreviewDialFreeForm || demo'>\n" +
    "                                                    <input id=\"inpFreeForm\" type=\"text\" ng-model='freeFormNumber' phoneNumber testDirective name='freeFormNumber' placeholder='Number to dial' />\n" +
    "                                                    <span ng-show=\"freeFormNumberForm.freeFormNumber.$error.text\">Phone number must be a number!</span>\n" +
    "                                                    <button id='btnPreviewDialFree' class=\"btn btn-default\" ng-click='interactionSelected.PreviewDialFreeForm(freeFormNumber) ' ng-disabled='!(interactionSelected.CanPreviewDialFreeForm) || freeFormNumberForm.freeFormNumber.$invalid || ! freeFormNumberForm.freeFormNumber.$dirty'>Dial Free Form</button>\n" +
    "                                                </div>\n" +
    "                                            </form>\n" +
    "\n" +
    "\n" +
    "                                            <div ng-show='interactionSelected.CanPreviewCancel || demo'>\n" +
    "                                                <button id='btnPreviewCancel' class=\"btn btn-default\" ng-click='interactionSelected.PreviewCancel()' ng-disabled='!(interactionSelected.CanPreviewCancel) '>Cancel POM Contact</button>\n" +
    "\n" +
    "                                            </div>\n" +
    "                                            <button id='btnWrapup' ng-show='interactionSelected.CanWrapup || demo' ng-click='interactionSelected.Wrapup() ' ng-disabled='!(interactionSelected.CanWrapup)' type=\"button\" class=\"btn btn-default\">Wrapup</button>\n" +
    "                                            <button id='btnWrapupWithCode' ng-show='interactionSelected.CanWrapupWithCode || demo' type=\"button\" ng-disabled='!(interactionSelected.CanWrapupWithCode)' class='btn btn-default' ng-click='getCodes(interactionSelected)'>Wrapup with Code</button>\n" +
    "\n" +
    "                                        </div>\n" +
    "                                        <button id=\"btnCallback\" ng-show=\"interactionSelected.CanCreateCallback || demo\" class=\"btn btn btn-default\" ng-click=\"callbackForm(interactionSelected)\" ng-disabled='!(interactionSelected.CanGetCallbackDestinations)'>Callback</button>\n" +
    "                                        <button id='btnAnswer' ng-show='interactionSelected.CanAnswer || demo' ng-click='interactionSelected.Answer() ' ng-disabled='!(interactionSelected.CanAnswer)' type=\"button\" class=\"btn btn-default\">Answer</button>\n" +
    "\n" +
    "                                        <button id='btnReject' ng-show='interactionSelected.CanReject || demo' ng-click='reject(interactionSelected)' ng-disabled='!(interactionSelected.CanReject)' type=\"button\" class=\"btn btn-default\">Reject</button>\n" +
    "\n" +
    "                                        <button id='btnHold' ng-show='interactionSelected.CanHold || demo' ng-click='interactionSelected.Hold() ' ng-disabled='!(interactionSelected.CanHold) ' type=\"button\" class=\"btn btn-default\">Hold</button>\n" +
    "                                        <button id='btnUnhold' ng-show='interactionSelected.CanUnhold || demo' ng-click='interactionSelected.Unhold() ' ng-disabled='!(interactionSelected.CanUnhold) ' type=\"button\" class=\"btn btn-default\">Unhold</button>\n" +
    "                                        <button id='btnDrop' ng-show='interactionSelected.CanEnd || demo' ng-click='interactionSelected.End() ' ng-disabled='!(interactionSelected.CanEnd) ' type=\"button\" class=\"btn btn-default\">Drop</button>\n" +
    "                                        \n" +
    "                                        <div ng-hide='interactionSelected.ContactType == \"Web_Communications\"'>\n" +
    "                                            <input id='inpConfDestNumber' class='signedin-input' ng-show='interactionSelected.CanInitiateConference || demo' ng-disabled='!(interactionSelected.CanInitiateConference)' ng-model='destinationNumber' ng-value='destinationNumber' placeholder='Number to consult'>\n" +
    "                                            <button id='btnInitTrans' ng-show='interactionSelected.CanInitiateTransfer || demo' ng-click='interactionSelected.InitiateTransfer(destinationNumber) ' ng-disabled='!(interactionSelected.CanInitiateTransfer) || !(destinationNumber)' type=\"button\" class=\"btn btn-default\">Initiate Transfer</button>\n" +
    "                                            <button id='btnInitConf' ng-show='interactionSelected.CanInitiateConference || demo' ng-click='interactionSelected.InitiateConference(destinationNumber) ' ng-disabled='!(interactionSelected.CanInitiateConference) || !(destinationNumber) ' type=\"button\" class=\"btn btn-default\">Initiate Conference</button>\n" +
    "                                            <button id='btnGetConsultList' ng-show='interactionSelected.CanGetConsultDestinations || demo' ng-click='consultList(interactionSelected)' ng-disabled='!(interactionSelected.CanGetConsultDestinations)' type=\"button\" class=\"btn btn-default\">Consult From List</button>\n" +
    "                                        </div>\n" +
    "                                        <br/>\n" +
    "                                        <div ng-hide='interactionSelected.ContactType == \"Web_Communications\"'>\n" +
    "                                            <button id='btnJoin' ng-show='interactionSelected.CanJoinConference || demo' ng-disabled='!(interactionSelected.CanJoinConference)' type=\"button\" class=\"btn btn-default\">Join</button>\n" +
    "                                            <button id='btnCompTrans' ng-show='interactionSelected.CanCompleteTransfer || demo' ng-click='interactionSelected.CompleteTransfer() ' ng-disabled='!(interactionSelected.CanCompleteTransfer)' type=\"button\" class=\"btn btn-default\">Complete Transfer</button>\n" +
    "                                            <button id='btnCompConf' ng-show='interactionSelected.CanCompleteConference || demo' ng-click='interactionSelected.CompleteConference() ' ng-disabled='!(interactionSelected.CanCompleteConference)' type=\"button\" class=\"btn btn-default\">Complete Conference</button>\n" +
    "                                            <button id='btnEndConf' ng-show='interactionSelected.CanEndConference || demo' ng-click='interactionSelected.EndConference() ' ng-disabled='!(interactionSelected.CanEndConference)' type=\"button\" class=\"btn btn-default\">End Conference</button>\n" +
    "                                            <button id='btnChgOwner' ng-show='interactionSelected.CanChangeConferenceOwner || demo' ng-click='interactionSelected.ChangeConferenceOwner()' ng-disabled='!(interactionSelected.CanChangeConferenceOwner)' type=\"button\" class=\"btn btn-default\">Change Ownership</button>\n" +
    "                                        </div>\n" +
    "                                        <br/>\n" +
    "                                        <button id='btnEmergency' ng-show='interactionSelected.CanEmergency || demo' ng-click='interactionSelected.Emergency() ' ng-disabled='!(interactionSelected.CanEmergency)' type=\"button\" class=\"btn btn-default\">Emergency</button>\n" +
    "                                        <button id='btnActivityCode' ng-show='interactionSelected.CanSetActivityCode || demo' ng-click='activityCode(interactionSelected) ' ng-disabled='!(interactionSelected.CanSetActivityCode)' type=\"button\" class=\"btn btn-default\">Set Activity Code</button>\n" +
    "                                        <button id='btnClosedReason' ng-show='interactionSelected.CanSetClosedReasonCode || demo' ng-click='getCodes(interactionSelected) ' ng-disabled='!(interactionSelected.CanSetClosedReasonCode)' type=\"button\" class=\"btn btn-default\">Set Closed Reason</button>\n" +
    "                                        <button id='btnData' ng-click='launchDataForm(interactionSelected)' type=\"button\" class=\"btn btn-default\">Data</button>\n" +
    "                                        <button id='btnUUI' ng-click='launchUUIForm(interactionSelected)' type=\"button\" class=\"btn btn-default\">UUI</button>\n" +
    "                                        <button id='btnIntrinsics' ng-click='launchIntrinsicsForm(interactionSelected)' type=\"button\" class=\"btn btn-default\">Intrinsics</button>\n" +
    "\n" +
    "                                        <p></p>\n" +
    "                                        <!--Agent notes for now only relevant for POM contacts-->\n" +
    "                                        <form id='frmAgentNotesForm' name=\"agentNotesForm\" ng-show='interactionSelected.CanAddAgentNote' ng-class=\"{ 'has-error' : agentNotesForm.inpAgtNote.$invalid && !userForm.inpAgtNote.$pristine }\">\n" +
    "                                            <div class=\"form-group\">\n" +
    "                                                <div class=\"mycontainer\" ng-disabled='!(interactionSelected.CanAddAgentNote)'>\n" +
    "                                                    <div class=\"form-group\">\n" +
    "                                                        <p>Enter a note:</p>\n" +
    "                                                        <input type=\"text\" id='inpAgentNotes' name=\"inpAgtNote\" class=\"form-control\" ng-model=\"inputs.note\" ng-maxlength=\"32767\">\n" +
    "                                                        <p ng-show=\"agentNotesForm.inpAgtNote.$error.maxlength\" class=\"help-block\">Agent note is too long.</p>\n" +
    "\n" +
    "                                                        <br/>\n" +
    "                                                        <button id='btnAddNote' ng-disabled='agentNotesForm.inpAgtNote.$invalid && !agentNotesForm.inpAgtNote.$pristine' ng-click='addAgentNote(interactionSelected)' type=\"button\" class=\"btn btn-default\">Add Agent Note</button>\n" +
    "                                                        <button id='btnRefreshNotes' ng-show='interactionSelected.CanRefreshAgentNotes || demo' ng-disabled='!(interactionSelected.CanRefreshAgentNotes)' ng-click='interactionSelected.RefreshAgentNotes()' type=\"button\" class=\"btn btn-default\">Refresh Agent Notes</button>\n" +
    "                                                    </div>\n" +
    "                                                </div>\n" +
    "                                                <div class=\"mycontainer\">\n" +
    "                                                    <div class=\"left-nav\">\n" +
    "                                                        <div class=\"list\" ng-repeat=\"note in interactionSelected.AgentNotes\">\n" +
    "                                                            <p>{{note}}</p>                        \n" +
    "                                                            <br/>\n" +
    "                                                        </div>    \n" +
    "                                                    </div>\n" +
    "                                                </div>\n" +
    "                                            </div>\n" +
    "\n" +
    "                                        </form>\n" +
    "\n" +
    "                                        <p></p>\n" +
    "                                        <div class=\"mycontainer\">\n" +
    "                                            <div class=\"panel-body-agentscript left-nav\" ng-show='interactionSelected.ContactType == \"POM_Outbound\"'>\n" +
    "                                                <a id='hrefAgentNotes' ng-href='{{interactionSelected.AgentScript}}' ng-disabled='!(interactionSelected.CanAddAgentNote)'>Agent Script</a> {{interactionSelected.AgentScript}}\n" +
    "                                            </div>\n" +
    "                                        </div>                                   \n" +
    "                                        <!-- Customer Details (relevant for POM, Email and Webchat interactions) -->                                        \n" +
    "                                        <div class=\"mycontainer\" ng-show='interactionSelected.ContactType == \"POM_Outbound\" || interactionSelected.ContactType == \"EMail\" || interactionSelected.ContactType == \"Web_Communications\"' ng-include=\"'interaction/customer-content.tpl.html'\">\n" +
    "                                        </div>\n" +
    "                                        <div class=\"mycontainer\" ng-show='interactionSelected.ScreenPops.length > 0' ng-include=\"'interaction/screenpops-content.tpl.html'\">\n" +
    "                                        </div>\n" +
    "                                    </div>\n" +
    "\n" +
    "                                    <!-- Email content -->\n" +
    "                                    <div class=\"mycontainer\" ng-show='interactionSelected.ContactType == \"EMail\"'>\n" +
    "                                        <email-media interaction=\"interactionSelected\"></email-media>\n" +
    "                                    </div>\n" +
    "                                    \n" +
    "                                     <!-- Webchat content -->\n" +
    "                                    <div class=\"mycontainer\" ng-show='interactionSelected.ContactType == \"Web_Communications\"'>\n" +
    "                                        <webchat-media interaction=\"interactionSelected\"></webchat-media>\n" +
    "                                    </div>\n" +
    "\n" +
    "                                    <div ng-hide=\"true\">\n" +
    "                                        <h3>Loading...</h3>\n" +
    "                                    </div>\n" +
    "                                </tab>\n" +
    "                            </tabset>\n" +
    "                        </div>\n" +
    "                        <!--Interaction tab End-->\n" +
    "\n" +
    "                    </div>\n" +
    "\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <!-- end of main app area row -->\n" +
    "        </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <!--Panel for logging errors and important information-->\n" +
    "    <div class=' col-sm-12 col-md-12'>\n" +
    "        <div class=\"panel panel-default\" ng-show='alerts.length > 0'>\n" +
    "\n" +
    "            <div class='panel-body'>\n" +
    "                <button id=\"btnClearAlerts\" ng-click='clearAlerts()' ng-show='alerts.length > 0' type=\"button\">Clear All Alerts</button>\n" +
    "\n" +
    "                <!--Loop through the messages and display in panel-->\n" +
    "                <alert id=\"alert{{$index}}\" ng-repeat=\"alert in alerts\" type=\"{{alert.type}}\" close=\"closeAlert($index)\">{{alert.msg}}</alert>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "    <!--Main body of signed in form containing user, resource an dinteraction information End-->\n" +
    "\n" +
    "</div>");
}]);

angular.module("signedin/UUIModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signedin/UUIModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"UUIModal.tpl.html\">-->\n" +
    "<div id=\"modalhdrUui\" class=\"modal-header\">\n" +
    "    <button aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"UUI of the interaction\" class=\"modal-title center\">UUI</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyIntrinsics\" class=\"modal-body\">\n" +
    "    <form id='frmUui' name='uuiModalForm'>\n" +
    "        <p id='pUUI'>{{uui}}</p>\n" +
    "         <input type=\"text\" id='inpUUIValue' name=\"inpUUIValue\" ng-value= 'uui' ng-model='uuiStringvalue'>\n" +
    "         <button id='btnUpdateUUI' ng-disabled='(!interaction.CanSetUUI)' ng-click='interaction.SetUUI(uuiStringvalue)' type=\"button\" class=\"btn btn-default\">Update</button>\n" +
    "                \n" +
    "    </form>\n" +
    "</br>\n" +
    "\n" +
    "</div>\n" +
    "<div id=\"modalfooterUui\" class=\"modal-footer\">\n" +
    "\n" +
    "\n" +
    "</div>\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("signin/signin.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("signin/signin.tpl.html",
    "<div class=\"container-fluid\">\n" +
    "    <div class=\"col-md-6\">\n" +
    "        <div class=\"row\">\n" +
    "            <h1 class=\"page-header\">\n" +
    "                Sign into the Contact Center\n" +
    "            </h1>\n" +
    "            <!--  Calls login function on scope object when the user clicks submit and can specify the input fields to the ng-model directives \n" +
    "username and password now available when user clicks button-->\n" +
    "\n" +
    "            <form id='frmUserForm' name=\"userForm\" ng-submit=\"signin()\">\n" +
    "                <div class=\"form-group\" ng-class=\"{ 'has-error' : userForm.server.$invalid && !userForm.server.$pristine }\">\n" +
    "                    <label id=\"lblServer\">Hostname</label>\n" +
    "                    <input id=\"inpServer\" type=\"text\" name='server' ng-model=\"server\" class=\"form-control\" autocomplete=\"on\" placeholder=\"Fully Qualified Hostname\" required>\n" +
    "                    <p id='pServerRequired' ng-show=\"userForm.server.$invalid && !userForm.server.$pristine\" class=\"help-block\">Server is required.</p>\n" +
    "                </div>\n" +
    "                <div class=\"form-group\" ng-class=\"{ 'has-error' : userForm.username.$invalid && !userForm.username.$pristine }\">\n" +
    "                    <label id=\"lblUserName\">Username</label>\n" +
    "                    <input id=\"inpUserName\" type=\"text\" name='name' ng-model=\"username\" class=\"form-control\" autocomplete=\"on\" placeholder=\"Domain\\Username\" required>\n" +
    "                    <p id='pUserRequired' ng-show=\"userForm.name.$invalid && !userForm.name.$pristine\" class=\"help-block\">Your username is required.</p>\n" +
    "                </div>\n" +
    "                <div class=\"form-group\" ng-class=\"{ 'has-error' : userForm.username.$invalid && !userForm.username.$pristine }\">\n" +
    "                    <label id=\"lblPassword\">Password</label>\n" +
    "                    <input id=\"inpPassword\" type=\"password\" name='password' ng-model=\"password\" class=\"form-control\" autocomplete=\"on\" placeholder=\"Password\" required>\n" +
    "                    <p id='pPwdRequired' ng-show=\"userForm.password.$invalid && !userForm.password.$pristine\" class=\"help-block\">Your password is required.</p>\n" +
    "                </div>\n" +
    "                <button id=\"btnSignin\" class=\"btn-success\" type=\"submit\" ng-disabled='signingin'>Signin</button>\n" +
    "            </form>\n" +
    "\n" +
    "        </div>\n" +
    "    </div>\n" +
    "    <div class='col-md-6'>\n" +
    "        <img id='imgAgents' src='assets\\Agents.png' alt='Avaya contact center agent' class='img-rounded img-responsive'></div>\n" +
    "\n" +
    "    <!--Panel for logging errors and important information-->\n" +
    "\n" +
    "    <div class=' col-sm-12 col-md-12'>\n" +
    "        <div class=\"panel panel-default\" ng-show='alerts.length > 0'>\n" +
    "\n" +
    "            <div class='panel-body'>\n" +
    "                <button id=\"btnClearAlerts\" ng-click='clearAlerts()' ng-show='alerts.length > 0'>Clear All Alerts</button>\n" +
    "                </p>\n" +
    "                <!--Loop through the messages and display in panel-->\n" +
    "                <alert id=\"alert{{$index}}\" ng-repeat=\"alert in alerts\" type=\"{{alert.type}}\" close=\"closeAlert($index)\">{{alert.msg}}</alert>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>");
}]);

angular.module("supervisor/monitoredUsers.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("supervisor/monitoredUsers.tpl.html",
    "<script type=\"text/ng-template\" id=\"tree_item_renderer.html\">\n" +
    "    {{data.name}}\n" +
    "    <button ng-click=\"add(data)\">Add node</button>\n" +
    "    <button ng-click=\"delete(data)\" ng-show=\"data.nodes.length > 0\">Delete nodes</button>\n" +
    "    <ul>\n" +
    "        <li ng-repeat=\"data in data.nodes\" ng-include=\"'tree_item_renderer.html'\"></li>\n" +
    "    </ul>\n" +
    "</script>\n" +
    "\n" +
    "<ul ng-app=\"Application\" ng-controller=\"TreeController\">\n" +
    "    <li ng-repeat=\"data in tree\" ng-include=\"'tree_item_renderer.html'\"></li>\n" +
    "</ul>");
}]);

angular.module("supervisor/NRRForcedCodesModal.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("supervisor/NRRForcedCodesModal.tpl.html",
    "<!--<script type=\"text/ng-template\" id=\"getDispCodes.html\">-->\n" +
    "<div id=\"modalhdrFNRRC\" class=\"modal-header\">\n" +
    "    <button id='btnCancel' aria-label=\"close\" class=\"btn btn-cancel pull-right btn-sm\" ng-attr-type=\"button\" ng-click=\"cancel()\">&times;</button>\n" +
    "    <h3 aria-label=\"Form to allow selection of not ready reason code\" class=\"modal-title center\">Select a Not Ready Reason Code</h3>\n" +
    "</div>\n" +
    "<div id=\"modalbodyFNRRC\" class=\"modal-body\">\n" +
    "    <form id='frmFNRRCodes' name='NRRCModalForm'>\n" +
    "        <div ng-show='NRRCodes'>\n" +
    "            <table id='tblNRRCodes'>\n" +
    "                <tr ng-repeat=\"x in NRRCodes\">\n" +
    "\n" +
    "                    <td>\n" +
    "                        <input name='NRRCRadio' id='{{x.Code}}' ng-attr-type=\"radio\" ng-model='$parent.codeSelected ' ng-attr-value='x'> {{ x.Code }} {{ x.Name }}</td>\n" +
    "                </tr>\n" +
    "            </table>\n" +
    "            <p ng-hide='NRRCodes'>Loading codes....</p>\n" +
    "        </div>\n" +
    "</div>\n" +
    "<div class='panel-body'>\n" +
    "    <button id='btnClearAlerts' ng-click='clearAlerts()' ng-show='alerts.length > 0'>Clear All Alerts</button>\n" +
    "    </p>\n" +
    "    <!--Loop through the messages and display in panel-->\n" +
    "    <alert id='alert$index' ng-repeat=\"alert in alerts\" ng-attr-type=\"{{alert.type}}\" close=\"closeAlert($index)\">{{alert.msg}}</alert>\n" +
    "</div>\n" +
    "<div id=\"modalfooterFNRRC\" class=\"modal-footer\">\n" +
    "    <p id='pcodeSelected' ng-hide='!(codeSelected)'> Selected: {{codeSelected}}</p>\n" +
    "    <button ng-attr-type='submit' id='submitFNRRC' ng-click='submit(codeSelected)'>Force Not Ready</button>\n" +
    "    </form>\n" +
    "</div>\n" +
    "\n" +
    "<!--</script>-->");
}]);

angular.module("user/user-caps.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("user/user-caps.tpl.html",
    "<div class=\"left-nav\">\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\">\n" +
    "            <accordion-heading class='panel-title-info'>\n" +
    "                User Capabilities\n" +
    "                <span id='caretUserCaps' class=\"caret\" />\n" +
    "            </accordion-heading>\n" +
    "            <table class=\"table table-bordered table-striped\">\n" +
    "                <tbody>\n" +
    "                    <tr>\n" +
    "                        <td>CanAfterCallWork</td>\n" +
    "                        <td>{{user.CanAfterCallWork}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanLogin</td>\n" +
    "                        <td>{{user.CanLogin}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanLogout </td>\n" +
    "                        <td>{{user.CanLogout}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanLoginOffsite </td>\n" +
    "                        <td>{{user.CanLoginOffsite}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanNotReady </td>\n" +
    "                        <td>{{user.CanNotReady}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanReady </td>\n" +
    "                        <td>{{user.CanReady}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanRecoverOffsite </td>\n" +
    "                        <td>{{user.CanRecoverOffsite}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanSetVoiceResource </td>\n" +
    "                        <td>{{user.CanSetVoiceResource}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanMonitorAgents </td>\n" +
    "                        <td>{{user.CanMonitorAgents}} </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                        <td>CanOriginateEmail </td>\n" +
    "                        <td>{{user.CanOriginateEmail}} </td>\n" +
    "                    </tr>\n" +
    "                </tbody>\n" +
    "\n" +
    "            </table>\n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>");
}]);

angular.module("user/user-props.tpl.html", []).run(["$templateCache", function($templateCache) {
  $templateCache.put("user/user-props.tpl.html",
    "<div class=\"left-nav\">\n" +
    "    <accordion close-others=\"false\">\n" +
    "        <accordion-group is-open=\"isopen\" ng-show='demo'>\n" +
    "            <accordion-heading>\n" +
    "                User Properties\n" +
    "                <span id='caretUserProps' class=\"caret\"/>\n" +
    "            </accordion-heading>\n" +
    "            <table class=\"table table-bordered table-striped\">\n" +
    "                <tbody>\n" +
    "                    <tr><td>ID</td><td>{{user.ID}} </td> </tr>\n" +
    "                    <tr><td>LoginID</td><td>{{user.LoginID}} </td> </tr>\n" +
    "                    <tr><td>FullName </td><td>{{user.FullName}} </td> </tr>\n" +
    "                    <tr><td>State </td><td>{{user.State}} </td> </tr>\n" +
    "                    <tr><td>ContactTypes </td><td>{{user.ContactTypes}} </td> </tr>\n" +
    "                    <tr><td>Roles </td><td>{{user.Roles}} </td> </tr>\n" +
    "                    <tr><td>VoiceResource </td><td>{{user.VoiceResource}} </td> </tr>\n" +
    "                    <tr><td>SupervisorName </td><td>{{user.SupervisorName}} </td> </tr>\n" +
    "                    <tr><td>IsMultimedia </td><td>{{user.IsMultimedia}} </td> </tr>                        \n" +
    "                    <tr><td>MMSessionKey </td><td>{{user.MMSessionKey}} </td> </tr>                        \n" +
    "                    <tr><td>IsPomNailedUp </td><td>{{user.IsPomNailedUp}} </td> </tr>\n" +
    "                    <tr><td>PomZones </td><td>{{user.PomZones}} </td> </tr>\n" +
    "                </tbody>\n" +
    "\n" +
    "            </table>\n" +
    "        </accordion-group>\n" +
    "    </accordion>\n" +
    "</div>\n" +
    "");
}]);
