/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.DataI;
import com.avaya.ccs.api.IntrinsicI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.InteractionState;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseObject;
import com.avaya.ccs.core.CodeList;
import com.avaya.ccs.core.ContactCenterCode;
import com.avaya.ccs.core.CustomFieldList;
import com.avaya.ccs.core.Data;
import com.avaya.ccs.core.IntrinsicList;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.RemoteParticipant;
import com.avaya.ccs.core.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class BaseInteraction
extends BaseObject {
    @JsonProperty(value="ContactID")
    String contactId;
    @JsonProperty(value="IsMonitored")
    boolean isMonitored;
    @JsonProperty(value="ContactType")
    ContactType contactType;
    @JsonProperty(value="RemoteParticipants")
    List<RemoteParticipant> remoteParticipants;
    @JsonProperty(value="IsMultimedia")
    boolean isMultimedia;
    @JsonProperty(value="UserID")
    String userId;
    @JsonProperty(value="State")
    InteractionState state;
    @JsonProperty(value="StateReason")
    StateReason reason;
    @JsonProperty(value="Address")
    String address;
    @JsonProperty(value="Skillset")
    String skillset;
    @JsonProperty(value="CallingAddress")
    String callingAddress;
    @JsonProperty(value="CalledAddress")
    String calledAddress;
    @JsonProperty(value="ActivityCode")
    ContactCenterCode activityCode;
    @JsonProperty(value="Intrinsics")
    IntrinsicList intrinsics;
    @JsonProperty(value="UUI")
    String uui;
    @JsonProperty(value="Data")
    Data data;
    @JsonProperty(value="OriginalDestination")
    String originalDestination;
    @JsonProperty(value="MainContactID")
    String mainContactId;
    CodeList activityCodes;
    private CodeList dispositionCodes;
    CustomFieldList customFields;

    String getAddress() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.address;
    }

    String getAddressName() throws ObjectInvalidException {
        this.checkForDeletion();
        return Utils.getUserFromUri(this.address);
    }

    String getCallingAddress() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.callingAddress;
    }

    String getCallingAddressName() throws ObjectInvalidException {
        this.checkForDeletion();
        return Utils.getUserFromUri(this.callingAddress);
    }

    String getCalledAddress() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.calledAddress;
    }

    String getCalledAddressName() throws ObjectInvalidException {
        this.checkForDeletion();
        return Utils.getUserFromUri(this.calledAddress);
    }

    ContactCenterCodeI getActivityCode() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.activityCode;
    }

    String getContactId() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.contactId;
    }

    ContactType getContactType() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.contactType;
    }

    DataI getData() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.data;
    }

    List<IntrinsicI> getIntrinsics() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.intrinsics == null) {
            return new ArrayList<IntrinsicI>();
        }
        return new ArrayList<IntrinsicI>(this.intrinsics.get());
    }

    IntrinsicI getIntrinsic(String name) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("mandatory intrinsic name argument is null or empty");
        }
        log.trace("getIntrinsic", name);
        IntrinsicI foundIntrinsic = null;
        for (IntrinsicI intrinsic : this.getIntrinsics()) {
            if (!intrinsic.getName().equals(name)) continue;
            foundIntrinsic = intrinsic;
            break;
        }
        return foundIntrinsic;
    }

    boolean isMonitored() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isMonitored;
    }

    public boolean isMultimedia() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isMultimedia;
    }

    String getSkillset() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.skillset;
    }

    InteractionState getState() {
        return this.state;
    }

    StateReason getStateReason() {
        if (this.reason == null) {
            return StateReason.Default;
        }
        return this.reason;
    }

    String getUUI() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.uui;
    }

    String getMainContactId() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.mainContactId;
    }

    String getOriginalDestination() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.originalDestination;
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.Interaction;
    }

    @Override
    void markForDeletion() {
        this.deleted.set(true);
        this.client = null;
        this.parent = null;
        this.state = InteractionState.Dropped;
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
        this.reason = StateReason.Default;
        this.activityCode = null;
        this.data = null;
    }

    public void setDispositionCodes(CodeList codes) {
        this.dispositionCodes = codes;
    }
}

