/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.core.ContactCenterCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CodeList
extends ResponseData
implements CodeListI {
    CodeType type;
    Map<String, String> codes;
    private List<ContactCenterCodeI> ccCodesList;

    @JsonCreator
    CodeList(@JsonProperty(value="CodeType") CodeType type, @JsonProperty(value="Codes") Map<String, String> codes) {
        this.type = type;
        this.codes = codes;
        this.ccCodesList = new ArrayList<ContactCenterCodeI>();
        for (String code : codes.keySet()) {
            this.ccCodesList.add(new ContactCenterCode(code, codes.get(code), type));
        }
    }

    public CodeList() {
        this.ccCodesList = new ArrayList<ContactCenterCodeI>();
    }

    @Override
    public List<ContactCenterCodeI> getCodes() {
        return new ArrayList<ContactCenterCodeI>(this.ccCodesList);
    }

    @Override
    public CodeType getCodeType() {
        return this.type;
    }

    @Override
    public void addCodeToList(ContactCenterCodeI code) {
        this.ccCodesList.add(code);
    }

    public String toString() {
        return "[CodeList: type=" + (Object)((Object)this.type) + " codes=" + this.ccCodesList + "]";
    }
}

