/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.core.Logger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationDescription {
    private static Logger log = Logger.getLogger(NotificationDescription.class);
    @JsonProperty(value="ObjectType")
    private ObjectType objectType;
    @JsonProperty(value="ID")
    private String id;
    @JsonProperty(value="Command")
    private Command command;
    @JsonProperty(value="PayloadType")
    private PayloadType payloadType;
    @JsonProperty(value="Path")
    private List<String> path;
    private Map<String, String> pathMap = new HashMap<String, String>();

    @JsonIgnore
    void setObjectType(ObjectType type) {
        this.objectType = type;
    }

    protected ObjectType getObjectType() {
        return this.objectType;
    }

    protected String getObjectId() {
        return this.id;
    }

    protected Command getCommand() {
        return this.command;
    }

    protected PayloadType getPayloadType() {
        return this.payloadType;
    }

    protected String getIdFromTypeInPath(ObjectType objectType) {
        return this.pathMap.get(objectType.toString());
    }

    @JsonSetter
    public void setPath(List<String> path) {
        log.debug("setPath", path);
        this.path = path;
        for (int i = 0; i < path.size(); ++i) {
            this.pathMap.put(path.get(i), path.get(++i));
        }
    }

    String toJsonString() {
        return "{ObjectType:" + (Object)((Object)this.getObjectType()) + ",ID:" + this.getObjectId() + (this.getCommand() != null ? ",Command:" + (Object)((Object)this.command) : "") + (this.path != null ? ",Path:" + this.path : "") + (this.getPayloadType() != null ? ",PayloadType:" + (Object)((Object)this.getPayloadType()) : "") + "}";
    }

    public String toString() {
        return "[NotificationDesc ObjectType:" + (Object)((Object)this.getObjectType()) + ",ID:" + this.getObjectId() + (this.getCommand() != null ? ",Command:" + (Object)((Object)this.command) : "") + (this.path != null ? ",Path:" + this.path : "") + (this.getPayloadType() != null ? ",PayloadType:" + (Object)((Object)this.getPayloadType()) : "") + "]";
    }

    public static enum PayloadType {
        ServiceConfig,
        CodeList,
        OffsiteSettings,
        DestinationList,
        EmailReplyResponse,
        ConsultDestinationTypes,
        CustomerHistory,
        CustomerInteractionMediaList,
        SuggestedResponseList,
        PagePushUrlList,
        AutoPhraseList,
        CustomerList,
        AgentSignature,
        CustomerManager,
        CustomFieldList,
        ApprovalInformation,
        ApprovalAuditInformation;

    }

    public static enum ObjectType {
        Client,
        Session,
        User,
        Resource,
        Interaction,
        MonitoredUser,
        MonitoredInteraction,
        Media,
        Customer,
        ResourceManager,
        UserManager,
        InteractionManager,
        CustomerManager;

    }
}

