/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.api.DestinationListI;
import com.avaya.ccs.api.enums.DestinationType;
import com.avaya.ccs.api.enums.InteractionType;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MediaFormI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class EmailForwardForm {
    private static final Logger LOG = Logger.getLogger(EmailForwardForm.class);
    private final Stage form = new Stage();
    ComboBox<String> skillsetListBox;
    HTMLEditor htmlEditor;
    FileChooser fileChooser;
    private Media media;
    private boolean mediaSet;
    private String agentSignature;
    private MediaFormI mediaForm;
    private RelocationType relocationType;
    private final InteractionExecutor interactionExe;
    private final ObservableList<DestinationI> destinationsOL = FXCollections.observableArrayList();
    private String currentInteractionID;
    private ListView<DestinationI> destinationsLV = new ListView();
    private InteractionType interactionType;

    public EmailForwardForm(InteractionExecutor interactionExe, String css, InteractionType interactionType) {
        this.interactionExe = interactionExe;
        BorderPane consultBorder = new BorderPane();
        Scene forwardScene = new Scene((Parent)consultBorder, 300.0, 400.0);
        forwardScene.getStylesheets().add((Object)css);
        this.form.setScene(forwardScene);
        this.interactionType = interactionType;
    }

    public void buildForwardUI(InteractionData interactionData) {
        Insets insets = new Insets(20.0);
        Tab transferToUserTab = new Tab("User");
        Tab transferToSkillsetTab = new Tab("Skillset");
        Tab transferToExternalTab = new Tab("External");
        StackPane transferPane = new StackPane();
        transferToSkillsetTab.setContent((Node)transferPane);
        TabPane tabPane = new TabPane();
        tabPane.getTabs().addAll((Object[])new Tab[]{transferToUserTab, transferToSkillsetTab, transferToExternalTab});
        ArrayList skillsetList = new ArrayList();
        this.destinationsOL.forEach(dest -> {
            if (dest.getDestinationType() == DestinationType.Skillset) {
                skillsetList.add(dest.getName());
            }
        });
        this.skillsetListBox = new ComboBox();
        this.skillsetListBox.setPrefWidth(200.0);
        this.skillsetListBox.getItems().addAll(skillsetList);
        this.skillsetListBox.setValue((Object)"EM_Default_Skillset_1");
        ArrayList selectedSkillsetList = new ArrayList();
        Button skillsetSendButton = new Button("Send");
        Button skillsetCancelButton = new Button("Cancel");
        VBox skillsetVBox = new VBox(5.0);
        HBox skillsetHBox = new HBox(5.0);
        skillsetHBox.getChildren().addAll((Object[])new Node[]{skillsetSendButton, skillsetCancelButton});
        skillsetVBox.setPadding(insets);
        Label skillsetLabel = new Label("Skillset");
        Label skillsetAgentNoteLabel = new Label("Agent Note");
        TextArea skillsetNoteTextArea = new TextArea();
        skillsetNoteTextArea.setPrefRowCount(10);
        transferToSkillsetTab.setContent((Node)skillsetVBox);
        skillsetVBox.getChildren().addAll((Object[])new Node[]{skillsetLabel, this.skillsetListBox, skillsetAgentNoteLabel, skillsetNoteTextArea, skillsetHBox});
        Scene scene = new Scene((Parent)tabPane, 600.0, 300.0);
        this.form.setScene(scene);
        this.form.show();
        skillsetSendButton.setOnAction(e -> {});
        this.skillsetListBox.setOnAction(e -> {
            String selectedValue = (String)this.skillsetListBox.getValue();
            if (selectedValue != null && !selectedSkillsetList.contains(selectedValue)) {
                selectedSkillsetList.add(selectedValue);
                System.out.println("Selected elements: " + selectedSkillsetList);
            }
        });
        skillsetCancelButton.setOnAction(e -> this.form.close());
        skillsetCancelButton.setOnAction(e -> this.form.close());
        TableView tableView = new TableView();
        Label userNoteTextAreaLabel = new Label("Agent note");
        TextArea userNoteTextArea = new TextArea();
        VBox userVbox = new VBox(5.0);
        userVbox.setPadding(insets);
        HBox userHbox = new HBox(10.0);
        Button userSendButton = new Button("Send");
        Button userCancelButton = new Button("Cancel");
        userHbox.getChildren().addAll((Object[])new Node[]{userSendButton, userCancelButton});
        userVbox.getChildren().addAll((Object[])new Node[]{tableView, userNoteTextAreaLabel, userNoteTextArea, userHbox});
        transferToUserTab.setContent((Node)userVbox);
        userSendButton.setOnAction(e -> {});
        userCancelButton.setOnAction(e -> this.form.close());
        this.htmlEditor = new HTMLEditor();
        this.fileChooser = new FileChooser();
        TextField toField = new TextField();
        toField.setPromptText("To (separate multiple addresses with commas)");
        TextField ccField = new TextField();
        ccField.setPromptText("CC (separate multiple addresses with commas)");
        TextField subjectField = new TextField();
        subjectField.setPromptText("Subject");
        HTMLEditor htmlEditor = new HTMLEditor();
        htmlEditor.setPrefHeight(600.0);
        this.fileChooser.setTitle("Attach File");
        Button attachButton = new Button("Attach");
        attachButton.setPadding(insets);
        attachButton.setOnAction(e -> {
            File selectedFile = this.fileChooser.showOpenDialog((Window)this.form);
            if (selectedFile != null) {
                System.out.println("Attached: " + selectedFile.getPath());
            }
        });
        TextArea externalAgentNoteTextArea = new TextArea();
        externalAgentNoteTextArea.setPrefRowCount(10);
        Button externalSendButton = new Button("Send");
        Button externalCancelButton = new Button("Cancel");
        externalSendButton.setOnAction(e -> {
            String to = toField.getText();
            String cc = ccField.getText();
            String subject = subjectField.getText();
            String content = htmlEditor.getHtmlText();
            System.out.println("To: " + to);
            System.out.println("CC: " + cc);
            System.out.println("Subject: " + subject);
            System.out.println("Content: " + content);
        });
        externalCancelButton.setOnAction(e -> this.form.close());
        Label agentExternalLabel = new Label("Agent note");
        VBox vboxExtTransfer = new VBox(10.0);
        vboxExtTransfer.setPadding(insets);
        HBox hboxExtTransfer = new HBox();
        hboxExtTransfer.setPadding(insets);
        hboxExtTransfer.getChildren().addAll((Object[])new Node[]{externalSendButton, externalCancelButton});
        vboxExtTransfer.getChildren().addAll((Object[])new Node[]{toField, ccField, subjectField, htmlEditor, agentExternalLabel, externalAgentNoteTextArea, hboxExtTransfer});
        transferToExternalTab.setContent((Node)vboxExtTransfer);
    }

    public void updateDestinationList(String interactionID, DestinationListI list) {
        String methodName = "updateDestinationList ";
        if (!interactionID.equals(this.currentInteractionID)) {
            LOG.error(methodName + "Contact ID:" + interactionID + " does not match current contactID:" + this.currentInteractionID, new Object[0]);
            return;
        }
        LOG.info(methodName + "Contact ID:" + interactionID + " updating list with " + list.getDestinations().size() + " items", new Object[0]);
        if (this.relocationType == RelocationType.Transfer) {
            LOG.debug(methodName + "Transfer", new Object[0]);
            this.destinationsOL.addAll((Collection)list.getDestinations());
        } else if (this.relocationType == RelocationType.Consult) {
            LOG.debug(methodName + " Consult", new Object[0]);
            for (DestinationI item : list.getDestinations()) {
                if (item.getDestinationType() != DestinationType.Agent) continue;
                this.destinationsOL.add((Object)item);
            }
        } else {
            LOG.error(methodName, " Unsupported relocation type. Destinations: " + list);
        }
    }

    public void setCurrentInteractionId(String id) {
        this.currentInteractionID = id;
    }

    public void initializeForwardForm(InteractionData interactionData) {
        this.initializeForm(true, interactionData);
    }

    private void initializeForm(boolean transfer, InteractionData interactionData) {
        this.relocationType = RelocationType.Transfer;
        this.form.titleProperty().set((Object)this.relocationType.name());
        this.buildForwardUI(interactionData);
    }

    public void setMediaForm(MediaFormI emailForm) {
        this.mediaForm = emailForm;
    }

    public void setInteractionMedia(Media media) {
        if (media != null) {
            this.media = media;
            this.mediaSet = true;
        }
    }

    public void setAgentSignature(String agentSignature) {
        this.agentSignature = agentSignature;
    }

    public boolean isMediaSet() {
        return this.mediaSet;
    }

    public void show() {
        this.form.show();
    }

    static enum RelocationType {
        Consult,
        Transfer;

    }
}

