/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.ClientSessionExecutor;
import com.avaya.ccs.javafxrefclient.CustomerExecutor;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.MonitoredExecutor;
import com.avaya.ccs.javafxrefclient.ResourceExecutor;
import com.avaya.ccs.javafxrefclient.UserExecutor;
import com.avaya.ccs.javafxrefclient.request.Request;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.concurrent.Task;

public class Executor {
    private static ExecutorService clientIncomingEventExecutor;
    private static ExecutorService clientOutgoingRequestExecutor;
    private static ClientSessionExecutor clientSession;
    private static UserExecutor user;
    private static ResourceExecutor resource;
    private static InteractionExecutor interactionExe;
    private static CustomerExecutor customerExe;
    private static MonitoredExecutor monitored;

    public Executor() {
        clientIncomingEventExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("incomingEvent");
            t.setDaemon(true);
            return t;
        });
        clientOutgoingRequestExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("outgoingRequest");
            t.setDaemon(true);
            return t;
        });
    }

    public static void createExecutors(JavaFXRefClient gui) {
        clientSession = new ClientSessionExecutor(gui);
        user = new UserExecutor(gui);
        resource = new ResourceExecutor(gui);
        interactionExe = new InteractionExecutor(gui);
        monitored = new MonitoredExecutor(gui);
        customerExe = new CustomerExecutor(gui);
    }

    public static ClientSessionExecutor getClientSession() {
        return clientSession;
    }

    public static UserExecutor getUser() {
        return user;
    }

    public static ResourceExecutor getResource() {
        return resource;
    }

    public static InteractionExecutor getInteractionExe() {
        return interactionExe;
    }

    public static CustomerExecutor getCustomerExe() {
        return customerExe;
    }

    public static MonitoredExecutor getMonitored() {
        return monitored;
    }

    protected void executeIncomingEvent(Task t) {
        clientIncomingEventExecutor.execute((Runnable)t);
    }

    protected void executeOutgoingRequest(Request t) {
        clientOutgoingRequestExecutor.execute((Runnable)((Object)t));
    }

    public static void close() {
        clientIncomingEventExecutor.shutdownNow();
        clientOutgoingRequestExecutor.shutdownNow();
    }
}

