/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomFieldListI;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.KVPItem;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;

public abstract class KVPTabBase {
    private final Tab tab;
    private final String BLANKDATA = "no data to display";
    private final ObservableList<KVPItem> list = FXCollections.observableArrayList();
    private final TableView<KVPItem> table = new TableView();
    private final BorderPane pane = new BorderPane();
    private final String title;

    public KVPTabBase(String title) {
        this.title = title;
        this.tab = new Tab();
        this.createTable();
        this.tab.setText(title + "s");
        this.tab.setClosable(false);
        this.pane.setCenter(this.table);
        this.tab.setContent((Node)this.pane);
        this.tab.setDisable(true);
    }

    private void createTable() {
        this.getTable().setEditable(false);
        this.getTable().setPlaceholder((Node)new Label("no data to display"));
        TableColumn name = new TableColumn("Name");
        name.getStyleClass().add((Object)"kvpTableNameRows");
        name.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<KVPItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<KVPItem, String> p) {
                return new ReadOnlyObjectWrapper((Object)((KVPItem)p.getValue()).getName());
            }
        });
        TableColumn value = new TableColumn("Value");
        value.getStyleClass().add((Object)"kvpTableValueRows");
        value.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<KVPItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<KVPItem, String> p) {
                return new ReadOnlyObjectWrapper((Object)((KVPItem)p.getValue()).getValue());
            }
        });
        this.getTable().setItems(this.getList());
        this.getTable().getColumns().add((Object)name);
        this.getTable().getColumns().add((Object)value);
    }

    void update(InteractionDataI data) {
    }

    void update(CustomFieldListI customFields) {
    }

    public Tab getTab() {
        return this.tab;
    }

    public String getTitle() {
        return this.title;
    }

    public ObservableList<KVPItem> getList() {
        return this.list;
    }

    public TableView<KVPItem> getTable() {
        return this.table;
    }

    public BorderPane getPane() {
        return this.pane;
    }
}

