/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class SessionData {
    private String lastLoginTime = "<NULL>";
    private String id = "<NULL>";
    private int numUsers = 0;
    private String version = "<NULL>";
    private boolean connected = false;
    private static final Logger LOG = Logger.getLogger(SessionData.class);

    public SessionData(SessionI session) {
        String methodName = "SessionData() ";
        if (session != null) {
            try {
                this.lastLoginTime = session.getLastLoginTime();
                this.id = session.getId();
                this.numUsers = session.getNumUsers();
                this.version = session.getVersion();
                this.connected = true;
            }
            catch (ObjectInvalidException ex) {
                LOG.error(methodName, new Object[]{"ObjectInvalidException while accessing session", ex});
                this.lastLoginTime = "<NULL>";
                this.id = "<NULL>";
                this.numUsers = 0;
                this.version = "<NULL>";
                this.connected = false;
            }
        }
    }

    public List<Pair<String, String>> getSessionProperties() {
        LinkedList<Pair<String, String>> sessionProperties = new LinkedList<Pair<String, String>>();
        sessionProperties.add(new Pair((Object)"LastLoginTime", (Object)this.lastLoginTime));
        sessionProperties.add(new Pair((Object)"Session ID", (Object)this.id));
        sessionProperties.add(new Pair((Object)"Number of Users", (Object)String.valueOf(this.numUsers)));
        sessionProperties.add(new Pair((Object)"Version", (Object)String.valueOf(this.version)));
        sessionProperties.add(new Pair((Object)"Connected", (Object)String.valueOf(this.connected)));
        return sessionProperties;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return "ID:" + this.id + " LastLoginTime:" + this.lastLoginTime + " NumUsers:" + this.numUsers + " Version:" + this.version + " Connected:" + this.connected;
    }
}

