/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.ClientData;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.request.SessionRequest;

public class GetClientDataRequest
extends SessionRequest {
    private static final Logger LOG = Logger.getLogger(GetClientDataRequest.class);
    private final JavaFXRefClient gui;

    public GetClientDataRequest(JavaFXRefClient gui) {
        super(LOG);
        this.gui = gui;
    }

    protected Object call() throws Exception {
        ClientData data;
        String methodName = "call() ";
        if (this.getClient() != null) {
            LOG.trace(methodName + "client non null", new Object[0]);
            data = new ClientData(this.getClient());
        } else {
            LOG.trace(methodName + "client null, returning blank data", new Object[0]);
            data = new ClientData(null);
        }
        return data;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            Object value = t.getSource().valueProperty().getValue();
            if (value != null) {
                ClientData newData = (ClientData)value;
                LOG.info(methodName + "ClientData:" + newData, new Object[0]);
                this.gui.updateClientData(newData);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }
}

