/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum StateReason {
    Default,
    BargeIn,
    Observe,
    ConsultInitiated,
    ConsultComplete,
    ConferenceInitiated,
    ConferenceComplete,
    TransferInitiated,
    TransferComplete,
    Join,
    CallSupervisor,
    Emergency,
    Park,
    Redirect,
    Reject,
    Route,
    Shutdown,
    Whisper,
    DefaultTreatment,
    ForceDisconnect,
    Pull,
    DestinationBusy,
    ServerError,
    ServiceUnavailable,
    CallForwardImmediate,
    CallForwardNoAnswer,
    InvalidRequest,
    Callback,
    Preview,
    AcquisitionFailure,
    CTILinkDown,
    CTILinkUp,
    DeviceNotRegistered,
    DeviceNotConfigured,
    DeviceNotSupported,
    LicenseNotGranted,
    ProviderOutOfService,
    ResourceDisabled,
    AddressRemoved,
    NotReady,
    Denied,
    Cancelled,
    Timeout,
    InsufficientResources,
    BulkRecord,
    DemandRecord,
    ResourceNotFound,
    RelatedResourceNotLicensed,
    InitiatedByAgent,
    InitiatedBySystem,
    PINValidation,
    DigitCollection,
    ContextCreation,
    AssignedToUser,
    UnassignedFromUser,
    SupervisorAssociation,
    Unknown;

    static Map<String, StateReason> reasonMap;

    @JsonCreator
    static StateReason get(String reasonName) {
        StateReason reason = reasonMap.get(reasonName);
        if (reason == null) {
            reason = Unknown;
        }
        return reason;
    }

    static {
        reasonMap = new HashMap<String, StateReason>();
        for (StateReason state : StateReason.values()) {
            reasonMap.put(state.toString(), state);
        }
    }
}

