/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.core.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CommandArgs {
    static Logger log = Logger.getLogger(CommandArgs.class);
    private String command = null;
    private StringBuilder commandArgs = new StringBuilder();
    private boolean containsSensitiveContent = false;

    CommandArgs(Command command) {
        this.appendCommand(command.toString(), null);
    }

    CommandArgs(Command command, String commandValue) {
        this.command = command.toString();
        this.appendCommand(this.command, commandValue);
    }

    CommandArgs(Command command, String commandValue, boolean containsSensitiveContent) {
        this.containsSensitiveContent = containsSensitiveContent;
        this.command = command.toString();
        this.appendCommand(this.command, commandValue);
    }

    public CommandArgs appendArg(Argument argumentName, String argumentValue) {
        if (argumentName == null || argumentValue == null) {
            log.error("appendArg", "cannot append arg, name or value are null");
            return this;
        }
        this.append('&').append(argumentName.toString()).appendArgValue(argumentValue);
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    private void appendCommand(String command, String commandValue) {
        this.append('?').append(command);
        if (commandValue != null) {
            this.appendArgValue(commandValue);
        }
    }

    private CommandArgs appendArgValue(String argumentValue) {
        if (argumentValue.contains("=") || argumentValue.contains("&") || argumentValue.contains("%") || argumentValue.contains(" ") || argumentValue.contains("/") || argumentValue.contains("\\")) {
            try {
                argumentValue = URLEncoder.encode(argumentValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("appendArgValue", e);
            }
        }
        return this.append('=').append(argumentValue);
    }

    private CommandArgs append(String s) {
        this.commandArgs.append(s);
        return this;
    }

    private CommandArgs append(char c) {
        this.commandArgs.append(c);
        return this;
    }

    boolean containsSensitiveContent() {
        return this.containsSensitiveContent;
    }

    public String toString() {
        return this.commandArgs.toString();
    }

    public static enum Argument {
        Application,
        Profile,
        SDK,
        Version,
        Build,
        Platform,
        Runtime,
        Language,
        ContactType,
        ContactId,
        Title,
        FirstName,
        LastName,
        DestinationType,
        RequestID,
        ReviewType,
        AuditId,
        ActionId,
        ApprovalId,
        Comment,
        CallbackDate,
        CallbackTime,
        CallbackNote;

    }
}

