/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.core.Client;
import com.avaya.ccs.core.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class CommonResources {
    private static int clientThreadPoolSize = 16;
    private static AtomicLong clientIdentifiers = new AtomicLong();
    private static ExecutorService webSocketExecPool = null;
    private static ScheduledExecutorService clientExecutorService = null;
    private static NamedThreadFactory wsThreadFactory = new NamedThreadFactory("ccs-websocket");
    private static NamedThreadFactory clientThreadFactory = new NamedThreadFactory("ccs-client");
    static Object poolLock = new Object();
    static Object wsPoolLock = new Object();
    static Logger log = Logger.getLogger(CommonResources.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExecutorService getWsSharedThreadPool() {
        Object object = wsPoolLock;
        synchronized (object) {
            if (webSocketExecPool == null || webSocketExecPool.isShutdown()) {
                webSocketExecPool = Executors.newCachedThreadPool(wsThreadFactory);
            }
        }
        return webSocketExecPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScheduledExecutorService getClientExecutorService() {
        Object object = poolLock;
        synchronized (object) {
            if (clientExecutorService == null || clientExecutorService.isShutdown()) {
                clientExecutorService = Executors.newScheduledThreadPool(clientThreadPoolSize, clientThreadFactory);
            }
        }
        return clientExecutorService;
    }

    static String getClientThreadPoolName() {
        return CommonResources.clientThreadFactory.poolName;
    }

    static long getNextClientId() {
        return clientIdentifiers.incrementAndGet();
    }

    static {
        String threadpoolSizePropValue = Client.props.getProperty("client.threadpool.size");
        if (threadpoolSizePropValue != null) {
            try {
                Integer threadpoolSize = Integer.valueOf(threadpoolSizePropValue);
                log.trace("<clinit>", "default threadpool size ", clientThreadPoolSize, ", property file threadpool size ", threadpoolSize);
                clientThreadPoolSize = threadpoolSize;
            }
            catch (Exception e) {
                log.error("<clinit>", e);
            }
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        String poolName;
        AtomicInteger threadNumber = new AtomicInteger();

        public NamedThreadFactory(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.poolName + "-pool-" + this.threadNumber.getAndIncrement());
        }
    }
}

