/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.api.CustomFieldListI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.InteractionState;
import com.avaya.ccs.api.enums.ResourceState;
import com.avaya.ccs.javafxrefclient.CallbackForm;
import com.avaya.ccs.javafxrefclient.CodeSelectionForm;
import com.avaya.ccs.javafxrefclient.ConsultForm;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.DtmfKeypad;
import com.avaya.ccs.javafxrefclient.EmailForm;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionDetailsForm;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.JoinForm;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.PreviewDialForm;
import com.avaya.ccs.javafxrefclient.ResourceData;
import com.avaya.ccs.javafxrefclient.SideBar;
import com.avaya.ccs.javafxrefclient.TableDataGUI;
import com.avaya.ccs.javafxrefclient.UserDataGUI;
import com.avaya.ccs.javafxrefclient.WebchatForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class InteractionDataGUI
extends TableDataGUI {
    private static final String HOLD = "Hold";
    private static final String UNHOLD = "UnHold";
    private static final String INIT_TRANSFER = "Transfer";
    private static final String COMPLETE_TRANSFER = "Complete Transfer";
    private static final String INIT_CONFERENCE = "Conf";
    private static final String COMPLETE_CONFERENCE = "Complete Conf";
    private static final String WRAPUP = "Wrapup";
    private HBox intreractionButtonHolderTop;
    private Button buttonAnswer;
    private Button buttonReject;
    private Button buttonHoldUnHold;
    private Button buttonEnd;
    private Button buttonDTMF;
    private Button buttonActivity;
    private HBox intreractionButtonHolderBottom;
    private Button buttonConference;
    private Button buttonJoin;
    private Button buttonTransfer;
    private Button buttonEmergency;
    private HBox pomButtonHolderTop;
    private Button buttonWrapup;
    private Button buttonWrapupWithCode;
    private Button buttonExtendWrapup;
    private Button buttonPreviewDial;
    private Button buttonReDial;
    private HBox pomButtonHolderBottom;
    private Button buttonAddToDNC;
    private Button buttonCallback;
    private Button buttonChangeConfOwner;
    private Button buttonEndConference;
    private VBox interactionTable;
    private final SideBar sideBar;
    private static final Logger LOG = Logger.getLogger(InteractionDataGUI.class);
    private final InteractionExecutor interactionExe;
    private final CodeSelectionForm codeSelection;
    private final PreviewDialForm previewDial;
    private final ConsultForm consultForm;
    private final Map<String, EmailForm> emailForms;
    private final Map<String, WebchatForm> webchatForms;
    private final JoinForm joinForm;
    private final DtmfKeypad dtmfKeypad;
    private final CallbackForm callbackForm;
    private String css;
    private UserDataGUI userGui;
    private boolean isCtiWasLost;

    public InteractionDataGUI(UserDataGUI userGui, InteractionExecutor interactionExe, String css, CodeSelectionForm codeSelection, PreviewDialForm previewDial, ConsultForm consultForm, JoinForm joinForm, CallbackForm callbackForm) {
        super(LOG);
        this.userGui = userGui;
        this.interactionExe = interactionExe;
        this.css = css;
        this.codeSelection = codeSelection;
        this.previewDial = previewDial;
        this.consultForm = consultForm;
        this.joinForm = joinForm;
        this.callbackForm = callbackForm;
        this.isCtiWasLost = false;
        this.emailForms = new HashMap<String, EmailForm>();
        this.webchatForms = new HashMap<String, WebchatForm>();
        this.setDetailsForm(new InteractionDetailsForm(interactionExe, css, this));
        this.dtmfKeypad = new DtmfKeypad(interactionExe);
        this.createInteractionButtons();
        this.createPomButtons();
        this.createInteractionTable();
        this.sideBar = new SideBar(interactionExe, this);
        this.redrawControls();
    }

    public VBox getInteractionButtons() {
        return new VBox(new Node[]{this.intreractionButtonHolderTop, this.intreractionButtonHolderBottom});
    }

    public VBox getPOMButtons() {
        return new VBox(new Node[]{this.pomButtonHolderTop, this.pomButtonHolderBottom});
    }

    public VBox getInteractionTable() {
        return this.interactionTable;
    }

    private void createInteractionButtons() {
        this.intreractionButtonHolderTop = new HBox();
        this.intreractionButtonHolderTop.getStyleClass().add((Object)"hbox");
        this.buttonAnswer = new Button("Answer");
        this.buttonAnswer.getStyleClass().add((Object)"interactionButton");
        this.buttonAnswer.setOnAction(e -> {
            String methodName = "answerButton() ";
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info(methodName + "ID:" + interactionID, new Object[0]);
            this.interactionExe.answer(interactionID);
            ContactType type = this.getCurrentInteractionSelection().getContactType();
            if (type == ContactType.EMail) {
                EmailForm newForm = new EmailForm(this.interactionExe, this.css, this.getCurrentInteractionSelection().getUserID(), false);
                newForm.setAgentSignature(this.userGui.getUser(this.getCurrentInteractionSelection().getUserID()).getAgentSignature());
                this.emailForms.put(interactionID, newForm);
                this.emailForms.get(interactionID).setInteractionData(this.getCurrentInteractionSelection());
            } else if (type == ContactType.Web_Communications) {
                WebchatForm newWebchatForm = new WebchatForm(interactionID, this.interactionExe, interactionID);
                this.webchatForms.put(interactionID, newWebchatForm);
                this.webchatForms.get(interactionID).setInteractionData(this.getCurrentInteractionSelection());
            }
        });
        this.buttonReject = new Button("Reject");
        this.buttonReject.getStyleClass().add((Object)"interactionButton");
        this.buttonReject.setOnAction(e -> {
            String methodName = "rejectButton() ";
            LOG.info(methodName, new Object[0]);
            this.userGui.setAgentNotReady();
        });
        this.buttonHoldUnHold = new Button(HOLD);
        this.buttonHoldUnHold.getStyleClass().add((Object)"interactionButton");
        this.buttonHoldUnHold.setOnAction(e -> {
            String methodName = "holdButton() ";
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info(methodName + "ID:" + interactionID, new Object[0]);
            if (this.getCurrentInteractionSelection().canHold()) {
                this.interactionExe.hold(interactionID);
                LOG.info(methodName + "Hold:ID:" + interactionID, new Object[0]);
            } else if (this.getCurrentInteractionSelection().canUnhold()) {
                LOG.info(methodName + "UnHold:ID:" + interactionID, new Object[0]);
                this.interactionExe.unHold(interactionID);
            } else {
                LOG.error(methodName + "Hold/UnHold button pressed but both capabilities false", new Object[0]);
            }
        });
        this.buttonEnd = new Button("End");
        this.buttonEnd.getStyleClass().add((Object)"interactionButton");
        this.buttonEnd.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("EndButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.end(interactionID);
        });
        this.buttonDTMF = new Button("DTMF");
        this.buttonDTMF.getStyleClass().add((Object)"interactionButton");
        this.buttonDTMF.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("DTMFButton() ID:" + interactionID, new Object[0]);
            this.dtmfKeypad.show(interactionID);
        });
        this.buttonActivity = new Button("Activity");
        this.buttonActivity.getStyleClass().add((Object)"interactionButton");
        this.buttonActivity.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("ActivityButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.getActivityCodes(interactionID);
            this.codeSelection.show();
        });
        this.intreractionButtonHolderBottom = new HBox();
        this.intreractionButtonHolderBottom.getStyleClass().add((Object)"hbox");
        this.buttonConference = new Button(INIT_CONFERENCE);
        this.buttonConference.getStyleClass().add((Object)"interactionButtonWide");
        this.buttonConference.setOnAction(e -> {
            String methodName = "conferenceButton() ";
            InteractionData interaction = this.getCurrentInteractionSelection();
            String interactionID = interaction.getId();
            LOG.info(methodName + " ID:" + interactionID, new Object[0]);
            if (interaction.canInitiateConference()) {
                this.getConsultForm().show();
                this.getConsultForm().initializeConsultForm(this.getCurrentInteractionSelection());
                if (interaction.canInitiateTransferToDestination()) {
                    this.interactionExe.getConsultDestinations(interactionID);
                }
            } else if (interaction.canCompleteConference()) {
                this.interactionExe.completeConference(interactionID);
            } else {
                LOG.error(methodName + "no init or complete conference capabilities", new Object[0]);
            }
        });
        this.buttonJoin = new Button("Join");
        this.buttonJoin.getStyleClass().add((Object)"interactionButton");
        this.buttonJoin.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("JoinButton() ID:" + interactionID, new Object[0]);
            this.joinForm.updateJoinForm(this.getUnselectedInteractions(), interactionID);
            this.joinForm.show();
        });
        this.buttonTransfer = new Button(INIT_TRANSFER);
        this.buttonTransfer.getStyleClass().add((Object)"interactionButtonWide");
        this.buttonTransfer.setOnAction(e -> {
            String methodName = "transferButton() ";
            InteractionData interaction = this.getCurrentInteractionSelection();
            String interactionID = interaction.getId();
            ContactType contactType = interaction.getContactType();
            if (interaction.canInitiateTransfer()) {
                LOG.info(methodName + " Init:ID:" + interactionID, new Object[0]);
                this.getConsultForm().show();
                this.getConsultForm().initializeTransferForm(this.getCurrentInteractionSelection());
                this.getConsultForm().setCurrentInteractionId(interactionID);
                if (contactType == ContactType.POM_Outbound || interaction.canInitiateTransferToDestination()) {
                    this.interactionExe.getConsultDestinations(interactionID);
                }
            } else if (interaction.canCompleteTransfer()) {
                LOG.info(methodName + " Complete:ID:" + interactionID, new Object[0]);
                this.interactionExe.completeTransfer(interactionID);
            } else {
                LOG.error(methodName + " no init or complete transfer capabilities", new Object[0]);
            }
        });
        this.buttonEmergency = new Button("Emergency");
        this.buttonEmergency.getStyleClass().add((Object)"interactionButtonWide");
        this.buttonEmergency.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("EmergencyButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.emergency(interactionID);
        });
        this.intreractionButtonHolderTop.getChildren().addAll((Object[])new Node[]{this.buttonAnswer, this.buttonReject, this.buttonHoldUnHold, this.buttonEnd, this.buttonDTMF, this.buttonActivity});
        this.intreractionButtonHolderBottom.getChildren().addAll((Object[])new Node[]{this.buttonConference, this.buttonJoin, this.buttonTransfer, this.buttonEmergency});
    }

    private void createPomButtons() {
        this.pomButtonHolderTop = new HBox();
        this.pomButtonHolderTop.getStyleClass().add((Object)"hbox");
        this.pomButtonHolderBottom = new HBox();
        this.pomButtonHolderBottom.getStyleClass().add((Object)"hbox");
        this.buttonWrapup = new Button(WRAPUP);
        this.buttonWrapup.getStyleClass().add((Object)"interactionButton");
        this.buttonWrapup.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("WrapUpButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.wrapUP(interactionID);
        });
        this.buttonWrapupWithCode = new Button("WrapupCode");
        this.buttonWrapupWithCode.getStyleClass().add((Object)"interactionButtonWide");
        this.buttonWrapupWithCode.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("WrapUpWithCodeButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.getDispositionCodes(interactionID);
            this.codeSelection.show();
        });
        this.buttonExtendWrapup = new Button("Extend Wrapup");
        this.buttonExtendWrapup.getStyleClass().add((Object)"interactionButtonWide");
        this.buttonExtendWrapup.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("ExtendWrapUpButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.extendWrapup(interactionID);
        });
        this.buttonPreviewDial = new Button("Preview");
        this.buttonPreviewDial.getStyleClass().add((Object)"interactionButton");
        this.buttonPreviewDial.setOnAction(e -> {
            LOG.info("PreviewButton()", new Object[0]);
            this.previewDial.show();
            this.previewDial.updatePreviewDialForm(this.getCurrentInteractionSelection(), this.getCallbackForm());
        });
        this.buttonReDial = new Button("Redial");
        this.buttonReDial.getStyleClass().add((Object)"interactionButton");
        this.buttonReDial.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("RedialButton() ID:" + interactionID, new Object[0]);
            List<ContactNumberI> numbers = this.getCurrentInteractionSelection().getContactNumbers();
            this.redialDialog(interactionID, numbers);
        });
        this.buttonAddToDNC = new Button("DNC");
        this.buttonAddToDNC.getStyleClass().add((Object)"interactionButton");
        this.buttonAddToDNC.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("DNCButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.addToDNC(interactionID);
        });
        this.buttonCallback = new Button("Callback");
        this.buttonCallback.getStyleClass().add((Object)"interactionButton");
        this.buttonCallback.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("CallbackButton() ID:" + interactionID, new Object[0]);
            this.getCallbackForm().initializeForm(this.getCurrentInteractionSelection());
            this.interactionExe.getCallbackDestinations(interactionID);
            this.getCallbackForm().show();
        });
        this.buttonChangeConfOwner = new Button("Change Conf");
        this.buttonChangeConfOwner.getStyleClass().add((Object)"interactionButtonWide");
        this.buttonChangeConfOwner.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("ChangeConfButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.changeConferenceOwner(interactionID);
        });
        this.buttonEndConference = new Button("End Conf");
        this.buttonEndConference.getStyleClass().add((Object)"interactionButton");
        this.buttonEndConference.setOnAction(e -> {
            String interactionID = this.getCurrentInteractionSelection().getId();
            LOG.info("EndConfButton() ID:" + interactionID, new Object[0]);
            this.interactionExe.endConference(interactionID);
        });
        this.pomButtonHolderTop.getChildren().addAll((Object[])new Node[]{this.buttonWrapup, this.buttonWrapupWithCode, this.buttonExtendWrapup, this.buttonPreviewDial, this.buttonReDial});
        this.pomButtonHolderBottom.getChildren().addAll((Object[])new Node[]{this.buttonAddToDNC, this.buttonCallback, this.buttonChangeConfOwner, this.buttonEndConference});
    }

    private void createInteractionTable() {
        this.getItemSelection().setEditable(false);
        this.getItemSelection().setPlaceholder((Node)new Label("No interactions"));
        TableColumn address = new TableColumn("Address");
        address.getStyleClass().add((Object)"interactionTableRows");
        address.setCellValueFactory((Callback)new PropertyValueFactory("addressName"));
        TableColumn contactID = new TableColumn("ContactID");
        contactID.getStyleClass().add((Object)"interactionTableRows");
        contactID.setCellValueFactory((Callback)new PropertyValueFactory("contactID"));
        TableColumn calledAddressName = new TableColumn("Called");
        calledAddressName.getStyleClass().add((Object)"interactionTableRows");
        calledAddressName.setCellValueFactory((Callback)new PropertyValueFactory("calledAddressName"));
        TableColumn callingAddressName = new TableColumn("Calling");
        callingAddressName.getStyleClass().add((Object)"interactionTableRows");
        callingAddressName.setCellValueFactory((Callback)new PropertyValueFactory("callingAddressName"));
        TableColumn state = new TableColumn("State");
        state.getStyleClass().add((Object)"interactionTableRows");
        state.setCellValueFactory((Callback)new PropertyValueFactory("combinedState"));
        TableColumn stateReason = new TableColumn("Reason");
        stateReason.getStyleClass().add((Object)"interactionTableRowsReason");
        stateReason.setCellValueFactory((Callback)new PropertyValueFactory("stateReason"));
        TableColumn activityCode = new TableColumn("Activity");
        activityCode.getStyleClass().add((Object)"interactionTableRows");
        activityCode.setCellValueFactory((Callback)new PropertyValueFactory("activityCodeNumber"));
        this.getItemSelection().setItems(this.getDetailsForm().getItems());
        this.getItemSelection().getColumns().add((Object)address);
        this.getItemSelection().getColumns().add((Object)contactID);
        this.getItemSelection().getColumns().add((Object)state);
        this.getItemSelection().getColumns().add((Object)stateReason);
        this.getItemSelection().getColumns().add((Object)calledAddressName);
        this.getItemSelection().getColumns().add((Object)callingAddressName);
        this.getItemSelection().getColumns().add((Object)activityCode);
        this.getItemSelection().setPrefHeight(5000.0);
        this.interactionTable = new VBox();
        this.interactionTable.getStyleClass().add((Object)"interactionTable");
        this.interactionTable.getChildren().addAll((Object[])new Node[]{this.getItemSelection()});
    }

    @Override
    protected void redrawControls() {
        LOG.debug("redrawControls", new Object[0]);
        InteractionData data = this.getCurrentInteractionSelection();
        this.buttonAnswer.setDisable(!data.canAnswer());
        this.buttonReject.setDisable(!data.canAnswer());
        this.buttonEnd.setDisable(!data.canEnd());
        this.buttonEmergency.setDisable(!data.canEmergency());
        if (data.canHold()) {
            this.buttonHoldUnHold.setText(HOLD);
            this.buttonHoldUnHold.setDisable(false);
        } else if (data.canUnhold()) {
            this.buttonHoldUnHold.setDisable(false);
            this.buttonHoldUnHold.setText(UNHOLD);
        } else {
            this.buttonHoldUnHold.setText(HOLD);
            this.buttonHoldUnHold.setDisable(true);
        }
        if (data.canInitiateTransfer()) {
            this.buttonTransfer.setDisable(false);
            this.buttonTransfer.setText(INIT_TRANSFER);
        } else if (data.canCompleteTransfer()) {
            this.buttonTransfer.setDisable(false);
            this.buttonTransfer.setText(COMPLETE_TRANSFER);
        } else {
            this.buttonTransfer.setDisable(true);
            this.buttonTransfer.setText(INIT_TRANSFER);
        }
        if (data.canInitiateConference()) {
            this.buttonConference.setDisable(false);
            this.buttonConference.setText(INIT_CONFERENCE);
        } else if (data.canCompleteConference()) {
            this.buttonConference.setDisable(false);
            this.buttonConference.setText(COMPLETE_CONFERENCE);
        } else {
            this.buttonConference.setDisable(true);
            this.buttonConference.setText(INIT_CONFERENCE);
        }
        this.buttonJoin.setDisable(!data.canJoinConference());
        this.buttonActivity.setDisable(!data.canSetActivityCode());
        this.buttonDTMF.setDisable(!data.canPlayDTMF());
        this.buttonWrapup.setDisable(!data.canWrapupCall());
        this.buttonWrapupWithCode.setDisable(!data.canWrapupCallWithCode());
        this.buttonExtendWrapup.setDisable(!data.canExtendWrapup());
        this.buttonWrapup.setText(WRAPUP);
        this.buttonCallback.setDisable(!data.canCreateCallback());
        this.buttonPreviewDial.setDisable(!data.canPreviewDial());
        this.buttonReDial.setDisable(!data.canRedial());
        this.buttonAddToDNC.setDisable(!data.canAddToDnc());
        this.buttonChangeConfOwner.setDisable(!data.canChangeConferenceOwner());
        this.buttonEndConference.setDisable(!data.canEndConference());
        this.sideBar.update(data);
    }

    public void handleAddressStateEvent(ResourceData data) {
        String methodName = "handleAddressStateEvent() ";
        LOG.debug(methodName + "+", new Object[0]);
        LOG.debug(methodName + "Address:" + data.getAddress() + " State:" + data.getState().toString(), new Object[0]);
        ResourceState state = data.getState();
        if (state == ResourceState.OutOfService) {
            this.isCtiWasLost = true;
            LOG.errorStatus("Address " + data.getAddress() + " is Out Of Service. Reason: " + data.getStateReason() + ". Message: " + data.getStateReasonMessage());
        } else if (state == ResourceState.InService && this.isCtiWasLost) {
            this.isCtiWasLost = false;
            LOG.infoStatus("Address " + data.getAddress() + " is In Service. Reason: " + data.getStateReason());
        }
        LOG.debug(methodName + "-", new Object[0]);
    }

    public MenuItem getMenuItem() {
        return this.getDetailsForm().getMenuItem();
    }

    protected InteractionData getCurrentInteractionSelection() {
        String methodName = "getCurrentInteractionSelection() ";
        Data currentInteraction = this.getCurrentItemSelection();
        if (currentInteraction != null) {
            return (InteractionData)currentInteraction;
        }
        LOG.trace(methodName + "current selection is NULL, returning blank", new Object[0]);
        return new InteractionData(null);
    }

    private List<InteractionData> getUnselectedInteractions() {
        List<Data> unselectedData = this.getUnselectedItems();
        ArrayList<InteractionData> unselectedInteractions = new ArrayList<InteractionData>();
        for (Data d : unselectedData) {
            unselectedInteractions.add((InteractionData)d);
        }
        return unselectedInteractions;
    }

    public void UpdateInteractionData(List<InteractionData> data) {
        ObservableList newData = FXCollections.observableArrayList();
        newData.addAll(data);
        this.update((ObservableList<Data>)newData);
    }

    public void UpdateInteractionData(InteractionData data) {
        InteractionData newData = data;
        this.update(newData);
    }

    public void updateCodeSectionForm(CodeListI codes) {
        this.codeSelection.updateCodeSectionForm(codes, this.getCurrentInteractionSelection().getId());
    }

    public void updateCustomFields(CustomFieldListI customFieldList) {
        this.getSideBar().updateCustomFields(customFieldList);
    }

    public SideBar getSideBar() {
        return this.sideBar;
    }

    public VBox getSideBarVbox() {
        return this.sideBar.getSideBar();
    }

    public ConsultForm getConsultForm() {
        return this.consultForm;
    }

    public EmailForm getEmailFormForContact(String id) {
        boolean isAdHocEmail;
        boolean bl = isAdHocEmail = this.getCurrentInteractionSelection().getState() == InteractionState.Initiated;
        if (this.emailForms.get(id) == null) {
            this.emailForms.put(id, new EmailForm(this.interactionExe, this.getCurrentInteractionSelection().getUserID(), this.css, isAdHocEmail));
            this.emailForms.get(id).setInteractionData(this.getCurrentInteractionSelection());
        }
        return this.emailForms.get(id);
    }

    public void createAndAddNewWebchatForm(String id) {
        Platform.runLater(() -> {
            LOG.info("createAndAddNewWebchatForm() " + id, new Object[0]);
            WebchatForm newform = new WebchatForm(id, this.interactionExe, this.css);
            this.webchatForms.put(id, newform);
        });
    }

    public void removeAndCloseWebChatForm(String id) {
        Platform.runLater(() -> {
            LOG.info("removeAndCloseWebChatForm() " + id, new Object[0]);
            WebchatForm thisform = this.webchatForms.get(id);
            thisform.close();
            this.webchatForms.remove(id);
        });
    }

    public WebchatForm getWebChatFormForContact(String id) {
        return this.webchatForms.get(id);
    }

    public CallbackForm getCallbackForm() {
        return this.callbackForm;
    }

    public InteractionData getSelectedInteractionData() {
        return this.getSelectedInteractionData();
    }

    public void deleteEmailFormCorContact(String id) {
        LOG.info("deleteEmailFormCorContact", " removing emailform from map for contact: " + id);
        this.emailForms.remove(id);
        this.getCurrentInteractionSelection().setDeleted(true);
    }

    public void customerDisconnectedWebChat(String contactId) {
        LOG.debug("customerDisconnectedWebChat  contact: " + contactId, new Object[0]);
        Data item = this.getItem(contactId);
        WebchatForm form = this.webchatForms.get(contactId);
        Platform.runLater(() -> form.goToWrapup());
        item.setDeleted(true);
    }

    private void redialDialog(String interactionID, List<ContactNumberI> numbers) {
        String methodName = "redialDialog() ";
        Dialog dialog = new Dialog();
        dialog.setTitle("Redial Dialog");
        ButtonType redialButtonType = new ButtonType("Redial", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{redialButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        ComboBox numberList = new ComboBox(FXCollections.observableList(numbers));
        numberList.getSelectionModel().selectFirst();
        numberList.setCellFactory((Callback)new Callback<ListView<ContactNumberI>, ListCell<ContactNumberI>>(){

            public ListCell<ContactNumberI> call(ListView<ContactNumberI> list) {
                return new CodeCell();
            }
        });
        numberList.setButtonCell((ListCell)new CodeCell());
        grid.add((Node)new Label("POM Zone:"), 0, 2);
        grid.add((Node)numberList, 1, 2);
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == redialButtonType) {
                return (ContactNumberI)numberList.getValue();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(number -> {
            LOG.info(methodName + "Name:" + number.getName() + " Number:" + number.getNumber(), new Object[0]);
            this.interactionExe.redial(interactionID, (ContactNumberI)number);
        });
    }

    private static class CodeCell
    extends ListCell<ContactNumberI> {
        private CodeCell() {
        }

        public void updateItem(ContactNumberI item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getName() + ":" + item.getNumber());
            }
        }
    }
}

