/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.CustomerDetailsI;
import com.avaya.ccs.api.DataI;
import com.avaya.ccs.api.IntrinsicI;
import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.InteractionState;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.IntrinsicElement;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class MonitoredInteractionData
extends Data
implements InteractionDataI {
    private boolean canObserve = false;
    private boolean canBargeIn = false;
    private boolean canWhisper = false;
    private ContactCenterCodeI activityCode = null;
    private String activityCodeNumber = null;
    private String address = "";
    private String addressName = "";
    private String calledAddress = "";
    private String calledAddressName = "";
    private String callingAddress = "";
    private String callingAddressName = "";
    private String contactID = "";
    private ContactType contactType = ContactType.Unknown;
    private DataI data = null;
    private String id = "";
    private List<IntrinsicElement> intrinsics = new LinkedList<IntrinsicElement>();
    private String mainContactID = "";
    private String originalDestination = "";
    private String skillset = "";
    private InteractionState state = InteractionState.Unknown;
    private StateReason stateReason = StateReason.Unknown;
    private String uui = "";
    private String monitoredUserID = "";
    private boolean monitored = false;
    private boolean multimedia = false;
    private InteractionData supervisorInteraction = null;
    private static final Logger LOG = Logger.getLogger(MonitoredInteractionData.class);

    public MonitoredInteractionData(MonitoredInteractionI interaction) {
        String methodName = "MonitoredInteractionData() ";
        if (interaction != null) {
            try {
                this.canObserve = interaction.canObserve();
                this.canBargeIn = interaction.canBargeIn();
                this.canWhisper = interaction.canWhisper();
                this.activityCode = interaction.getActivityCode();
                if (this.activityCode != null) {
                    this.activityCodeNumber = this.activityCode.getNumber().toString();
                }
                this.address = interaction.getAddress();
                this.addressName = interaction.getAddressName();
                this.calledAddress = interaction.getCalledAddress();
                this.calledAddressName = interaction.getCalledAddressName();
                this.callingAddress = interaction.getCallingAddress();
                this.callingAddressName = interaction.getCallingAddressName();
                this.contactID = interaction.getContactId();
                this.contactType = interaction.getContactType();
                this.data = interaction.getData();
                this.id = interaction.getId();
                this.intrinsics = this.buildIntrinsicsElmentList(interaction);
                this.mainContactID = interaction.getMainContactId();
                this.originalDestination = interaction.getOriginalDestination();
                this.skillset = interaction.getSkillset();
                this.state = interaction.getState();
                this.stateReason = interaction.getStateReason();
                this.uui = interaction.getUUI();
                this.monitoredUserID = interaction.getMonitoredUserId();
                this.monitored = interaction.isMonitored();
                this.multimedia = interaction.isMultimedia();
            }
            catch (ObjectInvalidException ex) {
                LOG.error(methodName, new Object[]{"ObjectInvalidException while accessing MonitoredInteractionData", ex});
                this.canObserve = false;
                this.canBargeIn = false;
                this.canWhisper = false;
                this.activityCode = null;
                this.activityCodeNumber = null;
                this.address = "";
                this.addressName = "";
                this.calledAddress = "";
                this.calledAddressName = "";
                this.callingAddress = "";
                this.callingAddressName = "";
                this.contactID = "";
                this.contactType = ContactType.Unknown;
                this.data = null;
                this.id = "";
                this.intrinsics = new LinkedList<IntrinsicElement>();
                this.mainContactID = "";
                this.originalDestination = "";
                this.skillset = "";
                this.state = InteractionState.Unknown;
                this.stateReason = StateReason.Unknown;
                this.uui = "";
                this.monitoredUserID = "";
                this.monitored = false;
                this.multimedia = false;
            }
        }
    }

    public MonitoredInteractionData(String id, boolean deleted) {
        this.id = id;
        this.setDeleted(deleted);
    }

    @Override
    public String toString() {
        String str = "ID:" + this.id;
        str = str + " activityCode:" + this.activityCode + " activityCodeNumber:" + this.activityCodeNumber + " address:" + this.address + " addressName:" + this.addressName + " calledAddress:" + this.calledAddress + " calledAddressName:" + this.calledAddressName + " callingAddress:" + this.callingAddress + " callingAddressName:" + this.callingAddressName;
        str = str + " contactID:" + this.contactID + " contactType:" + this.contactType + " mainContactID:" + this.mainContactID + " originalDestination:" + this.originalDestination + " skillset:" + this.skillset + " state:" + this.state.name() + " stateReason:" + this.stateReason.name() + " monitoredUserID:" + this.monitoredUserID + " monitored:" + this.monitored + " multimedia:" + this.multimedia;
        str = str + " canObserve:" + this.canObserve + " canBargeIn:" + this.canBargeIn + " canWhisper" + this.canWhisper;
        return str;
    }

    @Override
    public List<Pair<String, String>> getProperties() {
        LinkedList<Pair<String, String>> properties = new LinkedList<Pair<String, String>>();
        properties.add(new Pair((Object)"ID", (Object)this.getId()));
        String actCode = "NONE";
        if (this.activityCode != null) {
            actCode = this.activityCode.getName() + ":" + this.activityCode.getNumber();
        }
        properties.add(new Pair((Object)"ActivityCode", (Object)actCode));
        properties.add(new Pair((Object)"Address", (Object)this.getAddress()));
        properties.add(new Pair((Object)"AddressName", (Object)this.getAddressName()));
        properties.add(new Pair((Object)"CalledAddress", (Object)this.getCalledAddress()));
        properties.add(new Pair((Object)"CalledAddressName", (Object)this.getCalledAddressName()));
        properties.add(new Pair((Object)"CallingAddress", (Object)this.getCalledAddress()));
        properties.add(new Pair((Object)"CallingAddressName", (Object)this.getCallingAddressName()));
        properties.add(new Pair((Object)"ContactId", (Object)this.getContactID()));
        properties.add(new Pair((Object)"ContactType", (Object)this.getContactType().name()));
        properties.add(new Pair((Object)"MainContactId", (Object)this.getMainContactID()));
        properties.add(new Pair((Object)"OriginalDestination", (Object)this.getOriginalDestination()));
        properties.add(new Pair((Object)"Skillset", (Object)this.getSkillset()));
        properties.add(new Pair((Object)"MonitoredUserId", (Object)this.getMonitoredUserID()));
        properties.add(new Pair((Object)"isMonitored", (Object)Boolean.toString(this.isMonitored())));
        properties.add(new Pair((Object)"isMultimedia", (Object)Boolean.toString(this.isMultimedia())));
        properties.add(new Pair((Object)"State", (Object)this.getState().name()));
        properties.add(new Pair((Object)"StateReason", (Object)this.getStateReason().name()));
        return properties;
    }

    @Override
    public List<Pair<String, Boolean>> getCaps() {
        LinkedList<Pair<String, Boolean>> caps = new LinkedList<Pair<String, Boolean>>();
        caps.add(new Pair((Object)"canObserve", (Object)this.canObserve()));
        caps.add(new Pair((Object)"canBargeIn", (Object)this.canBargeIn()));
        caps.add(new Pair((Object)"canWhisper", (Object)this.canWhisper()));
        return caps;
    }

    private List<IntrinsicElement> buildIntrinsicsElmentList(MonitoredInteractionI interaction) {
        ArrayList<IntrinsicElement> l = new ArrayList<IntrinsicElement>();
        try {
            for (IntrinsicI i : interaction.getIntrinsics()) {
                l.add(new IntrinsicElement(i.getName(), i.getValue()));
            }
        }
        catch (ObjectInvalidException e) {
            return new ArrayList<IntrinsicElement>();
        }
        return l;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean canObserve() {
        return this.canObserve;
    }

    public boolean canObserveCalculated() {
        if (this.supervisorInteraction == null) {
            return this.canObserve;
        }
        return false;
    }

    public boolean canBargeInCalculated() {
        if (this.supervisorInteraction != null && (this.supervisorInteraction.getParticipationReason().equals((Object)StateReason.Observe) || this.supervisorInteraction.getParticipationReason().equals((Object)StateReason.Whisper))) {
            return this.canBargeIn;
        }
        return false;
    }

    public boolean canBargeIn() {
        return this.canBargeIn;
    }

    public boolean canWhisperCalculated() {
        if (this.supervisorInteraction != null && this.supervisorInteraction.getParticipationReason().equals((Object)StateReason.Observe)) {
            return this.canWhisper;
        }
        return false;
    }

    public boolean canWhisper() {
        return this.canWhisper;
    }

    @Override
    public boolean canSetIntrinsic() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    public boolean canGetIntrinsic() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    @Override
    public boolean canGetUUI() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    @Override
    public boolean canGetData() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    public ContactCenterCodeI getActivityCode() {
        return this.activityCode;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressName() {
        return this.addressName;
    }

    public String getCalledAddress() {
        return this.calledAddress;
    }

    public String getCalledAddressName() {
        return this.calledAddressName;
    }

    public String getCallingAddress() {
        return this.callingAddress;
    }

    public String getCallingAddressName() {
        return this.callingAddressName;
    }

    public String getContactID() {
        return this.contactID;
    }

    public ContactType getContactType() {
        return this.contactType;
    }

    @Override
    public DataI getData() {
        return this.data;
    }

    @Override
    public List<IntrinsicElement> getIntrinsics() {
        return this.intrinsics;
    }

    public String getMainContactID() {
        return this.mainContactID;
    }

    public String getOriginalDestination() {
        return this.originalDestination;
    }

    public String getSkillset() {
        return this.skillset;
    }

    public InteractionState getState() {
        return this.state;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    @Override
    public String getUui() {
        return this.uui;
    }

    public String getMonitoredUserID() {
        return this.monitoredUserID;
    }

    public String getActivityCodeNumber() {
        return this.activityCodeNumber;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    @Override
    public boolean isMultimedia() {
        return this.multimedia;
    }

    @Override
    public boolean canSetUUI() {
        return false;
    }

    @Override
    public boolean canAddAgentNote() {
        return false;
    }

    @Override
    public List<String> getAgentNotes() {
        ArrayList<String> empty = new ArrayList<String>();
        return empty;
    }

    @Override
    public boolean canGetCustomerDetails() {
        return false;
    }

    @Override
    public boolean canUpdateCustomerName() {
        return false;
    }

    @Override
    public boolean canUpdateCustomerEmail() {
        return false;
    }

    @Override
    public boolean canUpdateCustomerPhone() {
        return false;
    }

    @Override
    public boolean canUpdateCustomerAddress() {
        return false;
    }

    @Override
    public CustomerDetailsI getCustomerDetails() {
        throw new UnsupportedOperationException("Customer Details are not supported on monitored interactions");
    }

    @Override
    public void update(Data newData) {
        MonitoredInteractionData newMonitoredInteractionData = (MonitoredInteractionData)newData;
        this.canObserve = newMonitoredInteractionData.canObserve();
        this.canBargeIn = newMonitoredInteractionData.canBargeIn();
        this.canWhisper = newMonitoredInteractionData.canWhisper();
        this.activityCode = newMonitoredInteractionData.getActivityCode();
        this.activityCodeNumber = newMonitoredInteractionData.getActivityCodeNumber();
        this.address = newMonitoredInteractionData.getAddress();
        this.addressName = newMonitoredInteractionData.getAddressName();
        this.calledAddress = newMonitoredInteractionData.getCalledAddress();
        this.calledAddressName = newMonitoredInteractionData.getCalledAddressName();
        this.callingAddress = newMonitoredInteractionData.getCallingAddress();
        this.callingAddressName = newMonitoredInteractionData.getCallingAddressName();
        this.contactID = newMonitoredInteractionData.getContactID();
        this.contactType = newMonitoredInteractionData.getContactType();
        this.data = newMonitoredInteractionData.getData();
        this.id = newMonitoredInteractionData.getId();
        this.intrinsics = newMonitoredInteractionData.getIntrinsics();
        this.mainContactID = newMonitoredInteractionData.getMainContactID();
        this.originalDestination = newMonitoredInteractionData.getOriginalDestination();
        this.skillset = newMonitoredInteractionData.getSkillset();
        this.state = newMonitoredInteractionData.getState();
        this.stateReason = newMonitoredInteractionData.getStateReason();
        this.uui = newMonitoredInteractionData.getUui();
        this.monitoredUserID = newMonitoredInteractionData.getMonitoredUserID();
        this.monitored = newMonitoredInteractionData.isMonitored();
        this.multimedia = newMonitoredInteractionData.isMultimedia();
    }

    public void updateSupervisorInteraction(InteractionData interaction) {
        this.supervisorInteraction = interaction == null || interaction.isDeleted() ? null : interaction;
    }
}

