/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ResourceI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.ResourceState;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class ResourceData
extends Data {
    private boolean canCallSupervisor = false;
    private boolean canOriginate = false;
    private String address = "";
    private String addressName = "";
    private List<ContactType> contactTypes = new ArrayList<ContactType>();
    private ContactType defaultContactType = ContactType.Unknown;
    private String id = "0";
    private ResourceState state = ResourceState.Unknown;
    private StateReason stateReason = StateReason.Unknown;
    private String stateReasonMessage = "";
    private static final Logger LOG = Logger.getLogger(ResourceData.class);

    public ResourceData(ResourceI resource) {
        String methodName = "ResourceData() ";
        if (resource != null) {
            try {
                this.canCallSupervisor = resource.canCallSupervisor();
                this.canOriginate = resource.canOriginate();
                this.address = resource.getAddress();
                this.addressName = resource.getAddressName();
                this.contactTypes = resource.getContactTypes();
                this.defaultContactType = resource.getDefaultContactType();
                this.id = resource.getId();
                this.state = resource.getState();
                this.stateReason = resource.getStateReason();
                this.stateReasonMessage = resource.getStateReasonMessage();
            }
            catch (ObjectInvalidException ex) {
                LOG.error(methodName, new Object[]{"ObjectInvalidException while accessing resource", ex});
                this.canCallSupervisor = false;
                this.canOriginate = false;
                this.address = "";
                this.addressName = "";
                this.contactTypes = new ArrayList<ContactType>();
                this.defaultContactType = ContactType.Unknown;
                this.id = "0";
                this.state = ResourceState.Unknown;
                this.stateReason = StateReason.Unknown;
                this.stateReasonMessage = "";
            }
        }
    }

    @Override
    public String toString() {
        String str = "ID:" + this.id;
        str = str + " address:" + this.address + " addressName:" + this.addressName + " contactTypes:" + this.contactTypes + " defaultContactType:" + this.defaultContactType + " state:" + this.state.name() + " stateReason:" + this.stateReason + " stateReasonMessage:" + this.stateReasonMessage;
        str = str + " canCallSupervisor:" + this.canCallSupervisor + " canOriginate:" + this.canOriginate;
        return str;
    }

    @Override
    public List<Pair<String, String>> getProperties() {
        LinkedList<Pair<String, String>> properties = new LinkedList<Pair<String, String>>();
        properties.add(new Pair((Object)"ID", (Object)this.getId()));
        properties.add(new Pair((Object)"Contact Types", (Object)this.typesToString()));
        properties.add(new Pair((Object)"Default Contact Type", (Object)this.getDefaultContactType().name()));
        properties.add(new Pair((Object)"Address", (Object)this.getAddress()));
        properties.add(new Pair((Object)"AddressName", (Object)this.getAddressName()));
        properties.add(new Pair((Object)"State", (Object)this.stateToString()));
        properties.add(new Pair((Object)"StateReason", (Object)this.getStateReason().name()));
        properties.add(new Pair((Object)"StateReasonMessage", (Object)this.getStateReasonMessage()));
        return properties;
    }

    @Override
    public List<Pair<String, Boolean>> getCaps() {
        LinkedList<Pair<String, Boolean>> caps = new LinkedList<Pair<String, Boolean>>();
        caps.add(new Pair((Object)"CanCallSupervisor", (Object)this.canCallSupervisor()));
        caps.add(new Pair((Object)"CanOriginate", (Object)this.canOriginate()));
        return caps;
    }

    private String typesToString() {
        if (this.getContactTypes().isEmpty()) {
            return "NONE";
        }
        String types = "";
        for (ContactType type : this.getContactTypes()) {
            types = types + type.name() + " ";
        }
        return types;
    }

    private String stateToString() {
        if (this.state == null) {
            return "<NULL>";
        }
        return this.state.name();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean canCallSupervisor() {
        return this.canCallSupervisor;
    }

    public boolean canOriginate() {
        return this.canOriginate;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressName() {
        return this.addressName;
    }

    public List<ContactType> getContactTypes() {
        return this.contactTypes;
    }

    public ContactType getDefaultContactType() {
        return this.defaultContactType;
    }

    public ResourceState getState() {
        return this.state;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    public String getStateReasonMessage() {
        return this.stateReasonMessage;
    }

    @Override
    public void update(Data newData) {
        ResourceData newResourceData = (ResourceData)newData;
        this.canCallSupervisor = newResourceData.canCallSupervisor();
        this.canOriginate = newResourceData.canOriginate();
        this.address = newResourceData.getAddress();
        this.addressName = newResourceData.getAddressName();
        this.contactTypes = newResourceData.getContactTypes();
        this.defaultContactType = newResourceData.getDefaultContactType();
        this.id = newResourceData.getId();
        this.state = newResourceData.getState();
        this.stateReason = newResourceData.getStateReason();
        this.stateReasonMessage = newResourceData.getStateReasonMessage();
    }
}

