/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.javafxrefclient.ClientSessionExecutor;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.SessionData;
import javafx.concurrent.Task;

public class SessionEventTask
extends Task<SessionData> {
    private final NotificationEventI<SessionI> session;
    private final JavaFXRefClient gui;
    private final ClientSessionExecutor ccs;
    private static final Logger LOG = Logger.getLogger(SessionEventTask.class);

    public SessionEventTask(NotificationEventI<SessionI> session, ClientSessionExecutor ccs, JavaFXRefClient gui) {
        this.session = session;
        this.gui = gui;
        this.ccs = ccs;
        this.setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            SessionData value = (SessionData)t.getSource().getValue();
            if (value != null) {
                LOG.info(methodName + "SessionData:" + value, new Object[0]);
                this.gui.updateSessionData(value);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }

    protected SessionData call() throws Exception {
        String methodName = "call() ";
        SessionData data = null;
        NotificationType type = this.session.getNotificationType();
        LOG.debug(methodName + "Type:" + type + " ID:" + ((SessionI)this.session.getNotificationObject()).getId(), new Object[0]);
        switch (type) {
            case UPDATE: {
                data = new SessionData((SessionI)this.session.getNotificationObject());
                break;
            }
            case DELETE: {
                data = new SessionData(null);
                break;
            }
            case ERROR: {
                LOG.errorStatus(this.session.getError());
                break;
            }
            case NEW: {
                data = new SessionData((SessionI)this.session.getNotificationObject());
                this.ccs.processNewSession();
                break;
            }
            case RESPONSE: {
                break;
            }
        }
        return data;
    }
}

