/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredExecutor;
import com.avaya.ccs.javafxrefclient.MonitoredInteractionData;
import com.avaya.ccs.javafxrefclient.MonitoredUserData;
import com.avaya.ccs.javafxrefclient.SupervisorSideBar;
import com.avaya.ccs.javafxrefclient.UserData;
import com.avaya.ccs.javafxrefclient.WebchatForm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class SupervisorDataGUI {
    private static final String BLANKMONITORDATA = "No supervised agents to display";
    private static final String BLANKCONTACTINFO = "There are currently no contacts associated with the monitored agent(s).";
    private static final Logger LOG = Logger.getLogger(SupervisorDataGUI.class);
    private final MonitoredExecutor monitoredExe;
    private final InteractionExecutor interactionExe;
    private final Stage supervisorStage = new Stage();
    private TableView<MonitoredUserData> monitorTable = new TableView();
    private final TableView<MonitoredInteractionData> monitoredInteractionTable = new TableView();
    private final ObservableList<UserData> userItems = FXCollections.observableArrayList();
    private ObservableList<MonitoredUserData> monitoredUserItems = FXCollections.observableArrayList();
    private final ObservableList<MonitoredInteractionData> monitoredInteractionItems = FXCollections.observableArrayList();
    private final ObservableList<InteractionData> interactionItems = FXCollections.observableArrayList();
    private final ComboBox<String> superCombo = new ComboBox();
    private Button buttonForceReady;
    private Button buttonForceNotReady;
    private Button buttonForceLogout;
    private Button buttonObserve;
    private Button buttonBargein;
    private Button buttonWhisper;
    private Button buttonHold;
    private Button buttonEnd;
    private final SupervisorSideBar sideBar;
    private CheckBox allCheckBox;
    private final TextField conStatusField;
    private boolean shouldMonitor = false;
    private String supervisorUserId = null;
    private boolean areMonitoringSupervisor = false;
    private List<String> monitoredUserIds = new ArrayList<String>();
    private boolean areMonitoringUsers = false;
    private final String forceReadyButtonText = "Ready";
    private final String forceNotReadyButtonText = "Not Ready";
    private final String forceLogoutButtonText = "Logout";
    private final String observeButtonText = "Observe";
    private final String bargeinButtonText = "Barge-In";
    private final String whisperButtonText = "Whisper";
    private final String holdButtonText = "Hold";
    private final String unHoldButtonText = "Unhold";
    private final String endButtonText = "End";
    private final int supervisorSceneWidth = 1400;
    private final int supervisorSceneHeight = 800;
    private String css;
    private Map<String, WebchatForm> webchatForms = new HashMap<String, WebchatForm>();

    public SupervisorDataGUI(MonitoredExecutor monitoredExe, InteractionExecutor interactionExe, String css) {
        this.monitoredExe = monitoredExe;
        this.interactionExe = interactionExe;
        this.sideBar = new SupervisorSideBar(interactionExe, this);
        this.css = css;
        SplitPane sp = new SplitPane();
        VBox selectionVbox = new VBox();
        VBox interactionVbox = new VBox();
        sp.getStyleClass().add((Object)"root");
        Label superLabel = new Label("Supervisor");
        Label monitorLabel = new Label("Monitored Agents");
        this.allCheckBox = new CheckBox("All");
        this.allCheckBox.setAllowIndeterminate(false);
        this.allCheckBox.setSelected(false);
        this.allCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                SupervisorDataGUI.this.allCheckBox.setSelected(newValue.booleanValue());
                if (SupervisorDataGUI.this.monitoredUserItems.size() > 0) {
                    for (MonitoredUserData user : SupervisorDataGUI.this.monitoredUserItems) {
                        user.setIsSelected(newValue);
                    }
                    SupervisorDataGUI.this.monitorTable.refresh();
                    SupervisorDataGUI.this.checkMonitoredUsers();
                }
            }
        });
        AnchorPane monitorAp = new AnchorPane();
        monitorAp.getChildren().addAll((Object[])new Node[]{monitorLabel, this.allCheckBox});
        AnchorPane.setLeftAnchor((Node)monitorLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)this.allCheckBox, (Double)2.0);
        this.createAgentDataTable();
        VBox selGroupVbox1 = new VBox(5.0);
        selGroupVbox1.getChildren().addAll((Object[])new Node[]{superLabel, this.superCombo});
        this.createSelectionButtons();
        HBox selHbox3 = new HBox(5.0);
        selHbox3.getChildren().addAll((Object[])new Node[]{this.buttonForceReady, this.buttonForceNotReady, this.buttonForceLogout});
        selHbox3.setAlignment(Pos.CENTER);
        VBox selGroupVbox2 = new VBox(5.0);
        selGroupVbox2.getChildren().addAll((Object[])new Node[]{monitorAp, this.monitorTable, selHbox3});
        Label conStatusLabel = new Label("Monitor Connection Status");
        this.conStatusField = new TextField();
        this.conStatusField.setEditable(false);
        this.conStatusField.setText(BLANKCONTACTINFO);
        this.conStatusField.getStyleClass().add((Object)"statusField");
        VBox termGroupVbox1 = new VBox(5.0);
        termGroupVbox1.getChildren().addAll((Object[])new Node[]{conStatusLabel, this.conStatusField});
        VBox.setMargin((Node)this.conStatusField, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        Label monitoredLabel = new Label("Current Contacts of Monitored Agents");
        this.createInteractionTable();
        this.createInteractionButtons();
        HBox termGroupHbox3 = new HBox(5.0);
        termGroupHbox3.getChildren().addAll((Object[])new Node[]{this.buttonObserve, this.buttonWhisper, this.buttonBargein, this.buttonHold, this.buttonEnd});
        termGroupHbox3.setAlignment(Pos.CENTER);
        VBox termGroupVbox2 = new VBox(5.0);
        termGroupVbox2.getChildren().addAll((Object[])new Node[]{monitoredLabel, this.monitoredInteractionTable, termGroupHbox3});
        selectionVbox.getChildren().addAll((Object[])new Node[]{selGroupVbox1, selGroupVbox2, this.sideBar.getSideBar()});
        interactionVbox.getChildren().addAll((Object[])new Node[]{termGroupVbox1, termGroupVbox2});
        selectionVbox.getStyleClass().add((Object)"selvbox");
        interactionVbox.getStyleClass().add((Object)"intvbox");
        sp.getItems().addAll((Object[])new Node[]{selectionVbox, interactionVbox});
        sp.setDividerPositions(new double[]{0.3f});
        Scene supervisorScene = new Scene((Parent)sp, 1400.0, 800.0);
        supervisorScene.getStylesheets().add((Object)css);
        this.supervisorStage.setTitle("Supervisor Control");
        this.supervisorStage.setScene(supervisorScene);
        this.supervisorStage.setOnCloseRequest(event -> {
            LOG.info("supervisorStage.setOnCloseRequest(): Supervisor window closed", new Object[0]);
            this.shouldMonitor = false;
            this.checkMonitoredUsers();
            this.checkMonitoring();
        });
        this.supervisorStage.setOnShowing(event -> {
            LOG.info("supervisorStage.setOnShowing(): Supervisor window opened", new Object[0]);
            this.shouldMonitor = true;
            this.checkMonitoring();
            this.checkMonitoredUsers();
        });
    }

    private void createSelectionButtons() {
        this.buttonForceReady = new Button("Ready");
        this.buttonForceReady.getStyleClass().add((Object)"agent");
        this.buttonForceReady.setDisable(true);
        this.buttonForceReady.setOnAction(e -> {
            String methodName = "ForceReadyButton() ";
            MonitoredUserData user = (MonitoredUserData)this.monitorTable.getSelectionModel().getSelectedItem();
            if (user != null) {
                LOG.info(methodName + " SupervisorID: " + user.getSupervisorId() + " UserId:" + user.getId(), new Object[0]);
                this.monitoredExe.forceReady(user.getSupervisorId(), user.getId());
            } else {
                LOG.info(methodName + " User==NULL", new Object[0]);
            }
        });
        this.buttonForceNotReady = new Button("Not Ready");
        this.buttonForceNotReady.getStyleClass().add((Object)"agent");
        this.buttonForceNotReady.setDisable(true);
        this.buttonForceNotReady.setOnAction(e -> {
            String methodName = "ForceNotReadyButton() ";
            MonitoredUserData user = (MonitoredUserData)this.monitorTable.getSelectionModel().getSelectedItem();
            if (user != null) {
                LOG.info(methodName + " SupervisorID: " + user.getSupervisorId() + " UserId:" + user.getId(), new Object[0]);
                this.monitoredExe.forceNotReady(user.getSupervisorId(), user.getId());
            } else {
                LOG.info(methodName + " User==NULL", new Object[0]);
            }
        });
        this.buttonForceLogout = new Button("Logout");
        this.buttonForceLogout.getStyleClass().add((Object)"agent");
        this.buttonForceLogout.setDisable(true);
        this.buttonForceLogout.setOnAction(e -> {
            String methodName = "ForceLogoutButton() ";
            MonitoredUserData user = (MonitoredUserData)this.monitorTable.getSelectionModel().getSelectedItem();
            if (user != null) {
                LOG.info(methodName + " SupervisorID: " + user.getSupervisorId() + " UserId:" + user.getId(), new Object[0]);
                this.monitoredExe.forceLogout(user.getSupervisorId(), user.getId());
            } else {
                LOG.info(methodName + " User==NULL", new Object[0]);
            }
        });
    }

    private void createInteractionButtons() {
        this.buttonObserve = new Button("Observe");
        this.buttonObserve.getStyleClass().add((Object)"agentButton");
        this.buttonObserve.setDisable(true);
        this.buttonObserve.setOnAction(e -> {
            MonitoredInteractionData monitoredInteractionData = this.getSelectedMonitoredInteraction();
            LOG.info("ObserveButton SupervisorID: " + this.supervisorUserId + " UserId:" + monitoredInteractionData.getMonitoredUserID() + " InteractionID:" + monitoredInteractionData.getId(), new Object[0]);
            this.interactionExe.observe(this.supervisorUserId, monitoredInteractionData.getMonitoredUserID(), monitoredInteractionData.getId());
            String newInteractionId = this.supervisorUserId + "M" + monitoredInteractionData.getContactID();
            LOG.info("createInteractionButtons() creating a new form with the newly composed id of :" + newInteractionId, new Object[0]);
            WebchatForm newWebchatForm = new WebchatForm(newInteractionId, this.interactionExe, this.css);
            this.webchatForms.put(newInteractionId, newWebchatForm);
        });
        this.buttonWhisper = new Button("Whisper");
        this.buttonWhisper.getStyleClass().add((Object)"agentButton");
        this.buttonWhisper.setDisable(true);
        this.buttonWhisper.setOnAction(e -> {
            MonitoredInteractionData monitoredInteraction = this.getSelectedMonitoredInteraction();
            LOG.info("WhisperButton SupervisorID: " + this.supervisorUserId + " UserId:" + monitoredInteraction.getMonitoredUserID() + " InteractionID:" + monitoredInteraction.getId(), new Object[0]);
            this.interactionExe.whisper(this.supervisorUserId, monitoredInteraction.getMonitoredUserID(), monitoredInteraction.getId());
        });
        this.buttonBargein = new Button("Barge-In");
        this.buttonBargein.getStyleClass().add((Object)"agentButton");
        this.buttonBargein.setDisable(true);
        this.buttonBargein.setOnAction(e -> {
            MonitoredInteractionData monitoredInteraction = this.getSelectedMonitoredInteraction();
            LOG.info("BargeInButton SupervisorID: " + this.supervisorUserId + " UserId:" + monitoredInteraction.getMonitoredUserID() + " InteractionID:" + monitoredInteraction.getId(), new Object[0]);
            this.interactionExe.bargeIn(this.supervisorUserId, monitoredInteraction.getMonitoredUserID(), monitoredInteraction.getId());
        });
        this.buttonHold = new Button("Hold");
        this.buttonHold.getStyleClass().add((Object)"agentButton");
        this.buttonHold.setDisable(true);
        this.buttonHold.setOnAction(e -> {
            MonitoredInteractionData monitoredInteraction = this.getSelectedMonitoredInteraction();
            InteractionData interaction = this.findInteraction(this.supervisorUserId, monitoredInteraction.getContactID());
            if (interaction != null) {
                if (interaction.canUnhold()) {
                    LOG.info("HoldButton:UnHold:SupervisorID: " + this.supervisorUserId + " ContactID:" + monitoredInteraction.getContactID() + " InteractionID:" + interaction.getId(), new Object[0]);
                    this.buttonHold.setText("Hold");
                    this.interactionExe.unHold(interaction.getId());
                } else {
                    LOG.info("HoldButton:Hold:SupervisorID: " + this.supervisorUserId + " ContactID:" + monitoredInteraction.getContactID() + " InteractionID:" + interaction.getId(), new Object[0]);
                    this.buttonHold.setText("Unhold");
                    this.interactionExe.hold(interaction.getId());
                }
            } else {
                LOG.info("HoldButton SupervisorID: " + this.supervisorUserId + " ContactID:" + monitoredInteraction.getContactID() + " Interaction not found", new Object[0]);
            }
        });
        this.buttonEnd = new Button("End");
        this.buttonEnd.getStyleClass().add((Object)"agentButton");
        this.buttonEnd.setDisable(true);
        this.buttonEnd.setOnAction(e -> {
            MonitoredInteractionData monitoredInteraction = this.getSelectedMonitoredInteraction();
            InteractionData interaction = this.findInteraction(this.supervisorUserId, monitoredInteraction.getContactID());
            if (interaction != null) {
                LOG.info("endButton:SupervisorID: " + this.supervisorUserId + " ContactID:" + monitoredInteraction.getContactID() + " InteractionID:" + interaction.getId(), new Object[0]);
                this.interactionExe.end(interaction.getId());
            } else {
                LOG.info("EndButton SupervisorID: " + this.supervisorUserId + " ContactID:" + monitoredInteraction.getContactID() + " Interaction not found", new Object[0]);
            }
        });
    }

    private void refreshInteractionControls() {
        MonitoredInteractionData monitoredInteraction = this.getSelectedMonitoredInteraction();
        if (monitoredInteraction != null) {
            InteractionData interaction = this.findInteraction(this.supervisorUserId, monitoredInteraction.getContactID());
            monitoredInteraction.updateSupervisorInteraction(interaction);
            if (interaction != null) {
                String agentIds = "[]";
                List<String> agents = null;
                agents = this.findAgentsOnContact(interaction.getContactID());
                if (agents != null && !agents.isEmpty()) {
                    agentIds = agents.toString();
                }
                this.conStatusField.setText("Active Contact: " + interaction.getContactID() + " Agents: " + agentIds + " Mode: " + interaction.getParticipationReasonString() + " State: " + interaction.getState());
                this.setHoldButtonState(interaction.canHold(), interaction.canUnhold());
                this.buttonEnd.setDisable(!interaction.canEnd());
            } else {
                this.conStatusField.setText(BLANKCONTACTINFO);
                this.setHoldButtonState(false, false);
                this.buttonEnd.setDisable(true);
            }
            this.sideBar.update(monitoredInteraction);
            this.buttonObserve.setDisable(!monitoredInteraction.canObserveCalculated());
            this.buttonBargein.setDisable(!monitoredInteraction.canBargeInCalculated());
            this.buttonWhisper.setDisable(!monitoredInteraction.canWhisperCalculated());
            LOG.trace("refreshInteractionControls() obs=" + monitoredInteraction.canObserve() + " whisp=" + monitoredInteraction.canWhisper() + " bge=" + monitoredInteraction.canBargeIn(), new Object[0]);
        } else {
            this.buttonObserve.setDisable(true);
            this.buttonBargein.setDisable(true);
            this.buttonWhisper.setDisable(true);
            this.buttonEnd.setDisable(true);
            this.setHoldButtonState(false, false);
            this.conStatusField.setText(BLANKCONTACTINFO);
            this.sideBar.update(new MonitoredInteractionData(null));
        }
    }

    private void setHoldButtonState(boolean canHold, boolean canUnhold) {
        if (!canHold && !canUnhold) {
            this.buttonHold.setText("Hold");
            this.buttonHold.setDisable(true);
        } else if (canHold) {
            this.buttonHold.setText("Hold");
            this.buttonHold.setDisable(false);
        } else if (canUnhold) {
            this.buttonHold.setText("Unhold");
            this.buttonHold.setDisable(false);
        }
    }

    private void createAgentDataTable() {
        this.monitorTable.setEditable(true);
        this.monitorTable.setPlaceholder((Node)new Label(BLANKMONITORDATA));
        this.monitorTable.getStyleClass().add((Object)"table");
        TableColumn activeCol = new TableColumn("");
        activeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredUserData, CheckBox>, ObservableValue<CheckBox>>(){

            public ObservableValue<CheckBox> call(TableColumn.CellDataFeatures<MonitoredUserData, CheckBox> arg0) {
                final MonitoredUserData user = (MonitoredUserData)arg0.getValue();
                CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().setValue(Boolean.valueOf(user.isSelected()));
                checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                        user.setIsSelected(new_val);
                        SupervisorDataGUI.this.checkMonitoredUsers();
                    }
                });
                return new SimpleObjectProperty((Object)checkBox);
            }
        });
        TableColumn agentCol = new TableColumn("Agent");
        agentCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredUserData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredUserData, String> p) {
                return new ReadOnlyObjectWrapper((Object)(((MonitoredUserData)p.getValue()).getLoginId() + "[" + ((MonitoredUserData)p.getValue()).getFullName() + "]"));
            }
        });
        TableColumn stateCol = new TableColumn("State");
        stateCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredUserData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredUserData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredUserData)p.getValue()).getState().toString());
            }
        });
        this.monitorTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        activeCol.setMinWidth(32.0);
        activeCol.setMaxWidth(32.0);
        agentCol.setMaxWidth(1.2884901888E11);
        stateCol.setMaxWidth(6.442450944E10);
        this.monitorTable.setItems(this.monitoredUserItems);
        this.monitorTable.getColumns().add((Object)activeCol);
        this.monitorTable.getColumns().add((Object)agentCol);
        this.monitorTable.getColumns().add((Object)stateCol);
        this.monitorTable.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.buttonForceReady.setDisable(!newSelection.canForceReady());
                this.buttonForceNotReady.setDisable(!newSelection.canForceNotReady());
                this.buttonForceLogout.setDisable(!newSelection.canForceLogout());
            }
        });
    }

    private void createInteractionTable() {
        this.monitoredInteractionTable.setEditable(true);
        this.monitoredInteractionTable.setPlaceholder((Node)new Label("No interactions"));
        this.monitoredInteractionTable.getStyleClass().add((Object)"table");
        TableColumn agent = new TableColumn("Agent");
        agent.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredInteractionData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredInteractionData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredInteractionData)p.getValue()).getMonitoredUserID());
            }
        });
        TableColumn address = new TableColumn("Address");
        address.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredInteractionData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredInteractionData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredInteractionData)p.getValue()).getAddress());
            }
        });
        TableColumn callType = new TableColumn("Type");
        callType.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredInteractionData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredInteractionData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredInteractionData)p.getValue()).getContactType().name());
            }
        });
        TableColumn contactID = new TableColumn("ContactID");
        contactID.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredInteractionData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredInteractionData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredInteractionData)p.getValue()).getContactID());
            }
        });
        TableColumn state = new TableColumn("State");
        state.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredInteractionData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredInteractionData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredInteractionData)p.getValue()).getState().toString());
            }
        });
        TableColumn callingAddressName = new TableColumn("Calling");
        callingAddressName.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredInteractionData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredInteractionData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredInteractionData)p.getValue()).getCallingAddress());
            }
        });
        TableColumn stateReason = new TableColumn("Reason");
        stateReason.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MonitoredInteractionData, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MonitoredInteractionData, String> p) {
                return new ReadOnlyObjectWrapper((Object)((MonitoredInteractionData)p.getValue()).getStateReason().toString());
            }
        });
        this.monitoredInteractionTable.setItems(this.monitoredInteractionItems);
        this.monitoredInteractionTable.getColumns().add((Object)agent);
        this.monitoredInteractionTable.getColumns().add((Object)address);
        this.monitoredInteractionTable.getColumns().add((Object)callType);
        this.monitoredInteractionTable.getColumns().add((Object)contactID);
        this.monitoredInteractionTable.getColumns().add((Object)state);
        this.monitoredInteractionTable.getColumns().add((Object)callingAddressName);
        this.monitoredInteractionTable.getColumns().add((Object)stateReason);
        this.monitoredInteractionTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.monitoredInteractionTable.setPrefHeight(5000.0);
        this.monitoredInteractionTable.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> this.refreshInteractionControls());
    }

    public void show() {
        this.supervisorStage.show();
        if (!this.supervisorStage.isFocused()) {
            this.supervisorStage.toFront();
        }
    }

    public void clearData() {
        String methodName = "clearData() ";
        LOG.info(methodName + "clearing data", new Object[0]);
        this.shouldMonitor = false;
        this.checkMonitoredUsers();
        this.checkMonitoring();
        this.shouldMonitor = this.supervisorStage.isShowing();
    }

    public void removeData() {
        String methodName = "removeData() ";
        LOG.trace(methodName + "removing data", new Object[0]);
        this.shouldMonitor = false;
        this.checkMonitoredUsers();
        this.checkMonitoring();
        this.superCombo.setValue(null);
        this.userItems.clear();
        this.interactionItems.clear();
        this.monitoredUserItems.clear();
        this.monitoredInteractionItems.clear();
        this.shouldMonitor = this.supervisorStage.isShowing();
        this.supervisorUserId = null;
        this.areMonitoringSupervisor = false;
        this.monitoredUserIds = new ArrayList<String>();
        this.areMonitoringUsers = false;
        this.allCheckBox.setSelected(false);
        this.sideBar.update(new InteractionData(null));
    }

    protected UserData getCurrentItemSelection() {
        String methodName = "getCurrentItemSelection() ";
        String currentSelection = (String)this.superCombo.getValue();
        if (currentSelection != null) {
            LOG.trace(methodName + "current supervisor selection = " + currentSelection, new Object[0]);
            return this.getUserItem(currentSelection);
        }
        LOG.trace(methodName + "current supervisor selection is NULL, returning null", new Object[0]);
        return null;
    }

    public UserData getUserItem(String id) {
        String methodName = "getUserItem() ";
        LOG.trace(methodName + " ID:" + id, new Object[0]);
        for (UserData item : this.userItems) {
            if (!item.getId().equals(id)) continue;
            LOG.trace(methodName + "item found", new Object[0]);
            return item;
        }
        return null;
    }

    public String getSelectedInteractionId() {
        String selectedInteractionId = null;
        MonitoredInteractionData selectedInteraction = this.getSelectedMonitoredInteraction();
        if (selectedInteraction != null) {
            selectedInteractionId = selectedInteraction.getId();
        }
        return selectedInteractionId;
    }

    public MonitoredInteractionData getSelectedMonitoredInteraction() {
        return (MonitoredInteractionData)this.monitoredInteractionTable.getSelectionModel().getSelectedItem();
    }

    public void UpdateUserData(List<UserData> data) {
        ObservableList newData = FXCollections.observableArrayList();
        newData.addAll(data);
        this.updateUser((ObservableList<UserData>)newData);
    }

    public void UpdateUserData(UserData data) {
        this.updateUser(data);
    }

    public void updateUser(ObservableList<UserData> data) {
        String methodName = "updateUser() ";
        LOG.trace(methodName + "new count =  " + data.size(), new Object[0]);
        this.userItems.clear();
        this.userItems.addAll(data);
        this.refreshListsAndRedraw();
    }

    public void updateUser(UserData data) {
        String methodName = "updateUser() ";
        LOG.trace(methodName + "Data:" + data.getId(), new Object[0]);
        UserData itemFound = null;
        for (UserData item : this.userItems) {
            if (!item.getId().equals(data.getId())) continue;
            itemFound = item;
            break;
        }
        if (itemFound != null) {
            LOG.trace(methodName + "existing entry found", new Object[0]);
            this.userItems.remove((Object)itemFound);
            if (data.isDeleted()) {
                LOG.trace(methodName + "update is a deletion update, no adding new data", new Object[0]);
            } else {
                LOG.trace(methodName + "updating entry", new Object[0]);
                this.userItems.add((Object)data);
            }
        } else if (data.isDeleted()) {
            LOG.trace(methodName + "existing entry not found, but update is a delete so NOT adding", new Object[0]);
        } else {
            LOG.trace(methodName + "existing entry not found, adding", new Object[0]);
            this.userItems.add((Object)data);
        }
        this.refreshListsAndRedraw();
    }

    public void UpdateMonitoredUserData(List<MonitoredUserData> data) {
        ObservableList newData = FXCollections.observableArrayList();
        newData.addAll(data);
        this.updateMonitoredUser((ObservableList<MonitoredUserData>)newData);
    }

    public void UpdateMonitoredUserData(MonitoredUserData data) {
        this.updateMonitoredUser(data);
    }

    public void updateMonitoredUser(ObservableList<MonitoredUserData> data) {
        String methodName = "updateMonitoredUser() ";
        LOG.trace(methodName + "new count =  " + data.size(), new Object[0]);
        ArrayList<String> currentMultiSelection = new ArrayList<String>();
        for (MonitoredUserData user : this.monitoredUserItems) {
            if (!user.isSelected()) continue;
            currentMultiSelection.add(user.getId());
        }
        LOG.trace(methodName + "current monitored selection = " + currentMultiSelection, new Object[0]);
        if (currentMultiSelection.size() > 0) {
            for (String selectedId : currentMultiSelection) {
                for (MonitoredUserData user : data) {
                    if (!user.getId().equals(selectedId)) continue;
                    user.setIsSelected(true);
                }
            }
        }
        this.monitoredUserItems.clear();
        this.monitoredUserItems.addAll(data);
        this.refreshListsAndRedraw();
    }

    public void updateMonitoredUser(MonitoredUserData data) {
        String methodName = "updateMonitoredUser() ";
        LOG.trace(methodName + "ID:" + data.getId(), new Object[0]);
        MonitoredUserData selectedItem = (MonitoredUserData)this.monitorTable.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            LOG.trace(methodName + "selected item:NULL", new Object[0]);
        } else {
            LOG.trace(methodName + "selected item:" + selectedItem.getId(), new Object[0]);
        }
        MonitoredUserData itemFound = null;
        for (MonitoredUserData item : this.monitoredUserItems) {
            if (!item.getId().equals(data.getId())) continue;
            itemFound = item;
            break;
        }
        if (itemFound != null) {
            LOG.trace(methodName + "existing entry found", new Object[0]);
            boolean wasSelected = itemFound.isSelected();
            this.monitoredUserItems.remove((Object)itemFound);
            if (data.isDeleted()) {
                LOG.trace(methodName + "update is a deletion update, no adding new data", new Object[0]);
            } else {
                LOG.trace(methodName + "updating entry", new Object[0]);
                this.monitoredUserItems.add((Object)data);
                int i = this.monitoredUserItems.indexOf((Object)data);
                if (i != -1) {
                    ((MonitoredUserData)this.monitoredUserItems.get(i)).setIsSelected(wasSelected);
                }
            }
        } else if (data.isDeleted()) {
            LOG.trace(methodName + "existing entry not found, but update is a delete so NOT adding", new Object[0]);
        } else {
            LOG.trace(methodName + "existing entry not found, adding", new Object[0]);
            this.monitoredUserItems.add((Object)data);
        }
        if (selectedItem != null) {
            int i = 0;
            for (MonitoredUserData user : this.monitorTable.getItems()) {
                if (user.getId().equals(selectedItem.getId())) {
                    this.monitorTable.getSelectionModel().select(i);
                    break;
                }
                ++i;
            }
        }
        this.refreshListsAndRedraw();
    }

    public void UpdateMonitoredInteractionData(List<MonitoredInteractionData> data) {
        ObservableList newData = FXCollections.observableArrayList();
        newData.addAll(data);
        this.updateMonitoredInteraction((ObservableList<MonitoredInteractionData>)newData);
    }

    public void updateMonitoredInteraction(ObservableList<MonitoredInteractionData> data) {
        String methodName = "updateMonitoredInteraction() ";
        LOG.trace(methodName + "new count =  " + data.size(), new Object[0]);
        this.monitoredInteractionItems.clear();
        this.monitoredInteractionItems.addAll(data);
        this.refreshListsAndRedraw();
    }

    public void updateMonitoredInteraction(MonitoredInteractionData data) {
        MonitoredInteractionData currentSelection;
        String methodName = "updateMonitoredInteraction() ";
        LOG.trace(methodName + "Data:" + data, new Object[0]);
        MonitoredInteractionData itemFound = null;
        for (MonitoredInteractionData item : this.monitoredInteractionItems) {
            if (!item.getId().equals(data.getId())) continue;
            itemFound = item;
            break;
        }
        if (itemFound != null) {
            LOG.trace(methodName + "existing entry found", new Object[0]);
            if (data.isDeleted()) {
                LOG.trace(methodName + "update is a deletion update, removing data", new Object[0]);
                this.monitoredInteractionItems.remove((Object)itemFound);
            } else {
                LOG.trace(methodName + "updating entry", new Object[0]);
                itemFound.update(data);
                this.monitoredInteractionTable.refresh();
                currentSelection = (MonitoredInteractionData)this.monitoredInteractionTable.getSelectionModel().getSelectedItem();
                if (currentSelection != null && currentSelection.getId().equals(data.getId())) {
                    this.refreshInteractionControls();
                }
            }
        } else {
            LOG.trace(methodName + "existing entry not found, adding", new Object[0]);
            this.monitoredInteractionItems.add((Object)data);
            currentSelection = (MonitoredInteractionData)this.monitoredInteractionTable.getSelectionModel().getSelectedItem();
            if (currentSelection != null && currentSelection.getId().equals(data.getId())) {
                this.refreshInteractionControls();
            }
        }
        this.refreshListsAndRedraw();
    }

    public List<String> findAgentsOnContact(String contactId) {
        ArrayList<String> theList = new ArrayList<String>();
        if (this.notNullOrEmpty(contactId) && !this.monitoredInteractionItems.isEmpty()) {
            for (MonitoredInteractionData item : this.monitoredInteractionItems) {
                if (!item.getContactID().equals(contactId)) continue;
                theList.add(item.getMonitoredUserID());
            }
        }
        return theList;
    }

    public void updateInteraction(InteractionData data) {
        String methodName = "updateInteraction() ";
        LOG.trace(methodName + "DataID:" + data.getId(), new Object[0]);
        InteractionData itemFound = null;
        for (InteractionData item : this.interactionItems) {
            if (!item.getId().equals(data.getId())) continue;
            itemFound = item;
            break;
        }
        if (itemFound != null) {
            LOG.trace(methodName + "existing entry found", new Object[0]);
            this.interactionItems.remove((Object)itemFound);
            if (data.isDeleted()) {
                LOG.trace(methodName + "update is a deletion, not adding new data", new Object[0]);
                this.refreshInteractionControls();
            } else {
                LOG.trace(methodName + "updating entry", new Object[0]);
                this.interactionItems.add((Object)data);
                this.refreshInteractionControls();
            }
        } else if (data.isDeleted()) {
            LOG.trace(methodName + "existing entry not found, but update is a delete so NOT adding", new Object[0]);
        } else {
            LOG.trace(methodName + "existing entry not found, adding", new Object[0]);
            this.interactionItems.add((Object)data);
            this.refreshInteractionControls();
        }
    }

    public InteractionData findInteraction(String userId, String contactId) {
        for (InteractionData item : this.interactionItems) {
            if (!item.getUserID().equals(userId) || !item.getContactID().equals(contactId)) continue;
            return item;
        }
        return null;
    }

    public MonitoredInteractionData findMonitoredInteraction(InteractionData data) {
        for (MonitoredInteractionData item : this.monitoredInteractionItems) {
            if (!item.getContactID().equals(data.getContactID())) continue;
            return item;
        }
        return null;
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private boolean notNullOrEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    private void checkMonitoredUsers() {
        String methodName = "checkMonitoredUsers() ";
        LOG.trace(methodName + "+", new Object[0]);
        ArrayList<String> currentMultiSelection = new ArrayList<String>();
        for (MonitoredUserData user : this.monitoredUserItems) {
            if (!user.isSelected()) continue;
            currentMultiSelection.add(user.getId());
        }
        LOG.trace(methodName + "currentMultiSelection = " + currentMultiSelection, new Object[0]);
        if (this.shouldMonitor) {
            LOG.trace(methodName + "should monitor = true", new Object[0]);
            if (!this.areMonitoringUsers) {
                LOG.trace(methodName + "areMonitoringUsers = false", new Object[0]);
                this.monitoredUserIds.clear();
                if (currentMultiSelection.size() > 0) {
                    for (Object userId : currentMultiSelection) {
                        this.monitoredUserIds.add((String)userId);
                        this.monitoredExe.monitorInteractions(this.supervisorUserId, (String)userId);
                    }
                    this.areMonitoringUsers = true;
                    LOG.trace(methodName + "monitoredUserIds are now = " + this.monitoredUserIds, new Object[0]);
                }
            } else {
                LOG.trace(methodName + "areMonitoringUsers = true", new Object[0]);
                if (currentMultiSelection.size() > 0) {
                    ArrayList<String> newList = new ArrayList<String>();
                    for (String userId : currentMultiSelection) {
                        newList.add(userId);
                        if (this.monitoredUserIds.contains(userId)) continue;
                        LOG.trace(methodName + "begin monitoring interactions Id = " + userId, new Object[0]);
                        this.monitoredExe.monitorInteractions(this.supervisorUserId, userId);
                    }
                    for (String userId : this.monitoredUserIds) {
                        if (newList.contains(userId)) continue;
                        LOG.trace(methodName + "stop monitoring interactions Id = " + userId, new Object[0]);
                        this.monitoredExe.unMonitorInteractions(this.supervisorUserId, userId);
                        this.removeUsersInteractions(userId);
                    }
                    this.monitoredUserIds = newList;
                } else {
                    LOG.trace(methodName + "stop monitoring interactions as none are selected", new Object[0]);
                    if (!this.monitoredUserIds.isEmpty()) {
                        for (Object userId : this.monitoredUserIds) {
                            LOG.trace(methodName + "stop monitoring interactions Id = " + (String)userId, new Object[0]);
                            this.monitoredExe.unMonitorInteractions(this.supervisorUserId, (String)userId);
                            this.removeUsersInteractions((String)userId);
                        }
                        this.monitoredUserIds.clear();
                    }
                    this.areMonitoringUsers = false;
                }
            }
        } else {
            LOG.trace(methodName + "should monitor = false", new Object[0]);
            if (this.areMonitoringUsers) {
                if (!this.monitoredUserIds.isEmpty()) {
                    LOG.trace(methodName + "stop monitoring interactions as we should not be monitoring", new Object[0]);
                    for (Object userId : this.monitoredUserIds) {
                        LOG.trace(methodName + "stop monitoring interactions Id = " + userId, new Object[0]);
                        this.monitoredExe.unMonitorInteractions(this.supervisorUserId, (String)userId);
                    }
                    this.monitoredUserIds.clear();
                }
                this.areMonitoringUsers = false;
            }
        }
        LOG.trace(methodName + "-", new Object[0]);
    }

    private void checkMonitoring() {
        String methodName = "checkMonitoring() ";
        LOG.trace(methodName + "+", new Object[0]);
        if (this.shouldMonitor) {
            LOG.trace(methodName + "should monitor = true", new Object[0]);
            if (!this.areMonitoringSupervisor) {
                LOG.trace(methodName + "areMonitoringSupervisor = false", new Object[0]);
                if (this.isNullOrEmpty(this.supervisorUserId)) {
                    LOG.trace(methodName + "supervisorUserId empty so using current selection", new Object[0]);
                    this.supervisorUserId = (String)this.superCombo.getValue();
                }
                if (this.notNullOrEmpty(this.supervisorUserId)) {
                    UserData checkUser = this.getUserItem(this.supervisorUserId);
                    if (checkUser != null && checkUser.canMonitorUsers()) {
                        LOG.trace(methodName + "begin monitoring Id = " + this.supervisorUserId, new Object[0]);
                        this.monitoredExe.monitorUsers(this.supervisorUserId);
                        this.areMonitoringSupervisor = true;
                    } else {
                        LOG.trace(methodName + "Will not monitor non-supervisor Id = " + this.supervisorUserId, new Object[0]);
                    }
                }
            }
        } else {
            LOG.trace(methodName + "should monitor = false", new Object[0]);
            if (this.areMonitoringSupervisor) {
                LOG.trace(methodName + "areMonitoringSupervisor = true", new Object[0]);
                if (this.notNullOrEmpty(this.supervisorUserId)) {
                    LOG.trace(methodName + "stop monitoring Id = " + this.supervisorUserId, new Object[0]);
                    this.monitoredExe.unMonitorUsers(this.supervisorUserId);
                    this.areMonitoringSupervisor = false;
                    this.supervisorUserId = null;
                }
            }
        }
        LOG.trace(methodName + "-", new Object[0]);
    }

    private void removeUsersInteractions(String userId) {
        String methodName = "removeUsersInteractions() ";
        ObservableList toBeRemoved = FXCollections.observableArrayList();
        LOG.trace(methodName + "clearing interactions table for userId = " + userId, new Object[0]);
        if (this.monitoredInteractionItems.size() > 0) {
            for (MonitoredInteractionData inter : this.monitoredInteractionItems) {
                if (!inter.getMonitoredUserID().equals(userId)) continue;
                toBeRemoved.add((Object)inter);
            }
            if (toBeRemoved.size() > 0) {
                this.monitoredInteractionItems.removeAll((Collection)toBeRemoved);
            }
        }
    }

    private void refreshListsAndRedraw() {
        this.refreshLists();
        this.refreshInteractionControls();
    }

    private void refreshLists() {
        String methodName = "refreshLists() ";
        String currentSelection = (String)this.superCombo.getValue();
        boolean stillExists = false;
        for (Data user : this.userItems) {
            if (!user.getId().equals(currentSelection)) continue;
            stillExists = true;
        }
        this.superCombo.getItems().clear();
        for (Data user : this.userItems) {
            LOG.trace(methodName + "combo user = " + ((UserData)user).getId() + " canMonitor? " + ((UserData)user).canMonitorUsers(), new Object[0]);
            if (!((UserData)user).canMonitorUsers()) continue;
            LOG.trace(methodName + "added supervisor", new Object[0]);
            this.superCombo.getItems().add((Object)((UserData)user).getId());
        }
        if (stillExists) {
            LOG.trace(methodName + "existing user selection still exists:" + currentSelection, new Object[0]);
            this.superCombo.setValue((Object)currentSelection);
        } else if (this.userItems.size() > 0) {
            LOG.trace(methodName + "existing user selection does not exist, setting to first element", new Object[0]);
            this.superCombo.setValue((Object)((UserData)this.userItems.get(0)).getId());
        } else {
            LOG.trace(methodName + "user list is empty", new Object[0]);
        }
        currentSelection = (String)this.superCombo.getValue();
        if (this.notNullOrEmpty(currentSelection) && !currentSelection.equals(this.supervisorUserId)) {
            LOG.trace(methodName + "Supervisor selection has changed and is valid", new Object[0]);
            if (this.notNullOrEmpty(this.supervisorUserId) && this.areMonitoringSupervisor) {
                LOG.trace(methodName + "clearing old subscription for " + this.supervisorUserId, new Object[0]);
                this.monitoredExe.unMonitorUsers(this.supervisorUserId);
                this.areMonitoringSupervisor = false;
            }
            if (this.shouldMonitor) {
                this.supervisorUserId = currentSelection;
                LOG.trace(methodName + "starting new subscription for " + this.supervisorUserId, new Object[0]);
                this.monitoredExe.monitorUsers(this.supervisorUserId);
                this.areMonitoringSupervisor = true;
            }
        }
        LOG.trace(methodName + "interaction items = " + this.monitoredInteractionItems, new Object[0]);
    }

    public WebchatForm getWebChatFormForContact(String id) {
        LOG.info("getWebchatFormForContact called. Id:" + id, new Object[0]);
        WebchatForm form = this.webchatForms.get(id);
        return form;
    }
}

