/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.api.CustomerDetailsI;
import com.avaya.ccs.api.DataI;
import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.api.EmailListEntryI;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.IntrinsicI;
import com.avaya.ccs.api.PhoneListEntryI;
import com.avaya.ccs.api.PostalAddressListEntryI;
import com.avaya.ccs.api.RemoteParticipantI;
import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.DestinationType;
import com.avaya.ccs.api.enums.InteractionState;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseInteraction;
import com.avaya.ccs.core.CallbackDetails;
import com.avaya.ccs.core.CloseReasonCode;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.ContactNumber;
import com.avaya.ccs.core.CustomerDetails;
import com.avaya.ccs.core.Data;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.ProtocolHandler;
import com.avaya.ccs.core.ReadOnlyIntrinsics;
import com.avaya.ccs.core.ScreenPop;
import com.avaya.ccs.core.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Interaction
extends BaseInteraction
implements InteractionI {
    private static Logger log = Logger.getLogger(Interaction.class);
    @JsonProperty(value="ResourceID")
    private String resourceId;
    @JsonProperty(value="ParticipationReason")
    private StateReason participationReason = StateReason.Default;
    @JsonProperty(value="ReadOnlyIntrinsics")
    private ReadOnlyIntrinsics readOnlyIntrinsics;
    @JsonProperty(value="Customer")
    private CustomerDetails customerDetails;
    @JsonProperty(value="AgentNotes")
    private List<String> agentNotes;
    @JsonProperty(value="WrapupTimer")
    private int wrapupTimer = -1;
    @JsonProperty(value="CampaignName")
    private String campaignName;
    @JsonProperty(value="AgentScript")
    private String agentScript;
    @JsonProperty(value="ContactNumbers")
    private List<ContactNumber> contactNumbers;
    @JsonProperty(value="ConsultDestTypes")
    private List<DestinationType> consultDestinationTypes;
    @JsonProperty(value="WebChatAgentLabel")
    private String webChatAgentLabel;
    @JsonProperty(value="CallbackDestTypes")
    private List<DestinationType> callbackDestinationTypes;
    @JsonProperty(value="PreviewTimer")
    private int previewTimer = -1;
    @JsonProperty(value="IsConsult")
    private boolean isConsult;
    @JsonProperty(value="IsConsultedAgent")
    private boolean isConsultedAgent;
    @JsonProperty(value="IsAutoAnswered")
    private boolean isAutoAnswered;
    @JsonProperty(value="IsConference")
    private boolean isConference;
    @JsonProperty(value="WebChatCustomerConnected")
    private boolean webChatCustomerConnected;
    @JsonProperty(value="CloseReasonCode")
    private CloseReasonCode closedReasonCode;
    @JsonProperty(value="ScreenPops")
    List<ScreenPop> screenPops;
    Media media = null;
    String mediaPath = "/Interaction/" + this.id + "/Media";

    @Override
    public void setMedia(Media media) {
        this.media = media;
    }

    @Override
    public Media getMedia() {
        return this.media;
    }

    @Override
    public synchronized boolean canObserveDn() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.ObserveDn);
    }

    @Override
    public synchronized boolean canAnswer() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Answer);
    }

    @Override
    public synchronized boolean canHold() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Hold);
    }

    @Override
    public synchronized boolean canUnhold() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Unhold);
    }

    @Override
    public synchronized boolean canEnd() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.End);
    }

    @Override
    public synchronized boolean canInitiateTransfer() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.InitiateTransfer);
    }

    @Override
    public synchronized boolean canInitiateConference() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.InitiateConference);
    }

    @Override
    public synchronized boolean canCompleteTransfer() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.CompleteTransfer);
    }

    @Override
    public synchronized boolean canCompleteConference() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.CompleteConference);
    }

    @Override
    public synchronized boolean canJoinConference() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.JoinConference);
    }

    @Override
    public synchronized boolean canEmergency() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Emergency);
    }

    @Override
    public synchronized boolean canPlayDTMF() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.PlayDTMF);
    }

    @Override
    public synchronized boolean canGetActivityCodes() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetActivityCodes);
    }

    @Override
    public synchronized boolean canGetCustomFields() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetCustomFields);
    }

    @Override
    public boolean canGetSkillsets() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetSkillsets);
    }

    @Override
    public synchronized boolean canSetActivityCode() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.SetActivityCode);
    }

    @Override
    public synchronized boolean canSetUUI() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.SetUUI);
    }

    @Override
    public synchronized boolean canAddAgentNote() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.AddAgentNote);
    }

    @Override
    public synchronized boolean canRefreshAgentNotes() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.RefreshAgentNotes);
    }

    @Override
    public synchronized boolean canGetCallbackDestinations() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetCallbackDestinations);
    }

    @Override
    public synchronized boolean canGetConsultDestinations() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetConsultDestinations);
    }

    @Override
    public synchronized boolean canGetDispositionCodes() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetDispositionCodes);
    }

    @Override
    public synchronized boolean canWrapup() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Wrapup);
    }

    @Override
    public synchronized boolean canWrapupWithCode() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.WrapupWithCode);
    }

    @Override
    public synchronized boolean canExtendWrapup() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.ExtendWrapup);
    }

    @Override
    public synchronized boolean canCreateCallback() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.CreateCallback);
    }

    @Override
    public synchronized boolean canPreviewDialFreeForm() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.PreviewDialFreeForm);
    }

    @Override
    public synchronized boolean canPreviewDial() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.PreviewDial);
    }

    @Override
    public synchronized boolean canPreviewCancel() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.PreviewCancel);
    }

    @Override
    public synchronized boolean canRedial() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Redial);
    }

    @Override
    public synchronized boolean canInitiateTransferToDestination() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.InitiateTransferToDestination);
    }

    @Override
    public synchronized boolean canInitiateConferenceToDestination() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.InitiateConferenceToDestination);
    }

    @Override
    public synchronized boolean canChangeConferenceOwner() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.ChangeConferenceOwner);
    }

    @Override
    public synchronized boolean canEndConference() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.EndConference);
    }

    @Override
    public synchronized boolean canEndConsult() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.EndConsult);
    }

    @Override
    public synchronized boolean canTransferToDestination() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.TransferToDestination);
    }

    @Override
    public synchronized boolean canUpdateCustomerName() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.UpdateCustomerName);
    }

    @Override
    public synchronized boolean canUpdateCustomerAddress() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.UpdateCustomerAddress);
    }

    @Override
    public synchronized boolean canUpdateCustomerPhone() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.UpdateCustomerPhone);
    }

    @Override
    public synchronized boolean canUpdateCustomerEmail() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.UpdateCustomerEmail);
    }

    @Override
    public synchronized boolean canAddToDnc() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.AddToDNC);
    }

    @Override
    public synchronized boolean canGetAutoPhrases() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetAutoPhrases);
    }

    @Override
    public synchronized boolean canGetPagePushUrls() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetPagePushUrls);
    }

    @Override
    public synchronized boolean canGetCustomerHistory() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.GetCustomerHistory);
    }

    @Override
    public synchronized boolean canOpenMedia() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.OpenMedia);
    }

    @Override
    public synchronized String getAddress() throws ObjectInvalidException {
        return super.getAddress();
    }

    @Override
    public synchronized String getAddressName() throws ObjectInvalidException {
        return super.getAddressName();
    }

    @Override
    public synchronized String getCallingAddress() throws ObjectInvalidException {
        return super.getCallingAddress();
    }

    @Override
    public synchronized String getCallingAddressName() throws ObjectInvalidException {
        return super.getCallingAddressName();
    }

    @Override
    public synchronized String getCalledAddress() throws ObjectInvalidException {
        return super.getCalledAddress();
    }

    @Override
    public synchronized String getCalledAddressName() throws ObjectInvalidException {
        return super.getCalledAddressName();
    }

    @Override
    public synchronized ContactCenterCodeI getActivityCode() throws ObjectInvalidException {
        return super.getActivityCode();
    }

    @Override
    public synchronized String getContactId() throws ObjectInvalidException {
        return super.getContactId();
    }

    @Override
    public synchronized ContactType getContactType() throws ObjectInvalidException {
        return super.getContactType();
    }

    @Override
    public synchronized DataI getData() throws ObjectInvalidException {
        return super.getData();
    }

    @Override
    public synchronized List<IntrinsicI> getIntrinsics() throws ObjectInvalidException {
        return super.getIntrinsics();
    }

    @Override
    public synchronized boolean isMonitored() throws ObjectInvalidException {
        return super.isMonitored();
    }

    @Override
    public synchronized boolean isMultimedia() throws ObjectInvalidException {
        return super.isMultimedia();
    }

    @Override
    public synchronized boolean isConference() throws ObjectInvalidException {
        return this.isConference;
    }

    @Override
    public synchronized boolean isConsult() throws ObjectInvalidException {
        return this.isConsult;
    }

    @Override
    public synchronized boolean isAutoAnswered() {
        return this.isAutoAnswered;
    }

    @Override
    public boolean isConsultedAgent() {
        return this.isConsultedAgent;
    }

    @Override
    public synchronized StateReason getParticipationReason() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.participationReason;
    }

    @Override
    public synchronized List<RemoteParticipantI> getRemoteParticipants() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.remoteParticipants == null) {
            return new ArrayList<RemoteParticipantI>();
        }
        return new ArrayList<RemoteParticipantI>(this.remoteParticipants);
    }

    @Override
    public synchronized String getResourceId() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.resourceId;
    }

    @Override
    public synchronized String getUserId() {
        return this.userId;
    }

    @Override
    public synchronized SessionI getSession() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.client != null ? this.client.getSession() : null;
    }

    @Override
    public synchronized String getSkillset() throws ObjectInvalidException {
        return super.getSkillset();
    }

    @Override
    public synchronized InteractionState getState() {
        return super.getState();
    }

    @Override
    public synchronized StateReason getStateReason() {
        return super.getStateReason();
    }

    @Override
    public synchronized String getUUI() throws ObjectInvalidException {
        return super.getUUI();
    }

    @Override
    public synchronized String getMainContactId() throws ObjectInvalidException {
        return super.getMainContactId();
    }

    @Override
    public synchronized String getOriginalDestination() throws ObjectInvalidException {
        return super.getOriginalDestination();
    }

    @Override
    public synchronized CustomerDetailsI getCustomerDetails() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.customerDetails;
    }

    @Override
    public synchronized String getWebChatAgentLabel() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.webChatAgentLabel;
    }

    @Override
    public synchronized boolean getWebChatCustomerConnected() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.webChatCustomerConnected;
    }

    @Override
    public synchronized List<String> getAgentNotes() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.agentNotes == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.agentNotes);
    }

    @Override
    public synchronized int getWrapupTimer() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.wrapupTimer;
    }

    @Override
    public synchronized int getPreviewTimer() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.previewTimer;
    }

    @Override
    public synchronized String getCampaignName() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.campaignName;
    }

    @Override
    public synchronized String getAgentScriptUrl() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.agentScript;
    }

    @Override
    public List<ScreenPop> getScreenPops() {
        return this.screenPops;
    }

    @Override
    public synchronized List<ContactNumberI> getContactNumbers() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.contactNumbers == null) {
            return new ArrayList<ContactNumberI>();
        }
        return new ArrayList<ContactNumberI>(this.contactNumbers);
    }

    @Override
    public synchronized void getConsultDestinationTypes() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("getConsultDestinationTypes", this);
            this.get(new CommandArgs(Command.GetConsultDestinationTypes));
        }, "Interaction.getConsultDestinations()");
    }

    @Override
    public void updateClosedReasonCode(String code) throws ObjectInvalidException {
        this.checkForDeletion();
        String data = "{\"ClosedReasonCode\":\"" + code + "\"}";
        this.execute(() -> {
            log.info("updateCloseReasonCode", this);
            this.post(new CommandArgs(Command.UpdateClosedReasonCode), data);
        }, "Interaction.updateCloseReasonCode()");
    }

    @Override
    public void getSkillsets() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("getSkillsets", this);
            this.get(new CommandArgs(Command.GetSkillsets));
        }, "Interaction.getSkillsets()");
    }

    @Override
    public synchronized List<DestinationType> getCallbackDestinationTypes() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.callbackDestinationTypes == null) {
            return new ArrayList<DestinationType>();
        }
        return new ArrayList<DestinationType>(this.callbackDestinationTypes);
    }

    @Override
    public synchronized void answer() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("answer", this);
            this.post(new CommandArgs(Command.Answer), null);
        }, "Interaction.answer()");
    }

    @Override
    public synchronized void hold() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("hold", this);
            this.post(new CommandArgs(Command.Hold), null);
        }, "Interaction.hold()");
    }

    @Override
    public synchronized void unhold() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("unhold", this);
            this.post(new CommandArgs(Command.Unhold), null);
        }, "Interaction.unhold()");
    }

    @Override
    public synchronized void end() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("end", this);
            this.post(new CommandArgs(Command.End), null);
        }, "Interaction.end()");
    }

    @Override
    public synchronized void coach() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("coach", this);
            this.post(new CommandArgs(Command.Coach), null);
        }, "Interaction.Coach()");
    }

    @Override
    public synchronized void end(String closeReasonCode, String closingAgentNote, boolean sendTranscript) throws ObjectInvalidException {
        String data = "{\"ClosedReasonCode\":\"" + closeReasonCode + "\",\"AgentNote\":\"" + closingAgentNote + "\",\"SendTranscript\":" + sendTranscript + "}";
        this.execute(() -> {
            log.info("end", this);
            this.post(new CommandArgs(Command.End), data);
        }, "Interaction.end()");
    }

    @Override
    public synchronized void requestCustomerInteractionMedia(String contactId) {
        log.debug("requestCustomerInteractionMedia. id: " + contactId, new Object[0]);
        this.execute(() -> {
            log.info("end", this);
            this.get(new CommandArgs(Command.GetCustomerInteractionMedia, contactId));
        }, "Interaction.requestCustomerInteractionMedia()");
    }

    @Override
    public synchronized void endConsult() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("endConsult", this);
            this.post(new CommandArgs(Command.EndConsult), null);
        }, "Interaction.endConsult()");
    }

    @Override
    public synchronized void initiateTransfer(String destination) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(destination)) {
            throw new InvalidArgumentException("mandatory destination argument is null or empty");
        }
        this.execute(() -> {
            log.info("initiateTransfer", this, ", dest:", destination);
            this.post(new CommandArgs(Command.InitiateTransfer, destination), null);
        }, "Interaction.initiateTransfer()");
    }

    @Override
    public synchronized void consult(String destination) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(destination)) {
            throw new InvalidArgumentException("mandatory destination argument is null or empty");
        }
        this.execute(() -> {
            log.info("consult", this, ", dest:", destination);
            this.post(new CommandArgs(Command.Consult, destination), null);
        }, "Interaction.consult()");
    }

    @Override
    public synchronized void initiateConference(String destination) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(destination)) {
            throw new InvalidArgumentException("mandatory destination argument is null or empty");
        }
        this.execute(() -> {
            log.info("initiateConference", this, ", dest:", destination);
            this.post(new CommandArgs(Command.InitiateConference, destination), null);
        }, "Interaction.initiateConference()");
    }

    @Override
    public synchronized void completeTransfer() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("completeTransfer", this);
            this.post(new CommandArgs(Command.CompleteTransfer), null);
        }, "Interaction.completeTransfer()");
    }

    @Override
    public synchronized void completeConference() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("completeConference", this);
            this.post(new CommandArgs(Command.CompleteConference), null);
        }, "Interaction.completeConference()");
    }

    @Override
    public synchronized void joinConference(InteractionI otherInteraction) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (otherInteraction == null) {
            throw new InvalidArgumentException("mandatory interaction argument is null");
        }
        Interaction otherInteractionImpl = (Interaction)otherInteraction;
        otherInteractionImpl.checkForDeletion();
        this.execute(() -> {
            log.info("joinConference", this, ", other " + otherInteraction);
            this.post(new CommandArgs(Command.JoinConference, otherInteraction.getId()), null);
        }, "Interaction.joinConference()");
    }

    @Override
    public synchronized void playDTMF(String digits) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(digits)) {
            throw new InvalidArgumentException("mandatory digits argument is null or empty");
        }
        this.execute(() -> {
            log.info("playDTMF", this, ", digits:", digits);
            this.post(new CommandArgs(Command.PlayDTMF, digits), null);
        }, "Interaction.playDTMF()");
    }

    @Override
    public synchronized void emergency() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("emergency", this);
            this.post(new CommandArgs(Command.Emergency), null);
        }, "Interaction.emergency()");
    }

    @Override
    public synchronized void getActivityCodes() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            if (this.activityCodes != null) {
                log.info("getActivityCodes", this, ", return cached activity codes");
                if (this.client != null && this.client.getSession() != null) {
                    this.client.getSession().notify(NotificationType.RESPONSE, this, null, this.activityCodes);
                }
            } else {
                log.info("getActivityCodes", this);
                this.get(new CommandArgs(Command.GetActivityCodes));
            }
        }, "Interaction.getActivityCodes()");
    }

    @Override
    public synchronized void getCustomFields() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            if (this.customFields != null) {
                log.info("getCustomFields", this, ", return cached custom fields");
                if (this.client != null && this.client.getSession() != null) {
                    this.client.getSession().notify(NotificationType.RESPONSE, this, null, this.customFields);
                }
            } else {
                log.info("getCustomFields", this);
                this.get(new CommandArgs(Command.GetCustomFields));
            }
        }, "Interaction.getCustomFields()");
    }

    @Override
    @JsonIgnore
    public synchronized void setActivityCode(String code) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        String validatedCode = Utils.makeNullIfEmpty(code);
        this.execute(() -> {
            log.info("setActivityCode", this, ", code:", validatedCode);
            this.post(new CommandArgs(Command.SetActivityCode, validatedCode), null);
        }, "Interaction.setActivityCode()");
    }

    @Override
    public synchronized IntrinsicI getIntrinsic(String name) throws ObjectInvalidException, InvalidArgumentException {
        return super.getIntrinsic(name);
    }

    @Override
    @JsonIgnore
    public synchronized void setIntrinsic(String name, String value) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("mandatory intrinsic name argument is null or empty");
        }
        if (Utils.isNullOrEmpty(value)) {
            throw new InvalidArgumentException("mandatory intrinsic value argument is null or empty");
        }
        this.execute(() -> {
            log.info("setIntrinsic", this, ", name:", name, ", value:***sensitive-data[", value.length(), "]***");
            try {
                this.post(new CommandArgs(Command.SetIntrinsic, name), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)value));
            }
            catch (Exception e) {
                log.error("setIntrinsic", e, "unable to serialize data");
            }
        }, "Interaction.setIntrinsic()");
    }

    @Override
    public synchronized void removeIntrinsic(String name) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("mandatory intrinsic name argument is null or empty");
        }
        this.execute(() -> {
            log.info("removeIntrinsic", this, ", name:", name);
            this.post(new CommandArgs(Command.RemoveIntrinsic, name), null);
        }, "Interaction.removeIntrinsic()");
    }

    @Override
    @JsonIgnore
    public synchronized void setData(DataI data) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (data == null) {
            throw new InvalidArgumentException("mandatory data argument is null");
        }
        this.execute(() -> {
            log.info("setData", new Object[]{this, ", ***sensitive-data[", data.getFormat(), "][", ((Data)data).length(), "]***"});
            try {
                this.post(new CommandArgs(Command.SetData), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)data));
            }
            catch (Exception e) {
                log.error("setData", e, "unable to serialize data");
            }
        }, "Interaction.setData()");
    }

    @Override
    public synchronized void removeData() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.data == null) {
            log.warn("removeData", "no data to remove ", this);
            return;
        }
        this.execute(() -> {
            log.info("removeData", this);
            this.post(new CommandArgs(Command.RemoveData), null);
        }, "Interaction.removeData()");
    }

    @Override
    @JsonIgnore
    public synchronized void setUUI(String uui) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (uui == null) {
            throw new InvalidArgumentException("mandatory uui argument is null");
        }
        this.execute(() -> {
            log.info("setUUI", this, ", uui:***sensitive-data[", uui.length(), "]***");
            try {
                this.post(new CommandArgs(Command.SetUUI), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)uui));
            }
            catch (Exception e) {
                log.error("setUUI", e, "unable to serialize uui");
            }
        }, "Interaction.setUUI()");
    }

    @Override
    public synchronized void addToDNC() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("addToDNC", this);
            this.post(new CommandArgs(Command.AddToDNC, "1"), null);
        }, "Interaction.addToDNC()");
    }

    @Override
    public synchronized void addAgentNote(String note) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(note)) {
            throw new InvalidArgumentException("mandatory note argument is null or empty");
        }
        this.execute(() -> {
            log.info("addAgentNote", this, ", note:***sensitive-data[", note.length(), "]***");
            try {
                this.post(new CommandArgs(Command.AddAgentNote), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)note));
            }
            catch (Exception e) {
                log.error("addAgentNote", e, "unable to send request, exception serializing note string");
            }
        }, "Interaction.addAgentNote()");
    }

    @Override
    public synchronized void refreshAgentNotes() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("refreshAgentNotes", this);
            this.post(new CommandArgs(Command.RefreshAgentNotes), null);
        }, "Interaction.refreshAgentNotes()");
    }

    @Override
    public synchronized void getConsultDestinations(DestinationType consultDestType) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (consultDestType == null) {
            throw new InvalidArgumentException("mandatory consult destination type arg is null");
        }
        if (consultDestType == DestinationType.Unknown) {
            throw new InvalidArgumentException("consult destination type of unknown is not a valid arg");
        }
        this.execute(() -> {
            log.info("getConsultDestinations", new Object[]{this, ", ", consultDestType});
            this.get(new CommandArgs(Command.GetConsultDestinations).appendArg(CommandArgs.Argument.DestinationType, consultDestType.toString()));
        }, "Interaction.getConsultDestinations()");
    }

    @Override
    public synchronized void getCallbackDestinations(DestinationType callbackDestType) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (callbackDestType == null) {
            throw new InvalidArgumentException("mandatory callback destination type arg is null");
        }
        if (callbackDestType == DestinationType.Unknown) {
            throw new InvalidArgumentException("callback destination type of unknown is not a valid arg");
        }
        this.execute(() -> {
            log.info("getCallbackDestinations", new Object[]{this, ", ", callbackDestType});
            this.get(new CommandArgs(Command.GetCallbackDestinations).appendArg(CommandArgs.Argument.DestinationType, callbackDestType.toString()));
        }, "Interaction.getCallbackDestinations()");
    }

    @Override
    public synchronized void requestDispositionCodes() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("requestDispositionCodes", this);
            this.get(new CommandArgs(Command.GetDispositionCodes));
        }, "Interaction.requestDispositionCodes()");
    }

    @Override
    public synchronized void requestAutoPhrases() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("requestAutoPhrases", this);
            CommandArgs args = new CommandArgs(Command.GetAutoPhrases);
            this.get(args);
        }, "Interaction.requestAutoPhrases()");
    }

    @Override
    public synchronized void requestPagePushUrls() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("requestPagePushUrls", this);
            CommandArgs args = new CommandArgs(Command.GetPagePushUrls);
            this.get(args);
        }, "Interaction.requestPagePushUrls()");
    }

    @Override
    public synchronized void requestCustomerHistory() {
        this.execute(() -> {
            log.info("requestCustomerHistory", this);
            this.getCustomerHistory(this.id, new CommandArgs(Command.GetCustomerHistory));
        }, "Interaction.requestCustomerHistory");
    }

    @Override
    public synchronized void requestApprovalStatus() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("requestApprovalStatus", this);
            CommandArgs args = new CommandArgs(Command.ContactSearch);
            if (!Utils.isNullOrEmpty(this.contactId)) {
                args.appendArg(CommandArgs.Argument.ContactId, this.contactId);
            }
            this.get(args);
        }, "Interaction.requestApprovalStatus()");
    }

    @Override
    public synchronized void requestReviewEmail(String reviewType, Map<CommandArgs.Argument, String> queryParams, String data) throws ObjectInvalidException {
        this.execute(() -> {
            log.info("requestReviewEmail", this);
            CommandArgs args = new CommandArgs(Command.EmailReview);
            args.appendArg(CommandArgs.Argument.ReviewType, reviewType);
            for (Map.Entry entry : queryParams.entrySet()) {
                args.appendArg((CommandArgs.Argument)((Object)((Object)entry.getKey())), (String)entry.getValue());
            }
            this.post(args, data);
        }, "Interaction.requestReviewEmail()");
    }

    @Override
    public synchronized void previewDial(ContactNumberI contact) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (contact == null) {
            throw new InvalidArgumentException("mandatory contact number arg is null");
        }
        this.execute(() -> {
            log.info("previewDial", this, ", ", contact);
            try {
                this.post(new CommandArgs(Command.PreviewDial), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)contact));
            }
            catch (Exception e) {
                log.error("previewDial", e, "unable to send request, exception serializing ContactNumber");
            }
        }, "Interaction.previewDial()");
    }

    @Override
    public synchronized void previewCancel() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("previewCancel", this);
            this.post(new CommandArgs(Command.PreviewCancel), null);
        }, "Interaction.previewCancel()");
    }

    @Override
    public synchronized void redial(ContactNumberI contact) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (contact == null) {
            throw new InvalidArgumentException("mandatory contact number arg is null");
        }
        this.execute(() -> {
            log.info("redial", this, ", ", contact);
            try {
                this.post(new CommandArgs(Command.Redial), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)contact));
            }
            catch (Exception e) {
                log.error("redial", e, "unable to send request, exception serializing ContactNumber");
            }
        }, "Interaction.redial()");
    }

    @Override
    public synchronized void wrapup() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("wrapup", this);
            this.post(new CommandArgs(Command.Wrapup), null);
        }, "Interaction.wrapup()");
    }

    @Override
    public synchronized void wrapupWithCode(ContactCenterCodeI completionCode) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (completionCode == null || completionCode.getType() != CodeType.Disposition) {
            throw new InvalidArgumentException("mandatory completion code arg is null or is incorrect code type");
        }
        this.execute(() -> {
            log.info("wrapupWithCode", this, ", ", completionCode);
            try {
                this.post(new CommandArgs(Command.WrapupWithCode), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)completionCode));
            }
            catch (Exception e) {
                log.error("wrapupWithCode", e, "unable to send request, exception serializing ContactNumber");
            }
        }, "Interaction.wrapupWithCode()");
    }

    @Override
    public synchronized void extendWrapup() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("extendWrapup", this);
            this.post(new CommandArgs(Command.ExtendWrapup), null);
        }, "Interaction.extendWrapup()");
    }

    @Override
    public synchronized void createCallback(DestinationI callbackDestination, ContactNumberI contactNumber, String callbackTime, String callbackExpiryTime, String callbackNote) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (callbackDestination == null) {
            throw new InvalidArgumentException("mandatory callback destination arg is null");
        }
        if (contactNumber == null) {
            throw new InvalidArgumentException("mandatory contact number arg is null");
        }
        this.execute(() -> {
            try {
                CallbackDetails callbackDetails = new CallbackDetails(callbackDestination, callbackTime, callbackExpiryTime, callbackNote, null, contactNumber);
                String serializedCallbackDestJson = ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)callbackDetails);
                log.info("createCallback", this, ", ", callbackDestination, ", time:", callbackTime, ", expiryTime:", callbackExpiryTime, callbackNote != null ? ", note:***sensitive-data[" + callbackNote.length() + "]***" : "", ", ", contactNumber);
                this.post(new CommandArgs(Command.CreateCallback), serializedCallbackDestJson);
            }
            catch (Exception e) {
                log.error("createCallback", e, "unable to send request, exception serializing CallbackDestination");
            }
        }, "Interaction.createCallback(contactnumber)");
    }

    @Override
    public synchronized void createCallback(DestinationI callbackDestination, String externalNumber, String callbackTime, String callbackExpiryTime, String callbackNote) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (callbackDestination == null) {
            throw new InvalidArgumentException("mandatory callback destination arg is null");
        }
        if (Utils.isNullOrEmpty(externalNumber)) {
            throw new InvalidArgumentException("mandatory external number arg is null or empty");
        }
        this.execute(() -> {
            try {
                CallbackDetails callbackDest = new CallbackDetails(callbackDestination, callbackTime, callbackExpiryTime, callbackNote, externalNumber, null);
                String serializedCallbackDestJson = ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)callbackDest);
                log.info("createCallback", this, ", ", callbackDestination, ", time:", callbackTime, ", expiryTime:", callbackExpiryTime, callbackNote != null ? ", note:***sensitive-data[" + callbackNote.length() + "]***" : "", ", externalNumber:", externalNumber);
                this.post(new CommandArgs(Command.CreateCallback), serializedCallbackDestJson);
            }
            catch (Exception e) {
                log.error("createCallback", e, "unable to send request, exception serializing CallbackDestination");
            }
        }, "Interaction.createCallback(external)");
    }

    @Override
    public synchronized void initiateTransferToDestination(DestinationI destination) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (destination == null) {
            throw new InvalidArgumentException("mandatory destination arg is null");
        }
        this.execute(() -> {
            log.info("initiateTransferToDestination", this, ", ", destination);
            try {
                this.post(new CommandArgs(Command.InitiateTransferToDestination), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)destination));
            }
            catch (Exception e) {
                log.error("initiateTransferToDestination", e, "unable to send request, exception serializing Destination");
            }
        }, "Interaction.initiateTransferToDestination()");
    }

    @Override
    public synchronized void transferToDestination(DestinationI destination) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (destination == null) {
            throw new InvalidArgumentException("mandatory destination arg is null");
        }
        this.execute(() -> {
            log.info("transferToDestination", this, ", ", destination);
            try {
                this.post(new CommandArgs(Command.TransferToDestination), "{\"Destination\":\t" + ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)destination) + "}");
            }
            catch (Exception e) {
                log.error("transferToDestination", e, "unable to send request, exception serializing Destination");
            }
        }, "Interaction.transferToDestination()");
    }

    @Override
    public synchronized void initiateConferenceToDestination(DestinationI destination) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (destination == null) {
            throw new InvalidArgumentException("mandatory destination arg is null");
        }
        this.execute(() -> {
            log.info("initiateConferenceToDestination", this, ", ", destination);
            try {
                this.post(new CommandArgs(Command.InitiateConferenceToDestination), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)destination));
            }
            catch (Exception e) {
                log.error("initiateConferenceToDestination", e, "unable to send request, exception serializing Destination");
            }
        }, "Interaction.initiateConferenceToDestination()");
    }

    @Override
    public synchronized void updateCustomerEmail(EmailListEntryI emailEntry) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (emailEntry == null) {
            throw new InvalidArgumentException("mandatory email entry arg is null");
        }
        this.execute(() -> {
            log.info("updateCustomerEmail", this, ", emailEntryId:", emailEntry.getId());
            try {
                this.post(new CommandArgs(Command.UpdateCustomerEmail), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)emailEntry));
            }
            catch (Exception e) {
                log.error("updateCustomerEmail", e, "unable to send request, exception serializing EmailListEntry");
            }
        }, "Interaction.updateCustomerEmail()");
    }

    @Override
    public synchronized void updateCustomerPhone(PhoneListEntryI phoneEntry) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (phoneEntry == null) {
            throw new InvalidArgumentException("mandatory phone entry arg is null");
        }
        this.execute(() -> {
            log.info("updateCustomerPhone", this, ", phoneEntryId:", phoneEntry.getId());
            try {
                this.post(new CommandArgs(Command.UpdateCustomerPhone), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)phoneEntry));
            }
            catch (Exception e) {
                log.error("updateCustomerPhone", e, "unable to send request, exception serializing PhoneListEntry");
            }
        }, "Interaction.updateCustomerPhone()");
    }

    @Override
    public synchronized void updateCustomerAddress(PostalAddressListEntryI addressEntry) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (addressEntry == null) {
            throw new InvalidArgumentException("mandatory address entry arg is null");
        }
        this.execute(() -> {
            log.info("updateCustomerAddress", this, ", addressEntryId:", addressEntry.getId());
            try {
                this.post(new CommandArgs(Command.UpdateCustomerAddress), ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)addressEntry));
            }
            catch (Exception e) {
                log.error("updateCustomerAddress", e, "unable to send request, exception serializing PostalAddressListEntry");
            }
        }, "Interaction.updateCustomerAddress()");
    }

    @Override
    public synchronized void updateCustomerName(String title, String firstName, String lastName) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(title) && Utils.isNullOrEmpty(firstName) && Utils.isNullOrEmpty(lastName)) {
            throw new InvalidArgumentException("all name arguments are empty or null");
        }
        this.execute(() -> {
            log.info("updateCustomerName", this, ", title:", title, ", firstName:", firstName, ", lastName:", lastName);
            CommandArgs args = new CommandArgs(Command.UpdateCustomerName);
            if (!Utils.isNullOrEmpty(title)) {
                args.appendArg(CommandArgs.Argument.Title, title);
            }
            if (!Utils.isNullOrEmpty(firstName)) {
                args.appendArg(CommandArgs.Argument.FirstName, firstName);
            }
            if (!Utils.isNullOrEmpty(lastName)) {
                args.appendArg(CommandArgs.Argument.LastName, lastName);
            }
            this.post(args, null);
        }, "Interaction.updateCustomerName()");
    }

    @Override
    public synchronized void previewDialFreeForm(String destination) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(destination)) {
            throw new InvalidArgumentException("mandatory destination argument is null or empty");
        }
        this.execute(() -> {
            log.info("previewDialFreeForm", this, ", dest:", destination);
            this.post(new CommandArgs(Command.PreviewDialFreeForm, destination), null);
        }, "Interaction.previewDialFreeForm()");
    }

    @Override
    public synchronized void endConference() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("endConference", this);
            this.post(new CommandArgs(Command.EndConference), null);
        }, "Interaction.endConference()");
    }

    @Override
    public synchronized void changeConferenceOwner() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("changeConferenceOwner", this);
            this.post(new CommandArgs(Command.ChangeConferenceOwner), null);
        }, "Interaction.changeConferenceOwner()");
    }

    @Override
    public synchronized void openMedia() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("openMedia", this);
            if (this.client != null) {
                this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.OPEN, this.getMultimediaInteractionPath(this.id), new CommandArgs(Command.OpenMedia), null);
            } else {
                log.warn("open", "client object is null");
            }
        }, "Interaction.openMedia()");
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
        this.participationReason = StateReason.Default;
        super.clearOldCachedDataBeforeUpdate();
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.Interaction;
    }

    @Override
    public String toJsonStringMaskSensitive() {
        return "{ID:" + this.id + ",ContactID:" + this.contactId + ",IsMonitored:" + this.isMonitored + ",ContactType:" + (Object)((Object)this.contactType) + ",RemoteParticipants:" + this.remoteParticipants + ",IsMultimedia:" + this.isMultimedia + ",UserID:" + this.userId + ",ResourceID:" + this.resourceId + ",State:" + (Object)((Object)this.state) + ",StateReason:" + (Object)((Object)this.reason) + ",ParticipationReason:" + (Object)((Object)this.participationReason) + ",Address:" + this.address + (this.skillset != null ? ",Skillset:" + this.skillset : "") + ",CallingAddress:" + this.callingAddress + ",CalledAddress:" + this.calledAddress + ",ActivityCode:" + this.activityCode + (this.intrinsics != null ? ",Intrinsics:***sensitive-data[" + this.intrinsics.get().size() + "]***" : "") + (this.originalDestination != null ? ",OriginalDestination:" + this.originalDestination : "") + (this.uui != null ? ",UUI:***sensitive-data[" + this.uui.length() + "]***" : "") + (this.data != null ? ",Data:***sensitive-data[" + (Object)((Object)this.data.getFormat()) + "][" + this.data.length() + "]***" : "") + (this.mainContactId != null ? ",MainContactID:" + this.mainContactId : "") + (this.customerDetails != null ? ",Customer:***sensitive-data***" : "") + (this.agentNotes != null ? ",AgentNotes:***sensitive-data***" : "") + ",WrapupTimer:" + this.wrapupTimer + (this.campaignName != null ? ",CampaignName:" + this.campaignName : "") + (this.agentScript != null ? ",AgentScript:" + this.agentScript : "") + (this.contactNumbers != null ? ",ContactNumbers:" + this.contactNumbers : "") + (this.consultDestinationTypes != null ? ",ConsultDestTypes:" + this.consultDestinationTypes : "") + (this.callbackDestinationTypes != null ? ",CallbackDestTypes:" + this.callbackDestinationTypes : "") + ", screenPops=" + this.screenPops + ",PreviewTimer:" + this.previewTimer + ",Functions:" + this.availableCommands + "}";
    }

    @Override
    public CloseReasonCode getClosedReasonCode() {
        return this.closedReasonCode;
    }

    public String toString() {
        return "Interaction [resourceId=" + this.resourceId + ", participationReason=" + (Object)((Object)this.participationReason) + ", readOnlyIntrinsics=" + this.readOnlyIntrinsics + ", customerDetails=" + this.customerDetails + ", agentNotes=" + this.agentNotes + ", wrapupTimer=" + this.wrapupTimer + ", campaignName=" + this.campaignName + ", agentScript=" + this.agentScript + ", contactNumbers=" + this.contactNumbers + ", consultDestinationTypes=" + this.consultDestinationTypes + ", webChatAgentLabel=" + this.webChatAgentLabel + ", webChatCustomerConnected=" + this.webChatCustomerConnected + ", callbackDestinationTypes=" + this.callbackDestinationTypes + ", previewTimer=" + this.previewTimer + ", isConsult=" + this.isConsult + ", isConference=" + this.isConference + ", closedReasonCode=" + this.closedReasonCode + ", screenPops=" + this.screenPops + ", media=" + this.media + ", mediaPath=" + this.mediaPath + "]";
    }
}

