/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.function.UnaryOperator;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class DtmfKeypad {
    private InteractionExecutor interactionExe = null;
    private Stage theStage = null;
    private Scene theScene = null;
    private GridPane gridPane = null;
    private Button dtmf1;
    private Button dtmf2;
    private Button dtmf3;
    private Button dtmf4;
    private Button dtmf5;
    private Button dtmf6;
    private Button dtmf7;
    private Button dtmf8;
    private Button dtmf9;
    private Button dtmf0;
    private Button dtmfStar;
    private Button dtmfHash;
    private Button dtmfSend;
    private TextField sentTones;
    private TextField typedTones;
    private String interactionId = null;
    private static final Logger LOG = Logger.getLogger(DtmfKeypad.class);
    private static final Integer BUTTONWIDTH = 45;
    private static final Integer BUTTONHEIGHT = 45;

    public Stage getStage() {
        return this.theStage;
    }

    public void show(String interactionId) {
        this.theStage.show();
        this.theStage.requestFocus();
        this.typedTones.requestFocus();
        this.interactionId = interactionId;
    }

    public void hide() {
        this.theStage.hide();
    }

    public DtmfKeypad(InteractionExecutor interactionExe) {
        this.interactionExe = interactionExe;
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.setVgap(3.0);
        this.gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.gridPane.setMinWidth(110.0);
        this.gridPane.setMinHeight(150.0);
        this.createDtmfGrid();
        this.theScene = new Scene((Parent)this.gridPane);
        this.theStage = new Stage(StageStyle.UTILITY);
        this.theStage.setScene(this.theScene);
        this.theStage.setTitle("DTMF Keypad");
        this.theStage.setOnCloseRequest(event -> this.sentTones.clear());
    }

    private void createDtmfGrid() {
        this.dtmf1 = new Button("1");
        this.dtmf1.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf1.setOnAction(e -> {
            LOG.info("1()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf2 = new Button("2");
        this.dtmf2.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf2.setOnAction(e -> {
            LOG.info("2()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf3 = new Button("3");
        this.dtmf3.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf3.setOnAction(e -> {
            LOG.info("3()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf4 = new Button("4");
        this.dtmf4.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf4.setOnAction(e -> {
            LOG.info("4()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf5 = new Button("5");
        this.dtmf5.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf5.setOnAction(e -> {
            LOG.info("5()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf6 = new Button("6");
        this.dtmf6.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf6.setOnAction(e -> {
            LOG.info("6()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf7 = new Button("7");
        this.dtmf7.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf7.setOnAction(e -> {
            LOG.info("7()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf8 = new Button("8");
        this.dtmf8.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf8.setOnAction(e -> {
            LOG.info("8()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf9 = new Button("9");
        this.dtmf9.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf9.setOnAction(e -> {
            LOG.info("9()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmf0 = new Button("0");
        this.dtmf0.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmf0.setOnAction(e -> {
            LOG.info("0()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmfStar = new Button("*");
        this.dtmfStar.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmfStar.setOnAction(e -> {
            LOG.info("*()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmfHash = new Button("#");
        this.dtmfHash.setPrefSize((double)BUTTONWIDTH.intValue(), (double)BUTTONHEIGHT.intValue());
        this.dtmfHash.setOnAction(e -> {
            LOG.info("#()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        this.dtmfSend = new Button(">>>");
        this.dtmfSend.setPrefSize((double)BUTTONWIDTH.intValue(), (double)(BUTTONHEIGHT - 20));
        this.dtmfSend.setTooltip(new Tooltip("Send manual tones"));
        this.dtmfSend.setOnAction(e -> {
            LOG.info("Send()", new Object[0]);
            this.dtmfButtonClicked((ActionEvent)e);
        });
        UnaryOperator<TextFormatter.Change> filter = new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change t) {
                if (t.isReplaced() && t.getText().matches("[^0-9*#]")) {
                    t.setText(t.getControlText().substring(t.getRangeStart(), t.getRangeEnd()));
                }
                if (t.isAdded() && t.getText().matches("[^0-9*#]")) {
                    t.setText("");
                }
                return t;
            }
        };
        this.gridPane.add((Node)this.dtmf1, 0, 0);
        this.gridPane.add((Node)this.dtmf2, 1, 0);
        this.gridPane.add((Node)this.dtmf3, 2, 0);
        this.gridPane.add((Node)this.dtmf4, 0, 1);
        this.gridPane.add((Node)this.dtmf5, 1, 1);
        this.gridPane.add((Node)this.dtmf6, 2, 1);
        this.gridPane.add((Node)this.dtmf7, 0, 2);
        this.gridPane.add((Node)this.dtmf8, 1, 2);
        this.gridPane.add((Node)this.dtmf9, 2, 2);
        this.gridPane.add((Node)this.dtmf0, 1, 3);
        this.gridPane.add((Node)this.dtmfStar, 0, 3);
        this.gridPane.add((Node)this.dtmfHash, 2, 3);
        this.sentTones = new TextField();
        this.typedTones = new TextField();
        this.sentTones.setEditable(false);
        this.sentTones.setPrefWidth(135.0);
        this.sentTones.setTooltip(new Tooltip("Sent Tones"));
        this.typedTones.setPrefWidth(90.0);
        this.typedTones.setTextFormatter(new TextFormatter((UnaryOperator)filter));
        this.typedTones.setTooltip(new Tooltip("Manual Tones to send"));
        this.typedTones.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.dtmfButtonClicked(null);
            }
        });
        this.gridPane.add((Node)this.sentTones, 0, 4, 3, 1);
        this.gridPane.add((Node)this.typedTones, 0, 5, 2, 1);
        this.gridPane.add((Node)this.dtmfSend, 2, 5);
        GridPane.setMargin((Node)this.sentTones, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
    }

    public void dtmfButtonClicked(ActionEvent e) {
        String methodName = "dtmfButtonClicked() ";
        Button selected = null;
        if (this.interactionId == null) {
            LOG.info(methodName + "No interaction to play DTMF on", new Object[0]);
            return;
        }
        if (e != null) {
            selected = (Button)e.getSource();
            LOG.trace(methodName + "keypad pressed = " + selected.getText(), new Object[0]);
        }
        if (selected == null || selected == this.dtmfSend) {
            if (!this.typedTones.getText().isEmpty()) {
                LOG.trace(methodName + "sending digits = " + this.typedTones.getText(), new Object[0]);
                String existingText = this.sentTones.getText();
                existingText = existingText + this.typedTones.getText();
                this.sentTones.setText(existingText);
                this.interactionExe.playDTMF(this.typedTones.getText(), this.interactionId);
                this.typedTones.clear();
            }
        } else {
            LOG.trace(methodName + "sending digit = " + selected.getText(), new Object[0]);
            String existingText = this.sentTones.getText();
            existingText = existingText + selected.getText();
            this.sentTones.setText(existingText);
            this.interactionExe.playDTMF(selected.getText(), this.interactionId);
        }
    }
}

