/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.CustomerHistoryI;
import com.avaya.ccs.api.CustomerInteractionMediaItemI;
import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.api.DestinationListI;
import com.avaya.ccs.api.SuggestedResponseI;
import com.avaya.ccs.api.enums.InteractionType;
import com.avaya.ccs.core.ApprovalAuditInformation;
import com.avaya.ccs.core.ApprovalInformation;
import com.avaya.ccs.core.CodeList;
import com.avaya.ccs.core.ContactCenterCode;
import com.avaya.ccs.core.CustomerHistoryItem;
import com.avaya.ccs.core.CustomerInteractionMediaList;
import com.avaya.ccs.core.EmailMedia;
import com.avaya.ccs.core.InboundAttachment;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.core.SuggestedResponse;
import com.avaya.ccs.core.SuggestedResponses;
import com.avaya.ccs.javafxrefclient.ConsultForm;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MediaFormI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class EmailForm
implements MediaFormI {
    private TextArea reviewComment = new TextArea();
    private final Button rejectButton = new Button("Reject");
    private final Button approveButton = new Button("Approve");
    protected HBox hboxButtonRowApproval = new HBox(5.0);
    Scene reviewScene;
    Stage reviewStage;
    boolean isForApprovalAudit = false;
    List<Long> approvalIds = new ArrayList<Long>();
    private final Stage emailForm = new Stage();
    private static final Logger LOG = Logger.getLogger(EmailForm.class);
    private final InteractionExecutor interactionExe;
    private Scene emailScene;
    private ScrollPane scrollPaneForTab1;
    private ScrollPane scrollPaneForTab2;
    private InteractionData interactionData;
    private TabPane tabPane;
    private Tab tab1;
    private Tab tab2;
    private EmailMedia emailMedia;
    private final String userId;
    private ConsultForm emailTransferForm;
    private String agentSignature;
    private CodeList dispositionCodes;
    private CodeList activityCodes;
    private LocalDate rescheduleDate;
    private LocalDate followUpDate;
    private Label fromLabel = new Label("From");
    private Label toLabel = new Label("To");
    private TextField fromField = new TextField();
    private Label ccLabel = new Label("Cc");
    private TextField ccField = new TextField();
    private Label bccLabel = new Label("Bcc");
    private TextField bccField = new TextField();
    private Label subjectLabel = new Label("Subject");
    private TextField subjectField = new TextField();
    private Label suggestedRespLbl = new Label("Suggested Responses");
    private final ObservableList<SuggestedResponse> suggestedResponsesOL = FXCollections.observableArrayList();
    private ListView<SuggestedResponse> suggestedResponsesListView = new ListView();
    private Label originatorsLbl = new Label("Originator");
    private final ObservableList<DestinationI> originatorsOL = FXCollections.observableArrayList();
    private ChoiceBox<DestinationI> originatorsCB = new ChoiceBox();
    private Label closingReasonLbl = new Label("Closing Reason");
    private final ObservableList<ContactCenterCode> closingReasonsOl = FXCollections.observableArrayList();
    protected final ChoiceBox<ContactCenterCode> closingReasonCBox = new ChoiceBox();
    private Label activityCodeLbl = new Label("Activity code");
    private ObservableList<ContactCenterCode> activityCodesOl = FXCollections.observableArrayList();
    private ChoiceBox<ContactCenterCode> activityCodesCBox = new ChoiceBox();
    private Button setActivityCodeBtn = new Button("Set");
    private HBox hboxActivityCode = new HBox(5.0);
    private Label agentNoteslbl = new Label("Agent Notes");
    private TextArea agentNotesTa = new TextArea();
    private Label agentClosingNotesLbl = new Label("Agent Closing Notes");
    private TextArea agentClosingNotesTa = new TextArea();
    private Label bodyLabel = new Label("Body");
    private HTMLEditor htmlEd = new HTMLEditor();
    private Label attachmentsLabel = new Label("Attachments");
    private final ObservableList<File> outgoingEmailAttachments = FXCollections.observableArrayList();
    private ListView<InboundAttachment> incomingEmailAttachmentView = new ListView();
    private ListView<File> outgoingEmailAttachmentView = new ListView();
    private Label customerHistoryLbl = new Label("Customer History");
    private final ObservableList<CustomerHistoryItem> customerHistory = FXCollections.observableArrayList();
    private ListView<CustomerHistoryItem> customerHistoryListView = new ListView();
    private TextArea customerHistoryMediaItemTA = new TextArea();
    private Button replyButton = new Button("Reply (All)");
    private Button transferButton = new Button("Transfer");
    private Button finishButton = new Button("Finish");
    private Button sendButton = new Button("Send...");
    private Button cancelButton = new Button("Cancel");
    private Button selectFilesButton = new Button("Select Files");
    private Button closeButton = new Button("Close");
    private Button followUpBtn = new Button("Follow Up");
    private boolean isAdhocEmail;
    private Label rescheduleLbl = new Label("Reschedule");
    private DatePicker rescheduleDp = new DatePicker();
    private TextField rescheduleTime = new TextField();
    private Button rescheduleSave = new Button("Reschedule");
    private TextField rescheduleNote = new TextField();
    protected VBox vboxEmailFormTab = new VBox(5.0);
    private VBox vboxMoreTab = new VBox(5.0);
    protected VBox vboxMainArea = new VBox(5.0);
    protected HBox hboxButtonRow1 = new HBox(5.0);
    private HBox hboxButtonRow2 = new HBox(5.0);
    private VBox vboxEndRow = new VBox(5.0);
    private HBox hBoxRescheduleButtons = new HBox(5.0);
    HBox suggestedResponsesHbox = new HBox(5.0);

    public EmailForm(final InteractionExecutor interactionExe, String css, String userId, boolean isAdhocEmail) {
        String methodName = "EmailForm";
        this.userId = userId;
        this.interactionExe = interactionExe;
        this.isAdhocEmail = isAdhocEmail;
        this.tab1 = new Tab("Basic Email");
        this.tab2 = new Tab("More...");
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.scrollPaneForTab1 = new ScrollPane();
        this.scrollPaneForTab1.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPaneForTab1.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPaneForTab1.setContent((Node)this.vboxEmailFormTab);
        this.scrollPaneForTab1.setFitToWidth(true);
        this.hboxActivityCode.setPadding(new Insets(10.0));
        this.hboxActivityCode.getChildren().addAll((Object[])new Node[]{this.activityCodeLbl, this.activityCodesCBox, this.setActivityCodeBtn});
        this.vboxMoreTab.getChildren().add((Object)this.hboxActivityCode);
        this.scrollPaneForTab2 = new ScrollPane();
        this.scrollPaneForTab2.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPaneForTab2.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPaneForTab2.setContent((Node)this.vboxMoreTab);
        this.scrollPaneForTab2.setFitToWidth(true);
        this.vboxMoreTab.setFillWidth(true);
        this.vboxEmailFormTab.setPadding(new Insets(10.0));
        this.vboxMoreTab.setPadding(new Insets(10.0));
        this.vboxMoreTab.getChildren().addAll((Object[])new Node[0]);
        this.suggestedResponsesListView.setPrefHeight(80.0);
        this.suggestedResponsesHbox.getChildren().addAll((Object[])new Node[]{this.suggestedRespLbl, this.suggestedResponsesListView});
        this.tabPane.getTabs().addAll((Object[])new Tab[]{this.tab1, this.tab2});
        this.tab1.setContent((Node)this.scrollPaneForTab1);
        this.tab2.setContent((Node)this.scrollPaneForTab2);
        this.emailScene = new Scene((Parent)this.tabPane, 800.0, 850.0);
        this.emailScene.getStylesheets().add((Object)css);
        this.emailForm.setScene(this.emailScene);
        this.emailForm.setTitle("Email");
        this.fromField.setEditable(false);
        this.ccField.setEditable(false);
        this.bccField.setEditable(false);
        this.subjectField.setEditable(false);
        this.htmlEd.setPrefHeight(200.0);
        this.htmlEd.setDisable(true);
        this.agentNotesTa.setPrefRowCount(1);
        this.agentNotesTa.setDisable(true);
        this.agentClosingNotesTa.setPrefRowCount(1);
        this.rescheduleTime.setPromptText("hh:mm (24 hour clock)");
        this.rescheduleNote.setPromptText("Agent Note");
        this.selectFilesButton.setDisable(true);
        this.cancelButton.setDisable(true);
        this.sendButton.setDisable(true);
        this.closeButton.setDisable(true);
        this.setAgentClosingNotesVisible(false);
        this.incomingEmailAttachmentView.setPrefHeight(30.0);
        this.outgoingEmailAttachmentView.setPrefHeight(30.0);
        this.outgoingEmailAttachmentView.setItems(this.outgoingEmailAttachments);
        this.incomingEmailAttachmentView.setCellFactory((Callback)new Callback<ListView<InboundAttachment>, ListCell<InboundAttachment>>(){

            public ListCell<InboundAttachment> call(ListView<InboundAttachment> param) {
                ListCell<InboundAttachment> cell = new ListCell<InboundAttachment>(){

                    protected void updateItem(InboundAttachment item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.getName());
                        }
                    }
                };
                return cell;
            }
        });
        this.suggestedResponsesListView.setPrefHeight(60.0);
        this.suggestedResponsesListView.setItems(this.suggestedResponsesOL);
        this.suggestedResponsesListView.setCellFactory(param -> new ListCell<SuggestedResponse>(){

            protected void updateItem(SuggestedResponse item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null || item.getName() == null) {
                    this.setText(null);
                } else {
                    this.setText(item.getName());
                }
            }
        });
        this.originatorsCB.setPrefWidth(200.0);
        this.originatorsCB.setItems(this.originatorsOL);
        this.customerHistoryListView.setItems(this.customerHistory);
        this.customerHistoryListView.setPrefSize(400.0, 250.0);
        this.customerHistoryMediaItemTA.setPrefSize(400.0, 400.0);
        this.customerHistoryMediaItemTA.setEditable(false);
        this.closingReasonCBox.setPrefWidth(200.0);
        this.closingReasonCBox.setItems(this.closingReasonsOl);
        this.activityCodesCBox.setPrefWidth(200.0);
        this.activityCodesCBox.setItems(this.activityCodesOl);
        this.vboxMainArea.setPadding(new Insets(10.0));
        if (isAdhocEmail) {
            this.vboxMainArea.getChildren().addAll((Object[])new Node[]{this.originatorsLbl, this.originatorsCB});
        }
        this.approveButton.setDisable(false);
        this.rejectButton.setDisable(false);
        this.reviewComment.setPromptText("Enter your comment");
        this.reviewComment.setPrefColumnCount(15);
        this.reviewComment.setMaxHeight(5.0);
        this.hboxButtonRowApproval.getChildren().addAll((Object[])new Node[]{this.approveButton, this.rejectButton});
        this.hboxButtonRowApproval.setPadding(new Insets(10.0));
        VBox reviewEmailVbox = new VBox(10.0);
        reviewEmailVbox.getChildren().addAll((Object[])new Node[]{new Label("Review Comment"), this.reviewComment, this.hboxButtonRowApproval});
        reviewEmailVbox.setPadding(new Insets(10.0));
        this.reviewScene = new Scene((Parent)reviewEmailVbox);
        this.reviewStage = new Stage();
        this.reviewStage.setScene(this.reviewScene);
        this.reviewStage.setTitle("Approval Form");
        this.vboxMainArea.getChildren().add((Object)(isAdhocEmail ? this.toLabel : this.fromLabel));
        this.vboxMainArea.getChildren().addAll((Object[])new Node[]{this.fromField, this.ccLabel, this.ccField, this.bccLabel, this.bccField, this.subjectLabel, this.subjectField, this.attachmentsLabel, this.incomingEmailAttachmentView, this.outgoingEmailAttachmentView, this.bodyLabel, this.htmlEd, this.suggestedResponsesHbox, this.agentNoteslbl, this.agentNotesTa});
        this.vboxMoreTab.getChildren().addAll((Object[])new Node[]{this.customerHistoryLbl, this.customerHistoryListView, this.customerHistoryMediaItemTA});
        this.hboxButtonRow1.getChildren().addAll((Object[])new Node[]{this.replyButton, this.transferButton, this.finishButton});
        this.hboxButtonRow1.setPadding(new Insets(10.0));
        this.hboxButtonRow2.setPadding(new Insets(10.0));
        this.hboxButtonRow2.getChildren().addAll((Object[])new Node[]{this.sendButton, this.cancelButton, this.closeButton, this.closingReasonLbl, this.closingReasonCBox});
        this.hBoxRescheduleButtons.getChildren().addAll((Object[])new Node[]{this.rescheduleDp, this.rescheduleTime, this.rescheduleNote, this.rescheduleSave});
        this.vboxEndRow.getChildren().addAll((Object[])new Node[]{this.agentClosingNotesLbl, this.agentClosingNotesTa});
        if (isAdhocEmail) {
            this.vboxEmailFormTab.getChildren().addAll((Object[])new Node[]{this.vboxMainArea, this.hboxButtonRow2, this.hBoxRescheduleButtons, this.vboxEndRow});
            this.disableControls(new Control[]{this.selectFilesButton, this.followUpBtn, this.rescheduleDp, this.rescheduleTime, this.rescheduleSave, this.htmlEd, this.agentNotesTa});
            this.enableControls(new Control[]{this.ccField, this.bccField, this.htmlEd, this.sendButton, this.cancelButton, this.closeButton});
            this.fromField.setEditable(true);
            this.ccField.setEditable(true);
            this.bccField.setEditable(true);
            this.subjectField.setEditable(true);
        } else {
            this.vboxEmailFormTab.getChildren().addAll((Object[])new Node[]{this.vboxMainArea, this.hboxButtonRow1, this.hboxButtonRow2, this.hBoxRescheduleButtons, this.vboxEndRow});
            this.disableControls(new Control[]{this.sendButton, this.cancelButton, this.selectFilesButton, this.closeButton, this.followUpBtn, this.rescheduleDp, this.rescheduleTime, this.rescheduleSave, this.htmlEd, this.agentNotesTa});
        }
        this.emailTransferForm = new ConsultForm(interactionExe, css, InteractionType.EmailInteraction);
        this.htmlEd.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.SPACE) {
                event.consume();
            }
        });
        this.replyButton.setOnAction(t -> {
            LOG.info("replyButton() ID:" + this.emailMedia.getId(), new Object[0]);
            this.enableControls(new Control[]{this.sendButton, this.closeButton, this.selectFilesButton, this.cancelButton, this.htmlEd, this.agentNotesTa});
            this.disableControls(new Control[]{this.replyButton, this.transferButton, this.finishButton});
            this.fromField.setEditable(true);
            this.ccField.setEditable(true);
            this.bccField.setEditable(true);
            this.subjectField.setEditable(true);
            this.updateForm();
            String originalText = this.htmlEd.getHtmlText();
            StringBuilder replyPreamble = new StringBuilder();
            replyPreamble.append("<br/>-----------------------------<br/>");
            replyPreamble.append("From: " + this.emailMedia.getFrom() + "<br/>");
            replyPreamble.append("Sent: " + this.emailMedia.getArrivalTime() + "<br/>");
            replyPreamble.append("To: " + this.emailMedia.getTo() + "<br/>");
            replyPreamble.append("Subject: " + this.emailMedia.getSubject() + "<br/><br/><br/>");
            this.htmlEd.setHtmlText(replyPreamble + originalText);
            this.htmlEd.setFocusTraversable(false);
        });
        this.transferButton.setOnAction(t -> {
            LOG.info("transferButton() ID:" + this.emailMedia.getId(), new Object[0]);
            this.emailTransferForm.initializeTransferForm(this.interactionData);
            this.emailTransferForm.setMediaForm(this);
            this.emailTransferForm.setAgentSignature(this.agentSignature);
            interactionExe.getConsultDestinations(this.interactionData.getId());
            this.emailTransferForm.show();
        });
        this.finishButton.setOnAction(t -> {
            LOG.info("finishButton() ID:" + this.emailMedia.getId(), new Object[0]);
            this.finishEmail();
            this.enableControls(new Control[]{this.closeButton, this.cancelButton, this.followUpBtn, this.rescheduleDp, this.rescheduleTime, this.rescheduleSave});
            this.disableControls(new Control[]{this.replyButton, this.transferButton, this.finishButton, this.sendButton, this.selectFilesButton});
        });
        this.sendButton.setOnAction(t -> {
            LOG.info("sendButton() ID:" + this.emailMedia.getId(), new Object[0]);
            this.sendReply();
            this.enableControls(new Control[]{this.closeButton, this.selectFilesButton, this.cancelButton});
            this.vboxMainArea.getChildren().removeAll(Arrays.asList(this.fromLabel, this.fromField, this.ccLabel, this.ccField, this.bccField, this.bccLabel, this.subjectLabel, this.subjectField, this.attachmentsLabel, this.incomingEmailAttachmentView, this.outgoingEmailAttachmentView, this.bodyLabel, this.htmlEd, this.agentNoteslbl, this.agentNotesTa));
            this.disableControls(new Control[]{this.sendButton, this.cancelButton, this.selectFilesButton});
            this.enableControls(new Control[]{this.followUpBtn, this.rescheduleDp, this.rescheduleTime, this.rescheduleSave});
        });
        this.cancelButton.setOnAction(t -> {
            LOG.info("cancelButton() ID:" + this.emailMedia.getId(), new Object[0]);
            this.enableControls(new Control[]{this.replyButton, this.transferButton, this.finishButton});
            this.updateForm();
            this.disableControls(new Control[]{this.sendButton, this.cancelButton, this.selectFilesButton, this.closeButton, this.htmlEd, this.agentNotesTa});
        });
        this.selectFilesButton.setOnAction(t -> {
            LOG.info("selectFilesButton() ID:" + this.emailMedia.getId(), new Object[0]);
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Open Resource File");
            File file = fileChooser.showOpenDialog((Window)this.emailForm);
            if (file != null) {
                this.outgoingEmailAttachments.add((Object)file);
                this.emailMedia.addNewAttachment(file);
            }
        });
        this.closeButton.setOnAction(t -> {
            String id = this.emailMedia.getId();
            LOG.info("closeButton() ID:" + id, new Object[0]);
            String selectedCloseReasonCode = null;
            if (this.closingReasonCBox.getValue() != null) {
                selectedCloseReasonCode = ((ContactCenterCode)this.closingReasonCBox.getSelectionModel().getSelectedItem()).getNumber();
            }
            if (selectedCloseReasonCode != null) {
                LOG.info("Disposition code used to tear down the interaction = " + selectedCloseReasonCode, new Object[0]);
                interactionExe.end(id, selectedCloseReasonCode, this.agentClosingNotesTa.getText(), false);
            } else {
                LOG.info("No Disposition Code selected. Closing with no DC, no agent note.", new Object[0]);
                interactionExe.end(id);
            }
            Stage s = (Stage)this.emailScene.getWindow();
            s.close();
        });
        this.followUpBtn.setOnAction(t -> {
            LOG.info("followUpBtn() ID:" + this.emailMedia.getId(), new Object[0]);
            this.followUpDate = (LocalDate)this.rescheduleDp.getValue();
            LOG.info(methodName, "followUp date clicked");
        });
        this.rescheduleDp.setOnAction(t -> {
            LOG.info("rescheduleDp() ID:" + this.emailMedia.getId(), new Object[0]);
            this.rescheduleDate = (LocalDate)this.rescheduleDp.getValue();
            LOG.info(methodName, "reschedule date selected: " + this.rescheduleDate);
        });
        this.rescheduleSave.setOnAction(t -> {
            String id = this.emailMedia.getId();
            LOG.info("rescheduleSave() ID:" + id, new Object[0]);
            LOG.info("      TODO: send the request to the server with reschedule", new Object[0]);
            String date = "" + this.rescheduleDate.getMonthValue() + "/" + this.rescheduleDate.getDayOfMonth() + "/" + this.rescheduleDate.getYear();
            String time = this.rescheduleTime.getText();
            String agentNote = this.rescheduleNote.getText();
            interactionExe.rescheduleEmail(id, date, time, agentNote);
        });
        this.setActivityCodeBtn.setOnAction(t -> interactionExe.setActivityCode(this.emailMedia.getId(), ((ContactCenterCode)this.activityCodesCBox.getSelectionModel().getSelectedItem()).getNumber()));
        this.approveButton.setOnAction(t -> {
            if (this.reviewComment.getText().isEmpty()) {
                this.showAlert("Comment is mandatory");
            } else {
                for (Long approvalId : this.approvalIds) {
                    interactionExe.reviewApprovedEmail(this.interactionData.getId(), approvalId, this.reviewComment.getText());
                }
                this.hboxButtonRowApproval.setDisable(true);
            }
        });
        this.rejectButton.setOnAction(t -> {
            if (this.reviewComment.getText().isEmpty()) {
                this.showAlert("Comment is mandatory");
            } else {
                for (Long approvalId : this.approvalIds) {
                    interactionExe.reviewRejectedEmail(this.interactionData.getId(), approvalId, this.reviewComment.getText());
                }
                this.hboxButtonRowApproval.setDisable(true);
            }
        });
        this.incomingEmailAttachmentView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent click) {
                LOG.info("incomingEmailAttachmentView().handle() ID:" + EmailForm.this.emailMedia.getId(), new Object[0]);
                if (click.getClickCount() == 2) {
                    InboundAttachment attachment = (InboundAttachment)EmailForm.this.incomingEmailAttachmentView.getSelectionModel().getSelectedItem();
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle("Save Attachment");
                    fileChooser.setInitialFileName(attachment.getName());
                    File file = fileChooser.showSaveDialog((Window)EmailForm.this.emailForm);
                    if (file != null) {
                        try {
                            URL loc = new URL(attachment.getAddress());
                            try (InputStream in = loc.openStream();){
                                Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (IOException ex) {
                            LOG.error("save attachment exception", ex);
                        }
                    }
                }
            }
        });
        this.suggestedResponsesListView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent click) {
                LOG.info("suggestedResponsesListView().handle() ID:" + EmailForm.this.emailMedia.getId(), new Object[0]);
                if (click.getClickCount() == 2) {
                    SuggestedResponseI response = (SuggestedResponseI)EmailForm.this.suggestedResponsesListView.getSelectionModel().getSelectedItem();
                    String existingEmailContents = EmailForm.this.htmlEd.getHtmlText();
                    EmailForm.this.htmlEd.setHtmlText(response.getBody() + "<br/>" + existingEmailContents);
                    EmailForm.this.subjectField.setText(response.getSubject());
                    EmailForm.this.incomingEmailAttachmentView.getItems().addAll((Object[])response.getAttachments());
                    EmailForm.this.replyButton.fire();
                }
            }
        });
        this.customerHistoryListView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent click) {
                if (click.getClickCount() == 2) {
                    String contactId = ((CustomerHistoryItem)EmailForm.this.customerHistoryListView.getSelectionModel().getSelectedItem()).getContactId();
                    interactionExe.getCustomerInteractionMedia(EmailForm.this.emailMedia.getId(), contactId);
                }
            }
        });
    }

    private void showAlert(String comment) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText(null);
        alert.setContentText(comment);
        alert.showAndWait();
    }

    public void show() {
        LOG.debug("show()", new Object[0]);
        this.emailForm.show();
    }

    public void setCustomerHistory(CustomerHistoryI custHistory) {
        LOG.info("setCustomerHistory", new Object[0]);
        custHistory.getCustomerInteractions().forEach(item -> this.customerHistory.add(item));
    }

    public void setIsForAudit(ApprovalInformation info) {
        boolean bl = this.isForApprovalAudit = info.getApprovalCheck() == 1L && info.getApprovalCheckSpecified();
        if (this.isForApprovalAudit) {
            this.interactionExe.editStartEmail(this.interactionData.getId(), info.getEmailApproveData().getActionId());
        }
    }

    public void addApprovalId(ApprovalAuditInformation info) {
        this.approvalIds.add(info.getApprovalId());
    }

    @Override
    public void enableControls(Control[] controls) {
        for (Control c : controls) {
            c.setDisable(false);
        }
    }

    @Override
    public void disableControls(Control[] controls) {
        for (Control c : controls) {
            c.setDisable(true);
        }
    }

    public void updateForm() {
        LOG.debug("updateForm()", new Object[0]);
        this.fromField.setText(this.emailMedia.getFrom());
        this.ccField.setText(this.emailMedia.getCc());
        this.bccField.setText(this.emailMedia.getBcc());
        this.subjectField.setText(this.emailMedia.getSubject());
        if (this.emailMedia.getEncoding().equals("PLAIN")) {
            this.htmlEd.setHtmlText(this.htmlifyLineEndings(this.emailMedia.getBody()));
        } else {
            this.htmlEd.setHtmlText(this.emailMedia.getBody());
        }
        for (InboundAttachment a : this.emailMedia.getInboundAttachments()) {
            this.incomingEmailAttachmentView.getItems().add((Object)a);
        }
        if (this.isForApprovalAudit) {
            if (this.approvalIds != null && !this.approvalIds.isEmpty()) {
                this.hboxButtonRowApproval.setDisable(false);
                this.reviewStage.show();
            }
        } else {
            this.approvalIds.clear();
        }
    }

    private String htmlifyLineEndings(String body) {
        String returnStr = body.replaceAll("(\r\n|\n)", "<br />");
        return returnStr;
    }

    private void sendReply() {
        String methodName = "sendReply() ";
        String bodyHtml = this.htmlEd.getHtmlText();
        String emailTranscript = null;
        emailTranscript = bodyHtml;
        LOG.debug(methodName + "email transcript: " + emailTranscript, new Object[0]);
        boolean isHtml = true;
        if (this.isAdhocEmail) {
            int skillsetId = Integer.parseInt(((DestinationI)this.originatorsCB.getSelectionModel().getSelectedItem()).getNumber());
            this.emailMedia.create(this.fromField.getText().trim(), this.ccField.getText().trim(), this.bccField.getText().trim(), this.subjectField.getText(), emailTranscript, this.agentNotesTa.getText(), true, Integer.valueOf(skillsetId), isHtml);
        } else {
            this.emailMedia.reply(this.fromField.getText().trim(), this.ccField.getText().trim(), this.bccField.getText().trim(), this.subjectField.getText(), emailTranscript, this.agentNotesTa.getText(), true, isHtml);
        }
        this.setAgentClosingNotesVisible(true);
    }

    private void finishEmail() {
        LOG.info("finishEmail()", new Object[0]);
        this.setAgentClosingNotesVisible(true);
    }

    @Override
    public void close() {
        LOG.info("closeEmail()", new Object[0]);
        Stage s = (Stage)this.emailScene.getWindow();
        s.close();
    }

    private void setAgentClosingNotesVisible(boolean val) {
        LOG.info("setAgentClosingNotesVisible()", new Object[0]);
        this.agentClosingNotesLbl.setVisible(val);
        this.agentClosingNotesTa.setVisible(val);
    }

    public void setInteractionMedia(EmailMedia imedia) {
        LOG.debug("setInteractionMedia()", new Object[0]);
        this.emailMedia = imedia;
        if (this.isAdhocEmail) {
            this.interactionExe.getSkillsets(this.emailMedia.getId());
        }
        imedia.requestSuggestedResponses();
        if (!this.isAdhocEmail) {
            this.interactionExe.getCustomerHistory(this.interactionData.getId());
        }
        this.interactionExe.getDispositionCodes(this.emailMedia.getId());
        this.interactionExe.getActivityCodes(this.emailMedia.getId());
        this.interactionExe.getApprovalStatus(this.interactionData.getId());
        this.updateForm();
    }

    public void setDispositionCodes(CodeListI codes) {
        LOG.debug("setDispositionCodes()", new Object[0]);
        this.dispositionCodes = (CodeList)codes;
        for (ContactCenterCodeI item : this.dispositionCodes.getCodes()) {
            ContactCenterCode thisItem = (ContactCenterCode)item;
            if (this.closingReasonsOl.contains((Object)thisItem)) continue;
            this.closingReasonsOl.add((Object)thisItem);
        }
    }

    public void setSuggestedResponses(SuggestedResponses suggestedResponses) {
        LOG.debug("setSuggestedResponses()", new Object[0]);
        Arrays.asList(suggestedResponses.getSuggestedResponses()).forEach(item -> this.suggestedResponsesOL.add(item));
    }

    public void setOriginators(DestinationListI skillsets) {
        LOG.debug("setOriginators()", new Object[0]);
        for (DestinationI skillset : skillsets.getDestinations()) {
            this.originatorsOL.add((Object)skillset);
        }
    }

    public void setActivityCodes(CodeListI codes) {
        LOG.debug("setActivityCodes()", new Object[0]);
        this.activityCodes = (CodeList)codes;
        for (ContactCenterCodeI item : this.activityCodes.getCodes()) {
            ContactCenterCode thisItem = (ContactCenterCode)item;
            if (this.activityCodesOl.contains((Object)thisItem)) continue;
            this.activityCodesOl.add((Object)thisItem);
        }
    }

    public void setInteractionData(InteractionData interactionData) {
        LOG.debug("setInteractionData()", new Object[0]);
        this.interactionData = interactionData;
        this.emailTransferForm.setInteractionMedia((Media)this.emailMedia);
        this.emailTransferForm.initializeTransferForm(interactionData);
        this.emailTransferForm.setCurrentInteractionId(interactionData.getId());
    }

    public void setAgentSignature(String signature) {
        this.agentSignature = signature;
    }

    public TextField getFromField() {
        return this.fromField;
    }

    public String getBodyHtml() {
        return this.htmlEd.getHtmlText();
    }

    public TextField getSubjectField() {
        return this.subjectField;
    }

    public ConsultForm getConsultForm() {
        return this.emailTransferForm;
    }

    public void setCustomerInteractionMediaList(CustomerInteractionMediaList value) {
        List items = value.getCustomerInteractionMediaItems();
        StringBuilder mediaSB = new StringBuilder();
        for (CustomerInteractionMediaItemI item : items) {
            mediaSB.append(item.toString() + "\n");
        }
        this.customerHistoryMediaItemTA.setText(mediaSB.toString());
    }
}

