/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.UserState;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class MonitoredUserData
extends Data {
    private String id = "0";
    private List<ContactType> contactTypes = new ArrayList<ContactType>();
    private ContactCenterCodeI code;
    private String firstName = "";
    private String lastName = "";
    private String fullName = "";
    private String loginId = "";
    private UserState state = UserState.Unknown;
    private String supervisorId = "";
    private boolean canForceLogout = false;
    private boolean canForceNotReady = false;
    private boolean canForceReady = false;
    private CodeListI codes = null;
    private boolean isSelected = false;
    private static final Logger LOG = Logger.getLogger(MonitoredUserData.class);

    public MonitoredUserData(MonitoredUserI user) {
        String methodName = "MonitoredUserData() ";
        if (user != null) {
            try {
                this.id = user.getId();
                this.contactTypes = user.getContactTypes();
                this.code = user.getCode();
                this.firstName = user.getFirstName();
                this.lastName = user.getLastName();
                this.fullName = user.getFullName();
                this.loginId = user.getLoginId();
                this.state = user.getState();
                this.supervisorId = user.getSupervisorId();
                this.canForceLogout = user.canForceLogout();
                this.canForceNotReady = user.canForceNotReady();
                this.canForceReady = user.canForceReady();
                this.isSelected = false;
            }
            catch (ObjectInvalidException ex) {
                LOG.error(methodName, new Object[]{"ObjectInvalidException while accessing MonitoredUserData", ex});
                this.id = "0";
                this.contactTypes = new ArrayList<ContactType>();
                this.code = null;
                this.firstName = "";
                this.lastName = "";
                this.fullName = "";
                this.loginId = "";
                this.state = UserState.Unknown;
                this.supervisorId = "";
                this.canForceLogout = false;
                this.canForceNotReady = false;
                this.canForceReady = false;
                this.isSelected = false;
            }
        }
    }

    @Override
    public String toString() {
        String str = "ID:" + this.id;
        str = str + " contactTypes:" + this.contactTypes + " code:" + this.code + " firstName:" + this.firstName + " lastName:" + this.lastName + " fullName:" + this.fullName + " loginId:" + this.loginId + " state:" + this.state.name() + " supervisorId:" + this.supervisorId;
        str = str + " canForceLogout:" + this.canForceLogout + " canForceNotReady:" + this.canForceNotReady + " canForceReady:" + this.canForceReady;
        return str;
    }

    public MonitoredUserData(String id, boolean deleted) {
        this.id = id;
        this.setDeleted(deleted);
    }

    @Override
    public List<Pair<String, String>> getProperties() {
        LinkedList<Pair<String, String>> properties = new LinkedList<Pair<String, String>>();
        properties.add(new Pair((Object)"ID", (Object)this.getId()));
        properties.add(new Pair((Object)"Contact Types", (Object)this.typesToString()));
        properties.add(new Pair((Object)"Code", (Object)this.codeToString()));
        properties.add(new Pair((Object)"First Name", (Object)this.getFirstName()));
        properties.add(new Pair((Object)"Last Name", (Object)this.getLastName()));
        properties.add(new Pair((Object)"Full Name", (Object)this.getFullName()));
        properties.add(new Pair((Object)"Login ID", (Object)this.getLoginId()));
        properties.add(new Pair((Object)"State", (Object)this.stateToString()));
        properties.add(new Pair((Object)"Supervisor ID", (Object)this.getSupervisorId()));
        return properties;
    }

    @Override
    public List<Pair<String, Boolean>> getCaps() {
        LinkedList<Pair<String, Boolean>> caps = new LinkedList<Pair<String, Boolean>>();
        caps.add(new Pair((Object)"CanForceLogout", (Object)this.canForceLogout()));
        caps.add(new Pair((Object)"CanForceNotReady", (Object)this.canForceNotReady()));
        caps.add(new Pair((Object)"CanForceReady", (Object)this.canForceReady()));
        return caps;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    private String typesToString() {
        if (this.getContactTypes().isEmpty()) {
            return "NONE";
        }
        String types = "";
        for (ContactType type : this.getContactTypes()) {
            types = types + type.name() + " ";
        }
        return types;
    }

    private String codeToString() {
        if (this.getCode() == null) {
            return "<NULL>";
        }
        return this.getCode().getName() + " " + this.getCode().getNumber();
    }

    private String stateToString() {
        if (this.state == null) {
            return "<NULL>";
        }
        return this.state.name();
    }

    public UserState getState() {
        return this.state;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<ContactType> getContactTypes() {
        return this.contactTypes;
    }

    public ContactCenterCodeI getCode() {
        return this.code;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public String getSupervisorId() {
        return this.supervisorId;
    }

    public boolean canForceLogout() {
        return this.canForceLogout;
    }

    public boolean canForceNotReady() {
        return this.canForceNotReady;
    }

    public boolean canForceReady() {
        return this.canForceReady;
    }

    public CodeListI getCodes() {
        return this.codes;
    }

    public void setCodes(CodeListI codes) {
        this.codes = codes;
    }

    @Override
    public void update(Data newData) {
        MonitoredUserData newMonitoredUserData = (MonitoredUserData)newData;
        this.id = newMonitoredUserData.getId();
        this.contactTypes = newMonitoredUserData.getContactTypes();
        this.code = newMonitoredUserData.getCode();
        this.firstName = newMonitoredUserData.getFirstName();
        this.lastName = newMonitoredUserData.getLastName();
        this.fullName = newMonitoredUserData.getFullName();
        this.loginId = newMonitoredUserData.getLoginId();
        this.state = newMonitoredUserData.getState();
        this.supervisorId = newMonitoredUserData.getSupervisorId();
        this.canForceLogout = newMonitoredUserData.canForceLogout();
        this.canForceNotReady = newMonitoredUserData.canForceNotReady();
        this.canForceReady = newMonitoredUserData.canForceReady();
        this.codes = newMonitoredUserData.getCodes();
        this.isSelected = newMonitoredUserData.isSelected();
    }
}

