/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.ComboDataGUI;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.ResourceData;
import com.avaya.ccs.javafxrefclient.ResourceDetailsForm;
import com.avaya.ccs.javafxrefclient.ResourceExecutor;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;

public class ResourceDataGUI
extends ComboDataGUI {
    private final HBox hbox;
    private final Button originateButton;
    private final Button callSupervisorButton;
    private TextArea numberToDial;
    private final Text resourceState;
    private static final Logger LOG = Logger.getLogger(ResourceDataGUI.class);

    public ResourceDataGUI(ResourceExecutor resExe, String css) {
        super(LOG);
        this.setDetailsForm(new ResourceDetailsForm(resExe, css, this));
        this.hbox = new HBox();
        this.hbox.getStyleClass().add((Object)"hbox");
        this.originateButton = new Button("Originate");
        this.originateButton.getStyleClass().add((Object)"agentButton");
        this.originateButton.setOnAction(e -> {
            String methodName = "OriginateButton() ";
            String number = this.numberToDial.getText();
            ResourceData resource = this.getCurrentResourceSelection();
            if (number != null && !number.isEmpty()) {
                LOG.info(methodName + "Number:" + number + " ResourceID:" + resource.getId(), new Object[0]);
                resExe.originateCall(number, resource.getId());
            } else {
                LOG.info(methodName + "number to dial is empty or null, ignore button press", new Object[0]);
            }
        });
        this.callSupervisorButton = new Button("Call Supervisor");
        this.callSupervisorButton.getStyleClass().add((Object)"agentButton");
        this.callSupervisorButton.setOnAction(e -> {
            String methodName = "CallSupervisorButton() ";
            ResourceData resource = this.getCurrentResourceSelection();
            LOG.info(methodName + " ResouceID:" + resource.getId(), new Object[0]);
            resExe.callSupervisor(resource.getId());
        });
        this.numberToDial = new TextArea();
        this.numberToDial.getStyleClass().add((Object)"numberToDial");
        this.resourceState = new Text();
        this.hbox.getChildren().addAll((Object[])new Node[]{this.getItemSelection(), this.originateButton, this.numberToDial, this.callSupervisorButton, this.resourceState});
        this.hbox.setAlignment(Pos.CENTER_LEFT);
        this.redrawControls();
    }

    public MenuItem getMenuitem() {
        return this.getDetailsForm().getMenuItem();
    }

    @Override
    protected void redrawControls() {
        String methodName = "redrawControls() ";
        ResourceData resource = this.getCurrentResourceSelection();
        LOG.trace(methodName + "ID:" + resource.getId(), new Object[0]);
        this.originateButton.setDisable(!resource.canOriginate());
        this.callSupervisorButton.setDisable(!resource.canCallSupervisor());
        this.numberToDial.setDisable(!resource.canOriginate());
        this.resourceState.setText(resource.getState().name());
    }

    public void UpdateResourceData(List<ResourceData> data) {
        ObservableList newData = FXCollections.observableArrayList();
        newData.addAll(data);
        this.update((ObservableList<Data>)newData);
    }

    public void UpdateResourceData(ResourceData data) {
        this.update(data);
    }

    public HBox getAddressButtons() {
        return this.hbox;
    }

    private ResourceData getCurrentResourceSelection() {
        String methodName = "getCurrentResourceSelection() ";
        Data currentResource = this.getCurrentItemSelection();
        if (currentResource != null) {
            return (ResourceData)currentResource;
        }
        LOG.trace(methodName + "current selection is NULL, returning blank", new Object[0]);
        return new ResourceData(null);
    }
}

