/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.api.DestinationListI;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import java.time.LocalDate;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class CallbackForm {
    private final Stage callbackForm = new Stage();
    private static final Logger LOG = Logger.getLogger(CallbackForm.class);
    private final InteractionExecutor interactionExe;
    private final ObservableList<DestinationI> callbackDestinations = FXCollections.observableArrayList();
    private String currentInteractionID;
    private LocalDate startDate;
    private TextField startTimeField;
    private TextField endTimeField;

    public CallbackForm(InteractionExecutor interactionExe, String css) {
        this.interactionExe = interactionExe;
        BorderPane calbackBorder = new BorderPane();
        Scene callbackScene = new Scene((Parent)calbackBorder, 350.0, 400.0);
        callbackScene.getStylesheets().add((Object)css);
        this.callbackForm.setScene(callbackScene);
        this.callbackForm.titleProperty().set((Object)"Schedule Callback");
    }

    public void show() {
        this.callbackForm.show();
    }

    public void updateDestinationList(String interactionID, DestinationListI list) {
        String methodName = "updateDestinationList() ";
        if (interactionID.equals(this.currentInteractionID)) {
            LOG.info(methodName + "Contact ID:" + interactionID + " updating list with " + list.getDestinations().size() + " items", new Object[0]);
            this.callbackDestinations.addAll((Collection)list.getDestinations());
        } else {
            LOG.error(methodName + "Contact ID:" + interactionID + " does not match current contactID: " + this.currentInteractionID, new Object[0]);
        }
    }

    public void initializeForm(InteractionData interaction) {
        this.currentInteractionID = interaction.getId();
        this.callbackDestinations.clear();
        BorderPane bp = (BorderPane)((Scene)this.callbackForm.sceneProperty().get()).getRoot();
        final ListView destinations = new ListView();
        destinations.setItems(this.callbackDestinations);
        Label customerContact = new Label("Customer: ");
        ObservableList contacts = FXCollections.observableList(interaction.getContactNumbers());
        ComboBox contactList = new ComboBox(contacts);
        Label startDateLabel = new Label("Start Date (UTC): ");
        DatePicker startDatePicker = new DatePicker();
        Label startTimeLabel = new Label("Start Time (UTC): ");
        this.startTimeField = new TextField();
        this.startTimeField.setText("HH:MM");
        Label expiryLabel = new Label("Expiry Minutes");
        this.endTimeField = new TextField();
        TextField noteField = new TextField();
        Label noteLabel = new Label("Note:");
        final TextField externalNumberField = new TextField();
        final Button callbackToExternalButton = new Button("Callback External");
        final Button callbackToContactNumberButton = new Button("Callback Contact");
        callbackToContactNumberButton.setDisable(true);
        Button cancelButton = new Button("Cancel");
        cancelButton.getStyleClass().add((Object)"callbackFormButtons");
        destinations.setCellFactory((Callback)new Callback<ListView<DestinationI>, ListCell<DestinationI>>(){

            public ListCell<DestinationI> call(ListView<DestinationI> list) {
                return new CodeCell();
            }
        });
        destinations.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DestinationI>(){

            public void changed(ObservableValue<? extends DestinationI> observable, DestinationI oldValue, DestinationI newValue) {
                if (newValue != null) {
                    callbackToContactNumberButton.setDisable(false);
                    String val = externalNumberField.textProperty().getValue();
                    callbackToExternalButton.setDisable(val == null || val.isEmpty());
                }
            }
        });
        bp.setCenter((Node)destinations);
        contactList.setCellFactory((Callback)new Callback<ListView<ContactNumberI>, ListCell<ContactNumberI>>(){

            public ListCell<ContactNumberI> call(ListView<ContactNumberI> list) {
                return new CustomerCodeCell();
            }
        });
        contactList.setButtonCell((ListCell)new CustomerCodeCell());
        startDatePicker.setOnAction(t -> {
            this.startDate = (LocalDate)startDatePicker.getValue();
        });
        callbackToContactNumberButton.getStyleClass().add((Object)"callbackFormButtons");
        callbackToContactNumberButton.setOnAction(t -> {
            String methodName = "callbackToContactNumberButton";
            DestinationI callbackDestination = (DestinationI)destinations.getSelectionModel().getSelectedItem();
            ContactNumberI contactNumber = (ContactNumberI)contactList.getValue();
            String callbackTime = this.startDateTime();
            String callbackExpiryTime = this.expiryMinutes();
            String callbackNote = noteField.getText();
            if (callbackDestination != null) {
                LOG.info("CallbackToContactNumberButton() interactionID:" + this.currentInteractionID, new Object[0]);
                this.interactionExe.createCallbackToContactNumber(this.currentInteractionID, callbackDestination, contactNumber, callbackTime, callbackExpiryTime, callbackNote);
            } else {
                LOG.error(methodName + "Selected destination is null", new Object[0]);
            }
            this.callbackForm.close();
        });
        cancelButton.setOnAction(t -> {
            LOG.info("CancelButton()", new Object[0]);
            this.callbackForm.close();
        });
        callbackToExternalButton.getStyleClass().add((Object)"callbackFormButtons");
        callbackToExternalButton.setOnAction(t -> {
            String methodName = "callbackToExternalButton";
            DestinationI callbackDestination = (DestinationI)destinations.getSelectionModel().getSelectedItem();
            String callbackTime = this.startDateTime();
            String callbackExpiryTime = this.expiryMinutes();
            String callbackNote = noteField.getText();
            String externalNumber = externalNumberField.getText();
            if (callbackDestination != null) {
                LOG.info("CallbackToExternalNumberButton() interactionID:" + this.currentInteractionID, new Object[0]);
                this.interactionExe.createCallbackToExternalNumber(this.currentInteractionID, callbackDestination, externalNumber, callbackTime, callbackExpiryTime, callbackNote);
            } else {
                LOG.error(methodName + "Selected destination is null", new Object[0]);
            }
            this.callbackForm.close();
        });
        callbackToExternalButton.setDisable(true);
        externalNumberField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!destinations.getSelectionModel().isEmpty()) {
                    callbackToExternalButton.setDisable(newValue.isEmpty());
                }
            }
        });
        GridPane gp = new GridPane();
        gp.getStyleClass().add((Object)"dialog");
        gp.add((Node)customerContact, 0, 0);
        gp.add((Node)contactList, 1, 0);
        gp.add((Node)startDateLabel, 0, 1);
        gp.add((Node)startDatePicker, 1, 1);
        gp.add((Node)startTimeLabel, 0, 2);
        gp.add((Node)this.startTimeField, 1, 2);
        gp.add((Node)expiryLabel, 0, 3);
        gp.add((Node)this.endTimeField, 1, 3);
        gp.add((Node)noteLabel, 0, 4);
        gp.add((Node)noteField, 1, 4);
        gp.add((Node)externalNumberField, 0, 5);
        gp.add((Node)callbackToExternalButton, 1, 5);
        gp.add((Node)cancelButton, 0, 6);
        gp.add((Node)callbackToContactNumberButton, 1, 6);
        bp.setBottom((Node)gp);
    }

    private String startDateTime() {
        if (this.startDate != null) {
            return this.startDate.getYear() + "/" + this.startDate.getMonthValue() + "/" + this.startDate.getDayOfMonth() + " " + this.startTimeField.getText();
        }
        return "";
    }

    private String expiryMinutes() {
        return this.endTimeField.getText();
    }

    private static class CustomerCodeCell
    extends ListCell<ContactNumberI> {
        private CustomerCodeCell() {
        }

        public void updateItem(ContactNumberI item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getName() + ":" + item.getNumber());
            } else {
                this.setText(null);
            }
        }
    }

    private static class CodeCell
    extends ListCell<DestinationI> {
        private CodeCell() {
        }

        public void updateItem(DestinationI item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                String toDisplay = item.getName() + ":";
                if (item.getNumber() != null) {
                    toDisplay = toDisplay + item.getNumber() + ":";
                }
                toDisplay = toDisplay + item.getDestinationType().name();
                this.setText(toDisplay);
            }
        }
    }
}

