/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ClientI;
import com.avaya.ccs.api.enums.ClientState;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class ClientData {
    private final boolean connected;
    private boolean autoReconnect = true;
    private ClientState state = ClientState.DISCONNECTED;
    private boolean ha = false;
    private boolean haOperational = false;
    private String server = "";
    private String sdkVersion = "";
    private String connectedServer = "";

    public ClientData(ClientI client) {
        if (client != null) {
            this.connected = client.isConnected();
            this.autoReconnect = client.getAutoReconnect();
            this.state = client.getState();
            this.ha = client.isHa();
            this.haOperational = client.isHaOperational();
            this.server = client.getServer();
            this.sdkVersion = client.getVersion();
            this.connectedServer = client.getConnectedServer();
        } else {
            this.connected = false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return " connected:" + this.connected + " autoReconnect:" + this.autoReconnect + " state:" + this.state.name() + " HA:" + this.isHa() + " haOperational:" + this.isHaOperational();
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public ClientState getState() {
        return this.state;
    }

    public boolean isHa() {
        return this.ha;
    }

    public boolean isHaOperational() {
        return this.haOperational;
    }

    public List<Pair<String, String>> getClientProperties() {
        LinkedList<Pair<String, String>> clientProperties = new LinkedList<Pair<String, String>>();
        clientProperties.add(new Pair((Object)"Connected", (Object)String.valueOf(this.isConnected())));
        clientProperties.add(new Pair((Object)"Auto Reconnect", (Object)String.valueOf(this.isAutoReconnect())));
        clientProperties.add(new Pair((Object)"HA", (Object)String.valueOf(this.isHa())));
        clientProperties.add(new Pair((Object)"HA Operational", (Object)String.valueOf(this.isHaOperational())));
        clientProperties.add(new Pair((Object)"State", (Object)this.getState().name()));
        clientProperties.add(new Pair((Object)"Server", (Object)this.getServer()));
        clientProperties.add(new Pair((Object)"SDK Version", (Object)this.getSdkVersion()));
        clientProperties.add(new Pair((Object)"Connected Server", (Object)this.getConnectedServer()));
        return clientProperties;
    }

    public String getServer() {
        return this.server;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getConnectedServer() {
        return this.connectedServer;
    }
}

