/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomerDataI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.javafxrefclient.CustomerExecutor;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.concurrent.Task;

public class CustomerEventTask
extends Task<Object> {
    private final NotificationEventI<CustomerDataI> customerEvent;
    private final InteractionDataGUI gui;
    private static final Logger LOG = Logger.getLogger(CustomerEventTask.class);
    CustomerExecutor customerExecutor;

    public CustomerEventTask(NotificationEventI<CustomerDataI> customerEvent, InteractionDataGUI gui, CustomerExecutor customerExecutor) {
        this.customerEvent = customerEvent;
        this.gui = gui;
        this.customerExecutor = customerExecutor;
        this.setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {});
    }

    protected Object call() throws Exception {
        String methodName = "call() ";
        NotificationType type = this.customerEvent.getNotificationType();
        LOG.debug(methodName + "Type:" + type, new Object[0]);
        switch (type) {
            case UPDATE: 
            case DELETE: 
            case ERROR: 
            case NEW: {
                LOG.warn(methodName, " no implemented");
                break;
            }
            case RESPONSE: {
                CustomerDataI c = (CustomerDataI)this.customerEvent.getNotificationObject();
                LOG.info(methodName + " returning response data: " + c, new Object[0]);
                return c;
            }
            case UNKNOWN: {
                LOG.warn(methodName + " unknown ", new Object[0]);
            }
        }
        return null;
    }
}

