/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionTimer;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.PreviewTimer;
import com.avaya.ccs.javafxrefclient.WrapUpTimer;
import java.util.HashMap;

public class InteractionTimerMap {
    private static final HashMap<String, InteractionTimer> TIMERS = new HashMap();
    private static final Logger LOG = Logger.getLogger(InteractionTimerMap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(String interactionID) {
        String methodName = "stop() ";
        InteractionTimerMap interactionTimerMap = this;
        synchronized (interactionTimerMap) {
            InteractionTimer t = TIMERS.get(interactionID);
            if (t == null) {
                LOG.trace(methodName + " no timer to stop with interactonID:" + interactionID, new Object[0]);
                return false;
            }
            LOG.debug(methodName + " stopping and removing timer with interactonID:" + interactionID, new Object[0]);
            t.stopTimer();
            TIMERS.remove(interactionID);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreview(int timerLength, String interactionID, ContactNumberI todial, InteractionDataGUI gui) {
        String methodName = "startPreview() ";
        InteractionTimerMap interactionTimerMap = this;
        synchronized (interactionTimerMap) {
            InteractionTimer t = TIMERS.get(interactionID);
            if (t == null || !(t instanceof PreviewTimer)) {
                LOG.debug(methodName + " starting timer with interactonID:" + interactionID, new Object[0]);
                this.stop(interactionID);
                PreviewTimer pt = new PreviewTimer(timerLength, interactionID, todial, gui);
                TIMERS.put(interactionID, pt);
            } else {
                LOG.debug(methodName + " timer already running with interactonID:" + interactionID, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWrapUp(int timerLength, String interactionID, InteractionDataGUI gui) {
        String methodName = "startWrapUp() ";
        InteractionTimerMap interactionTimerMap = this;
        synchronized (interactionTimerMap) {
            InteractionTimer t = TIMERS.get(interactionID);
            if (t == null || !(t instanceof WrapUpTimer)) {
                LOG.debug(methodName + " starting timer with interactonID:" + interactionID, new Object[0]);
                this.stop(interactionID);
                WrapUpTimer wt = new WrapUpTimer(timerLength, interactionID, gui);
                TIMERS.put(interactionID, wt);
            } else {
                LOG.debug(methodName + " timer already running with interactonID:" + interactionID, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartWrapUP(String interactionID) {
        String methodName = "restartWrapUP() ";
        InteractionTimerMap interactionTimerMap = this;
        synchronized (interactionTimerMap) {
            InteractionTimer t = TIMERS.get(interactionID);
            if (t == null) {
                LOG.debug(methodName + " no timer to restart with interactonID:" + interactionID, new Object[0]);
                return false;
            }
            if (t instanceof WrapUpTimer) {
                LOG.debug(methodName + " restarting wrapup timer with interactonID:" + interactionID, new Object[0]);
                return t.restartTimer();
            }
            LOG.debug(methodName + " no wrapup timer to restart with interactonID:" + interactionID, new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extendWrapUP(String interactionID) {
        String methodName = "extendWrapUP() ";
        InteractionTimerMap interactionTimerMap = this;
        synchronized (interactionTimerMap) {
            InteractionTimer t = TIMERS.get(interactionID);
            if (t == null) {
                LOG.debug(methodName + " no timer to extend with interactonID:" + interactionID, new Object[0]);
                return false;
            }
            if (t instanceof WrapUpTimer) {
                LOG.debug(methodName + " extending wrapup timer with interactonID:" + interactionID, new Object[0]);
                return t.extendTimer();
            }
            LOG.debug(methodName + " no wrapup timer to extend with interactonID:" + interactionID, new Object[0]);
            return false;
        }
    }
}

