/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ErrorI;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;

public class Logger {
    private static final int DISPLAY_ERROR_FOR_SECONDS = 10;
    Class<?> clazz;
    org.apache.logging.log4j.Logger log;
    long mainErrorTime = 0L;

    private Logger(Class<?> clazz) {
        this.clazz = clazz;
        this.log = LogManager.getLogger(clazz);
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    public void trace(String msg, Object ... args) {
        this.clearStatusIfTimeout();
        this.log.trace(msg, args);
    }

    public void info(String msg, Object ... args) {
        this.clearStatusIfTimeout();
        this.log.info(msg, args);
    }

    public void debug(String msg, Object ... args) {
        this.clearStatusIfTimeout();
        this.log.debug(msg, args);
    }

    public void warn(String msg, Object ... args) {
        this.clearStatusIfTimeout();
        this.log.warn(msg, args);
    }

    public void error(String methodName, Throwable t, String msg) {
        this.clearStatusIfTimeout();
        this.log.error(methodName + "() " + msg, t);
    }

    public void error(String methodName, Throwable t) {
        this.clearStatusIfTimeout();
        this.log.error(methodName + "() ", t);
    }

    public void error(String msg, Object ... args) {
        this.clearStatusIfTimeout();
        this.log.error(msg, args);
    }

    public void errorStatus(ErrorI error) {
        String msg = error.getCommand() + " error - " + error.getMessage();
        this.mainErrorTime = System.currentTimeMillis();
        JavaFXRefClient.UpdateStatus(msg);
        this.log.error("errorStatus():" + msg);
    }

    public void errorStatus(String msg) {
        this.mainErrorTime = System.currentTimeMillis();
        JavaFXRefClient.UpdateStatus("System error: " + msg);
        this.log.error("errorStatus():" + msg);
    }

    public void infoStatus(String msg) {
        this.mainErrorTime = System.currentTimeMillis();
        JavaFXRefClient.UpdateStatus("System info: " + msg);
        this.log.info("infoStatus():" + msg);
    }

    public void clearStatus() {
        JavaFXRefClient.UpdateStatus("");
        this.mainErrorTime = 0L;
    }

    public void clearStatusIfTimeout() {
        long currentTime = System.currentTimeMillis();
        if (this.mainErrorTime != 0L && currentTime - this.mainErrorTime > Duration.ofSeconds(10L).toMillis()) {
            JavaFXRefClient.UpdateStatus("");
            this.mainErrorTime = 0L;
        }
    }
}

