/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;

public class UUITabBase {
    protected final Tab tab;
    protected final TextArea uuiEditor = new TextArea();
    protected final String BLANKUUI = "no UUI to display";
    protected final BorderPane uuiPane;
    private static final Logger LOG = Logger.getLogger(UUITabBase.class);

    public UUITabBase() {
        this.uuiEditor.getStyleClass().add((Object)"uuiEditor");
        this.uuiEditor.setText("no UUI to display");
        this.uuiEditor.setDisable(true);
        this.tab = new Tab();
        this.tab.setText("UUI");
        this.tab.setClosable(false);
        this.tab.setContent((Node)this.uuiEditor);
        this.tab.setDisable(true);
        this.uuiPane = new BorderPane();
        this.uuiPane.setCenter((Node)this.uuiEditor);
        this.tab.setContent((Node)this.uuiPane);
    }

    public Tab getTab() {
        return this.tab;
    }

    void update(InteractionDataI data) {
        String methodName = "update() ";
        LOG.trace(methodName + "+", new Object[0]);
        boolean disable = !data.canGetUUI();
        LOG.trace(methodName + "disable = " + disable, new Object[0]);
        this.tab.setDisable(false);
        this.uuiEditor.setDisable(disable);
        String uuiData = data.getUui();
        if (uuiData != null) {
            LOG.trace(methodName + "UUI:" + uuiData, new Object[0]);
            this.uuiEditor.setText(uuiData);
        } else {
            LOG.trace(methodName + "setting blank txt", new Object[0]);
            this.uuiEditor.setText("no UUI to display");
        }
        LOG.trace(methodName + "-", new Object[0]);
    }
}

