/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.UserListenerI;
import com.avaya.ccs.javafxrefclient.Executor;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UserEventTask;
import com.avaya.ccs.javafxrefclient.request.ACWRequest;
import com.avaya.ccs.javafxrefclient.request.GetAgentSignatureRequest;
import com.avaya.ccs.javafxrefclient.request.GetUserDataRequest;
import com.avaya.ccs.javafxrefclient.request.LoginRequest;
import com.avaya.ccs.javafxrefclient.request.LogoutRequest;
import com.avaya.ccs.javafxrefclient.request.NotReadyRequest;
import com.avaya.ccs.javafxrefclient.request.OriginateEmailRequest;
import com.avaya.ccs.javafxrefclient.request.ReadyRequest;
import com.avaya.ccs.javafxrefclient.request.SetAgentSignatureRequest;

public class UserExecutor
extends Executor
implements UserListenerI {
    private static final Logger LOG = Logger.getLogger(UserExecutor.class);
    private final JavaFXRefClient gui;

    public UserExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public void logout(String userID) {
        String methodName = "logout() ";
        LOG.debug(methodName + "+ UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new LogoutRequest(userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void login(String userID, String password, String zone) {
        String methodName = "login() ";
        LOG.debug(methodName + "+ UserID:" + userID + " PasswordLength:" + password.length() + " Zone:" + (zone == null ? "NULL" : zone), new Object[0]);
        this.executeOutgoingRequest(new LoginRequest(userID, password, zone));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void ready(String userID) {
        String methodName = "ready() ";
        LOG.debug(methodName + "+ UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new ReadyRequest(userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void notReady(String userID, String reason) {
        String methodName = "notReady() ";
        LOG.debug(methodName + "+ UserID:" + userID + "Reason:" + reason, new Object[0]);
        this.executeOutgoingRequest(new NotReadyRequest(userID, reason));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void ACW(String userID, String reason) {
        String methodName = "ACW() ";
        LOG.debug(methodName + "+ UserID:" + userID + "Reason:" + reason, new Object[0]);
        this.executeOutgoingRequest(new ACWRequest(userID, reason));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getUserData() {
        String methodName = "getUserData() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new GetUserDataRequest(this.gui.getUserGUI(), this.gui.getSupervisorGUI()));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void setAgentSignature(String userId, String htmlSignature) {
        String methodName = "setAgentSignature() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new SetAgentSignatureRequest(userId, htmlSignature));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getAgentSignature(String userId) {
        String methodName = "getAgentSignature() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new GetAgentSignatureRequest(userId));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void originateEmail(String userId) {
        String methodName = "originateEmail() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new OriginateEmailRequest(userId));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void onUserEvent(NotificationEventI<UserI> user) {
        String methodName = "onUserEvent() ";
        LOG.info(methodName + user.getNotificationType() + " UserI-ID:" + ((UserI)user.getNotificationObject()).getId(), new Object[0]);
        UserEventTask t = new UserEventTask(user, this.gui.getUserGUI(), this.gui.getSupervisorGUI());
        this.executeIncomingEvent(t);
    }
}

