/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum InteractionType {
    VoiceInteraction,
    EmailInteraction,
    ChatInteraction,
    Unknown;

    static Map<String, InteractionType> stateMap;

    @JsonCreator
    static InteractionType get(String stateName) {
        InteractionType state = stateMap.get(stateName);
        if (state == null) {
            state = Unknown;
        }
        return state;
    }

    static {
        stateMap = new HashMap<String, InteractionType>();
        for (InteractionType state : InteractionType.values()) {
            stateMap.put(state.toString(), state);
        }
    }
}

