/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.Client;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.ProtocolHandler;
import com.avaya.ccs.core.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseObject {
    static Logger log = Logger.getLogger(BaseObject.class);
    @JsonProperty(value="ID")
    String id;
    @JsonProperty(value="Functions")
    List<Command> availableCommands;
    Client client;
    BaseObject parent;
    String path;
    AtomicBoolean deleted = new AtomicBoolean(false);

    String getPath() {
        if (this.path == null) {
            this.path = this.parent != null ? this.parent.getPath() + "/" + (Object)((Object)this.getObjectType()) + "/" + this.id : "/" + (Object)((Object)this.getObjectType()) + "/" + this.id;
        }
        return this.path;
    }

    String getMultimediaInteractionPath(String interactionId) {
        return "/Interaction/" + interactionId + "/Media";
    }

    public String getId() {
        return this.id;
    }

    protected void setParent(BaseObject parent) {
        this.parent = parent;
    }

    protected void checkForDeletion() throws ObjectInvalidException {
        if (this.deleted.get()) {
            throw new ObjectInvalidException((Object)((Object)this.getObjectType()) + " object with id=" + this.id + " is invalid", this);
        }
    }

    boolean isCommandAvailable(Command commandToCheck) {
        for (Command command : this.availableCommands) {
            if (command != commandToCheck) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends BaseObject> T createOrUpdate(T object, Class<? extends T> clazz, String payload, Map<String, T> objMap, BaseObject parent, Client client) {
        Object updatedObject;
        block9: {
            String methodName = "createOrUpdate";
            if (Utils.isNullOrEmpty(payload)) {
                log.error("createOrUpdate", "mandatory payload argument is null or empty! unable to create or update ", object, " [class:", clazz, "]");
                return object;
            }
            if (client == null || clazz == null) {
                log.error("createOrUpdate", "mandatory arguments are null! client:", client, ", map:", objMap, ", class:", clazz);
                return object;
            }
            updatedObject = object;
            try {
                if (updatedObject != null) {
                    T t = updatedObject;
                    synchronized (t) {
                        ((BaseObject)updatedObject).clearOldCachedDataBeforeUpdate();
                        updatedObject = (BaseObject)ProtocolHandler.getJsonObjectMapper().readerForUpdating(updatedObject).readValue(payload);
                        break block9;
                    }
                }
                updatedObject = (BaseObject)ProtocolHandler.getJsonObjectMapper().readValue(payload, clazz);
                ((BaseObject)updatedObject).setClient(client);
                ((BaseObject)updatedObject).setParent(parent);
                if (objMap != null) {
                    objMap.put(((BaseObject)updatedObject).getId(), updatedObject);
                }
            }
            catch (IOException e) {
                log.error("createOrUpdate", e, "Unable to deserialize object from json payload: " + payload + ", obj:" + updatedObject);
            }
        }
        return (T)updatedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends BaseObject> void delete(T objectToDelete, Map<String, T> objMap) {
        if (objectToDelete != null && objMap != null) {
            T t = objectToDelete;
            synchronized (t) {
                objectToDelete.markForDeletion();
                objMap.remove(objectToDelete.getId());
            }
        }
    }

    void execute(Runnable task, String taskName) {
        if (this.client != null) {
            this.client.execute(task, taskName);
        } else {
            log.warn("execute", "client is null on ", this);
        }
    }

    void setClient(Client client) {
        this.client = client;
    }

    void open(String targetPath) {
        if (this.client != null) {
            String path = this.getPath() + (Utils.isNullOrEmpty(targetPath) ? "" : targetPath);
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.OPEN, path, null, null);
        } else {
            log.warn("open", "client object is null");
        }
    }

    void close(String targetPath, CommandArgs commandArgs) {
        if (this.client != null) {
            String path = this.getPath() + (Utils.isNullOrEmpty(targetPath) ? "" : targetPath);
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.CLOSE, path, commandArgs, null);
        } else {
            log.warn("close", "client object is null");
        }
    }

    void get(CommandArgs commandArgs) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.GET, this.getPath(), commandArgs, null);
        } else {
            log.warn("get", "client object is null");
        }
    }

    void post(CommandArgs commandArgs, String data) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, this.getPath(), commandArgs, data);
        } else {
            log.warn("post", "client object is null");
        }
    }

    void getCustomerSearch(CommandArgs commandArgs, String query) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.GET, "/Customer/", commandArgs, query);
        } else {
            log.warn("open", "client object is null");
        }
    }

    void getSuggestedResponses(CommandArgs commandArgs, String contactId) {
        this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.GET, this.getMultimediaInteractionPath(contactId) + "/" + contactId, commandArgs, null);
    }

    void rescheduleEmail(String contactId, CommandArgs commandArgs, String data) {
        this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, this.getMultimediaInteractionPath(contactId) + "/" + contactId, commandArgs, data);
    }

    void getCustomerHistory(String contactId, CommandArgs commandArgs) {
        this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.GET, "/Interaction/" + contactId, commandArgs, null);
    }

    void postEmailReply(CommandArgs commandArgs, String data, String contactId) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, this.getMultimediaInteractionPath(contactId) + "/" + contactId, commandArgs, data);
        } else {
            log.warn("postEmailReply", "client object is null");
        }
    }

    void postEmailAddAttachments(CommandArgs commandArgs, String data, String contactId) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, this.getMultimediaInteractionPath(contactId) + "/" + contactId, commandArgs, data);
        } else {
            log.warn("postEmailAddAttachments", "client object is null");
        }
    }

    void postEmailCreate(CommandArgs commandArgs, String data, String contactId) {
        log.info("postEmailSend", new Object[0]);
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, this.getMultimediaInteractionPath(contactId) + "/" + contactId, commandArgs, data);
        } else {
            log.warn("postEmailCreate", "client object is null");
        }
    }

    void postEmailReschedule(CommandArgs commandArgs, String data, String contactId) {
        log.info("postEmailReschedule", new Object[0]);
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, "/Interaction/" + contactId, commandArgs, data);
        } else {
            log.warn("postEmailReschedule", "client object is null");
        }
    }

    void postWebChatMessage(CommandArgs commandArgs, String data, String contactId) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, this.getMultimediaInteractionPath(contactId) + "/" + contactId, commandArgs, data);
        } else {
            log.warn("postWebChatMessage", "client object is null");
        }
    }

    void postPullContact(CommandArgs commandArgs, String data, String contactId) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.POST, this.getMultimediaInteractionPath(contactId) + "/" + contactId + "", commandArgs, data);
        } else {
            log.warn("postPullContact", "client is null");
        }
    }

    abstract NotificationDescription.ObjectType getObjectType();

    abstract void clearOldCachedDataBeforeUpdate();

    abstract void markForDeletion();
}

