/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.MonitoredUserListenerI;
import com.avaya.ccs.api.NotificationI;
import com.avaya.ccs.api.OffsiteStatusI;
import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.enums.Role;
import com.avaya.ccs.api.enums.UserState;
import com.avaya.ccs.api.enums.UserSyncStatus;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseUser;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.LoginOptions;
import com.avaya.ccs.core.MonitoredUser;
import com.avaya.ccs.core.Notification;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.NotificationEvent;
import com.avaya.ccs.core.OffsiteStatus;
import com.avaya.ccs.core.ProtocolHandler;
import com.avaya.ccs.core.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class User
extends BaseUser
implements UserI {
    private static Logger log = Logger.getLogger(User.class);
    @JsonProperty(value="Roles")
    private List<Role> roles;
    @JsonProperty(value="VoiceResource")
    private String voiceResource;
    @JsonProperty(value="OffsiteStatus")
    private OffsiteStatus offsiteStatus;
    @JsonProperty(value="IsMultimedia")
    private boolean isMultimedia;
    @JsonProperty(value="SupervisorName")
    private String supervisorName;
    @JsonProperty(value="Notification")
    private Notification notification;
    @JsonProperty(value="UserSyncStatus")
    private UserSyncStatus syncStatus;
    @JsonProperty(value="UserSyncMessage")
    private String syncMessage;
    @JsonProperty(value="IsPomNailedUp")
    private boolean isPomNailedUp;
    @JsonProperty(value="PomZones")
    private List<String> pomZones;
    @JsonProperty(value="Language")
    private String language;
    private String agentSignature;
    private Map<String, MonitoredUser> monitoredUsers = Collections.synchronizedMap(new HashMap());
    private MonitoredUserListenerI monitoredUserListener;

    @Override
    public synchronized boolean canAfterCallWork() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.AfterCallWork);
    }

    @Override
    public synchronized boolean canLogin() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Login);
    }

    @Override
    public synchronized boolean canLoginOffsite() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.LoginOffsite);
    }

    @Override
    public synchronized boolean canLogout() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Logout);
    }

    @Override
    public synchronized boolean canReady() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Ready);
    }

    @Override
    public synchronized boolean canNotReady() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.NotReady);
    }

    @Override
    public synchronized boolean canRecoverOffsite() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.RecoverOffsite);
    }

    @Override
    public synchronized boolean canMonitorUsers() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.MonitorAgents);
    }

    @Override
    public synchronized boolean canUnmonitorUsers() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.UnmonitorAgents);
    }

    @Override
    public synchronized boolean canOriginateEmail() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.OriginateEmail);
    }

    @Override
    public synchronized boolean canSetLanguage() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.SetLanguage);
    }

    @Override
    public synchronized ContactCenterCodeI getCode() throws ObjectInvalidException {
        return super.getCode();
    }

    @Override
    public synchronized List<ContactType> getContactTypes() throws ObjectInvalidException {
        return super.getContactTypes();
    }

    @Override
    public synchronized String getFirstName() throws ObjectInvalidException {
        return super.getFirstName();
    }

    @Override
    public synchronized String getLastName() throws ObjectInvalidException {
        return super.getLastName();
    }

    @Override
    public synchronized String getFullName() throws ObjectInvalidException {
        return super.getFullName();
    }

    @Override
    public synchronized String getLoginId() throws ObjectInvalidException {
        return super.getLoginId();
    }

    @Override
    public synchronized List<Role> getRoles() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.roles == null) {
            return new ArrayList<Role>();
        }
        return new ArrayList<Role>(this.roles);
    }

    @Override
    public synchronized UserState getState() {
        return super.getState();
    }

    @Override
    public synchronized boolean isMultimedia() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isMultimedia;
    }

    @Override
    public synchronized SessionI getSession() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.client != null ? this.client.getSession() : null;
    }

    @Override
    public synchronized String getVoiceResource() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.voiceResource;
    }

    @Override
    public synchronized String getSupervisorName() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.supervisorName;
    }

    @Override
    public synchronized NotificationI getNotification() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.notification;
    }

    @Override
    public synchronized OffsiteStatusI getOffsiteStatus() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.offsiteStatus;
    }

    @Override
    public synchronized List<MonitoredUserI> getMonitoredUsers() throws ObjectInvalidException {
        this.checkForDeletion();
        return new ArrayList<MonitoredUserI>(this.monitoredUsers.values());
    }

    @Override
    public synchronized UserSyncStatus getUserSyncStatus() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.syncStatus;
    }

    @Override
    public synchronized String getUserSyncMessage() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.syncMessage;
    }

    @Override
    public synchronized boolean isPomNailedUp() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isPomNailedUp;
    }

    @Override
    public synchronized List<String> getPomZones() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.pomZones == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.pomZones);
    }

    @Override
    public synchronized void getOffsiteSettings() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("getOffsiteSettings", this);
            this.get(new CommandArgs(Command.GetOffsiteSettings));
        }, "User.getOffsiteSettings()");
    }

    @Override
    public synchronized String getLanguage() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.language;
    }

    @Override
    public synchronized boolean hasContactType(ContactType contactType) throws ObjectInvalidException, InvalidArgumentException {
        return super.hasContactType(contactType);
    }

    @Override
    public synchronized void login(String passwordOrToken, String zone) throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("login", this, Utils.isNotNullAndNotEmpty(passwordOrToken) ? ", password:***sensitive-data[" + passwordOrToken.length() + "]***" : "", Utils.isNotNullAndNotEmpty(zone) ? ", zone:" + zone : "");
            try {
                CommandArgs args = new CommandArgs(Command.Login);
                this.post(args, ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)new LoginOptions(passwordOrToken, zone)));
            }
            catch (JsonProcessingException e) {
                log.warn("login", new Object[]{"unable to serialize LoginOptions objects ", e});
            }
        }, "User.login()");
    }

    @Override
    public synchronized void logout() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("logout", this);
            this.post(new CommandArgs(Command.Logout), null);
        }, "User.logout()");
    }

    @Override
    public synchronized void ready() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("ready", this);
            this.post(new CommandArgs(Command.Ready), null);
        }, "User.ready()");
    }

    @Override
    public synchronized void notReady(String notReadyCode) throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("notReady", this);
            this.post(new CommandArgs(Command.NotReady, !Utils.isNullOrEmpty(notReadyCode) ? notReadyCode : null), null);
        }, "User.notReady()");
    }

    @Override
    public synchronized void afterCallWork(String acwCode) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(acwCode)) {
            throw new InvalidArgumentException("mandatory code argument is null or empty");
        }
        this.execute(() -> {
            log.info("afterCallWork", this, ", code:", acwCode);
            this.post(new CommandArgs(Command.AfterCallWork, !Utils.isNullOrEmpty(acwCode) ? acwCode : null), null);
        }, "User.afterCallWork()");
    }

    @Override
    public synchronized void clearNotification() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("clearNotification", this);
            this.notification = null;
            this.post(new CommandArgs(Command.ClearNotification), null);
        }, "User.clearNotification()");
    }

    @Override
    public synchronized void loginOffsite(String offsitePhone, String password) throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("loginOffsite", this, ", offsite-phone:", offsitePhone, Utils.isNotNullAndNotEmpty(password) ? ", password:***sensitive-data[" + password.length() + "]***" : "");
            this.post(new CommandArgs(Command.LoginOffsite, offsitePhone), password != null && !password.isEmpty() ? password : null);
        }, "User.loginOffsite()");
    }

    @Override
    public synchronized void recoverOffsite() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("recoverOffsite", this);
            this.post(new CommandArgs(Command.RecoverOffsite), null);
        }, "User.recoverOffsite()");
    }

    @Override
    public synchronized void monitorUsers(MonitoredUserListenerI listener) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (listener == null) {
            throw new InvalidArgumentException("mandatory monitored users listener argument is null");
        }
        this.monitoredUserListener = listener;
        this.execute(() -> {
            log.info("monitorUsers", this);
            this.open("/" + (Object)((Object)NotificationDescription.ObjectType.MonitoredUser));
        }, "User.monitorUsers()");
    }

    @Override
    public synchronized void unmonitorUsers() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            this.monitoredUserListener = null;
            log.info("unmonitorUsers", this);
            this.close("/" + (Object)((Object)NotificationDescription.ObjectType.MonitoredUser), null);
            for (MonitoredUser monitoredUser : this.monitoredUsers.values()) {
                monitoredUser.markForDeletion();
                this.notify(NotificationType.DELETE, monitoredUser);
            }
            this.monitoredUsers.clear();
        }, "User.unmonitorUsers()");
    }

    @Override
    public synchronized void setLanguage(String language) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(language)) {
            throw new InvalidArgumentException("mandatory language argument is null or empty");
        }
        this.execute(() -> {
            log.info("setLanguage", this, ", Language:", language);
            this.post(new CommandArgs(Command.SetLanguage, language), null);
        }, "User.setLanguage()");
    }

    void notify(NotificationType type, MonitoredUser monitoredUser) {
        String methodName = "notify";
        if (monitoredUser == null) {
            log.warn(methodName, new Object[]{type, " MonitoredUser is null!"});
            return;
        }
        try {
            if (this.monitoredUserListener != null) {
                log.info(methodName, new Object[]{type, " ", monitoredUser});
                this.monitoredUserListener.onMonitoredUserEvent(new NotificationEvent<MonitoredUserI>(type, monitoredUser));
            } else {
                log.warn(methodName, new Object[]{type, " ", this.monitoredUserListener, ", listener is null!"});
            }
        }
        catch (Exception e) {
            log.error(methodName, e, "Executing event listener for " + monitoredUser + ", exception thrown from Application");
        }
    }

    void onMonitoredUserNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onMonitoredUserNotification";
        log.info(methodName, new Object[]{this.client.getSession(), "\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
        try {
            MonitoredUser monitoredUser = this.monitoredUsers.get(desc.getObjectId());
            switch (type) {
                case NEW: 
                case UPDATE: 
                case DELETE: {
                    monitoredUser = this.createOrUpdate(monitoredUser, MonitoredUser.class, payload, this.monitoredUsers, this, this.client);
                    if (type != NotificationType.DELETE) break;
                    this.delete(monitoredUser, this.monitoredUsers);
                    break;
                }
                default: {
                    log.warn(methodName, "unhandled notification type " + (Object)((Object)type));
                }
            }
            this.notify(type, monitoredUser);
        }
        catch (Exception e) {
            log.error(methodName, e);
        }
    }

    void onMonitoredInteractionNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onMonitoredInteractionNotification";
        MonitoredUser monitoredUser = this.monitoredUsers.get(desc.getIdFromTypeInPath(NotificationDescription.ObjectType.MonitoredUser));
        if (monitoredUser != null) {
            monitoredUser.onMonitoredInteractionNotification(type, desc, payload);
        } else {
            log.error(methodName, "Unable to find MonitoredUser using id ", desc.getIdFromTypeInPath(NotificationDescription.ObjectType.MonitoredUser));
        }
    }

    @Override
    public void markForDeletion() {
        super.markForDeletion();
        for (MonitoredUser monitoredUser : this.monitoredUsers.values()) {
            this.delete(monitoredUser, this.monitoredUsers);
            this.notify(NotificationType.DELETE, monitoredUser);
        }
        this.monitoredUsers.clear();
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.User;
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
        this.syncMessage = null;
        super.clearOldCachedDataBeforeUpdate();
    }

    @Override
    public void initiateAdhocEmail() {
        this.execute(() -> {
            log.info("initiateAdhocEmail", this);
            this.post(new CommandArgs(Command.OriginateEmail), "");
        }, "User.sendAdhocEmail()");
    }

    @Override
    public void retrieve(String contactId) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(contactId)) {
            throw new InvalidArgumentException("mandatory contactId argument is null or empty");
        }
        this.execute(() -> {
            log.info("retrieve", this, "contact", contactId);
            this.post(new CommandArgs(Command.Pull, contactId), "");
        }, "User.retrieve()");
    }

    @Override
    public void getSkillsetsForContactType(ContactType type) {
        this.execute(() -> {
            log.info("getSkillsetsForContactType", this);
            this.post(new CommandArgs(Command.GetSkillsets), "{\"ContactType\": \"" + type.toString() + "\"}");
        }, "User.getSkillsetsForContactType()");
    }

    protected String escapeForJson(String raw) {
        String escaped = raw;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }

    private String inQuotes(String content) {
        return "\"" + content + "\"";
    }

    String toJsonStringMaskSensitive() {
        return "{ID:" + this.id + ",LoginID:" + this.loginId + ",FirstName:" + this.firstName + ",LastName:" + this.lastName + ",State:" + (Object)((Object)this.state) + ",ContactTypes:" + this.contactTypes + ",Roles:" + this.roles + ",VoiceResource:" + this.voiceResource + ",SupervisorName:" + this.supervisorName + ",IsMultimedia:" + this.isMultimedia + (this.offsiteStatus != null ? ",OffsiteStatus:" + this.offsiteStatus : "") + ",UserSyncStatus:" + (Object)((Object)this.syncStatus) + (this.syncMessage != null ? ",UserSyncMessage:" + this.syncMessage : "") + ",Language:" + this.language + ",IsPomNailedUp:" + this.isPomNailedUp + (this.notification != null ? ",Notification:" + this.notification : "") + (this.code != null ? ",Code:" + this.code : "") + (this.pomZones != null && !this.pomZones.isEmpty() ? ",PomZones:" + this.pomZones : "") + ",Functions:" + this.availableCommands + "}";
    }

    public String toString() {
        return "[User ID:" + this.id + ",LoginID:" + this.loginId + ",Name:" + this.firstName + " " + this.lastName + ",State:" + (Object)((Object)this.state) + ",SyncStatus:" + (Object)((Object)this.syncStatus) + ",Language:" + this.language + "]";
    }
}

