/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.DataI;
import com.avaya.ccs.api.enums.DataFormat;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.core.ByteArraySerializer;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Data
implements DataI {
    private static Logger log = Logger.getLogger(Data.class);
    @JsonSerialize(using=ByteArraySerializer.class)
    @JsonProperty(value="BIN")
    private byte[] binaryData;
    @JsonProperty(value="KVP")
    private Map<String, String> kvpData;
    @JsonProperty(value="STR")
    private String stringData;
    @JsonIgnore
    private DataFormat format = DataFormat.UNKNOWN;

    Data() {
    }

    Data(byte[] binaryData) {
        log.trace("Data<bin>", new Object[0]);
        this.format = DataFormat.BIN;
        this.binaryData = binaryData;
    }

    Data(String stringData) {
        log.trace("Data<str>", new Object[0]);
        this.format = DataFormat.STR;
        this.stringData = stringData;
    }

    Data(Map<String, String> kvpData) {
        log.trace("Data<kvp>", new Object[0]);
        this.format = DataFormat.KVP;
        this.kvpData = kvpData;
    }

    public static Data create(Map<String, String> kvpData) throws InvalidArgumentException {
        if (kvpData == null || kvpData.isEmpty()) {
            throw new InvalidArgumentException("mandatory kvp data argument is null or empty");
        }
        return new Data(kvpData);
    }

    public static Data create(String strData) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(strData)) {
            throw new InvalidArgumentException("mandatory string data argument is null or empty");
        }
        return new Data(strData);
    }

    public static Data create(byte[] binData) throws InvalidArgumentException {
        if (binData == null || binData.length < 1) {
            throw new InvalidArgumentException("mandatory binary data argument is null or empty");
        }
        return new Data(binData);
    }

    @JsonSetter
    private void setBinaryData(byte[] binaryData) {
        this.format = DataFormat.BIN;
        this.binaryData = binaryData;
        log.trace("setBinaryData", "Size of data ", this.length());
    }

    @JsonSetter
    private void setKvpData(Map<String, String> kvpData) {
        this.format = DataFormat.KVP;
        this.kvpData = kvpData;
        log.trace("setKvpData", "Size of data ", this.length());
    }

    @JsonSetter
    private void setStringData(String stringData) {
        this.format = DataFormat.STR;
        this.stringData = stringData;
        log.trace("setStringData", "Size of data ", this.length());
    }

    @Override
    @JsonIgnore
    public DataFormat getFormat() {
        return this.format;
    }

    @Override
    @JsonIgnore
    public byte[] getBinaryData() {
        if (this.binaryData == null || this.binaryData.length == 0) {
            return new byte[0];
        }
        log.trace("getBinaryData", "Size of data ", this.length());
        return this.binaryData;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getKvpData() {
        if (this.kvpData == null || this.kvpData.isEmpty()) {
            return new HashMap<String, String>();
        }
        log.trace("getKvpData", "Size of data ", this.length());
        return new HashMap<String, String>(this.kvpData);
    }

    @Override
    @JsonIgnore
    public String getStringData() {
        if (Utils.isNullOrEmpty(this.stringData)) {
            return null;
        }
        log.trace("getStringData", "Size of data ", this.length());
        return this.stringData;
    }

    public int length() {
        int length = 0;
        if (this.format == DataFormat.BIN && this.binaryData != null && this.binaryData.length > 0) {
            length = this.binaryData.length;
        } else if (this.format == DataFormat.KVP && this.kvpData != null && !this.kvpData.isEmpty()) {
            length = this.kvpData.size();
        } else if (this.format == DataFormat.STR && Utils.isNotNullAndNotEmpty(this.stringData)) {
            length = this.stringData.length();
        }
        return length;
    }

    public String toString() {
        String data = null;
        if (this.format == DataFormat.BIN && this.binaryData != null && this.binaryData.length > 0) {
            data = this.binaryData.toString();
        } else if (this.format == DataFormat.KVP && this.kvpData != null && !this.kvpData.isEmpty()) {
            data = this.kvpData.toString();
        } else if (this.format == DataFormat.STR && Utils.isNotNullAndNotEmpty(this.stringData)) {
            data = this.stringData;
        }
        return "[Data: " + (Object)((Object)this.format) + "=" + data + "]";
    }
}

