/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomerDetailsI;
import com.avaya.ccs.api.EmailListEntryI;
import com.avaya.ccs.api.PhoneListEntryI;
import com.avaya.ccs.api.PostalAddressListEntryI;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class CustomerDataPane {
    private final BorderPane pane = new BorderPane();
    private TableView<CustomerDataElement> dataTable = new TableView();
    private final ObservableList<CustomerDataElement> dataList = FXCollections.observableArrayList();
    private Button edit;
    private final InteractionExecutor interactionExe;
    private final InteractionDataGUI gui;
    private static String BLANKCUSTOMERDATA = "No customer data to display";
    private static final Logger LOG = Logger.getLogger(CustomerDataPane.class);

    public CustomerDataPane(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        this.gui = gui;
        this.interactionExe = interactionExe;
        this.pane.getStyleClass().add((Object)"customerData");
        this.pane.setCenter(this.dataTable);
        this.createCustomerDataTable();
        this.edit = new Button("Edit");
        this.edit.setDisable(true);
        this.edit.getStyleClass().add((Object)"intrinsicButton");
        this.edit.setOnAction(t -> {
            CustomerDataElement element = (CustomerDataElement)this.dataTable.getSelectionModel().getSelectedItem();
            if (element != null) {
                if (element.data instanceof CustomerName) {
                    LOG.info("EditButton() CustomerName", new Object[0]);
                    CustomerName n = (CustomerName)element.data;
                    this.editCustomerNameDialog(n.title, n.firstName, n.lastName);
                } else if (element.data instanceof EmailListEntryI) {
                    LOG.info("EditButton() CustomerEmail", new Object[0]);
                    EmailListEntryI email = (EmailListEntryI)element.data;
                    this.editEmailDialog(email);
                } else if (element.data instanceof PhoneListEntryI) {
                    LOG.info("EditButton() CustomerPhone", new Object[0]);
                    PhoneListEntryI phone = (PhoneListEntryI)element.data;
                    this.editPhoneDialog(phone);
                } else if (element.data instanceof PostalAddressListEntryI) {
                    LOG.info("EditButton() CustomerAddress", new Object[0]);
                    PostalAddressListEntryI postalAddress = (PostalAddressListEntryI)element.data;
                    this.editPostalAddressDialog(postalAddress);
                }
            }
        });
        this.dataTable.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                CustomerDataElement d = newSelection;
                this.edit.setDisable(!d.editable);
            } else {
                this.edit.setDisable(true);
            }
        });
        HBox buttonHolder = new HBox();
        buttonHolder.getChildren().addAll((Object[])new Node[]{this.edit});
        this.pane.setBottom((Node)buttonHolder);
    }

    public BorderPane getPane() {
        return this.pane;
    }

    private void createCustomerDataTable() {
        this.dataTable.setEditable(true);
        this.dataTable.setPlaceholder((Node)new Label(BLANKCUSTOMERDATA));
        TableColumn name = new TableColumn("Name");
        name.getStyleClass().add((Object)"customerDataTableNameRows");
        name.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<CustomerDataElement, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<CustomerDataElement, String> p) {
                return new ReadOnlyObjectWrapper((Object)((CustomerDataElement)p.getValue()).name);
            }
        });
        TableColumn value = new TableColumn("Value");
        value.getStyleClass().add((Object)"customerDataTableValueRows");
        value.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<CustomerDataElement, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<CustomerDataElement, String> p) {
                return new ReadOnlyObjectWrapper((Object)((CustomerDataElement)p.getValue()).value);
            }
        });
        this.dataTable.setItems(this.dataList);
        this.dataTable.getColumns().add((Object)name);
        this.dataTable.getColumns().add((Object)value);
    }

    void update(InteractionDataI data) {
        this.pane.setDisable(!data.canGetCustomerDetails());
        this.dataList.clear();
        CustomerDetailsI custdetails = data.getCustomerDetails();
        if (custdetails == null) {
            return;
        }
        CustomerName n = new CustomerName(custdetails.getTitle(), custdetails.getFirstName(), custdetails.getLastName());
        this.dataList.add((Object)new CustomerDataElement("Title", n.title, data.canUpdateCustomerName(), n));
        this.dataList.add((Object)new CustomerDataElement("First Name", n.firstName, data.canUpdateCustomerName(), n));
        this.dataList.add((Object)new CustomerDataElement("Last Name", n.lastName, data.canUpdateCustomerName(), n));
        List emails = custdetails.getEmailList();
        int count = 1;
        for (Object email : emails) {
            this.dataList.add((Object)new CustomerDataElement("Email-" + count, email.getEmailAddress(), data.canUpdateCustomerEmail(), email));
            ++count;
        }
        List phones = custdetails.getPhoneList();
        count = 1;
        for (PhoneListEntryI phone : phones) {
            this.dataList.add((Object)new CustomerDataElement("CountryCode-" + count, phone.getCountryCode(), data.canUpdateCustomerPhone(), phone));
            this.dataList.add((Object)new CustomerDataElement("PhoneNumber-" + count, phone.getPhoneNumber(), data.canUpdateCustomerPhone(), phone));
            this.dataList.add((Object)new CustomerDataElement("TimeZone-" + count, phone.getTimezone(), data.canUpdateCustomerPhone(), phone));
            ++count;
        }
        List addresses = custdetails.getPostalAddressList();
        count = 1;
        for (PostalAddressListEntryI address : addresses) {
            this.dataList.add((Object)new CustomerDataElement("Address-" + count + "-Line1", address.getLine1(), data.canUpdateCustomerAddress(), address));
            this.dataList.add((Object)new CustomerDataElement("Address-" + count + "-Line2", address.getLine2(), data.canUpdateCustomerAddress(), address));
            this.dataList.add((Object)new CustomerDataElement("Address-" + count + "-Line3", address.getLine3(), data.canUpdateCustomerAddress(), address));
            this.dataList.add((Object)new CustomerDataElement("Address-" + count + "-Line4", address.getLine4(), data.canUpdateCustomerAddress(), address));
            this.dataList.add((Object)new CustomerDataElement("Address-" + count + "-Line5", address.getLine5(), data.canUpdateCustomerAddress(), address));
            this.dataList.add((Object)new CustomerDataElement("Address-" + count + "-Country", address.getCountry(), data.canUpdateCustomerAddress(), address));
            this.dataList.add((Object)new CustomerDataElement("Address-" + count + "-Zip", address.getZipcode(), data.canUpdateCustomerAddress(), address));
            ++count;
        }
    }

    private void editCustomerNameDialog(String title, String firstName, String lastName) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Edit Customer Name");
        ButtonType okButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField titleTextField = new TextField();
        titleTextField.setText(title);
        TextField firstNameTextField = new TextField();
        firstNameTextField.setText(firstName);
        TextField lastNameTextField = new TextField();
        lastNameTextField.setText(lastName);
        grid.add((Node)new Label("Title:"), 0, 0);
        grid.add((Node)titleTextField, 1, 0);
        grid.add((Node)new Label("First Name:"), 0, 1);
        grid.add((Node)firstNameTextField, 1, 1);
        grid.add((Node)new Label("Last Name:"), 0, 2);
        grid.add((Node)lastNameTextField, 1, 2);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> titleTextField.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return new CustomerName(titleTextField.getText(), firstNameTextField.getText(), lastNameTextField.getText());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(name -> this.interactionExe.updateCustomerName(this.gui.getCurrentItemSelection().getId(), name.title, name.firstName, name.lastName));
    }

    private void editEmailDialog(EmailListEntryI email) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Edit Customer Email");
        ButtonType signinButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{signinButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField emailTextField = new TextField();
        emailTextField.setText(email.getEmailAddress());
        emailTextField.setEditable(true);
        grid.add((Node)new Label("Name:"), 0, 0);
        grid.add((Node)emailTextField, 1, 0);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> emailTextField.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == signinButtonType) {
                return emailTextField.getText();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(emailValue -> {
            email.setEmailAddress(emailValue);
            this.interactionExe.updateCustomerEmail(this.gui.getCurrentItemSelection().getId(), email);
        });
    }

    private void editPhoneDialog(PhoneListEntryI phone) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Edit Customer Phone");
        ButtonType okButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField countryTextField = new TextField();
        countryTextField.setText(phone.getCountryCode());
        countryTextField.setEditable(true);
        TextField numberTextField = new TextField();
        numberTextField.setText(phone.getPhoneNumber());
        numberTextField.setEditable(true);
        TextField timezoneTextField = new TextField();
        timezoneTextField.setText(phone.getTimezone());
        timezoneTextField.setEditable(true);
        grid.add((Node)new Label("Country:"), 0, 0);
        grid.add((Node)countryTextField, 1, 0);
        grid.add((Node)new Label("Phone Number:"), 0, 1);
        grid.add((Node)numberTextField, 1, 1);
        grid.add((Node)new Label("Time Zone:"), 0, 2);
        grid.add((Node)timezoneTextField, 1, 2);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> countryTextField.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return new Phone(countryTextField.getText(), numberTextField.getText(), timezoneTextField.getText());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(phoneresult -> {
            phone.setCountryCode(phoneresult.countryCode);
            phone.setPhoneNumber(phoneresult.phoneNumber);
            phone.setTimezone(phoneresult.timeZone);
            this.interactionExe.updateCustomerPhone(this.gui.getCurrentItemSelection().getId(), phone);
        });
    }

    private void editPostalAddressDialog(PostalAddressListEntryI address) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Edit Customer Address");
        ButtonType okButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField line1TextField = new TextField();
        line1TextField.setText(address.getLine1());
        line1TextField.setEditable(true);
        TextField line2TextField = new TextField();
        line2TextField.setText(address.getLine2());
        line2TextField.setEditable(true);
        TextField line3TextField = new TextField();
        line3TextField.setText(address.getLine3());
        line3TextField.setEditable(true);
        TextField line4TextField = new TextField();
        line4TextField.setText(address.getLine4());
        line4TextField.setEditable(true);
        TextField line5TextField = new TextField();
        line5TextField.setText(address.getLine5());
        line5TextField.setEditable(true);
        TextField countryTextField = new TextField();
        countryTextField.setText(address.getCountry());
        countryTextField.setEditable(true);
        TextField zipCodeTextField = new TextField();
        zipCodeTextField.setText(address.getZipcode());
        zipCodeTextField.setEditable(true);
        grid.add((Node)new Label("Line1:"), 0, 0);
        grid.add((Node)line1TextField, 1, 0);
        grid.add((Node)new Label("Line2:"), 0, 1);
        grid.add((Node)line2TextField, 1, 1);
        grid.add((Node)new Label("Line3:"), 0, 2);
        grid.add((Node)line3TextField, 1, 2);
        grid.add((Node)new Label("Line4:"), 0, 3);
        grid.add((Node)line4TextField, 1, 3);
        grid.add((Node)new Label("Line5:"), 0, 4);
        grid.add((Node)line5TextField, 1, 4);
        grid.add((Node)new Label("Country:"), 0, 5);
        grid.add((Node)countryTextField, 1, 5);
        grid.add((Node)new Label("Zip Code:"), 0, 6);
        grid.add((Node)zipCodeTextField, 1, 6);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> line1TextField.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return new Address(line1TextField.getText(), line2TextField.getText(), line3TextField.getText(), line4TextField.getText(), line5TextField.getText(), countryTextField.getText(), zipCodeTextField.getText());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(addressResult -> {
            address.setLine1(addressResult.line1);
            address.setLine2(addressResult.line2);
            address.setLine3(addressResult.line3);
            address.setLine4(addressResult.line4);
            address.setLine5(addressResult.line5);
            address.setCountry(addressResult.country);
            address.setZipcode(addressResult.zipCode);
            this.interactionExe.updateCustomerAddress(this.gui.getCurrentItemSelection().getId(), address);
        });
    }

    private class Address {
        public String line1;
        public String line2;
        public String line3;
        public String line4;
        public String line5;
        public String country;
        public String zipCode;

        public Address(String line1, String line2, String line3, String line4, String line5, String country, String zipCode) {
            this.line1 = line1;
            this.line2 = line2;
            this.line3 = line3;
            this.line4 = line4;
            this.line5 = line5;
            this.country = country;
            this.zipCode = zipCode;
        }
    }

    private class Phone {
        public String countryCode;
        public String phoneNumber;
        public String timeZone;

        public Phone(String countryCode, String phoneNumber, String timeZone) {
            this.countryCode = countryCode;
            this.phoneNumber = phoneNumber;
            this.timeZone = timeZone;
        }
    }

    private class CustomerName {
        public String title;
        public String firstName;
        public String lastName;

        public CustomerName(String t, String fN, String lN) {
            this.title = t;
            this.firstName = fN;
            this.lastName = lN;
        }
    }

    private class CustomerDataElement {
        public String name;
        public String value;
        public boolean editable;
        public Object data;

        public CustomerDataElement(String n, String v, boolean edit, Object data) {
            this.name = n;
            this.value = v;
            this.editable = edit;
            this.data = data;
        }
    }
}

