/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.enums.InteractionType;
import com.avaya.ccs.javafxrefclient.CallbackForm;
import com.avaya.ccs.javafxrefclient.ClientData;
import com.avaya.ccs.javafxrefclient.ClientDetailsForm;
import com.avaya.ccs.javafxrefclient.CodeSelectionForm;
import com.avaya.ccs.javafxrefclient.ConnectionDetails;
import com.avaya.ccs.javafxrefclient.ConsultForm;
import com.avaya.ccs.javafxrefclient.Executor;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.JoinForm;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.PreviewDialForm;
import com.avaya.ccs.javafxrefclient.RefClientProperties;
import com.avaya.ccs.javafxrefclient.ResourceDataGUI;
import com.avaya.ccs.javafxrefclient.SessionData;
import com.avaya.ccs.javafxrefclient.SessionDetailsForm;
import com.avaya.ccs.javafxrefclient.SupervisorDataGUI;
import com.avaya.ccs.javafxrefclient.UserDataGUI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JavaFXRefClient
extends Application {
    private static final Logger LOG = Logger.getLogger(JavaFXRefClient.class);
    private String css = "";
    private ConnectionDetails connectionDetails;
    private final int mainSceneWidth = 1600;
    private final int mainSceneHeight = 700;
    private SessionData sessionData = new SessionData(null);
    private UserDataGUI userGUI;
    private ClientData clientData = new ClientData(null);
    private SessionDetailsForm sessionDetailsForm;
    private ClientDetailsForm clientDetailsForm;
    private ResourceDataGUI resourceDataGUI;
    private InteractionDataGUI interactionDataGUI;
    private CodeSelectionForm codeSelection;
    private PreviewDialForm previewDial;
    private ConsultForm consultForm;
    private JoinForm joinForm;
    private SupervisorDataGUI supervisorDataGUI;
    private CallbackForm callbackForm;
    private MenuItem disconnect;
    private MenuItem signIn;
    private static Text connectionStatus;
    private static Text operationStatus;
    private final String styleSheetName = "javaClientStylesheet.css";
    private final String styleSheetDirectory = "css";

    public static void main(String[] args) {
        JavaFXRefClient.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        Thread.currentThread().setName("JavaFX");
        String methodName = "start() ";
        LOG.info(methodName + "Reading properties file", new Object[0]);
        RefClientProperties props = new RefClientProperties();
        this.connectionDetails = props.getConnectionDetails();
        URL url = ((Object)((Object)this)).getClass().getResource("/css/javaClientStylesheet.css");
        if (url == null && (url = ((Object)((Object)this)).getClass().getResource("javaClientStylesheet.css")) == null) {
            LOG.error(methodName + "Style sheet " + "javaClientStylesheet.css" + " not found", new Object[0]);
        }
        this.css = url.toExternalForm();
        Executor.createExecutors(this);
        this.codeSelection = new CodeSelectionForm(Executor.getUser(), Executor.getInteractionExe(), this.css);
        this.previewDial = new PreviewDialForm(Executor.getInteractionExe(), this.css);
        this.consultForm = new ConsultForm(Executor.getInteractionExe(), this.css, InteractionType.VoiceInteraction);
        this.joinForm = new JoinForm(Executor.getInteractionExe(), this.css);
        this.userGUI = new UserDataGUI(Executor.getClientSession(), Executor.getUser(), Executor.getInteractionExe(), this.css, this.codeSelection);
        this.sessionDetailsForm = new SessionDetailsForm(Executor.getClientSession(), this.css);
        this.clientDetailsForm = new ClientDetailsForm(Executor.getClientSession(), this.css);
        this.resourceDataGUI = new ResourceDataGUI(Executor.getResource(), this.css);
        this.callbackForm = new CallbackForm(Executor.getInteractionExe(), this.css);
        this.interactionDataGUI = new InteractionDataGUI(this.userGUI, Executor.getInteractionExe(), this.css, this.codeSelection, this.previewDial, this.consultForm, this.joinForm, this.callbackForm);
        this.supervisorDataGUI = new SupervisorDataGUI(Executor.getMonitored(), Executor.getInteractionExe(), this.css);
        BorderPane border = new BorderPane();
        border.setTop((Node)this.createMenuBar());
        border.setLeft((Node)this.interactionDataGUI.getSideBarVbox());
        border.setCenter((Node)this.createCenter());
        border.setBottom((Node)this.createStatusBar());
        primaryStage.setOnCloseRequest(event -> {
            LOG.trace("primaryStage.setOnCloseRequest(): Client window closed", new Object[0]);
            this.supervisorDataGUI.clearData();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Executor.close();
            System.exit(0);
        });
        Scene primaryScene = new Scene((Parent)border, 1600.0, 700.0);
        primaryScene.getStylesheets().add((Object)this.css);
        primaryStage.setTitle("Java ReferenceClient");
        primaryStage.setScene(primaryScene);
        primaryStage.show();
        this.setConnectionState();
        JavaFXRefClient.disableSslVerification();
    }

    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        menuBar.getStyleClass().add((Object)"mainMenuBar");
        Menu menuSession = new Menu("Session");
        this.signIn = new MenuItem("SignIn");
        this.signIn.setOnAction(t -> {
            LOG.info("SignInMenuItem()", new Object[0]);
            this.createUserLoginDialog();
        });
        this.disconnect = new MenuItem("Disconnect");
        this.disconnect.setOnAction(t -> {
            LOG.info("DisconnectMenuItem()", new Object[0]);
            this.supervisorDataGUI.clearData();
            Executor.getClientSession().disconnect();
        });
        MenuItem exit = new MenuItem("Exit");
        exit.setOnAction(t -> {
            LOG.info("ExitMenuItem()", new Object[0]);
            this.supervisorDataGUI.clearData();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Executor.close();
            System.exit(0);
        });
        menuSession.getItems().addAll((Object[])new MenuItem[]{this.signIn, this.disconnect, exit});
        Menu menuView = new Menu("View");
        MenuItem addSupervisor = new MenuItem("Supervisor Window");
        addSupervisor.setOnAction(t -> {
            LOG.info("SupervisorMenuItem()", new Object[0]);
            this.supervisorDataGUI.show();
        });
        menuView.getItems().addAll((Object[])new MenuItem[]{addSupervisor, this.clientDetailsForm.getMenuItem(), this.sessionDetailsForm.getMenuItem(), this.getUserGUI().getMenuItem(), this.getResourceDataGUI().getMenuitem(), this.interactionDataGUI.getMenuItem()});
        menuBar.getMenus().addAll((Object[])new Menu[]{menuSession, menuView});
        return menuBar;
    }

    private void createUserLoginDialog() {
        Dialog dialog = new Dialog();
        dialog.setTitle("SignIn Dialog");
        ButtonType signinButtonType = new ButtonType("SignIn", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{signinButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField dialogServer = new TextField();
        dialogServer.setPromptText("Server");
        dialogServer.setText(this.connectionDetails.getServer());
        TextField dialogUsername = new TextField();
        dialogUsername.setPromptText("Username");
        dialogUsername.setText(this.connectionDetails.getUsername());
        PasswordField dialogPassword = new PasswordField();
        dialogPassword.setPromptText("Password");
        dialogPassword.setText(this.connectionDetails.getPassword());
        CheckBox autoReconnect = new CheckBox();
        autoReconnect.setSelected(this.connectionDetails.isAutoReconnect());
        grid.add((Node)new Label("Server:"), 0, 0);
        grid.add((Node)dialogServer, 1, 0);
        grid.add((Node)new Label("Username:"), 0, 1);
        grid.add((Node)dialogUsername, 1, 1);
        grid.add((Node)new Label("Password:"), 0, 2);
        grid.add((Node)dialogPassword, 1, 2);
        grid.add((Node)new Label("AutoReconnect:"), 0, 3);
        grid.add((Node)autoReconnect, 1, 3);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> dialogUsername.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == signinButtonType) {
                return new ConnectionDetails(dialogUsername.getText(), dialogPassword.getText(), dialogServer.getText(), autoReconnect.selectedProperty().getValue());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(connectionDetails -> {
            LOG.trace("SignIn Selected - Username = " + connectionDetails.getUsername() + ", Password num of chars = " + connectionDetails.getPassword().length() + " server = " + connectionDetails.getServer() + " auto reconnect = " + connectionDetails.isAutoReconnect(), new Object[0]);
            this.connectionDetails = connectionDetails;
            Executor.getClientSession().signinClient((ConnectionDetails)connectionDetails);
        });
    }

    public VBox createCenter() {
        VBox vbox = new VBox();
        vbox.getStyleClass().add((Object)"vbox");
        vbox.getChildren().add((Object)this.getUserGUI().getUserControls());
        vbox.getChildren().add((Object)this.resourceDataGUI.getAddressButtons());
        vbox.getChildren().add((Object)this.interactionDataGUI.getInteractionTable());
        vbox.getChildren().add((Object)this.interactionDataGUI.getInteractionButtons());
        vbox.getChildren().add((Object)this.interactionDataGUI.getPOMButtons());
        return vbox;
    }

    public GridPane createStatusBar() {
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"statusBar");
        connectionStatus = new Text("");
        operationStatus = new Text("");
        Label clock = this.createClock();
        GridPane.setHalignment((Node)clock, (HPos)HPos.RIGHT);
        gridPane.add((Node)connectionStatus, 0, 0);
        gridPane.add((Node)operationStatus, 1, 0);
        gridPane.add((Node)clock, 2, 0);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(20.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(55.0);
        ColumnConstraints col3 = new ColumnConstraints();
        col3.setPercentWidth(25.0);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2, col3});
        return gridPane;
    }

    private Label createClock() {
        Label clock = new Label();
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), event -> {
            LocalDateTime timePoint = LocalDateTime.now();
            clock.setText(timePoint.format(DateTimeFormatter.ISO_DATE) + " " + timePoint.format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        }, new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.play();
        return clock;
    }

    public static void UpdateStatus(String newStatus) {
        operationStatus.setText(newStatus);
    }

    public static String getStatus() {
        return operationStatus.getText();
    }

    public void updateClientData(ClientData data) {
        String methodName = "updateClientData() ";
        this.clientData = data;
        if (this.clientData == null) {
            LOG.trace(methodName + "data == null, creating blank object", new Object[0]);
            this.clientData = new ClientData(null);
        }
        LOG.trace(methodName, new Object[0]);
        this.setConnectionState();
        this.clientDetailsForm.update(this.clientData.getClientProperties());
    }

    public void updateSessionData(SessionData data) {
        String methodName = "updateSessionData() ";
        this.sessionData = data;
        if (this.sessionData == null) {
            LOG.info(methodName + "data == null, session disconnected", new Object[0]);
            this.sessionData = new SessionData(null);
        }
        LOG.info(methodName + " SessionData:" + this.sessionData, new Object[0]);
        this.sessionDetailsForm.update(this.sessionData.getSessionProperties());
        if (!this.sessionData.isConnected()) {
            this.clearSessionData();
        }
    }

    public void setConnectionState() {
        String methodName = "setConnectionState() ";
        boolean canDisconnect = false;
        boolean canSignIn = false;
        Status status = Status.Red;
        switch (this.clientData.getState()) {
            default: {
                canDisconnect = false;
                canSignIn = true;
                this.supervisorDataGUI.removeData();
                break;
            }
            case CONNECTING: 
            case CONNECTED: {
                canDisconnect = true;
                canSignIn = false;
                break;
            }
            case AUTHENTICATED: {
                canDisconnect = true;
                canSignIn = false;
                LOG.clearStatus();
                if (this.clientData.isHa()) {
                    if (this.clientData.isHaOperational()) {
                        status = Status.Green;
                        break;
                    }
                    status = Status.Orange;
                    break;
                }
                status = Status.Green;
            }
        }
        this.disconnect.setDisable(!canDisconnect);
        this.signIn.setDisable(!canSignIn);
        LOG.info(methodName + "new state = " + this.clientData.getState().name() + " status = " + status.name(), new Object[0]);
        switch (status) {
            case Red: {
                connectionStatus.fillProperty().set((Object)Color.RED);
                break;
            }
            case Orange: {
                connectionStatus.fillProperty().set((Object)Color.ORANGE);
                break;
            }
            case Green: {
                connectionStatus.fillProperty().set((Object)Color.GREEN);
            }
        }
        connectionStatus.setText(this.clientData.getState().name());
    }

    public void clearSessionData() {
        String methodName = "clearSessionData() ";
        LOG.info(methodName + "session disconnected, invalidate all session related state as no delete events will be received", new Object[0]);
        this.getUserGUI().clearData();
        this.getResourceDataGUI().clearData();
        this.getSupervisorGUI().clearData();
        this.getInteractionDataGUI().clearData();
    }

    public UserDataGUI getUserGUI() {
        return this.userGUI;
    }

    public SupervisorDataGUI getSupervisorGUI() {
        return this.supervisorDataGUI;
    }

    public ResourceDataGUI getResourceDataGUI() {
        return this.resourceDataGUI;
    }

    public InteractionDataGUI getInteractionDataGUI() {
        return this.interactionDataGUI;
    }

    private static enum Status {
        Red,
        Green,
        Orange;

    }
}

