/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredInteractionData;
import com.avaya.ccs.javafxrefclient.SupervisorDataGUI;
import javafx.concurrent.Task;

public class MonitoredInteractionEventTask
extends Task<MonitoredInteractionData> {
    private final NotificationEventI<MonitoredInteractionI> interaction;
    private final SupervisorDataGUI gui;
    private static final Logger LOG = Logger.getLogger(MonitoredInteractionEventTask.class);

    public MonitoredInteractionEventTask(NotificationEventI<MonitoredInteractionI> resource, SupervisorDataGUI gui) {
        this.interaction = resource;
        this.gui = gui;
        this.setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            MonitoredInteractionData value = (MonitoredInteractionData)t.getSource().getValue();
            if (value != null) {
                if (!value.isDeleted()) {
                    LOG.info(methodName + "MonitoredInteractionData:" + value, new Object[0]);
                } else {
                    LOG.info(methodName + "Deletion of MonitoredInteractionData-ID:" + value.getId(), new Object[0]);
                }
                this.gui.updateMonitoredInteraction(value);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }

    protected MonitoredInteractionData call() throws Exception {
        String methodName = "call() ";
        MonitoredInteractionData data = null;
        NotificationType type = this.interaction.getNotificationType();
        LOG.debug(methodName + "Type:" + type + " ID:" + ((MonitoredInteractionI)this.interaction.getNotificationObject()).getId(), new Object[0]);
        switch (type) {
            case UPDATE: {
                LOG.debug(methodName + "UPDATE:", new Object[0]);
                data = new MonitoredInteractionData((MonitoredInteractionI)this.interaction.getNotificationObject());
                break;
            }
            case DELETE: {
                LOG.debug(methodName + "DELETE:", new Object[0]);
                data = new MonitoredInteractionData(((MonitoredInteractionI)this.interaction.getNotificationObject()).getId(), true);
                break;
            }
            case ERROR: {
                LOG.errorStatus(this.interaction.getError());
                break;
            }
            case NEW: {
                LOG.debug(methodName + "NEW:", new Object[0]);
                data = new MonitoredInteractionData((MonitoredInteractionI)this.interaction.getNotificationObject());
                break;
            }
            case RESPONSE: {
                LOG.debug(methodName + "RESPONSE:", new Object[0]);
                break;
            }
            case UNKNOWN: {
                LOG.debug(methodName + "UNKNOWN:", new Object[0]);
            }
        }
        LOG.trace(methodName + "InteractionData " + (data == null ? "<NULL>" : data.toString()), new Object[0]);
        return data;
    }
}

