/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UUITabBase;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class UUITab
extends UUITabBase {
    private final Button save;
    private final InteractionExecutor interactionExe;
    private final InteractionDataGUI gui;
    private static final Logger LOG = Logger.getLogger(UUITab.class);

    public UUITab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        this.interactionExe = interactionExe;
        this.gui = gui;
        HBox buttons = new HBox();
        this.save = new Button("Save");
        this.save.setDisable(true);
        this.save.getStyleClass().add((Object)"intrinsicButton");
        this.save.setOnAction(t -> {
            String text = this.uuiEditor.getText();
            LOG.info("SaveButton() Text:" + text, new Object[0]);
            this.saveUUIDialog(text);
        });
        buttons.getChildren().addAll((Object[])new Node[]{this.save});
        this.uuiPane.setBottom((Node)buttons);
    }

    private void saveUUIDialog(String newUUI) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Save UUI");
        ButtonType saveButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{saveButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField uui = new TextField();
        uui.setText(newUUI);
        grid.add((Node)new Label("UUI:"), 0, 0);
        grid.add((Node)uui, 1, 0);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> uui.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == saveButtonType) {
                return uui.getText();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(uuiResult -> {
            String methodName = "saveUUIDialog() ";
            LOG.trace(methodName + " UUI:" + uuiResult, new Object[0]);
            this.interactionExe.setUUI(this.gui.getCurrentItemSelection().getId(), (String)uuiResult);
        });
    }

    @Override
    void update(InteractionDataI data) {
        String methodName = "update() ";
        LOG.trace(methodName + "+", new Object[0]);
        boolean disable = false;
        LOG.trace(methodName + "disable = " + disable, new Object[0]);
        this.tab.setDisable(disable);
        this.uuiEditor.setDisable(disable);
        this.save.setDisable(!data.canSetUUI());
        String uuiData = data.getUui();
        if (uuiData != null) {
            LOG.trace(methodName + "UUI:" + uuiData, new Object[0]);
            this.uuiEditor.setText(uuiData);
        } else {
            LOG.trace(methodName + "setting blank txt", new Object[0]);
            this.uuiEditor.setText("no UUI to display");
        }
        LOG.trace(methodName + "-", new Object[0]);
    }
}

