/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.javafxrefclient.AgentSignatureForm;
import com.avaya.ccs.javafxrefclient.ClientSessionExecutor;
import com.avaya.ccs.javafxrefclient.CodeSelectionForm;
import com.avaya.ccs.javafxrefclient.ComboDataGUI;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UserData;
import com.avaya.ccs.javafxrefclient.UserDetailsForm;
import com.avaya.ccs.javafxrefclient.UserExecutor;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class UserDataGUI
extends ComboDataGUI {
    private final HBox userButtonsHolder = new HBox();
    private final HBox userStatusHolder = new HBox();
    private final VBox userHolder = new VBox();
    private final Button buttonAgentLogin;
    private final Button buttonAgentReady;
    private final Button buttonAgentNotReady;
    private final Button buttonAgentNotReadyWithReason;
    private final Button buttonAgentACW;
    private final Button originateEmailButton;
    private final Button agentSignatureButton;
    InteractionExecutor interactionExe;
    private final Label agentStatus;
    private final Label pomStatus;
    private final Label userSyncStatus;
    private final String goReadyButtonText = "Ready";
    private final String goNotReadyButtonText = "NotReady";
    private final String goNotReadyWithReasonButtonText = "NotReadyWithReason";
    private final String goACWButtonText = "ACW";
    private final String loginButtonText = "Login";
    private final String logoutButtonText = "Logout";
    private final CodeSelectionForm codeSelection;
    private static final Logger LOG = Logger.getLogger(UserDataGUI.class);

    public UserDataGUI(ClientSessionExecutor clientSessionExe, UserExecutor userExe, InteractionExecutor interactionExe, String css, CodeSelectionForm codeSelection) {
        super(LOG);
        this.codeSelection = codeSelection;
        this.setDetailsForm(new UserDetailsForm(userExe, css, this));
        this.userButtonsHolder.getStyleClass().add((Object)"hbox");
        this.userStatusHolder.getStyleClass().add((Object)"hbox");
        this.interactionExe = interactionExe;
        this.buttonAgentLogin = new Button("Login");
        this.buttonAgentLogin.getStyleClass().add((Object)"agentButton");
        this.buttonAgentLogin.setOnAction(e -> {
            String methodName = "agentLoginButton() ";
            if (this.getUser((String)this.getItemSelection().getValue()).canLogout()) {
                userExe.logout(this.getUser((String)this.getItemSelection().getValue()).getId());
            } else if (this.getUser((String)this.getItemSelection().getValue()).canLogin()) {
                Dialog dialog = new Dialog();
                dialog.setTitle("Agent Login");
                ButtonType signinButtonType = new ButtonType("Login", ButtonBar.ButtonData.OK_DONE);
                dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{signinButtonType, ButtonType.CANCEL});
                GridPane grid = new GridPane();
                grid.getStyleClass().add((Object)"dialog");
                TextField dialogUsername = new TextField();
                dialogUsername.setPromptText("AgentID");
                dialogUsername.setText(this.getUser((String)this.getItemSelection().getValue()).getLoginId());
                dialogUsername.setEditable(false);
                PasswordField dialogPassword = new PasswordField();
                dialogPassword.setPromptText("Password");
                grid.add((Node)new Label("AgentID:"), 0, 0);
                grid.add((Node)dialogUsername, 1, 0);
                grid.add((Node)new Label("Password:"), 0, 1);
                grid.add((Node)dialogPassword, 1, 1);
                List<String> zones = this.getUser((String)this.getItemSelection().getValue()).getPomZones();
                ComboBox zoneList = new ComboBox(FXCollections.observableList(zones));
                zoneList.getSelectionModel().selectFirst();
                grid.add((Node)new Label("POM Zone:"), 0, 2);
                grid.add((Node)zoneList, 1, 2);
                dialog.getDialogPane().setContent((Node)grid);
                Platform.runLater(() -> dialogUsername.requestFocus());
                dialog.setResultConverter(dialogButton -> {
                    if (dialogButton == signinButtonType) {
                        return new LoginDetails(dialogUsername.getText(), dialogPassword.getText(), (String)zoneList.getValue());
                    }
                    return null;
                });
                Optional result = dialog.showAndWait();
                result.ifPresent(loginDetails -> {
                    LOG.info(methodName + "Username:" + loginDetails.username + " Password length:" + loginDetails.password.length() + " zone:" + (loginDetails.zone == null ? "NULL" : loginDetails.zone), new Object[0]);
                    userExe.login(this.getUser((String)this.getItemSelection().getValue()).getId(), loginDetails.password, loginDetails.zone);
                });
            }
        });
        this.buttonAgentReady = new Button("Ready");
        this.buttonAgentReady.getStyleClass().add((Object)"agentButton");
        this.buttonAgentReady.setOnAction(e -> {
            String userId = this.getUser((String)this.getItemSelection().getValue()).getId();
            LOG.info("ReadyButton() UserID:" + userId, new Object[0]);
            userExe.ready(userId);
        });
        this.buttonAgentNotReady = new Button("NotReady");
        this.buttonAgentNotReady.setOnAction(e -> {
            String userId = this.getUser((String)this.getItemSelection().getValue()).getId();
            LOG.info("NotReadyButton() UserID:" + userId, new Object[0]);
            userExe.notReady(userId, null);
        });
        this.buttonAgentNotReadyWithReason = new Button("NotReadyWithReason");
        this.buttonAgentNotReadyWithReason.setOnAction(e -> {
            LOG.info("NotReadyWithReasonButton() ", new Object[0]);
            clientSessionExe.getSessionCodes(CodeType.NRRC);
            codeSelection.show();
        });
        this.buttonAgentACW = new Button("ACW");
        this.buttonAgentACW.setOnAction(e -> {
            LOG.info("ACWButton() ", new Object[0]);
            clientSessionExe.getSessionCodes(CodeType.ACW);
            codeSelection.show();
        });
        this.originateEmailButton = new Button("New Email");
        this.originateEmailButton.getStyleClass().add((Object)"agentButton");
        this.originateEmailButton.setOnAction(e -> userExe.originateEmail((String)this.getItemSelection().getValue()));
        this.agentSignatureButton = new Button("Edit signature");
        this.agentSignatureButton.getStyleClass().add((Object)"agentButton");
        this.agentSignatureButton.setOnAction(e -> {
            AgentSignatureForm newForm = new AgentSignatureForm((String)this.getItemSelection().getValue(), userExe, this.getUser((String)this.getItemSelection().getValue()).getAgentSignature(), css);
            newForm.show();
        });
        this.userButtonsHolder.getChildren().addAll((Object[])new Node[]{this.getItemSelection(), this.buttonAgentLogin, this.buttonAgentReady, this.buttonAgentNotReady, this.buttonAgentNotReadyWithReason, this.buttonAgentACW, this.originateEmailButton});
        this.userButtonsHolder.setAlignment(Pos.CENTER_LEFT);
        this.agentStatus = new Label();
        this.pomStatus = new Label();
        this.userSyncStatus = new Label();
        this.agentStatus.setPrefWidth(80.0);
        this.pomStatus.setPrefWidth(120.0);
        this.userStatusHolder.getChildren().addAll((Object[])new Node[]{this.agentStatus, this.pomStatus, this.userSyncStatus});
        this.userStatusHolder.setAlignment(Pos.CENTER_LEFT);
        this.userHolder.getChildren().addAll((Object[])new Node[]{this.userButtonsHolder, this.userStatusHolder});
        this.redrawControls();
    }

    public MenuItem getMenuItem() {
        return this.getDetailsForm().getMenuItem();
    }

    private UserData getCurrentUserSelection() {
        String methodName = "getCurrentUserSelection() ";
        Data currentUser = this.getCurrentItemSelection();
        if (currentUser != null) {
            return (UserData)currentUser;
        }
        LOG.trace(methodName + "current selection is NULL, returning blank", new Object[0]);
        return new UserData(null);
    }

    public UserData getUser(String id) {
        return (UserData)this.getItem(id);
    }

    public VBox getUserControls() {
        return this.userHolder;
    }

    @Override
    protected void redrawControls() {
        String methodName = "redrawControls() ";
        UserData user = this.getCurrentUserSelection();
        LOG.trace(methodName + " UserID:" + user.getId(), new Object[0]);
        String status = user.getState().toString();
        if (user.getCode() != null) {
            status = status + ":" + user.getCode().getName() + ":" + user.getCode().getNumber();
        }
        this.agentStatus.setText(status);
        this.agentStatus.setPrefWidth((double)(10 * (status.length() + 1)));
        String pomState = "";
        pomState = user.isPomNailedUp() ? pomState + "NailedUP" : pomState + "NotNailedUP";
        this.pomStatus.setText(pomState);
        this.pomStatus.setPrefWidth((double)(10 * (pomState.length() + 1)));
        this.pomStatus.setVisible(user.getContactTypes().contains(ContactType.POM_Outbound));
        this.userSyncStatus.setText(user.getUserSyncStatus().name());
        switch (user.getUserSyncStatus()) {
            case LoginRequired: 
            case LogoutRequired: 
            case ToggleReady: 
            case ProviderUnavailable: {
                this.userSyncStatus.setVisible(true);
                JavaFXRefClient.UpdateStatus(user.getId() + ":" + user.getUserSyncMessage());
                break;
            }
            case Synchronised: {
                if (JavaFXRefClient.getStatus().contains(user.getId())) {
                    JavaFXRefClient.UpdateStatus("");
                }
            }
            default: {
                this.userSyncStatus.setVisible(false);
            }
        }
        if (user.canLogin()) {
            this.buttonAgentLogin.setText("Login");
            this.buttonAgentLogin.setDisable(false);
        } else if (user.canLogout()) {
            this.buttonAgentLogin.setText("Logout");
            this.buttonAgentLogin.setDisable(false);
        } else {
            this.buttonAgentLogin.setDisable(true);
        }
        this.buttonAgentReady.setDisable(!user.canReady());
        this.buttonAgentNotReady.setDisable(!user.canNotReady());
        this.buttonAgentNotReadyWithReason.setDisable(!user.canNotReady());
        this.buttonAgentACW.setDisable(!user.canAfterCallWork());
        this.originateEmailButton.setDisable(!user.getContactTypes().contains(ContactType.EMail) || !user.canLogout());
    }

    public void setAgentNotReady() {
        LOG.debug("setAgentNotReady() fired", new Object[0]);
        this.buttonAgentNotReady.fire();
    }

    public void updateCodeSectionForm(CodeListI codes) {
        this.codeSelection.updateCodeSectionForm(codes, this.getCurrentUserSelection().getId());
    }

    public void UpdateUserData(List<UserData> data) {
        ObservableList newData = FXCollections.observableArrayList();
        newData.addAll(data);
        this.update((ObservableList<Data>)newData);
    }

    public void UpdateUserData(UserData data) {
        this.update(data);
    }

    private class LoginDetails {
        public String username;
        public String password;
        public String zone;

        public LoginDetails(String username, String password, String zone) {
            this.username = username;
            this.password = password;
            this.zone = zone;
        }
    }

    static class CodeCell
    extends ListCell<ContactCenterCodeI> {
        CodeCell() {
        }

        public void updateItem(ContactCenterCodeI item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getName() + ":" + item.getNumber().toString());
            }
        }
    }
}

