/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.ClientI;
import com.avaya.ccs.api.ClientListenerI;
import com.avaya.ccs.api.SessionListenerI;
import com.avaya.ccs.api.enums.Profile;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.javafxrefclient.ClientSessionExecutor;
import com.avaya.ccs.javafxrefclient.ConnectionDetails;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.request.Request;

public class SignInRequest
extends Request {
    private static final Logger LOG = Logger.getLogger(SignInRequest.class);
    private final ClientSessionExecutor clientSessionExe;
    private final ConnectionDetails connectionDetails;

    public SignInRequest(ClientSessionExecutor clientSessionExe, ConnectionDetails connectionDetails) {
        super(LOG);
        this.clientSessionExe = clientSessionExe;
        this.connectionDetails = connectionDetails;
    }

    protected Object call() throws Exception {
        String methodName = "call() ";
        if (this.getClient() == null) {
            ClientI client = ClientI.create((String)this.connectionDetails.getServer(), (Profile)Profile.AgentDesktop, (String)"JavaFxCcsReferenceClient", null);
            this.clientSessionExe.setClient(client);
            this.setClient(client);
        }
        this.getClient().setAutoReconnect(this.connectionDetails.isAutoReconnect());
        this.getClient().setServer(this.connectionDetails.getServer());
        if (this.getClient().getSession() == null) {
            LOG.trace(methodName + "session == null", new Object[0]);
            try {
                this.getClient().signin(this.connectionDetails.getUsername(), this.connectionDetails.getPassword(), (SessionListenerI)this.clientSessionExe, (ClientListenerI)this.clientSessionExe);
            }
            catch (InvalidArgumentException ex) {
                return ex;
            }
            LOG.trace(methodName + "signin -", new Object[0]);
            return null;
        }
        LOG.trace(methodName + "session != null, signin ignored", new Object[0]);
        return null;
    }
}

