/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum ResourceState {
    Invalid,
    OutOfService,
    InService,
    Unknown;

    static Map<String, ResourceState> stateMap;

    @JsonCreator
    static ResourceState get(String stateName) {
        ResourceState state = stateMap.get(stateName);
        if (state == null) {
            state = Unknown;
        }
        return state;
    }

    static {
        stateMap = new HashMap<String, ResourceState>();
        for (ResourceState state : ResourceState.values()) {
            stateMap.put(state.toString(), state);
        }
    }
}

