/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.core.CustomerData;
import com.avaya.ccs.core.CustomerDetails;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class CustomerSearchTab {
    private static final Logger LOG = Logger.getLogger(CustomerSearchTab.class);
    private final Tab tab;
    private final InteractionExecutor interactionExe;
    private ObservableList<CustomerDetails> searchResults = FXCollections.observableArrayList();
    private ListView<CustomerDetails> searchResultsListView = new ListView();
    VBox root;
    VBox allSearchRowsVBox;
    ObservableList<String> keys = FXCollections.observableArrayList();
    ObservableList<String> conditions = FXCollections.observableArrayList();
    List<Query> allQueries;

    private void addSearchRow() {
        ComboBox subjectCB = new ComboBox(this.keys);
        ComboBox operatorsCB = new ComboBox(this.conditions);
        TextField searchValueTf = new TextField();
        Button addRowButton = new Button("+");
        HBox thisRowHbox = new HBox(5.0);
        addRowButton.setOnAction(t -> this.addSearchRow());
        thisRowHbox.getChildren().addAll((Object[])new Node[]{subjectCB, operatorsCB, searchValueTf, addRowButton});
        this.allSearchRowsVBox.getChildren().add((Object)thisRowHbox);
    }

    public CustomerSearchTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        this.tab = new Tab();
        this.tab.setText("Customer Search");
        this.tab.setClosable(false);
        this.interactionExe = interactionExe;
        Label searchCriteriaLbl = new Label("Search Criteria");
        this.allQueries = new ArrayList<Query>();
        this.allSearchRowsVBox = new VBox(5.0);
        this.root = new VBox(5.0);
        this.keys.addAll(Arrays.asList("FirstName", "LastName", "PreferredAgent", "Address", "EmailAddress", "PhoneNumber", "SIPURI"));
        this.conditions.addAll(Arrays.asList("Contains", "Begins With", "Ends With", "Is", "Is Not"));
        Button btnSearch = new Button("Search");
        Button btnClear = new Button("Clear");
        HBox searchButtons = new HBox(5.0);
        searchButtons.getChildren().addAll((Object[])new Node[]{btnSearch, btnClear});
        this.addSearchRow();
        this.root.getChildren().addAll((Object[])new Node[]{searchCriteriaLbl, this.allSearchRowsVBox, searchButtons, this.searchResultsListView});
        btnClear.setOnAction(t -> {
            this.allQueries.clear();
            for (int i = 0; i < this.allSearchRowsVBox.getChildren().size(); ++i) {
                this.allSearchRowsVBox.getChildren().remove(i);
            }
            this.addSearchRow();
            HBox firstRow = (HBox)this.allSearchRowsVBox.getChildren().get(0);
            ComboBox subj = (ComboBox)firstRow.getChildren().get(0);
            subj.getSelectionModel().clearSelection();
            ComboBox cond = (ComboBox)firstRow.getChildren().get(1);
            cond.getSelectionModel().clearSelection();
            TextField val = (TextField)firstRow.getChildren().get(2);
            val.setText("");
            this.searchResults.clear();
        });
        btnSearch.setOnAction(t -> {
            this.allQueries.clear();
            this.searchResults.clear();
            for (int i = 0; i < this.allSearchRowsVBox.getChildren().size(); ++i) {
                HBox thisQuery = (HBox)this.allSearchRowsVBox.getChildren().get(i);
                ComboBox subj = (ComboBox)thisQuery.getChildren().get(0);
                ComboBox cond = (ComboBox)thisQuery.getChildren().get(1);
                TextField val = (TextField)thisQuery.getChildren().get(2);
                Query q = new Query(((String)subj.getValue()).toString(), ((String)cond.getValue()).toString(), val.getText());
                this.allQueries.add(q);
            }
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("{\"SearchCriteriaList\":[");
            for (int i = 0; i < this.allQueries.size(); ++i) {
                queryBuilder.append("{\"Key\":\"" + this.allQueries.get((int)i).key + "\",\"Condition\":\"" + this.allQueries.get((int)i).condition + "\",\"Value\":\"" + this.allQueries.get((int)i).value + "\"}");
                if (i >= this.allQueries.size() - 1) continue;
                queryBuilder.append(",");
            }
            queryBuilder.append("]}");
            LOG.info("CustomerSearchTab. Query: " + queryBuilder.toString(), new Object[0]);
            this.interactionExe.searchCustomers(queryBuilder.toString());
        });
        this.searchResultsListView.setItems(this.searchResults);
        this.tab.setContent((Node)this.root);
        this.tab.setDisable(false);
    }

    public Tab getTab() {
        return this.tab;
    }

    public void setSearchResults(CustomerData c) {
        List<CustomerDetails> items = Arrays.asList(c.getCustomerList().getCustomerList());
        items.stream().forEach(i -> this.searchResults.add(i));
    }
}

