/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class JoinForm {
    private final Stage join = new Stage();
    private final InteractionExecutor interactionExe;
    private static final Logger LOG = Logger.getLogger(JoinForm.class);

    public JoinForm(InteractionExecutor interactionExe, String css) {
        this.interactionExe = interactionExe;
        BorderPane joinBorder = new BorderPane();
        Scene joinScene = new Scene((Parent)joinBorder, 300.0, 400.0);
        joinScene.getStylesheets().add((Object)css);
        this.join.setScene(joinScene);
        this.join.titleProperty().set((Object)"Join");
    }

    public void show() {
        this.join.show();
    }

    public void updateJoinForm(List<InteractionData> numbers, String interactionID) {
        BorderPane bp = (BorderPane)((Scene)this.join.sceneProperty().get()).getRoot();
        ListView list = new ListView();
        ObservableList items = FXCollections.observableArrayList(numbers);
        list.setItems(items);
        list.setCellFactory((Callback)new Callback<ListView<InteractionData>, ListCell<InteractionData>>(){

            public ListCell<InteractionData> call(ListView<InteractionData> list) {
                return new CodeCell();
            }
        });
        final Button joinButton = new Button("Join");
        joinButton.setDisable(true);
        list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<InteractionData>(){

            public void changed(ObservableValue<? extends InteractionData> observable, InteractionData oldValue, InteractionData newValue) {
                if (newValue != null) {
                    joinButton.setDisable(false);
                }
            }
        });
        bp.setCenter((Node)list);
        joinButton.getStyleClass().add((Object)"interactionButton");
        joinButton.setOnAction(t -> {
            LOG.info("JoinButton()", new Object[0]);
            InteractionData selectedInteraction = (InteractionData)list.getSelectionModel().getSelectedItem();
            this.interactionExe.join(interactionID, selectedInteraction.getId());
            this.join.close();
        });
        Button cancelButton = new Button("Cancel");
        cancelButton.getStyleClass().add((Object)"interactionButton");
        cancelButton.setOnAction(t -> {
            LOG.info("CancelButton()", new Object[0]);
            this.join.close();
        });
        HBox hbuttonbox = new HBox();
        hbuttonbox.getChildren().addAll((Object[])new Node[]{joinButton, cancelButton});
        VBox v = new VBox();
        v.getChildren().addAll((Object[])new Node[]{hbuttonbox});
        bp.setBottom((Node)v);
    }

    private static class CodeCell
    extends ListCell<InteractionData> {
        private CodeCell() {
        }

        public void updateItem(InteractionData item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getContactID());
            }
        }
    }
}

