/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.DataI;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.request.InteractionRequest;
import java.util.Map;

public class RemoveKVPDataRequest
extends InteractionRequest {
    private static final Logger LOG = Logger.getLogger(RemoveKVPDataRequest.class);
    private String name = null;

    public RemoveKVPDataRequest(String interactionID, String newName) {
        super(LOG, interactionID);
        this.name = newName;
    }

    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+", new Object[0]);
        InteractionI interaction = this.getInteraction();
        DataI data = interaction.getData();
        if (data == null) {
            LOG.error(methodName + " no exisitng data found for interaction with ID:" + interaction.getId(), new Object[0]);
        } else {
            Map kvpData = data.getKvpData();
            if (kvpData == null) {
                LOG.error(methodName + " no exisitng KVP data found for interaction with ID:" + interaction.getId(), new Object[0]);
            } else {
                kvpData.remove(this.name);
                if (kvpData.isEmpty()) {
                    LOG.trace(methodName + " last entry in kvp data has been removed, delete all data", new Object[0]);
                    interaction.removeData();
                } else {
                    data = DataI.create((Map)kvpData);
                    interaction.setData(data);
                }
            }
        }
        LOG.trace(methodName + "-", new Object[0]);
        return null;
    }
}

