/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.core.Channel;
import com.avaya.ccs.core.Client;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Error;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.WebSocket;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ProtocolHandler {
    private static Logger log = Logger.getLogger(ProtocolHandler.class);
    private WebSocket socket;
    private Channel channel;
    private static ObjectMapper JSON_MAPPER = new ObjectMapper();

    ProtocolHandler(String server, Channel channel, SslContextFactory sslContextFactory) {
        boolean isSecure = sslContextFactory != null;
        this.channel = channel;
        String wsURI = (isSecure ? "wss" : "ws") + "://" + server + "/IntegrationPortal/SessionHandler.ashx?Service=CCS";
        log.info("<init>", "URI is '", wsURI, "'");
        this.socket = isSecure ? new WebSocket(wsURI, this, sslContextFactory) : new WebSocket(wsURI, this, null);
    }

    static ObjectMapper getJsonObjectMapper() {
        return JSON_MAPPER;
    }

    Channel getChannel() {
        return this.channel;
    }

    void connect() {
        this.socket.connect();
    }

    void disconnect() {
        this.socket.disconnect();
    }

    void send(ProtocolRequestType reqType, String path, CommandArgs commandArgs, String data) {
        switch (reqType) {
            case POST: {
                this.sendPost(path, commandArgs, data);
                break;
            }
            case GET: {
                this.sendGet(path, commandArgs, data);
                break;
            }
            case OPEN: {
                this.sendOpen(path);
                break;
            }
            case CLOSE: {
                this.sendClose(path, commandArgs);
                break;
            }
        }
    }

    private void sendPost(String path, CommandArgs commandArgs, String data) {
        String methodName = "sendPost";
        if (commandArgs == null) {
            log.error(methodName, "command arguments are null, cannot send request!");
            return;
        }
        String request = (Object)((Object)ProtocolRequestType.POST) + " " + path + commandArgs.toString() + (data != null ? "\n" + data : "");
        if (!Client.labEnvironment) {
            log.debug(methodName, this, "\n", (Object)((Object)ProtocolRequestType.POST) + " " + path + (commandArgs.containsSensitiveContent() ? "?" + commandArgs.getCommand() : commandArgs.toString()));
        } else {
            log.info(methodName, this, "\n", request);
        }
        this.socket.send(request);
    }

    private void sendOpen(String path) {
        String request = (Object)((Object)ProtocolRequestType.OPEN) + " " + path;
        log.debug("sendOpen", this, "\n", request);
        this.socket.send(request);
    }

    private void sendClose(String path, CommandArgs args) {
        String request = (Object)((Object)ProtocolRequestType.CLOSE) + " " + path + (args != null ? args.toString() : "");
        log.info("sendClose", this, "\n", request);
        this.socket.send(request);
    }

    private void sendGet(String path, CommandArgs commandArgs, String data) {
        if (commandArgs == null) {
            log.error("sendGet", "command arguments are null, cannot send request!");
            return;
        }
        String request = (Object)((Object)ProtocolRequestType.GET) + " " + path + commandArgs.toString() + (data != null ? "\n" + data : "");
        log.debug("sendGet", this, "\n", request);
        this.socket.send(request);
    }

    void onConnect() {
        this.channel.execute(() -> {
            String methodName = "onConnect";
            log.info(methodName, this.socket);
            this.getChannel().onSocketConnect();
        }, "ProtocolHandler.onConnect()");
    }

    void onClose(int status, String reason) {
        this.channel.execute(() -> {
            String methodName = "onClose";
            log.info(methodName, this.socket, ", Status=", status, " Reason=", reason);
            this.getChannel().onSocketClosed(status, reason);
            this.channel = null;
            this.socket = null;
        }, "ProtocolHandler.onClose()");
    }

    void onError(Throwable t) {
        this.channel.execute(() -> {
            String methodName = "onError";
            log.error(methodName, t, "" + this.socket);
            this.getChannel().onSocketError(t);
        }, "ProtocolHandler.onError()");
    }

    void onMessage(String msg) {
        this.channel.execute(() -> this.receivedMessage(msg), "ProtocolHandler.onMessage()");
    }

    private void receivedMessage(String msg) {
        String methodName = "receivedMessage";
        String jsonObjectPayload = null;
        try {
            NotificationDescription objectDescription;
            int indexOfFirstBrace = msg.indexOf(123);
            NotificationType type = NotificationType.get(msg.substring(0, indexOfFirstBrace));
            if (type == NotificationType.ERROR) {
                String jsonErrorDescription = msg.substring(indexOfFirstBrace);
                objectDescription = (NotificationDescription)JSON_MAPPER.readValue(jsonErrorDescription, Error.class);
            } else if (type == NotificationType.RESPONSE) {
                String jsonObjectDesc;
                int indexDescPayloadSplitPattern = msg.indexOf("}-{");
                if (indexDescPayloadSplitPattern == -1) {
                    jsonObjectDesc = msg.substring(msg.indexOf(123), msg.indexOf(125) + 1);
                } else {
                    jsonObjectDesc = msg.substring(msg.indexOf(123), indexDescPayloadSplitPattern + 1);
                    jsonObjectPayload = msg.substring(indexDescPayloadSplitPattern + 2);
                }
                objectDescription = (NotificationDescription)JSON_MAPPER.readValue(jsonObjectDesc, NotificationDescription.class);
            } else {
                String jsonObjectDesc;
                int indexDescPayloadSplitPattern = msg.indexOf("}-{");
                if (indexDescPayloadSplitPattern == -1) {
                    jsonObjectDesc = msg.substring(msg.indexOf(123), msg.indexOf(125) + 1);
                } else {
                    jsonObjectDesc = msg.substring(msg.indexOf(123), indexDescPayloadSplitPattern + 1);
                    jsonObjectPayload = msg.substring(indexDescPayloadSplitPattern + 2);
                }
                objectDescription = (NotificationDescription)JSON_MAPPER.readValue(jsonObjectDesc, NotificationDescription.class);
            }
            if (!Client.labEnvironment) {
                log.debug(methodName, new Object[]{this.socket, " ", type, objectDescription.toJsonString()});
            } else {
                log.info(methodName, this.socket, "\n\n", msg, "\n");
            }
            this.getChannel().onNotification(type, objectDescription, jsonObjectPayload);
        }
        catch (Exception e) {
            log.error(methodName, e);
        }
    }

    public String toString() {
        return "[ProtocolHandler " + this.socket + "]";
    }

    static {
        JSON_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static enum ProtocolRequestType {
        GET,
        POST,
        OPEN,
        CLOSE;

    }
}

