/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.api.DestinationListI;
import com.avaya.ccs.api.enums.DestinationType;
import com.avaya.ccs.api.enums.InteractionType;
import com.avaya.ccs.core.EmailMedia;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.EmailForm;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MediaFormI;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class ConsultForm {
    private final Stage form = new Stage();
    private static final Logger LOG = Logger.getLogger(ConsultForm.class);
    RelocationType relocationType;
    private final InteractionExecutor interactionExe;
    private final ObservableList<DestinationI> destinationsOL = FXCollections.observableArrayList();
    private String currentInteractionID;
    private ListView<DestinationI> destinationsLV = new ListView();
    private InteractionType interactionType;
    private Media media;
    private MediaFormI mediaForm;
    private String agentSignature = "";
    private boolean mediaSet;

    public ConsultForm(InteractionExecutor interactionExe, String css, InteractionType interactionType) {
        this.interactionExe = interactionExe;
        BorderPane consultBorder = new BorderPane();
        Scene consultScene = new Scene((Parent)consultBorder, 300.0, 400.0);
        consultScene.getStylesheets().add((Object)css);
        this.form.setScene(consultScene);
        this.interactionType = interactionType;
    }

    public void show() {
        this.form.show();
    }

    public void setCurrentInteractionId(String id) {
        this.currentInteractionID = id;
    }

    public void updateDestinationList(String interactionID, DestinationListI list) {
        String methodName = "updateDestinationList ";
        if (!interactionID.equals(this.currentInteractionID)) {
            LOG.error(methodName + "Contact ID:" + interactionID + " does not match current contactID:" + this.currentInteractionID, new Object[0]);
            return;
        }
        LOG.info(methodName + "Contact ID:" + interactionID + " updating list with " + list.getDestinations().size() + " items", new Object[0]);
        if (this.relocationType == RelocationType.Transfer) {
            LOG.debug(methodName + "Transfer", new Object[0]);
            this.destinationsOL.addAll((Collection)list.getDestinations());
        } else if (this.relocationType == RelocationType.Consult) {
            LOG.debug(methodName + " Consult", new Object[0]);
            for (DestinationI item : list.getDestinations()) {
                if (item.getDestinationType() != DestinationType.Agent) continue;
                this.destinationsOL.add((Object)item);
            }
        } else {
            LOG.error(methodName, " Unsupported relocation type. Destinations: " + list);
        }
    }

    public void initializeTransferForm(Data interactionData) {
        this.initializeForm(true, interactionData);
    }

    public void initializeConsultForm(Data interactionData) {
        this.initializeForm(false, interactionData);
    }

    private void initializeForm(boolean transfer, Data interactionData) {
        this.relocationType = transfer ? RelocationType.Transfer : RelocationType.Consult;
        this.form.titleProperty().set((Object)this.relocationType.name());
        this.destinationsOL.clear();
        BorderPane bp = (BorderPane)((Scene)this.form.sceneProperty().get()).getRoot();
        this.destinationsLV.setItems(this.destinationsOL);
        this.destinationsLV.setCellFactory((Callback)new Callback<ListView<DestinationI>, ListCell<DestinationI>>(){

            public ListCell<DestinationI> call(ListView<DestinationI> list) {
                return new CodeCell();
            }
        });
        final Button dialDestinationButton = new Button("Dial Destination");
        dialDestinationButton.setDisable(true);
        this.destinationsLV.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DestinationI>(){

            public void changed(ObservableValue<? extends DestinationI> observable, DestinationI oldValue, DestinationI newValue) {
                if (newValue != null) {
                    dialDestinationButton.setDisable(false);
                }
            }
        });
        bp.setCenter(this.destinationsLV);
        dialDestinationButton.getStyleClass().add((Object)"consultFormButtons");
        if (transfer) {
            dialDestinationButton.setOnAction(t -> {
                String methodName = "dialDestinationButton() ";
                DestinationI selectedDestination = (DestinationI)this.destinationsLV.getSelectionModel().getSelectedItem();
                if (selectedDestination != null) {
                    LOG.info(methodName + "Transfer:InteractionID:" + this.currentInteractionID + " Desination:" + selectedDestination, new Object[0]);
                    if (this.interactionType == InteractionType.VoiceInteraction) {
                        this.interactionExe.initiateTransferToConsultDestination(this.currentInteractionID, selectedDestination);
                    } else if (this.interactionType == InteractionType.EmailInteraction) {
                        this.interactionExe.transferToConsultDestination(this.currentInteractionID, selectedDestination);
                    } else if (this.interactionType == InteractionType.ChatInteraction) {
                        if (this.relocationType.equals((Object)RelocationType.Consult)) {
                            this.interactionExe.initConference(this.currentInteractionID, selectedDestination.getNumber());
                        } else {
                            this.interactionExe.transferToConsultDestination(this.currentInteractionID, selectedDestination);
                        }
                    } else {
                        LOG.warn(methodName, "Not implemented");
                    }
                } else {
                    LOG.error(methodName + "Selected destination is null", new Object[0]);
                }
                this.form.close();
                this.mediaForm.close();
            });
        } else {
            dialDestinationButton.setOnAction(t -> {
                String methodName = "dialDestinationButton";
                DestinationI selectedDestination = (DestinationI)this.destinationsLV.getSelectionModel().getSelectedItem();
                if (selectedDestination != null) {
                    LOG.info(methodName + "Conference:InteractionID:" + this.currentInteractionID + " Desination:" + selectedDestination, new Object[0]);
                    if (this.interactionType == InteractionType.VoiceInteraction) {
                        this.interactionExe.conferenceToConsultDestination(this.currentInteractionID, selectedDestination);
                    } else if (this.interactionType == InteractionType.ChatInteraction && this.relocationType.equals((Object)RelocationType.Consult)) {
                        this.interactionExe.initConference(this.currentInteractionID, selectedDestination.getNumber());
                    }
                } else {
                    LOG.error(methodName + "Selected destination is null", new Object[0]);
                }
                this.form.close();
            });
        }
        Button cancelButton = new Button("Cancel");
        cancelButton.getStyleClass().add((Object)"consultFormButtons");
        cancelButton.setOnAction(t -> {
            LOG.info("CancelButton", new Object[0]);
            this.form.close();
        });
        HBox hbuttonbox = new HBox();
        hbuttonbox.getChildren().addAll((Object[])new Node[]{dialDestinationButton, cancelButton});
        HBox freeFormBox = new HBox();
        TextField freeFormDest = new TextField();
        final Button freeFormTransferButton = new Button("Send External");
        freeFormTransferButton.getStyleClass().add((Object)"consultFormButtons");
        if (transfer) {
            freeFormTransferButton.setOnAction(t -> {
                if (this.interactionType == InteractionType.VoiceInteraction) {
                    String id = interactionData.getId();
                    String destination = freeFormDest.getText();
                    this.interactionExe.initTransfer(id, destination);
                    this.form.close();
                } else if (this.interactionType == InteractionType.EmailInteraction) {
                    String id = interactionData.getId();
                    String destination = freeFormDest.getText();
                    EmailForm emailForm = (EmailForm)this.mediaForm;
                    EmailMedia email = (EmailMedia)this.media;
                    boolean isHtml = true;
                    email.reply(destination, "", "", emailForm.getSubjectField().getText(), emailForm.getBodyHtml(), "", true, isHtml);
                    this.form.close();
                    emailForm.close();
                }
            });
        } else {
            freeFormTransferButton.setOnAction(t -> {
                String id = interactionData.getId();
                String destination = freeFormDest.getText();
                this.interactionExe.initConference(id, destination);
                this.form.close();
            });
        }
        freeFormTransferButton.setDisable(true);
        freeFormDest.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                freeFormTransferButton.setDisable(newValue.isEmpty());
            }
        });
        freeFormBox.getChildren().addAll((Object[])new Node[]{freeFormDest, freeFormTransferButton});
        VBox v = new VBox();
        v.getChildren().addAll((Object[])new Node[]{freeFormBox, hbuttonbox});
        bp.setBottom((Node)v);
    }

    public void setInteractionMedia(Media media) {
        if (media != null) {
            this.media = media;
            this.mediaSet = true;
        }
    }

    public boolean isMediaSet() {
        return this.mediaSet;
    }

    public void setMediaForm(MediaFormI emailForm) {
        this.mediaForm = emailForm;
    }

    public void setAgentSignature(String agentSignature) {
        this.agentSignature = agentSignature;
    }

    private static class CodeCell
    extends ListCell<DestinationI> {
        private CodeCell() {
        }

        public void updateItem(DestinationI item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getName() + ":" + item.getNumber() + ":" + item.getDestinationType().name());
            }
        }
    }

    static enum RelocationType {
        Consult,
        Transfer;

    }
}

