/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.api.EmailListEntryI;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.InteractionListenerI;
import com.avaya.ccs.api.MediaI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.PhoneListEntryI;
import com.avaya.ccs.api.PostalAddressListEntryI;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Interaction;
import com.avaya.ccs.javafxrefclient.Executor;
import com.avaya.ccs.javafxrefclient.InteractionEventTask;
import com.avaya.ccs.javafxrefclient.InteractionMediaEventTask;
import com.avaya.ccs.javafxrefclient.InteractionTimerMap;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.request.AddAgentNote;
import com.avaya.ccs.javafxrefclient.request.AddKVPToExistingDataRequest;
import com.avaya.ccs.javafxrefclient.request.AddToDNCRequest;
import com.avaya.ccs.javafxrefclient.request.AnswerRequest;
import com.avaya.ccs.javafxrefclient.request.BargeInRequest;
import com.avaya.ccs.javafxrefclient.request.CallbackRequestToContactNumber;
import com.avaya.ccs.javafxrefclient.request.CallbackRequestToExternalNumber;
import com.avaya.ccs.javafxrefclient.request.ChangeConfOwnerRequest;
import com.avaya.ccs.javafxrefclient.request.CompleteConferenceRequest;
import com.avaya.ccs.javafxrefclient.request.CompleteTransferRequest;
import com.avaya.ccs.javafxrefclient.request.ConferenceToDestinationRequest;
import com.avaya.ccs.javafxrefclient.request.ContactSearchRequest;
import com.avaya.ccs.javafxrefclient.request.CustomerSearchRequest;
import com.avaya.ccs.javafxrefclient.request.EditKVPValueRequest;
import com.avaya.ccs.javafxrefclient.request.EditOrAddIntrinsicRequest;
import com.avaya.ccs.javafxrefclient.request.EmailCallbackRequest;
import com.avaya.ccs.javafxrefclient.request.EmergencyRequest;
import com.avaya.ccs.javafxrefclient.request.EndConferenceRequest;
import com.avaya.ccs.javafxrefclient.request.EndConsultRequest;
import com.avaya.ccs.javafxrefclient.request.EndRequest;
import com.avaya.ccs.javafxrefclient.request.ExtendWrapupRequest;
import com.avaya.ccs.javafxrefclient.request.GetActivityCodesRequest;
import com.avaya.ccs.javafxrefclient.request.GetApprovalStatusRequest;
import com.avaya.ccs.javafxrefclient.request.GetAutoPhrasesRequest;
import com.avaya.ccs.javafxrefclient.request.GetCallbackDestinationsRequest;
import com.avaya.ccs.javafxrefclient.request.GetConsultDestinationTypesRequest;
import com.avaya.ccs.javafxrefclient.request.GetConsultDestinationsRequest;
import com.avaya.ccs.javafxrefclient.request.GetCustomFieldsRequest;
import com.avaya.ccs.javafxrefclient.request.GetCustomerHistoryRequest;
import com.avaya.ccs.javafxrefclient.request.GetCustomerInteractionMediaRequest;
import com.avaya.ccs.javafxrefclient.request.GetDispostionCodesRequest;
import com.avaya.ccs.javafxrefclient.request.GetInteractionDataRequest;
import com.avaya.ccs.javafxrefclient.request.GetPagePushUrlsRequest;
import com.avaya.ccs.javafxrefclient.request.GetSkillsetsRequest;
import com.avaya.ccs.javafxrefclient.request.HoldRequest;
import com.avaya.ccs.javafxrefclient.request.InitConferenceRequest;
import com.avaya.ccs.javafxrefclient.request.InitTransferRequest;
import com.avaya.ccs.javafxrefclient.request.InitiateTransferToDestinationRequest;
import com.avaya.ccs.javafxrefclient.request.IsTypingRequest;
import com.avaya.ccs.javafxrefclient.request.JoinRequest;
import com.avaya.ccs.javafxrefclient.request.ObserveRequest;
import com.avaya.ccs.javafxrefclient.request.OpenMediaDataRequest;
import com.avaya.ccs.javafxrefclient.request.PagePushRequest;
import com.avaya.ccs.javafxrefclient.request.PlayDTMFRequest;
import com.avaya.ccs.javafxrefclient.request.PreviewCancelRequest;
import com.avaya.ccs.javafxrefclient.request.PreviewDialFreeFormRequest;
import com.avaya.ccs.javafxrefclient.request.PreviewDialRequest;
import com.avaya.ccs.javafxrefclient.request.RedialRequest;
import com.avaya.ccs.javafxrefclient.request.RefreshAgentNotes;
import com.avaya.ccs.javafxrefclient.request.RemoveDataRequest;
import com.avaya.ccs.javafxrefclient.request.RemoveIntrinsicRequest;
import com.avaya.ccs.javafxrefclient.request.RemoveKVPDataRequest;
import com.avaya.ccs.javafxrefclient.request.ReviewEmailEditStartRequest;
import com.avaya.ccs.javafxrefclient.request.ReviewEmailRequest;
import com.avaya.ccs.javafxrefclient.request.ReviewEmailReviewApprovedRequest;
import com.avaya.ccs.javafxrefclient.request.ReviewEmailReviewRejectRequest;
import com.avaya.ccs.javafxrefclient.request.SetActivityCodeRequest;
import com.avaya.ccs.javafxrefclient.request.SetDataRequest;
import com.avaya.ccs.javafxrefclient.request.SetUUIRequest;
import com.avaya.ccs.javafxrefclient.request.TransferToDestinationRequest;
import com.avaya.ccs.javafxrefclient.request.UnHoldRequest;
import com.avaya.ccs.javafxrefclient.request.UpdateCustomerAddressRequest;
import com.avaya.ccs.javafxrefclient.request.UpdateCustomerEmailRequest;
import com.avaya.ccs.javafxrefclient.request.UpdateCustomerNameRequest;
import com.avaya.ccs.javafxrefclient.request.UpdateCustomerPhoneRequest;
import com.avaya.ccs.javafxrefclient.request.WebChatMessageRequest;
import com.avaya.ccs.javafxrefclient.request.WhisperRequest;
import com.avaya.ccs.javafxrefclient.request.WrapUPWithCodeRequest;
import com.avaya.ccs.javafxrefclient.request.WrapUpRequest;
import java.util.Map;

public class InteractionExecutor
extends Executor
implements InteractionListenerI {
    private static final Logger LOG = Logger.getLogger(InteractionExecutor.class);
    private final JavaFXRefClient gui;
    private static final InteractionTimerMap TIMERS = new InteractionTimerMap();
    InteractionMediaEventTask interactionMediaEventTask;
    InteractionEventTask interactionEventTask;

    public InteractionExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public void onInteractionEvent(NotificationEventI<InteractionI> nei) {
        String methodName = "onInteractionEvent() ";
        LOG.info(methodName + nei.getNotificationType() + " InteractionI-ID:" + ((InteractionI)nei.getNotificationObject()).getId(), new Object[0]);
        Interaction i = (Interaction)nei.getNotificationObject();
        if (nei.getNotificationType() == NotificationType.NEW || nei.getNotificationType() == NotificationType.UPDATE) {
            try {
                if (i.canOpenMedia()) {
                    i.openMedia();
                }
            }
            catch (ObjectInvalidException e) {
                LOG.error(methodName, e);
            }
        }
        this.executeIncomingEvent(new InteractionEventTask(nei, this.gui.getInteractionDataGUI(), this.gui.getSupervisorGUI(), this));
    }

    public void onInteractionMediaEvent(NotificationEventI<? extends MediaI> nei) {
        String methodName = "onInteractionMediaEvent()";
        LOG.info(methodName + nei.getNotificationType() + " MediaI-ID: " + ((MediaI)nei.getNotificationObject()).getId() + ". Contact Type:" + ((MediaI)nei.getNotificationObject()).getContactType(), new Object[0]);
        this.interactionMediaEventTask = new InteractionMediaEventTask(nei, this.gui.getInteractionDataGUI(), this.gui.getSupervisorGUI(), ((MediaI)nei.getNotificationObject()).getContactType());
        this.executeIncomingEvent(this.interactionMediaEventTask);
    }

    public void answer(String interactionID) {
        String methodName = "answer() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new AnswerRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void end(String interactionID) {
        String methodName = "end() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new EndRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void end(String interactionId, String closeReasonCode, String closingAgentNote, boolean sendTranscript) {
        String methodName = "end() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionId, new Object[0]);
        this.executeOutgoingRequest(new EndRequest(interactionId, closeReasonCode, closingAgentNote, sendTranscript));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void hold(String interactionID) {
        String methodName = "hold() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new HoldRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void unHold(String interactionID) {
        String methodName = "unHold() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new UnHoldRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void initTransfer(String interactionID, String destination) {
        String methodName = "initTransfer() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Destination:" + destination, new Object[0]);
        this.executeOutgoingRequest(new InitTransferRequest(interactionID, destination));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void completeTransfer(String interactionID) {
        String methodName = "completeTransfer() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new CompleteTransferRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void initConference(String interactionID, String destination) {
        String methodName = "initConference() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Destination:" + destination, new Object[0]);
        this.executeOutgoingRequest(new InitConferenceRequest(interactionID, destination));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void completeConference(String interactionID) {
        String methodName = "completeConference() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new CompleteConferenceRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void join(String sourceInteractionID, String destinationInteractionID) {
        String methodName = "join() ";
        LOG.debug(methodName + "+ SourceInteractionID:" + sourceInteractionID + " DestinationInteractionID:" + destinationInteractionID, new Object[0]);
        this.executeOutgoingRequest(new JoinRequest(sourceInteractionID, destinationInteractionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getInteractionData() {
        String methodName = "getInteractionData() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new GetInteractionDataRequest(this.gui.getInteractionDataGUI()));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void openInteractionMedia(String interactionId) {
        String methodName = "openInteractionMedia() ";
        LOG.info(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new OpenMediaDataRequest(interactionId));
        LOG.info(methodName + "-", new Object[0]);
    }

    public void setActivityCode(String interactionID, String code) {
        String methodName = "setActivityCode() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Code:" + code, new Object[0]);
        this.executeOutgoingRequest(new SetActivityCodeRequest(interactionID, code));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getActivityCodes(String interactionID) {
        String methodName = "getActivityCodes() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetActivityCodesRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getCustomFields(String interactionID) {
        String methodName = "getCustomFields() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetCustomFieldsRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getDispositionCodes(String interactionID) {
        String methodName = "getDispostionCodes() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetDispostionCodesRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getAutoPhrases(String interactionID) {
        String methodName = "getAutoPhrases() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetAutoPhrasesRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getPagePushUrls(String interactionID) {
        String methodName = "getPagePushUrls() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetPagePushUrlsRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getCustomerHistory(String interactionID) {
        String methodName = "requestCustomerHistory() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetCustomerHistoryRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getApprovalStatus(String interactionID) {
        String methodName = "getApprovalStatus() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetApprovalStatusRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void reviewEmail(String interactionID, String reviewType, Map<CommandArgs.Argument, String> queryParams, String data) {
        String methodName = "reviewEmail() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new ReviewEmailRequest(interactionID, reviewType, queryParams, data));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void editStartEmail(String interactionID, String actionId) {
        String methodName = "editStartEmail() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new ReviewEmailEditStartRequest(interactionID, actionId));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void reviewApprovedEmail(String interactionID, Long approvalId, String comment) {
        String methodName = "reviewApprovedEmail() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new ReviewEmailReviewApprovedRequest(interactionID, approvalId.toString(), comment));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void reviewRejectedEmail(String interactionID, Long approvalId, String comment) {
        String methodName = "reviewRejectedEmail() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new ReviewEmailReviewRejectRequest(interactionID, approvalId.toString(), comment));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getCustomerInteractionMedia(String interactionId, String queryContactID) {
        String methodName = "requestCustomerInteractionMedia() ";
        LOG.debug(methodName + "+ contactID:" + queryContactID, new Object[0]);
        this.executeOutgoingRequest(new GetCustomerInteractionMediaRequest(interactionId, queryContactID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void removeIntrinsic(String interactionID, String intrinsicName) {
        String methodName = "removeIntrinsic() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " IntrinsicName:" + intrinsicName, new Object[0]);
        this.executeOutgoingRequest(new RemoveIntrinsicRequest(interactionID, intrinsicName));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void editOrAddIntrinsic(String interactionID, String intrinsicName, String newValue) {
        String methodName = "editOrAddIntrinsic() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " IntrinsicName:" + intrinsicName + " NewValue:" + newValue, new Object[0]);
        this.executeOutgoingRequest(new EditOrAddIntrinsicRequest(interactionID, intrinsicName, newValue));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void setUUI(String interactionID, String newValue) {
        String methodName = "setUUI() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " NewValue:" + newValue, new Object[0]);
        this.executeOutgoingRequest(new SetUUIRequest(interactionID, newValue));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void setDATA(String interactionID, String newValue) {
        String methodName = "setDATA() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " NewValue:" + newValue, new Object[0]);
        this.executeOutgoingRequest(new SetDataRequest(interactionID, newValue));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void setDATA(String interactionID, Map<String, String> newValue) {
        String methodName = "setDATA() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new SetDataRequest(interactionID, newValue));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void setDATA(String interactionID, byte[] newValue) {
        String methodName = "setDATA() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " ByteArraySize:" + newValue.length, new Object[0]);
        this.executeOutgoingRequest(new SetDataRequest(interactionID, newValue));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void addKVPDATA(String interactionID, String newName, String newValue) {
        String methodName = "addKVPDATA() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " NewName:" + newName + " NewValue:" + newValue, new Object[0]);
        this.executeOutgoingRequest(new AddKVPToExistingDataRequest(interactionID, newName, newValue));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void removeKVPDATA(String interactionID, String name) {
        String methodName = "removeKVPDATA() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Name:" + name, new Object[0]);
        this.executeOutgoingRequest(new RemoveKVPDataRequest(interactionID, name));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void editKVPDATA(String interactionID, String name, String newValue) {
        String methodName = "editKVPDATA() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Name:" + name + " NewValue:" + newValue, new Object[0]);
        this.executeOutgoingRequest(new EditKVPValueRequest(interactionID, name, newValue));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void deleteDATA(String interactionID) {
        String methodName = "deleteDATA() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new RemoveDataRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void observe(String superID, String userID, String interactionID) {
        String methodName = "observe() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " SupervisorID:" + superID + " UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new ObserveRequest(superID, userID, interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void bargeIn(String superID, String userID, String interactionID) {
        String methodName = "bargeIn() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " SupervisorID:" + superID + " UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new BargeInRequest(superID, userID, interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void whisper(String superID, String userID, String interactionID) {
        String methodName = "whisper() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " SupervisorID:" + superID + " UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new WhisperRequest(superID, userID, interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void playDTMF(String digits, String interactionID) {
        String methodName = "playDTMF() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Digits:" + digits, new Object[0]);
        this.executeOutgoingRequest(new PlayDTMFRequest(digits, interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void emergency(String interactionID) {
        String methodName = "emergency() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new EmergencyRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void wrapUP(String interactionID) {
        String methodName = "wrapUP() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new WrapUpRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void wrapUPWithCode(String interactionID, ContactCenterCodeI code) {
        String methodName = "wrapUPWithCode() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Code-Name:" + code.getName() + "Number:" + code.getNumber(), new Object[0]);
        this.executeOutgoingRequest(new WrapUPWithCodeRequest(interactionID, code));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void extendWrapup(String interactionID) {
        String methodName = "extendWrapup() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new ExtendWrapupRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void previewDial(String interactionID, ContactNumberI toDial) {
        String methodName = "previewDial() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " ToDial:" + toDial, new Object[0]);
        this.executeOutgoingRequest(new PreviewDialRequest(interactionID, toDial));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void previewDialFreeForm(String interactionID, String toDial) {
        String methodName = "previewDialFreeForm() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " ToDial:" + toDial, new Object[0]);
        this.executeOutgoingRequest(new PreviewDialFreeFormRequest(interactionID, toDial));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void previewCancel(String interactionID) {
        String methodName = "previewCancel() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new PreviewCancelRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void updateCustomerName(String interactionID, String title, String firstName, String lastName) {
        String methodName = "updateCustomerName() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Title:" + title + " FirstName:" + firstName + " LastName:" + lastName, new Object[0]);
        this.executeOutgoingRequest(new UpdateCustomerNameRequest(interactionID, title, firstName, lastName));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void updateCustomerEmail(String interactionID, EmailListEntryI emailEntry) {
        String methodName = "updateCustomerEmail() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " EmailEntry:" + emailEntry, new Object[0]);
        this.executeOutgoingRequest(new UpdateCustomerEmailRequest(interactionID, emailEntry));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void updateCustomerPhone(String interactionID, PhoneListEntryI phoneEntry) {
        String methodName = "updateCustomerPhone() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Phone:" + phoneEntry, new Object[0]);
        this.executeOutgoingRequest(new UpdateCustomerPhoneRequest(interactionID, phoneEntry));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void updateCustomerAddress(String interactionID, PostalAddressListEntryI address) {
        String methodName = "updateCustomerAddress() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " PostalAddress:" + address, new Object[0]);
        this.executeOutgoingRequest(new UpdateCustomerAddressRequest(interactionID, address));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void addToDNC(String interactionID) {
        String methodName = "addToDNC() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new AddToDNCRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getConsultDestinationTypes(String interactionID) {
        String methodName = "getConsultDestinationTypes() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetConsultDestinationTypesRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getConsultDestinations(String interactionID) {
        String methodName = "getConsultDestinations() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetConsultDestinationsRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getCallbackDestinations(String interactionID) {
        String methodName = "getCallbackDestinations() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new GetCallbackDestinationsRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void transferToConsultDestination(String interactionID, DestinationI destination) {
        String methodName = "transferToConsultDestination() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Desination:" + destination, new Object[0]);
        this.executeOutgoingRequest(new TransferToDestinationRequest(interactionID, destination));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void initiateTransferToConsultDestination(String interactionID, DestinationI destination) {
        String methodName = "initiateTransferToConsultDestination() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Desination:" + destination, new Object[0]);
        this.executeOutgoingRequest(new InitiateTransferToDestinationRequest(interactionID, destination));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void conferenceToConsultDestination(String interactionID, DestinationI destination) {
        String methodName = "conferenceToConsultDestination() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Desination:" + destination, new Object[0]);
        this.executeOutgoingRequest(new ConferenceToDestinationRequest(interactionID, destination));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void endConsult(String interactionID) {
        String methodName = "endConsult() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new EndConsultRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void refreshAgentNotes(String interactionID) {
        String methodName = "refreshAgentNotes() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new RefreshAgentNotes(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void addAgentNote(String interactionID, String note) {
        String methodName = "addAgentNote() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Note:" + note, new Object[0]);
        this.executeOutgoingRequest(new AddAgentNote(interactionID, note));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void createCallbackToContactNumber(String interactionID, DestinationI destination, ContactNumberI contactNumber, String callbackTime, String callbackExpiryTime, String callbackNote) {
        String methodName = "createCallbackToContactNumber() ";
        String toLog = methodName + "+ callbackDestination:" + destination.getNumber() + " callbackTime:" + callbackTime + " callbackExpiryTime:" + callbackExpiryTime + " callbackNote:" + callbackNote + "contactNumber:";
        toLog = contactNumber != null ? toLog + contactNumber.toString() : toLog + "NULL";
        LOG.debug(toLog, new Object[0]);
        this.executeOutgoingRequest(new CallbackRequestToContactNumber(interactionID, destination, contactNumber, callbackTime, callbackExpiryTime, callbackNote));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void createCallbackToExternalNumber(String interactionID, DestinationI destination, String externalNumber, String callbackTime, String callbackExpiryTime, String callbackNote) {
        String methodName = "createCallbackToExternalNumber() ";
        LOG.debug(methodName + "+ callbackDestination:" + destination.getNumber() + " externalNumber:" + externalNumber + " callbackTime:" + callbackTime + " callbackExpiryTime:" + callbackExpiryTime + " callbackNote:" + callbackNote, new Object[0]);
        this.executeOutgoingRequest(new CallbackRequestToExternalNumber(interactionID, destination, externalNumber, callbackTime, callbackExpiryTime, callbackNote));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void changeConferenceOwner(String interactionID) {
        String methodName = "changeConferenceOwner() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new ChangeConfOwnerRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void endConference(String interactionID) {
        String methodName = "endConference() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new EndConferenceRequest(interactionID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void redial(String interactionID, ContactNumberI number) {
        String methodName = "redial() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID + " Number:" + number, new Object[0]);
        this.executeOutgoingRequest(new RedialRequest(interactionID, number));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void rescheduleEmail(String interactionID, String date, String time, String agentNote) {
        String methodName = "rescheduleEmail() ";
        LOG.debug(methodName + "+ InteractionID:" + interactionID, new Object[0]);
        this.executeOutgoingRequest(new EmailCallbackRequest(interactionID, date, time, agentNote));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void searchCustomers(String query) {
        String methodName = "searchCustomers";
        LOG.debug(methodName + "+ Query:" + query, new Object[0]);
        this.executeOutgoingRequest(new CustomerSearchRequest(query));
    }

    public void searchContacts(String query) {
        String methodName = "searchContacts";
        LOG.debug(methodName + "+ Query:" + query, new Object[0]);
        this.executeOutgoingRequest(new ContactSearchRequest(query));
    }

    public static InteractionTimerMap getTimers() {
        return TIMERS;
    }

    public void sendWebChatMessage(String interactionId, String message, boolean isWhisper) {
        String methodName = "sendWebChatMessage";
        LOG.debug("sendWebChatMessage", new Object[0]);
        this.executeOutgoingRequest(new WebChatMessageRequest(interactionId, message, isWhisper));
    }

    public void sendWebChatPagePush(String interactionId, String url) {
        String methodName = "sendWebChatPagePush";
        LOG.debug("sendWebChatPagePush", new Object[0]);
        this.executeOutgoingRequest(new PagePushRequest(interactionId, url));
    }

    public void sendAgentIsTypingMessage(String interactionId) {
        LOG.debug("sendAgentIsTypingMessage ", interactionId);
        this.executeOutgoingRequest(new IsTypingRequest(interactionId));
    }

    public void getSkillsets(String interactionId) {
        LOG.debug("getSkillsets " + interactionId, new Object[0]);
        this.executeOutgoingRequest(new GetSkillsetsRequest(interactionId));
    }
}

