/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.ConnectionDetails;
import com.avaya.ccs.javafxrefclient.Logger;
import java.io.InputStream;
import java.util.Properties;

public class RefClientProperties {
    private static final Logger LOG = Logger.getLogger(RefClientProperties.class);
    private static final String FILENAME = "JavaFXRefClient.properties";
    private static final String USERNAME = "domain\\username";
    private static final String PASSWORD = "password";
    private static final String SERVER = "servername";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionDetails getConnectionDetails() {
        String methodName = "getConnectionDetails()";
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(FILENAME);){
            Properties prop = new Properties();
            if (inputStream == null) {
                LOG.warn(methodName + " failed to read connection details from prop file, using defaults", new Object[0]);
                ConnectionDetails connectionDetails = new ConnectionDetails(USERNAME, PASSWORD, SERVER, true);
                return connectionDetails;
            }
            prop.load(inputStream);
            String username = prop.getProperty("username", USERNAME);
            String password = prop.getProperty(PASSWORD, PASSWORD);
            String server = prop.getProperty("server", SERVER);
            String autoreconnect = prop.getProperty("autoreconnect");
            boolean autoReconnectBoolean = true;
            if (autoreconnect != null) {
                autoReconnectBoolean = Boolean.parseBoolean(autoreconnect);
            }
            ConnectionDetails connectionDetails = new ConnectionDetails(username, password, server, autoReconnectBoolean);
            LOG.trace(methodName + " username=" + username + " password chars=" + password.length() + " server=" + server + " autoreconnect=" + autoreconnect, new Object[0]);
            return connectionDetails;
        }
        catch (Exception e) {
            LOG.warn(methodName + " failed to read connection details from prop file, using defaults" + e, new Object[0]);
            return new ConnectionDetails(USERNAME, PASSWORD, SERVER, true);
        }
    }
}

